/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.query;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.metadata.util.RptDataExtractQueryConverter;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.CustomSortInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;

public class EsQueryConverter {
    private static final Log LOGGER = LogFactory.getLog(EsQueryConverter.class);

    public void clearAnObjDataFilters(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        if (calculateInfo.isEsQuery()) {
            LOGGER.info("-----EsQueryConverter clearAnObjDataFilters start-----");
            complexObjContext.getQfilterList().clear();
        }
    }

    public void convert2EsInfo(ReportCalculateInfo calculateInfo) {
        List<ReportField> rowFieldList = calculateInfo.getRowFieldList();
        RptDataExtractQueryConverter.getInstance().addBaseDataIdBySummary(rowFieldList, calculateInfo);
        for (ReportField reportField : rowFieldList) {
            this.convertReportField(reportField);
        }
        calculateInfo.setAnObjPivot(false);
        calculateInfo.setAnObjPivotService(null);
    }

    private void convertReportField(ReportField reportField) {
        CustomSortInfo customSort;
        if (HRStringUtils.equals((String)"custom", (String)reportField.getSortord()) && (customSort = reportField.getCustomSort()) != null) {
            FieldSortInfo fieldSort = new FieldSortInfo();
            String fieldAlias = reportField.getFieldAlias();
            fieldSort.setNumber(fieldAlias + "\u03b9index");
            fieldSort.setSort("desc");
            fieldSort.setFieldType(DataTypeEnum.INTEGER.getDataTypeKey());
            reportField.setFieldSort(fieldSort);
            reportField.setCustomSort(null);
            reportField.setSortord(SortEnum.FIELD.getValue());
        }
    }
}

