/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.center.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.RptPermService;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.reportcenter.share.ReportShareFilterRangeBo;

public class ReportCenterUtil {
    private static final Log LOGGER = LogFactory.getLog(ReportCenterUtil.class);
    public static final String IS_VERSION = "isVersion";
    public static final String VERSION_TIME = "versionTime";
    public static final String OPEN_FROM = "openFrom";
    public static final String OPEN_FROM_REPORT_CENTER = "reportCenter";
    public static final String OPEN_FROM_MY_SUBSCRIBE = "mySubscribe";
    public static final String OPEN_FROM_SUBSCRIBE = "subscribe";
    public static final String OPEN_FROM_SHARE = "share";
    public static final String ONLY_QUERY_RESULT = "onlyQueryResult";
    public static final String SHARE_FILTER_RANGE = "shareFilterRangeBoList";
    public static String PARAM_MY_SUBSCRIBE_ID = "mySubScribeId";
    public static String PARAM_SHARE_ID = "shareId";
    public static String PARAM_REPORT_ES_INDEX_ID = "reportEsIndexId";
    public static String PARAM_BASE_DATA_ES_INDEX_ID = "baseDataEsIndexId";
    public static String PARAM_BASE_DATA_PERM_QFTILER = "baseDataPermQFilter";
    public static String PARAM_REPORT_DATA_PERM_QFTILER = "reportDataPermQFilter";
    public static String PARAM_ADMIN_ORG_F7_PERM_QFILTER = "adminOrgF7PermQFilter";
    private static final HRBaseServiceHelper mySubscribeHelper = new HRBaseServiceHelper("hrptmc_mysubscribe");
    private static final HRBaseServiceHelper shareHelper = new HRBaseServiceHelper("hrptmc_sharerecord");

    public static Map<String, QFilter> getBaseDataF7PermQFilters(String qFilterStr) {
        try {
            if (HRStringUtils.isEmpty((String)qFilterStr)) {
                return null;
            }
            Map originMap = (Map)SerializationUtils.fromJsonString((String)qFilterStr, Map.class);
            if (originMap == null || originMap.isEmpty()) {
                return null;
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)originMap.size());
            originMap.forEach((key, val) -> {
                if (val != null) {
                    map.put(key, QFilter.fromSerializedString((String)val));
                }
            });
            return map;
        }
        catch (Exception exception) {
            LOGGER.error("ReportCenterUtil getBaseDataF7PermQFilters error, qFilterStr: {}", (Object)qFilterStr, (Object)exception);
            return null;
        }
    }

    public static void setEsQueryParam(ReportCalculateInfo reportCalculateInfo, String openFrom, Long mySubscribeId, Long shareId) {
        if (HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_MY_SUBSCRIBE)) {
            reportCalculateInfo.setEsQuery(true);
            DynamicObject dy = mySubscribeHelper.queryOriginalOne("esindex.id", new QFilter[]{new QFilter("id", "=", (Object)mySubscribeId)});
            if (dy != null) {
                reportCalculateInfo.setEsIndex(dy.getString("esindex.id"));
            }
        } else if (HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_SHARE)) {
            reportCalculateInfo.setEsQuery(true);
            DynamicObject dy = shareHelper.queryOriginalOne("esindex.id", new QFilter[]{new QFilter("id", "=", (Object)shareId)});
            if (dy != null) {
                reportCalculateInfo.setEsIndex(dy.getString("esindex.id"));
            }
        }
    }

    public static void setReportCenterParamForQuery(ReportQueryParamInfo reportQueryParamInfo, Map<String, Object> formShowParameters) {
        String openFrom = (String)formShowParameters.get(OPEN_FROM);
        if (HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_MY_SUBSCRIBE)) {
            reportQueryParamInfo.setReportCenterOpenFrom(OPEN_FROM_MY_SUBSCRIBE);
            reportQueryParamInfo.setMySubscribeId((Long)formShowParameters.get(PARAM_MY_SUBSCRIBE_ID));
        } else if (HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_SHARE)) {
            reportQueryParamInfo.setReportCenterOpenFrom(OPEN_FROM_SHARE);
            reportQueryParamInfo.setShareId((Long)formShowParameters.get(PARAM_SHARE_ID));
        }
    }

    public static boolean openFromReportCenter(Map<String, Object> formShowParameters) {
        String publishType = (String)formShowParameters.get("CUSTOM_PARAM_PUBLISH_TYPE");
        return HRStringUtils.equals((String)publishType, (String)OPEN_FROM_REPORT_CENTER);
    }

    public static boolean openFromMySubscribeOrShare(Map<String, Object> formShowParameters) {
        String openFrom = (String)formShowParameters.get(OPEN_FROM);
        return HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_SHARE) || HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_MY_SUBSCRIBE);
    }

    public static QFilter getReportCenterPermissionQFilter(Map<String, Object> formShowParameters) {
        String openFrom = (String)formShowParameters.get(OPEN_FROM);
        if (HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_MY_SUBSCRIBE)) {
            String permQFilterStr = (String)formShowParameters.get(PARAM_REPORT_DATA_PERM_QFTILER);
            if (HRStringUtils.isNotEmpty((String)permQFilterStr)) {
                return QFilter.fromSerializedString((String)permQFilterStr);
            }
            return null;
        }
        if (HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_SHARE)) {
            return null;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Long reportId = (Long)formShowParameters.get("reportId");
        LOGGER.info("ReportCenterUtil getReportCenterPermissionQFilter userId: {}, reportId: {}", (Object)currUserId, (Object)reportId);
        QFilter permQFilter = RptPermService.getRptPerm(currUserId, reportId);
        LOGGER.info("ReportCenterUtil getReportCenterPermissionQFilter: {}", (Object)permQFilter);
        return permQFilter;
    }

    public static Date getVersionTime(Map<String, Object> formShowParameters) {
        Object versionTimeObj = formShowParameters.get(VERSION_TIME);
        if (versionTimeObj == null) {
            return null;
        }
        if (versionTimeObj instanceof String) {
            try {
                return HRDateTimeUtils.parseDate((String)((String)versionTimeObj));
            }
            catch (ParseException e) {
                LOGGER.error((Throwable)e);
                throw new KDBizException("getVersionTime time parse error.");
            }
        }
        return (Date)versionTimeObj;
    }

    public static void transferBaseDataFilterToEnumFilter(List<FilterBo> filterBoList) {
        for (FilterBo filterBo : filterBoList) {
            if (!HRStringUtils.equals((String)FilterType.BASE_DATA.getValue(), (String)filterBo.getFilterType()) && !HRStringUtils.equals((String)FilterType.HIS_BASE_DATA.getValue(), (String)filterBo.getFilterType()) || filterBo.getCustomBo()) continue;
            filterBo.setFilterType(FilterType.BASE_DATA_ENUM.getValue());
        }
    }

    public static List<FilterBo> handleMySubscribeAndShareFilter(String openFrom, Boolean onlyQueryResult, String shareFilterRangeStr, Date versionTime, List<FilterBo> filterBoList) {
        try {
            filterBoList = ReportCenterUtil.handleMySubscribeReportFilters(filterBoList, openFrom, versionTime);
            filterBoList = ReportCenterUtil.handleShareReportFilters(filterBoList, onlyQueryResult, shareFilterRangeStr, versionTime);
        }
        catch (Exception exception) {
            LOGGER.error("ReportCenterUtil handleMySubscribeAndShareFilter error:", (Throwable)exception);
        }
        return filterBoList;
    }

    public static boolean isShareOrMySubscribeOpenReportPage(Map<String, Object> formShowParameters) {
        String openFrom = (String)formShowParameters.get(OPEN_FROM);
        return HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_SHARE) || HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_MY_SUBSCRIBE);
    }

    public static boolean isShareOpenReportPage(Map<String, Object> formShowParameters) {
        String openFrom = (String)formShowParameters.get(OPEN_FROM);
        return HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_SHARE);
    }

    public static List<FilterBo> handleShareReportFilters(List<FilterBo> filters, Boolean onlyQueryResult, String shareFilterRangeBoListJson, Date versionTime) {
        if (filters == null || filters.isEmpty() || shareFilterRangeBoListJson == null) {
            return filters;
        }
        boolean isOnlyQueryResult = onlyQueryResult != null && onlyQueryResult != false;
        List shareFilterRangeBoList = JSON.parseArray((String)shareFilterRangeBoListJson, ReportShareFilterRangeBo.class);
        Map shareFilterRangeBoMap = shareFilterRangeBoList.stream().collect(Collectors.toMap(ReportShareFilterRangeBo::getFieldAlias, Function.identity(), (k1, k2) -> k1));
        for (FilterBo filter : filters) {
            ReportShareFilterRangeBo reportShareFilterRangeBo = (ReportShareFilterRangeBo)shareFilterRangeBoMap.get(filter.getFieldAlias());
            if (reportShareFilterRangeBo == null) continue;
            FilterType filterType = FilterType.getFilterTypeByValue((String)reportShareFilterRangeBo.getFilterType());
            switch (filterType) {
                case NUMBER: {
                    String filterDefault = reportShareFilterRangeBo.getFilterDefault();
                    if (HRStringUtils.isNotEmpty((String)filterDefault)) {
                        filter.setTextDefaultValue(filterDefault);
                    }
                    filter.setOpt(reportShareFilterRangeBo.getOpt());
                    break;
                }
                case STRING: {
                    String filterDefault = reportShareFilterRangeBo.getFilterDefault();
                    if (!HRStringUtils.isNotEmpty((String)filterDefault)) break;
                    filter.setTextDefaultValue(filterDefault);
                    break;
                }
                case DATE: {
                    ReportCenterUtil.handleDateFilter(filter, reportShareFilterRangeBo);
                    break;
                }
                case ENUM: {
                    ReportCenterUtil.handleEnumFilter(filter, reportShareFilterRangeBo, isOnlyQueryResult);
                    break;
                }
                case BASE_DATA_ENUM: 
                case BASE_DATA: 
                case HIS_BASE_DATA: {
                    ReportCenterUtil.handleBaseDataEnumFilter(filter, reportShareFilterRangeBo, isOnlyQueryResult);
                    break;
                }
                case ADMIN_ORG: {
                    ReportCenterUtil.handleAdminOrgFilter(filter, reportShareFilterRangeBo, isOnlyQueryResult, versionTime);
                    break;
                }
            }
        }
        return filters;
    }

    private static void handleDateFilter(FilterBo filter, ReportShareFilterRangeBo reportShareFilterRangeBo) {
        String dateFilterType = reportShareFilterRangeBo.getDateFilterType();
        String dateFilterText = reportShareFilterRangeBo.getDateFilterText();
        String startDateDefault = reportShareFilterRangeBo.getFilterStartDateDefault();
        String endDateDefault = reportShareFilterRangeBo.getFilterEndDateDefault();
        if (HRStringUtils.isNotEmpty((String)dateFilterType)) {
            filter.setDateFilterType(dateFilterType);
        }
        if (HRStringUtils.isNotEmpty((String)dateFilterText)) {
            filter.setDateFilterText(dateFilterText);
        }
        if (HRStringUtils.isNotEmpty((String)startDateDefault)) {
            filter.setFilterStartDateStr(startDateDefault);
        }
        if (HRStringUtils.isNotEmpty((String)endDateDefault)) {
            filter.setFilterEndDateStr(endDateDefault);
        }
    }

    private static void handleEnumFilter(FilterBo filter, ReportShareFilterRangeBo reportShareFilterRangeBo, boolean isOnlyQueryResult) {
        String filterDefault;
        String[] split;
        String filterRange;
        if (isOnlyQueryResult && HRStringUtils.isNotEmpty((String)(filterRange = reportShareFilterRangeBo.getFilterRange())) && Arrays.stream(split = filterRange.split(",")).anyMatch(HRStringUtils::isNotEmpty)) {
            filter.setTextFilterRange(filterRange);
        }
        if (HRStringUtils.isNotEmpty((String)(filterDefault = reportShareFilterRangeBo.getFilterDefault()))) {
            filter.setTextDefaultValue(filterDefault);
        }
    }

    private static void handleBaseDataEnumFilter(FilterBo filter, ReportShareFilterRangeBo reportShareFilterRangeBo, boolean isOnlyQueryResult) {
        String filterDefault;
        String[] split;
        String filterRange;
        if (isOnlyQueryResult && HRStringUtils.isNotEmpty((String)(filterRange = reportShareFilterRangeBo.getFilterRange())) && Arrays.stream(split = filterRange.split(",")).anyMatch(HRStringUtils::isNotEmpty)) {
            filter.setBdFilterRange(filterRange);
        }
        if (HRStringUtils.isNotEmpty((String)(filterDefault = reportShareFilterRangeBo.getFilterDefault()))) {
            filter.setBdDefaultValue(filterDefault);
        }
    }

    private static void handleAdminOrgFilter(FilterBo filter, ReportShareFilterRangeBo reportShareFilterRangeBo, boolean isOnlyQueryResult, Date versionTime) {
        String filterRange = reportShareFilterRangeBo.getFilterRange();
        if (HRStringUtils.isNotEmpty((String)filterRange)) {
            List currentIds = Arrays.stream(filterRange.split(",")).map(Long::parseLong).collect(Collectors.toList());
            HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
            ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(versionTime);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE));
            qFilters.add(new QFilter("boid", "in", currentIds));
            qFilters.add(new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toList())));
            qFilters.add(new QFilter("bsed", "<=", (Object)calendar.getTime()));
            qFilters.add(new QFilter("bsled", ">=", (Object)calendar.getTime()));
            DynamicObjectCollection versionDys = adminOrgHelper.queryOriginalCollection("id", qFilters.toArray(new QFilter[0]));
            if (!versionDys.isEmpty()) {
                List versionIds = versionDys.stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
                String versionIdStr = String.join((CharSequence)",", versionIds);
                if (isOnlyQueryResult) {
                    filter.setBdFilterRange(versionIdStr);
                }
                filter.setBdDefaultValue(versionIdStr);
            } else {
                if (isOnlyQueryResult) {
                    filter.setBdFilterRange(filterRange);
                }
                filter.setBdDefaultValue(reportShareFilterRangeBo.getFilterDefault());
            }
            filter.setHisData(true);
        }
    }

    public static List<FilterBo> handleMySubscribeReportFilters(List<FilterBo> filters, String openFrom, Date versionTime) {
        if (filters == null || filters.isEmpty() || !HRStringUtils.equals((String)openFrom, (String)OPEN_FROM_MY_SUBSCRIBE) || versionTime == null) {
            return filters;
        }
        for (FilterBo filter : filters) {
            FilterType filterType = FilterType.getFilterTypeByValue((String)filter.getFilterType());
            if (filterType != FilterType.ADMIN_ORG) continue;
            filter.setHisData(true);
        }
        return filters;
    }
}

