/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.common;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeFieldBo;

public class DateTimeFieldTimeZoneUtil {
    private static final Log LOGGER = LogFactory.getLog(DateTimeFieldTimeZoneUtil.class);

    public static String getUserTimeZone() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        DynamicObject dyo = service.getUserTimezone(Long.valueOf(RequestContext.get().getCurrUserId()));
        return dyo.getString("number");
    }

    public static String getUserDateFormat() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        return service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
    }

    public static String getUserDateTimeFormat() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        String dateFormatStr = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        Map timeFormatMap = service.getTimeFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        return dateFormatStr + " " + (String)timeFormatMap.get("timeFormat");
    }

    public static void buildTimeZoneInfoIntoQueryField(List<QueryFieldBo> queryFields, MainEntityTypeUtil entityTypeUtil) {
        String userTimeZone = DateTimeFieldTimeZoneUtil.getUserTimeZone();
        for (QueryFieldBo queryField : queryFields) {
            if (!HRStringUtils.equals((String)queryField.getControlType(), (String)FieldControlType.DATE_TIME.getValue()) || queryField.getTimeZoneInfo() != null) continue;
            queryField.setTimeZoneInfo(DateTimeFieldTimeZoneUtil.getTimeZoneInfo(queryField.getEntityNumber(), queryField.getFieldAlias(), userTimeZone, entityTypeUtil));
        }
    }

    public static TimeZoneInfo getTimeZoneInfo(String entityNumber, String fieldAlias, String userTimeZone, MainEntityTypeUtil entityTypeUtil) {
        DateTimeProp dateTimeProp = (DateTimeProp)AnalyseObjectUtil.parseFieldAliasGetProperty((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)entityTypeUtil);
        if (dateTimeProp != null) {
            TimeZoneInfo timeZoneInfo = new TimeZoneInfo();
            timeZoneInfo.setTimeZoneTransType(Integer.valueOf(dateTimeProp.getTimeZoneTransType()));
            if (timeZoneInfo.getTimeZoneTransType() == 1) {
                timeZoneInfo.setTimeZone(userTimeZone);
            }
            return timeZoneInfo;
        }
        return null;
    }

    public static void setFieldTimeZone(List<QueryFieldBo> queryFields, List<ReportField> rowFields, List<ReportField> colFields) {
        TimeZoneInfo timeZoneInfo;
        String fieldAlias;
        LOGGER.info("DateTimeFieldTimeZoneUtil setFieldTimeZone rowFields: {}, colFields: {}", rowFields, colFields);
        Map<String, TimeZoneInfo> timeZoneInfoMap = queryFields.stream().filter(field -> HRStringUtils.equals((String)field.getControlType(), (String)FieldControlType.DATE_TIME.getValue()) && field.getTimeZoneInfo() != null).collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, QueryFieldCommonBo::getTimeZoneInfo, (k1, k2) -> k1));
        for (ReportField rowField : rowFields) {
            fieldAlias = DateTimeFieldTimeZoneUtil.getFieldAlias(rowField.getFieldAlias());
            timeZoneInfo = timeZoneInfoMap.get(fieldAlias);
            if (timeZoneInfo == null || !(rowField instanceof EntityPropField)) continue;
            ((EntityPropField)rowField).setTimeZoneInfo(timeZoneInfo);
        }
        for (ReportField colField : colFields) {
            fieldAlias = DateTimeFieldTimeZoneUtil.getFieldAlias(colField.getFieldAlias());
            timeZoneInfo = timeZoneInfoMap.get(fieldAlias);
            if (timeZoneInfo == null || !(colField instanceof EntityPropField)) continue;
            ((EntityPropField)colField).setTimeZoneInfo(timeZoneInfo);
        }
    }

    public static void setTimeZoneInfoIntoFilterBo(FilterBo filterBo, List<QueryFieldBo> queryFields) {
        Map fieldMap = queryFields.stream().filter(field -> HRStringUtils.equals((String)field.getControlType(), (String)FieldControlType.DATE_TIME.getValue()) && field.getTimeZoneInfo() != null).collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity(), (k1, k2) -> k1));
        QueryFieldBo queryFieldBo = (QueryFieldBo)fieldMap.get(DateTimeFieldTimeZoneUtil.getFieldAlias(filterBo.getFieldAlias()));
        if (queryFieldBo != null) {
            filterBo.setTimeZoneInfo(queryFieldBo.getTimeZoneInfo());
        }
    }

    public static void setTimeZoneInfoIntoFilterBo(QuerySchemeFieldBo querySchemeFieldBo, List<QueryFieldBo> queryFields) {
        Map fieldMap = queryFields.stream().filter(field -> HRStringUtils.equals((String)field.getControlType(), (String)FieldControlType.DATE_TIME.getValue()) && field.getTimeZoneInfo() != null).collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity(), (k1, k2) -> k1));
        QueryFieldBo queryFieldBo = (QueryFieldBo)fieldMap.get(DateTimeFieldTimeZoneUtil.getFieldAlias(querySchemeFieldBo.getFieldAlias()));
        if (queryFieldBo != null) {
            querySchemeFieldBo.setTimeZoneInfo(queryFieldBo.getTimeZoneInfo());
        }
    }

    private static String getFieldAlias(String fieldAlias) {
        if (fieldAlias.contains("!")) {
            return fieldAlias.split("!")[0];
        }
        return fieldAlias;
    }
}

