/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore.metadata.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.util.DevportalUtilProxy;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.metadata.handler.IRptMetadataHandler;
import kd.hr.hrptmc.business.datastore.metadata.handler.RptEntityMetadataHandler;
import kd.hr.hrptmc.business.datastore.metadata.handler.RptFormMetadataHandler;
import kd.hr.hrptmc.business.datastore.metadata.handler.RptMetadataHandlerFactory;
import kd.hr.hrptmc.business.datastore.metadata.model.RptFormMetadataContent;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetadataContentBaseMsg;
import kd.hr.hrptmc.business.datastore.metadata.util.RptDataStoreUtil;
import kd.hr.hrptmc.business.datastore.metadata.util.RptMetaFieldTransferUtil;
import kd.hr.hrptmc.business.publish.GenMetaDataHelper;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;

public class RptMetadataService {
    private static final Log LOGGER = LogFactory.getLog(RptMetadataService.class);
    private static volatile RptMetadataService service = null;

    private RptMetadataService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RptMetadataService getInstance() {
        if (service != null) return service;
        Class<RptMetadataService> clazz = RptMetadataService.class;
        synchronized (RptMetadataService.class) {
            if (service != null) return service;
            service = new RptMetadataService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public RptFormMetadataContent generateMetaData(RptMetadataContentBaseMsg metadataBaseMsg, long anObjId, List<QueryFieldBo> anObjQueryFields, List<CalculateFieldBo> calculateFields, List<PivotIndexFieldBo> analysePivotIndexes, List<AnObjGroupField> groupFields) {
        RptFormMetadataContent formMetadataContent = this.buildRptFormMetadataContent(metadataBaseMsg, anObjId, anObjQueryFields, calculateFields, analysePivotIndexes, groupFields);
        this.generateMetaData(formMetadataContent);
        return formMetadataContent;
    }

    public RptFormMetadataContent generateMetaData(RptMetadataContentBaseMsg metadataBaseMsg, long anObjId, List<FieldInfo> reportFieldInfoList) {
        RptFormMetadataContent formMetadataContent = this.buildRptFormMetadataContent(metadataBaseMsg, anObjId, reportFieldInfoList);
        this.generateMetaData(formMetadataContent);
        return formMetadataContent;
    }

    public RptFormMetadataContent generateMetaData(RptFormMetadataContent formMetadataContent) {
        LOGGER.info("---RptMetadataService generateMetaData--- metadataBaseMsg: {}", (Object)formMetadataContent.getBaseMsg());
        StringBuilder errorMsg = new StringBuilder();
        if (!this.validateMetadataBaseMsg(formMetadataContent.getBaseMsg(), errorMsg)) {
            throw new KDBizException(errorMsg.toString());
        }
        this.setDefaultUnitId(formMetadataContent.getBaseMsg());
        IRptMetadataHandler entityMetadataHandler = RptMetadataHandlerFactory.getRptMetadataHandler(RptEntityMetadataHandler.class);
        String entityContent = entityMetadataHandler.getCreateMetadataContext(formMetadataContent);
        IRptMetadataHandler formMetadataHandler = RptMetadataHandlerFactory.getRptMetadataHandler(RptFormMetadataHandler.class);
        String formContent = formMetadataHandler.getCreateMetadataContext(formMetadataContent);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                MetadataDao.deployMetadata((String)formContent, (String)formMetadataContent.getBaseMsg().getUnitId(), (String)formMetadataContent.getBaseMsg().getAppId());
                MetadataDao.deployMetadata((String)entityContent, (String)formMetadataContent.getBaseMsg().getUnitId(), (String)formMetadataContent.getBaseMsg().getAppId());
                ArrayList formIdList = Lists.newArrayListWithExpectedSize((int)1);
                formIdList.add(formMetadataContent.getBaseMsg().getId());
                MetadataDao.clearSubRuntimeMeta((List)formIdList);
                MetadataDao.rebuildRuntimeMetaById((String)formMetadataContent.getBaseMsg().getId());
            }
            catch (Exception exception) {
                txHandle.markRollback();
                LOGGER.error("RptMetadataService generateMetaData error: ", (Throwable)exception);
                throw new KDBizException("generate metadata error.");
            }
        }
        RptDataStoreUtil.setBaseDataRefNotValidate(formMetadataContent.getBaseMsg().getEntityNumber());
        return formMetadataContent;
    }

    public void bindTable(RptFormMetadataContent formMetadataContent) {
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMetadataContent.getBaseMsg().getId(), (MetaCategory)MetaCategory.Entity);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formMetadataContent.getBaseMsg().getId(), (MetaCategory)MetaCategory.Form);
        formMetadata.getRootAp().setName(new LocaleString(formMetadataContent.getBaseMsg().getEntityName()));
        entityMeta.getRootEntity().setName(new LocaleString(formMetadataContent.getBaseMsg().getEntityName()));
        entityMeta.getRootEntity().setTableName(formMetadataContent.getBaseMsg().getTableName());
        entityMeta.getRootEntity().setdbRoute(formMetadataContent.getBaseMsg().getDbRoute());
        MetadataWriter metadataWriter = new MetadataWriter(formMetadata.getModelType());
        metadataWriter.save(new AbstractMetadata[]{entityMeta, formMetadata});
    }

    public boolean deleteMetaData(String entityNumber) {
        String unitId;
        DevportalUtilProxy dePortalUtil = new DevportalUtilProxy();
        String bizAppNumber = EntityMetadataCache.getBizAppNumber((String)entityNumber);
        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)bizAppNumber);
        String bizAppId = appInfo.getAppId();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String type = appMeta.getDevType();
        String formId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        Map result = dePortalUtil.deletePage(formId, unitId = MetadataDao.getUnitIdFromUnitrel((String)formId), Boolean.valueOf(false), bizAppId, type, "PAGE_TYPE", "bos_formmeta");
        if (!(result == null || result.get("message") == null || result.get("success") != null && ((Boolean)result.get("success")).booleanValue())) {
            String errorMsg = result.get("message").toString();
            LOGGER.error("DeleteMetaService deleteMetaData error: {}", (Object)errorMsg);
            return false;
        }
        RptDataStoreUtil.deleteBaseDataRefNotValidate(entityNumber);
        return true;
    }

    private boolean validateMetadataBaseMsg(RptMetadataContentBaseMsg metadataBaseMsg, StringBuilder errorMsg) {
        boolean result = true;
        if (HRStringUtils.isEmpty((String)metadataBaseMsg.getAppId())) {
            errorMsg.append(ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528ID\u4e3a\u7a7a\u3002", (String)"RptMetadataService_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            result = false;
        }
        if (HRStringUtils.isEmpty((String)metadataBaseMsg.getDbRoute())) {
            errorMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u8def\u7531\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"RptMetadataService_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            result = false;
        }
        if (HRStringUtils.isEmpty((String)metadataBaseMsg.getEntityNumber())) {
            errorMsg.append(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"RptMetadataService_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            result = false;
        }
        if (HRStringUtils.isEmpty((String)metadataBaseMsg.getEntityName())) {
            errorMsg.append(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"RptMetadataService_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            result = false;
        }
        if (HRStringUtils.isEmpty((String)metadataBaseMsg.getTableName())) {
            errorMsg.append(ResManager.loadKDString((String)"\u7269\u7406\u8868\u540d\u4e3a\u7a7a\u3002", (String)"RptMetadataService_4", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            result = false;
        }
        if (HRDBUtil.exitsTable((DBRoute)new DBRoute(metadataBaseMsg.getDbRoute()), (String)metadataBaseMsg.getTableName())) {
            errorMsg.append(ResManager.loadKDString((String)"\u7269\u7406\u8868\u540d\u5df2\u5b58\u5728\u3002", (String)"RptMetadataService_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            result = false;
        }
        return result;
    }

    private RptFormMetadataContent buildRptFormMetadataContent(RptMetadataContentBaseMsg metadataBaseMsg, long anObjId, List<QueryFieldBo> anObjQueryFields, List<CalculateFieldBo> calculateFields, List<PivotIndexFieldBo> analysePivotIndexes, List<AnObjGroupField> groupFields) {
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent metadataBaseMsg: {}", (Object)metadataBaseMsg);
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent anObjId: {}", (Object)anObjId);
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent anObjQueryFields: {}", anObjQueryFields);
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent analysePivotIndexes: {}", analysePivotIndexes);
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent groupFields: {}", groupFields);
        ArrayList metaFieldMapList = Lists.newArrayListWithCapacity((int)10);
        ArrayList rptEntityMetaFieldContents = Lists.newArrayListWithCapacity((int)10);
        int index = 0;
        if (anObjQueryFields != null) {
            rptEntityMetaFieldContents.addAll(RptMetaFieldTransferUtil.anObjQueryFieldsToEntityMetaFields(index, anObjId, anObjQueryFields, metaFieldMapList));
            index += anObjQueryFields.size();
        }
        if (calculateFields != null) {
            rptEntityMetaFieldContents.addAll(RptMetaFieldTransferUtil.calculateFieldsToEntityMetaFields(index, anObjId, calculateFields, metaFieldMapList));
            index += calculateFields.size();
        }
        if (analysePivotIndexes != null) {
            rptEntityMetaFieldContents.addAll(RptMetaFieldTransferUtil.pivotIndexesToEntityMetaFields(index, analysePivotIndexes, metaFieldMapList));
            index += analysePivotIndexes.size();
        }
        if (groupFields != null) {
            rptEntityMetaFieldContents.addAll(RptMetaFieldTransferUtil.groupFieldsToEntityMetaFields(index, groupFields, metaFieldMapList));
        }
        RptFormMetadataContent formMetadataContent = new RptFormMetadataContent(metadataBaseMsg, rptEntityMetaFieldContents);
        formMetadataContent.setMetaFieldMapList(metaFieldMapList);
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent metaFieldMapList: {}", (Object)metaFieldMapList);
        return formMetadataContent;
    }

    private RptFormMetadataContent buildRptFormMetadataContent(RptMetadataContentBaseMsg metadataBaseMsg, long anObjId, List<FieldInfo> reportFieldInfoList) {
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent metadataBaseMsg: {}", (Object)metadataBaseMsg);
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent anObjId: {}", (Object)anObjId);
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent reportFieldInfoList: {}", reportFieldInfoList);
        ArrayList metaFieldMapList = Lists.newArrayListWithCapacity((int)10);
        ArrayList rptEntityMetaFieldContents = Lists.newArrayListWithCapacity((int)10);
        if (reportFieldInfoList != null && !reportFieldInfoList.isEmpty()) {
            List allNumberAliasList = reportFieldInfoList.stream().map(FieldInfo::getNumberAlias).collect(Collectors.toList());
            LOGGER.info("---RptMetadataService buildRptFormMetadataContent--- reportFieldInfoList: {}", allNumberAliasList);
            rptEntityMetaFieldContents.addAll(RptMetaFieldTransferUtil.fieldInfoToEntityMetaFields(0, anObjId, reportFieldInfoList, metaFieldMapList));
        }
        RptFormMetadataContent formMetadataContent = new RptFormMetadataContent(metadataBaseMsg, rptEntityMetaFieldContents);
        formMetadataContent.setMetaFieldMapList(metaFieldMapList);
        LOGGER.info("RptMetadataService.buildRptFormMetadataContent metaFieldMapList: {}", (Object)metaFieldMapList);
        return formMetadataContent;
    }

    private void setDefaultUnitId(RptMetadataContentBaseMsg metadataBaseMsg) {
        AppMetadata metadata;
        List functionPackets;
        if (HRStringUtils.equals((String)metadataBaseMsg.getAppId(), (String)"3+JJD4IUAS56")) {
            metadataBaseMsg.setUnitId("445JGQ+QKY6=");
        }
        if (HRStringUtils.isEmpty((String)metadataBaseMsg.getUnitId()) && !(functionPackets = (metadata = AppMetaServiceHelper.loadAppMetadataById((String)metadataBaseMsg.getAppId(), (boolean)false)).getAppFunctionPackets()).isEmpty()) {
            metadataBaseMsg.setUnitId(((AppFunctionPacketElement)functionPackets.get(0)).getId());
        }
    }

    private String getExtendAppId(String appId) {
        String extAppId = appId;
        String currentIsv = GenMetaDataHelper.getCurrentIsv();
        if (!"kingdee".equals(currentIsv)) {
            QFilter isvFilter;
            String selProp = "id,isv,number,inheritpath";
            QFilter inheritPathFilter = new QFilter("inheritpath", "like", (Object)("%" + appId + "%"));
            DynamicObject[] appObjs = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selProp, (QFilter[])new QFilter[]{inheritPathFilter, isvFilter = new QFilter("isv", "=", (Object)currentIsv)});
            if (appObjs != null && appObjs.length > 0) {
                DynamicObject appExdDy = RptMetadataService.getAppExdDy(appObjs);
                if (appExdDy != null) {
                    extAppId = appExdDy.getString("id");
                }
            } else {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
                String extendAppId = GenMetaDataHelper.createExtendApp(appInfo.getCloudId(), appId);
                if (extendAppId != null) {
                    extAppId = extendAppId;
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u5546\u6743\u9650\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u5728\u7cfb\u7edf\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u5f00\u53d1\u5546\u6807\u8bc6\u3002", (String)"", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
                }
            }
        }
        return extAppId;
    }

    private static DynamicObject getAppExdDy(DynamicObject[] appObjs) {
        if (appObjs != null && appObjs.length > 0) {
            DynamicObject appObjExd = null;
            for (DynamicObject appObjDy : appObjs) {
                if (appObjExd == null) {
                    appObjExd = appObjDy;
                    continue;
                }
                String inheritPathExd = appObjExd.getString("inheritpath");
                String inheritPath = appObjDy.getString("inheritpath");
                if (!StringUtils.isNotBlank((CharSequence)inheritPathExd) || !StringUtils.isNotBlank((CharSequence)inheritPath) || inheritPath.length() <= inheritPathExd.length()) continue;
                appObjExd = appObjDy;
            }
            return appObjExd;
        }
        return null;
    }
}

