/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore.metadata.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjDataExtractService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.AnalysisObjectPresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.BizServicePresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.CustomSortInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import kd.hr.hrptmc.common.model.dataextract.AnObjExtractConfigBo;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;

public class RptDataExtractQueryConverter {
    private static final Log LOGGER = LogFactory.getLog(RptDataExtractQueryConverter.class);
    private static volatile RptDataExtractQueryConverter service = null;

    private RptDataExtractQueryConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RptDataExtractQueryConverter getInstance() {
        if (service != null) return service;
        Class<RptDataExtractQueryConverter> clazz = RptDataExtractQueryConverter.class;
        synchronized (RptDataExtractQueryConverter.class) {
            if (service != null) return service;
            service = new RptDataExtractQueryConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void convertReportQueryParam(ReportCalculateInfo calculateInfo) {
        LOGGER.info("-----RptDataExtractQueryConverter convertReportQueryParam start-----");
        try {
            AnObjExtractConfigBo anObjExtractConfig;
            DynamicObject config;
            Long reportId = calculateInfo.getReportId();
            Long anObjRelId = calculateInfo.getAnObjRelId();
            boolean getReportDataStore = false;
            if (reportId != null && (config = ReportManageService.getParamConfigWithSchedule(reportId)) != null && config.getBoolean("enableextract") && "2".equals(config.getString("schedulestatus"))) {
                LOGGER.info("RptDataExtractQueryConverter convertReportQueryParam report convert");
                this.convertForReportDataExtract(calculateInfo);
                getReportDataStore = true;
            }
            if (!getReportDataStore && anObjRelId != null && (anObjExtractConfig = AnObjDataExtractService.getInstance().getAnObjExtractConfig(anObjRelId)) != null && anObjExtractConfig.isOpenExtract() && "2".equals(anObjExtractConfig.getRunStatus())) {
                LOGGER.info("RptDataExtractQueryConverter convertReportQueryParam anObj convert");
                this.convertForAnObjDataExtract(calculateInfo);
            }
        }
        catch (Exception exception) {
            LOGGER.error("RptDataExtractQueryConverter convertReportQueryParam error: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\u3002", (String)"RptDataExtractQueryConverter_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
    }

    public void clearAnObjDataFilters(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        String storeEntityNumber = calculateInfo.getStoreEntityNumber();
        List<RptMetaFieldMap> storeFieldMapList = calculateInfo.getStoreFieldMapList();
        if (HRStringUtils.isEmpty((String)storeEntityNumber) || storeFieldMapList == null) {
            return;
        }
        LOGGER.info("-----RptDataExtractQueryConverter clearAnObjDataFilters start-----");
        complexObjContext.getQfilterList().clear();
    }

    public void convertComplexObjContext(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        String storeEntityNumber = calculateInfo.getStoreEntityNumber();
        List<RptMetaFieldMap> storeFieldMapList = calculateInfo.getStoreFieldMapList();
        if (HRStringUtils.isEmpty((String)storeEntityNumber) || storeFieldMapList == null) {
            return;
        }
        LOGGER.info("-----RptDataExtractQueryConverter convertComplexObjContext convert start-----");
        try {
            Map<String, RptMetaFieldMap> fieldMap = storeFieldMapList.stream().collect(Collectors.toMap(RptMetaFieldMap::getFieldAlias, Function.identity(), (k1, k2) -> k1));
            complexObjContext.setEntityNumber(storeEntityNumber);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)storeEntityNumber);
            complexObjContext.setEntityTable(dataEntityType.getAlias());
            List groupFieldList = complexObjContext.getGroupFieldList();
            for (Object groupFieldInfo : groupFieldList) {
                groupFieldInfo.setAlias(this.getConvertedFieldAlias(groupFieldInfo.getAlias(), fieldMap));
                groupFieldInfo.setFullPath(groupFieldInfo.getAlias());
            }
            List complexObjFieldInfoList = complexObjContext.getComplexObjFieldInfoList();
            for (Object hrComplexObjFieldInfo : complexObjFieldInfoList) {
                hrComplexObjFieldInfo.setAlias(this.getConvertedFieldAlias(hrComplexObjFieldInfo.getAlias(), fieldMap));
                if (!HRStringUtils.equals((String)hrComplexObjFieldInfo.getFieldType(), (String)"1")) continue;
                hrComplexObjFieldInfo.setFullPath(hrComplexObjFieldInfo.getAlias());
            }
            List sortFieldInfoList = complexObjContext.getSortFieldInfoList();
            for (Object sortFieldInfo : sortFieldInfoList) {
                sortFieldInfo.setFieldAlias(this.getConvertedFieldAlias(sortFieldInfo.getFieldAlias(), fieldMap));
            }
            List columnSortFieldInfoList = complexObjContext.getColumnSortFieldInfoList();
            for (SortFieldInfo sortFieldInfo : columnSortFieldInfoList) {
                sortFieldInfo.setFieldAlias(this.getConvertedFieldAlias(sortFieldInfo.getFieldAlias(), fieldMap));
            }
            for (QFilter qFilter : complexObjContext.getQfilterList()) {
                this.convertQFilter(qFilter, fieldMap);
            }
            List joinRelationList = complexObjContext.getJoinRelationList();
            joinRelationList.clear();
            complexObjContext.setDataExtractQuery(true);
        }
        catch (Exception exception) {
            LOGGER.error("RptDataExtractQueryConverter convertComplexObjContext error: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\u3002", (String)"RptDataExtractQueryConverter_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
    }

    private void convertForReportDataExtract(ReportCalculateInfo calculateInfo) {
        Long reportId = calculateInfo.getReportId();
        DynamicObject config = ReportManageService.getParamConfigWithSchedule(reportId);
        String entityNumber = config.getString("newentitynum");
        DynamicObject[] reportMappings = ReportManageService.getReportMappings(reportId);
        List<RptMetaFieldMap> rptMetaFieldMapList = Arrays.stream(reportMappings).map(rm -> {
            String numberAlias = rm.getString("numberalias");
            String fieldAlias = rm.getString("fieldalias");
            String metaDataFieldKey = rm.getString("metadatafieldkey");
            String metaDataControlKey = rm.getString("metadatacontrolkey");
            String tableFieldType = rm.getString("tablefieldtype");
            int tableFieldLength = rm.getInt("tablefieldlength");
            return new RptMetaFieldMap(fieldAlias, numberAlias, metaDataFieldKey, null, tableFieldLength, metaDataControlKey, tableFieldType);
        }).collect(Collectors.toList());
        this.convertReportCalculateInfo(calculateInfo, entityNumber, rptMetaFieldMapList, true);
    }

    private void convertForAnObjDataExtract(ReportCalculateInfo calculateInfo) {
        String entityNumber = AnObjDataExtractService.getInstance().getStoreMetadataNumber(calculateInfo.getAnObjRelId());
        List<RptMetaFieldMap> fieldMaps = AnObjDataExtractService.getInstance().queryFieldMapList(calculateInfo.getAnObjRelId());
        this.convertReportCalculateInfo(calculateInfo, entityNumber, fieldMaps, false);
    }

    private void convertReportCalculateInfo(ReportCalculateInfo calculateInfo, String entityNumber, List<RptMetaFieldMap> fieldMaps, boolean isReportDataExtract) {
        LOGGER.info("RptDataExtractQueryConverter convertReportCalculateInfo entityNumber:{}, fieldMaps: {}", (Object)entityNumber, fieldMaps);
        calculateInfo.setStoreEntityNumber(entityNumber);
        calculateInfo.setStoreFieldMapList(fieldMaps);
        Map<String, RptMetaFieldMap> fieldMap = fieldMaps.stream().collect(Collectors.toMap(RptMetaFieldMap::getFieldAlias, Function.identity(), (k1, k2) -> k1));
        List<ReportField> rowFieldList = calculateInfo.getRowFieldList();
        this.addBaseDataIdBySummary(rowFieldList, calculateInfo);
        calculateInfo.setRowFieldList(this.getFilterReportField(rowFieldList, fieldMap, isReportDataExtract));
        List<ReportField> columnFieldList = calculateInfo.getColumnFieldList();
        calculateInfo.setColumnFieldList(this.getFilterReportField(columnFieldList, fieldMap, isReportDataExtract));
        AdminOrgSummaryInfo adminOrgSummaryInfo = calculateInfo.getAdminOrgSummaryInfo();
        this.convertAdminOrgSummaryInfo(adminOrgSummaryInfo, fieldMap);
        List<TransposeConfigInfo> transposeConfigInfoList = calculateInfo.getTransposeConfigInfoList();
        this.convertTransposeConfigInfo(transposeConfigInfoList, fieldMap, isReportDataExtract);
        List<QFilter> originFilters = calculateInfo.getOriginFilters();
        this.convertQFilters(originFilters, fieldMap);
        List<QFilter> joinQFilterList = calculateInfo.getJoinQFilterList();
        this.convertQFilters(joinQFilterList, fieldMap);
        List<QFilter> qFilters = calculateInfo.getqFilterList();
        this.convertQFilters(qFilters, fieldMap);
        calculateInfo.setAnObjPivot(false);
        calculateInfo.setAnObjPivotService(null);
    }

    public void addBaseDataIdBySummary(List<ReportField> rowFieldList, ReportCalculateInfo calculateInfo) {
        ArrayList baseDataIdFields = Lists.newArrayListWithCapacity((int)10);
        List<TransposeConfigInfo> transposeConfigInfoList = calculateInfo.getTransposeConfigInfoList();
        HashSet transposeFieldKeySet = Sets.newHashSetWithExpectedSize((int)transposeConfigInfoList.size());
        for (TransposeConfigInfo transposeConfigInfo : transposeConfigInfoList) {
            List<ReportField> transposeFieldList = transposeConfigInfo.getTransposeFieldList();
            for (ReportField reportField : transposeFieldList) {
                transposeFieldKeySet.add(reportField.getFieldAlias());
            }
        }
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (ReportField reportField : rowFieldList) {
            FieldComplexType fieldComplexType;
            if (!(reportField instanceof EntityPropField) || reportField.isDependField() || !reportField.getFieldAlias().endsWith(".name") && !reportField.getFieldAlias().endsWith(".number") || transposeFieldKeySet.contains(reportField.getFieldAlias()) || (fieldComplexType = ((EntityPropField)reportField).getFieldComplexType()) == null || !AnalyseObjectUtil.isBaseDataType((String)fieldComplexType.getValue())) continue;
            LatitudeField baseDataIdField = new LatitudeField();
            String prefix = reportField.getFieldAlias().substring(0, reportField.getFieldAlias().lastIndexOf("."));
            baseDataIdField.setFieldAlias(prefix + ".id");
            String baseDataNumber = ((EntityPropField)reportField).getBaseDataNumber();
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(baseDataNumber);
            if (mainEntityType != null) {
                if (mainEntityType.getPrimaryKey() instanceof LongProp) {
                    baseDataIdField.setFieldType(DataTypeEnum.LONG.getDataTypeKey());
                } else {
                    baseDataIdField.setFieldType(DataTypeEnum.STRING.getDataTypeKey());
                }
            }
            baseDataIdField.setPropFullPath(baseDataIdField.getFieldAlias());
            baseDataIdField.setDependField(reportField.isDependField());
            baseDataIdFields.add(baseDataIdField);
        }
        rowFieldList.addAll(0, baseDataIdFields);
    }

    private void convertAdminOrgSummaryInfo(AdminOrgSummaryInfo adminOrgSummaryInfo, Map<String, RptMetaFieldMap> fieldMap) {
        if (adminOrgSummaryInfo != null) {
            RptMetaFieldMap rptMetaFieldMap = fieldMap.get(adminOrgSummaryInfo.getAdminOrgFieldAlias());
            if (rptMetaFieldMap == null) {
                return;
            }
            String idField = adminOrgSummaryInfo.getAdminOrgFieldAlias().substring(0, adminOrgSummaryInfo.getAdminOrgFieldAlias().lastIndexOf(".")) + ".id";
            rptMetaFieldMap = fieldMap.get(idField);
            String idNum = rptMetaFieldMap.getMetaFieldNumber().substring(0, rptMetaFieldMap.getMetaFieldNumber().lastIndexOf("."));
            adminOrgSummaryInfo.setAdminOrgFieldFullPath(idNum + ".id");
            String newNum = idNum + adminOrgSummaryInfo.getAdminOrgFieldAlias().substring(adminOrgSummaryInfo.getAdminOrgFieldAlias().lastIndexOf("."));
            adminOrgSummaryInfo.setAdminOrgFieldAlias(newNum);
        }
    }

    private void convertTransposeConfigInfo(List<TransposeConfigInfo> transposeConfigInfoList, Map<String, RptMetaFieldMap> fieldMap, boolean isReportDataExtract) {
        if (transposeConfigInfoList != null) {
            for (TransposeConfigInfo transposeConfigInfo : transposeConfigInfoList) {
                transposeConfigInfo.setTransposeFieldList(this.getFilterReportField(transposeConfigInfo.getTransposeFieldList(), fieldMap, isReportDataExtract));
                transposeConfigInfo.setTransposeValueFieldList(this.getFilterReportField(transposeConfigInfo.getTransposeValueFieldList(), fieldMap, isReportDataExtract));
            }
        }
    }

    private ReportField convertReportField(ReportField reportField, Map<String, RptMetaFieldMap> fieldMap, boolean isReportDataExtract) {
        RptMetaFieldMap rptMetaFieldMap;
        CustomSortInfo customSort;
        this.convertDateReportField(reportField, fieldMap, isReportDataExtract);
        String fieldAlias = reportField.getFieldAlias();
        String uniqueKey = reportField.getUniqueKey();
        if (isReportDataExtract) {
            reportField.setFieldAlias(this.getConvertedFieldAlias(fieldAlias, fieldMap));
        } else {
            reportField.setFieldAlias(this.getConvertedBaseDataFieldAlias(reportField, fieldMap));
        }
        FieldSortInfo fieldSort = reportField.getFieldSort();
        if (fieldSort != null) {
            fieldSort.setNumber(this.getConvertedFieldAlias(fieldSort.getNumber(), fieldMap));
        }
        if (HRStringUtils.equals((String)"custom", (String)reportField.getSortord()) && (customSort = reportField.getCustomSort()) != null && isReportDataExtract) {
            fieldSort = new FieldSortInfo();
            fieldSort.setNumber(fieldMap.get(fieldAlias + "\u03b9index").getMetaFieldNumber());
            fieldSort.setSort("desc");
            fieldSort.setFieldType(DataTypeEnum.INTEGER.getDataTypeKey());
            reportField.setFieldSort(fieldSort);
            reportField.setCustomSort(null);
            reportField.setSortord(SortEnum.FIELD.getValue());
        }
        if ((rptMetaFieldMap = fieldMap.get(fieldAlias)) != null) {
            if (reportField instanceof EntityPropField) {
                ((EntityPropField)reportField).setFieldControlType(FieldControlType.getFieldControlTypeByValue((String)rptMetaFieldMap.getFieldControlType()));
                ((EntityPropField)reportField).setPropName(rptMetaFieldMap.getMetaFieldNumber());
                ((EntityPropField)reportField).setPropFullPath(reportField.getFieldAlias());
            } else if (reportField instanceof AggregateIndexField) {
                if (AnalyseObjectService.getInstance().isIndexField(reportField.getFieldType())) {
                    EntityPrimitiveIndexField field = new EntityPrimitiveIndexField();
                    AggregateIndexField aggregateIndexField = (AggregateIndexField)reportField;
                    aggregateIndexField.setUniqueKey(uniqueKey);
                    this.copyProperties(aggregateIndexField, field);
                    return field;
                }
                LatitudeField field = new LatitudeField();
                field.setPropName(reportField.getFieldAlias());
                field.setFieldType(reportField.getFieldType());
                field.setFieldAlias(reportField.getFieldAlias());
                field.setFieldSort(reportField.getFieldSort());
                field.setCustomSort(reportField.getCustomSort());
                field.setUniqueKey(uniqueKey);
                field.setPropFullPath(reportField.getFieldAlias());
                return field;
            }
        }
        return null;
    }

    private String getConvertedBaseDataFieldAlias(ReportField reportField, Map<String, RptMetaFieldMap> fieldMap) {
        String fieldAlias = reportField.getFieldAlias();
        if (HRStringUtils.equals((String)"custom", (String)reportField.getSortord()) && reportField.getCustomSort() != null && (fieldAlias.endsWith(".name") || fieldAlias.endsWith(".number"))) {
            String idFieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(".")) + ".id";
            String suffixFieldNumber = fieldAlias.substring(fieldAlias.lastIndexOf("."));
            RptMetaFieldMap rptMetaFieldMap = fieldMap.get(idFieldAlias);
            if (rptMetaFieldMap != null) {
                return rptMetaFieldMap.getMetaFieldNumber().substring(0, rptMetaFieldMap.getMetaFieldNumber().lastIndexOf(".")) + suffixFieldNumber;
            }
        }
        return this.getConvertedFieldAlias(fieldAlias, fieldMap);
    }

    private void convertQFilters(List<QFilter> qFilters, Map<String, RptMetaFieldMap> fieldMap) {
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                this.convertQFilter(qFilter, fieldMap);
            }
        }
    }

    private void convertQFilter(QFilter qFilter, Map<String, RptMetaFieldMap> fieldMap) {
        String fieldAlias = qFilter.getProperty();
        int index = fieldAlias.indexOf("!");
        if (index != -1) {
            String dateFieldAlias = fieldAlias.substring(0, index);
            RptMetaFieldMap rptMetaFieldMap = fieldMap.get(dateFieldAlias);
            if (rptMetaFieldMap == null) {
                return;
            }
            fieldAlias = rptMetaFieldMap.getMetaFieldNumber() + fieldAlias.substring(index);
            qFilter.__setProperty(fieldAlias);
        } else {
            qFilter.__setProperty(this.getConvertedFieldAlias(fieldAlias, fieldMap));
        }
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter filter = nest.getFilter();
            this.convertQFilter(filter, fieldMap);
        }
    }

    private String getConvertedFieldAlias(String fieldAlias, Map<String, RptMetaFieldMap> fieldMap) {
        RptMetaFieldMap rptMetaFieldMap = fieldMap.get(fieldAlias);
        if (rptMetaFieldMap == null) {
            return fieldAlias;
        }
        return rptMetaFieldMap.getMetaFieldNumber();
    }

    private List<ReportField> getFilterReportField(List<ReportField> reportFieldList, Map<String, RptMetaFieldMap> fieldMap, boolean isReportDataExtract) {
        ArrayList filterRowFieldList = Lists.newArrayListWithExpectedSize((int)reportFieldList.size());
        for (ReportField reportField : reportFieldList) {
            if (fieldMap.containsKey(reportField.getFieldAlias()) || this.isDateSplitWithDate(reportField.getFieldAlias(), isReportDataExtract)) {
                ReportField newReportField = this.convertReportField(reportField, fieldMap, isReportDataExtract);
                if (newReportField != null) {
                    filterRowFieldList.add(newReportField);
                    continue;
                }
                filterRowFieldList.add(reportField);
                continue;
            }
            if (reportField instanceof AnalysisObjectPresetIndexField || reportField instanceof BizServicePresetIndexField) {
                filterRowFieldList.add(reportField);
                continue;
            }
            if (reportField instanceof NonAggregateIndexField) {
                filterRowFieldList.add(reportField);
                continue;
            }
            if (!(reportField instanceof AggregateIndexField)) continue;
            Set<String> dependentFieldSet = ((AggregateIndexField)reportField).getDependentFieldSet();
            if (dependentFieldSet != null && !dependentFieldSet.isEmpty()) {
                String calcFormula = ((AggregateIndexField)reportField).getCalcFormulaInfo();
                HashSet mapDependFieldSet = Sets.newHashSetWithExpectedSize((int)dependentFieldSet.size());
                for (String dependField : dependentFieldSet) {
                    RptMetaFieldMap dependRptMetaFieldMap = fieldMap.get(dependField);
                    if (dependRptMetaFieldMap != null) {
                        mapDependFieldSet.add(dependRptMetaFieldMap.getMetaFieldNumber());
                        calcFormula = calcFormula.replace(dependField, dependRptMetaFieldMap.getMetaFieldNumber());
                        continue;
                    }
                    mapDependFieldSet.add(dependField);
                }
                ((AggregateIndexField)reportField).setDependentFieldSet(mapDependFieldSet);
                ((AggregateIndexField)reportField).setCalcFormulaInfo(calcFormula);
            }
            filterRowFieldList.add(reportField);
        }
        return filterRowFieldList;
    }

    private void convertPreIndexDimMapFields(PresetIndexField preIndexField, Map<String, RptMetaFieldMap> fieldMap, boolean isReportDataExtract) {
        DimMapBo dimMap = preIndexField.getDimMap();
        if (dimMap == null) {
            return;
        }
        List dimMapEntryBos = dimMap.getDimMapEntryBos();
        for (DimMapEntryBo dimMapEntryBo : dimMapEntryBos) {
            String dimNumber = dimMapEntryBo.getDimNumber();
            if (dimNumber.contains("!")) {
                if (isReportDataExtract && (dimNumber.contains(SplitDateTypeEnum.SN_QUARTER.getKey()) || dimNumber.contains(SplitDateTypeEnum.FN_QUARTER.getKey()) || dimNumber.contains(SplitDateTypeEnum.SN_MONTH.getKey()) || dimNumber.contains(SplitDateTypeEnum.FN_MONTH.getKey()) || dimNumber.contains(SplitDateTypeEnum.SN_DAY.getKey()) || dimNumber.contains(SplitDateTypeEnum.FN_DAY.getKey()))) {
                    dimMapEntryBo.setDimNumber(this.getConvertedFieldAlias(dimNumber, fieldMap));
                    continue;
                }
                int index = dimNumber.indexOf("!");
                String dateFieldAlias = dimNumber.substring(0, index);
                RptMetaFieldMap rptMetaFieldMap = fieldMap.get(dateFieldAlias);
                if (rptMetaFieldMap == null) continue;
                dimMapEntryBo.setDimNumber(rptMetaFieldMap.getMetaFieldNumber() + dimNumber.substring(index));
                continue;
            }
            dimMapEntryBo.setDimNumber(this.getConvertedFieldAlias(dimNumber, fieldMap));
        }
    }

    private boolean isDateSplitWithDate(String fieldAlias, boolean isReportDataExtract) {
        if (fieldAlias.contains("!")) {
            if (isReportDataExtract) {
                return fieldAlias.contains(SplitDateTypeEnum.SN_YEAR.getKey()) || fieldAlias.contains(SplitDateTypeEnum.FN_YEAR.getKey()) || fieldAlias.contains(SplitDateTypeEnum.SN_YEAR_QUARTER.getKey()) || fieldAlias.contains(SplitDateTypeEnum.FN_YEAR_QUARTER.getKey()) || fieldAlias.contains(SplitDateTypeEnum.SN_YEAR_MONTH.getKey()) || fieldAlias.contains(SplitDateTypeEnum.FN_YEAR_MONTH.getKey()) || fieldAlias.contains(SplitDateTypeEnum.FN_YEAR_MONTH_DAY.getKey());
            }
            return true;
        }
        return false;
    }

    private void convertDateReportField(ReportField reportField, Map<String, RptMetaFieldMap> fieldMap, boolean isReportDataExtract) {
        if (reportField.getFieldAlias().contains("!")) {
            int index;
            if (isReportDataExtract && (reportField.getFieldAlias().contains(SplitDateTypeEnum.SN_QUARTER.getKey()) || reportField.getFieldAlias().contains(SplitDateTypeEnum.FN_QUARTER.getKey()) || reportField.getFieldAlias().contains(SplitDateTypeEnum.SN_MONTH.getKey()) || reportField.getFieldAlias().contains(SplitDateTypeEnum.FN_MONTH.getKey()) || reportField.getFieldAlias().contains(SplitDateTypeEnum.SN_DAY.getKey()) || reportField.getFieldAlias().contains(SplitDateTypeEnum.FN_DAY.getKey()))) {
                reportField.setFieldType(DataTypeEnum.STRING.getDataTypeKey());
                return;
            }
            String fieldAlias = reportField.getFieldAlias();
            String dateFieldAlias = fieldAlias.substring(0, index = fieldAlias.indexOf("!"));
            RptMetaFieldMap rptMetaFieldMap = fieldMap.get(dateFieldAlias);
            if (rptMetaFieldMap != null) {
                reportField.setFieldAlias(rptMetaFieldMap.getMetaFieldNumber() + fieldAlias.substring(index));
            }
        }
    }

    private void copyProperties(AggregateIndexField aggregateIndexField, EntityPrimitiveIndexField field) {
        field.setFieldAlias(aggregateIndexField.getFieldAlias());
        field.setFieldType(aggregateIndexField.getFieldType());
        field.setSortord(aggregateIndexField.getSortord());
        field.setFieldSort(aggregateIndexField.getFieldSort());
        field.setCustomSort(aggregateIndexField.getCustomSort());
        field.setUniqueKey(aggregateIndexField.getUniqueKey());
        field.setFieldId(aggregateIndexField.getFieldId());
        field.setCalcFunction(aggregateIndexField.getCalcFunction());
        field.setDependField(aggregateIndexField.isDependField());
    }
}

