/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.datastore.physicaltable.model;

import java.io.Serializable;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;

public class ReportDataStoreFieldBo
implements Serializable {
    private static final long serialVersionUID = -963704442254507868L;
    private String fieldDisplayName;
    private String fieldName;
    private ReportDataStoreType type = ReportDataStoreType.VARCHAR;
    private int length;
    private Object defaultVal;
    private boolean allowNull;
    private boolean isMulLanField = false;
    private String splitTableSuffix;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public ReportDataStoreType getType() {
        return this.type;
    }

    public void setType(ReportDataStoreType type) {
        this.type = type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Object getDefaultVal() {
        return this.defaultVal;
    }

    public void setDefaultVal(Object defaultVal) {
        this.defaultVal = defaultVal;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public String getFieldDisplayName() {
        return this.fieldDisplayName;
    }

    public void setFieldDisplayName(String fieldDisplayName) {
        this.fieldDisplayName = fieldDisplayName;
    }

    public boolean isMulLanField() {
        return this.isMulLanField;
    }

    public void setMulLanField(boolean mulLanField) {
        this.isMulLanField = mulLanField;
    }

    public String getSplitTableSuffix() {
        return this.splitTableSuffix;
    }

    public void setSplitTableSuffix(String splitTableSuffix) {
        this.splitTableSuffix = splitTableSuffix;
    }

    public String getDefaultControlType() {
        String controlType = FieldControlType.OTHER.getValue();
        switch (this.type) {
            case INT: {
                controlType = FieldControlType.INTEGER.getValue();
                break;
            }
            case BIGINT: {
                controlType = FieldControlType.BIGINT.getValue();
                break;
            }
            case DECIMAL: {
                controlType = FieldControlType.DECIMAL.getValue();
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case NVARCHAR: 
            case TEXT: {
                controlType = FieldControlType.TEXT.getValue();
                break;
            }
            case DATETIME: {
                controlType = FieldControlType.DATE.getValue();
                break;
            }
        }
        return controlType;
    }

    public String getValueType() {
        String valueType = DataTypeEnum.STRING.getDataTypeKey();
        switch (this.type) {
            case INT: {
                valueType = DataTypeEnum.INTEGER.getDataTypeKey();
                break;
            }
            case BIGINT: {
                valueType = DataTypeEnum.LONG.getDataTypeKey();
                break;
            }
            case DECIMAL: {
                valueType = DataTypeEnum.BIGDECIMAL.getDataTypeKey();
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case NVARCHAR: 
            case TEXT: {
                valueType = DataTypeEnum.STRING.getDataTypeKey();
                break;
            }
            case DATETIME: {
                valueType = DataTypeEnum.DATETIME.getDataTypeKey();
                break;
            }
        }
        return valueType;
    }

    public String toString() {
        String result = this.fieldName + " " + this.type.getType();
        result = this.type == ReportDataStoreType.CHAR || this.type == ReportDataStoreType.VARCHAR || this.type == ReportDataStoreType.NVARCHAR ? result + "(" + this.length + ") " : (this.getType() == ReportDataStoreType.DECIMAL ? result + "(23,10) " : result + " ");
        if (this.defaultVal != null) {
            result = result + "DEFAULT " + this.defaultVal + " ";
        }
        if (!this.allowNull) {
            result = result + "NOT NULL";
        }
        return result;
    }
}

