/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.exp.HReportConfExpEntityConf;
import kd.hr.hrptmc.business.exp.complexconvert.BaseComplexPropConvert;
import kd.hr.hrptmc.business.exp.complexconvert.ComplexPropConvertFactory;
import kd.hr.hrptmc.common.model.exp.ExpEntityBo;
import kd.hr.hrptmc.common.model.exp.RptRefComplexPropBo;

public class HReportConfExpService {
    private DynamicObject[] queryFieldArr;
    private Object anObjPk;

    public ExpEntityBo getExpEntityData(HReportConfExpEntityConf expEntityConf, Object relData) {
        ExpEntityBo expEntityBo = this.loadExpData(expEntityConf, relData, null, null);
        if (this.queryFieldArr == null) {
            String anObjPkField = expEntityConf.getAnObjPkField();
            this.anObjPk = expEntityBo.getData().get(anObjPkField);
        }
        this.recursionTransBdProp(expEntityBo);
        return expEntityBo;
    }

    public List<ExpEntityBo> getExpEntityDataList(HReportConfExpEntityConf expEntityConf, Object relData) {
        List<ExpEntityBo> expEntityBoList = this.loadExpDataList(expEntityConf, relData, null, null);
        if (this.queryFieldArr == null) {
            for (ExpEntityBo entityBo : expEntityBoList) {
                String anObjPkField = expEntityConf.getAnObjPkField();
                this.anObjPk = entityBo.getData().get(anObjPkField);
            }
        }
        for (ExpEntityBo expEntityBo : expEntityBoList) {
            this.recursionTransBdProp(expEntityBo);
        }
        return expEntityBoList;
    }

    private void recursionTransBdProp(ExpEntityBo expEntityBo) {
        this.transBdPropData(expEntityBo);
        List one2OneEntityList = expEntityBo.getOne2OneEntityList();
        for (ExpEntityBo entityBo : one2OneEntityList) {
            this.recursionTransBdProp(entityBo);
        }
        Map one2ManyEntityMapList = expEntityBo.getOne2ManyEntityMapList();
        one2ManyEntityMapList.forEach((key, value) -> {
            for (ExpEntityBo entityBo : value) {
                this.recursionTransBdProp(entityBo);
            }
        });
    }

    private void transBdPropData(ExpEntityBo expEntityData) {
        List refComplexPropBoList = expEntityData.getRefComplexPropBoList();
        if (refComplexPropBoList == null) {
            return;
        }
        Map data = expEntityData.getData();
        for (RptRefComplexPropBo refComplexPropBo : refComplexPropBoList) {
            BaseComplexPropConvert complexPropConvert = ComplexPropConvertFactory.produceConvert(refComplexPropBo.getType());
            if (complexPropConvert == null) continue;
            complexPropConvert.setQueryFieldArr(this.queryFieldArr);
            complexPropConvert.setAnObjPk(this.anObjPk);
            complexPropConvert.transBdPropData(expEntityData.getAnObjMainEntityNumber(), expEntityData.getAnObjRelEntityMap(), data, refComplexPropBo);
        }
    }

    public ExpEntityBo loadExpData(HReportConfExpEntityConf expEntityConf, Object relData, String anObjEntityNumber, Map<String, String> anObjRelEntityMap) {
        List<String> fieldList = expEntityConf.getFieldList();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(expEntityConf.getEntityNumber());
        String relField = expEntityConf.getRelField();
        DynamicObject dynamicObject = null;
        if (relData != null && !HRStringUtils.isEmpty((String)relData.toString()) && !"0".equals(relData.toString())) {
            if (HRStringUtils.isEmpty((String)relField)) {
                try {
                    dynamicObject = serviceHelper.loadSingle(relData);
                }
                catch (Exception exception) {}
            } else {
                QFilter qFilter = new QFilter(relField, "=", relData);
                dynamicObject = serviceHelper.loadDynamicObject(qFilter);
            }
        }
        return this.getExpEntityBo(expEntityConf, fieldList, dynamicObject, anObjEntityNumber, anObjRelEntityMap);
    }

    private DynamicObject[] queryJoinEntity(Object anObjPk) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_anobjjoinentity");
        return serviceHelper.queryOriginalArray("entitynumber,entityalias,type", new QFilter[]{new QFilter("anobj", "=", anObjPk)});
    }

    private ExpEntityBo getExpEntityBo(HReportConfExpEntityConf expEntityConf, List<String> fieldList, DynamicObject dynamicObject, String anObjEntityNumber, Map<String, String> anObjRelEntityMap) {
        List<HReportConfExpEntityConf> one2ManyConfList;
        List<HReportConfExpEntityConf> one2OneConfList;
        ExpEntityBo expEntityBo = new ExpEntityBo();
        expEntityBo.setEntityNumber(expEntityConf.getEntityNumber());
        expEntityBo.setFields(fieldList);
        expEntityBo.setData(this.genDataNodeList(dynamicObject, fieldList, expEntityConf.getDefValMap()));
        expEntityBo.setRefComplexPropBoList(expEntityConf.getRefComplexPropBoList());
        String anObjPkField = expEntityConf.getAnObjPkField();
        if (HRStringUtils.isNotEmpty((String)anObjEntityNumber)) {
            expEntityBo.setAnObjMainEntityNumber(anObjEntityNumber);
            expEntityBo.setAnObjRelEntityMap(anObjRelEntityMap);
        } else if (HRStringUtils.isNotEmpty((String)anObjPkField)) {
            this.loadAnObjRelEntityInfo(expEntityBo, anObjPkField);
        }
        Object relObj = null;
        if (dynamicObject != null) {
            relObj = dynamicObject.get(expEntityConf.getForeignKey());
        }
        if ((one2OneConfList = expEntityConf.getOne2OneConfList()) != null) {
            for (HReportConfExpEntityConf conf : one2OneConfList) {
                expEntityBo.getOne2OneEntityList().add(this.loadExpData(conf, relObj, expEntityBo.getAnObjMainEntityNumber(), expEntityBo.getAnObjRelEntityMap()));
            }
        }
        if ((one2ManyConfList = expEntityConf.getOne2ManyConfList()) != null) {
            for (HReportConfExpEntityConf conf : one2ManyConfList) {
                expEntityBo.getOne2ManyEntityMapList().put(conf.getEntityNumber(), this.loadExpDataList(conf, relObj, expEntityBo.getAnObjMainEntityNumber(), expEntityBo.getAnObjRelEntityMap()));
            }
        }
        return expEntityBo;
    }

    private void loadAnObjRelEntityInfo(ExpEntityBo expEntityBo, String anObjPkField) {
        Object anObjPk = expEntityBo.getData().get(anObjPkField);
        if (!(anObjPk instanceof Long)) {
            return;
        }
        DynamicObject[] joinEntityDyoArr = this.queryJoinEntity(anObjPk);
        if (joinEntityDyoArr == null) {
            return;
        }
        for (DynamicObject joinEntityDyo : joinEntityDyoArr) {
            if ("main".equals(joinEntityDyo.getString("type"))) {
                expEntityBo.setAnObjMainEntityNumber(joinEntityDyo.getString("entitynumber"));
                continue;
            }
            expEntityBo.addAnObjRelEntityMap(joinEntityDyo.getString("entityalias"), joinEntityDyo.getString("entitynumber"));
        }
    }

    public List<ExpEntityBo> loadExpDataList(HReportConfExpEntityConf expEntityConf, Object relData, String anObjEntityNumber, Map<String, String> anObjRelEntityMap) {
        ArrayList<ExpEntityBo> expEntityBoList = new ArrayList<ExpEntityBo>(10);
        if (relData != null) {
            List<String> fieldList = expEntityConf.getFieldList();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(expEntityConf.getEntityNumber());
            String relField = expEntityConf.getRelField();
            QFilter qFilter = new QFilter(relField, "=", relData);
            DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
            if ("hrptmc_anobjqueryfield".equals(expEntityConf.getEntityNumber())) {
                this.queryFieldArr = dynamicObjects;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                ExpEntityBo expEntityBo = this.getExpEntityBo(expEntityConf, fieldList, dynamicObject, anObjEntityNumber, anObjRelEntityMap);
                expEntityBoList.add(expEntityBo);
            }
        }
        return expEntityBoList;
    }

    private Map<String, Object> genDataNodeList(DynamicObject dynamicObject, List<String> fields, Map<String, Object> defValMap) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(0);
        if (dynamicObject == null) {
            return data;
        }
        for (String field : fields) {
            List<Map<String, Object>> obj;
            Object defVal;
            if (defValMap != null && Objects.nonNull(defVal = defValMap.get(field))) {
                data.put(field, defVal);
                continue;
            }
            List<Map<String, Object>> val = obj = dynamicObject.get(field);
            if (obj instanceof DynamicObject) {
                DynamicObject subDyo = (DynamicObject)obj;
                val = this.getDynObjKey(subDyo);
            } else if (obj instanceof DynamicObjectCollection) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(field);
                val = this.transEntryToListMap(dynamicObjectCollection);
            }
            data.put(field, val);
        }
        return data;
    }

    private List<Map<String, Object>> transEntryToListMap(DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<Map<String, Object>> entryData = new ArrayList<Map<String, Object>>(10);
        DynamicObjectType dynamicObjectType = dynamicObjectCollection.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        for (DynamicObject object : dynamicObjectCollection) {
            HashMap<String, Object> tmpData = new HashMap<String, Object>(16);
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (property.isDbIgnore() || property instanceof DynamicLocaleProperty) continue;
                if (property instanceof PKFieldProp && ((PKFieldProp)property).isRefId()) {
                    String realProp = propertyName;
                    if (realProp.endsWith("_id")) {
                        realProp = realProp.substring(0, realProp.length() - 3);
                    }
                    tmpData.put(realProp, object.get(propertyName));
                    continue;
                }
                if (property instanceof DynamicObject) {
                    DynamicObject tmpDyo = object.getDynamicObject(propertyName);
                    tmpData.put(propertyName, this.getDynObjKey(tmpDyo));
                    continue;
                }
                tmpData.put(propertyName, object.get(propertyName));
            }
            entryData.add(tmpData);
        }
        return entryData;
    }

    private Object getDynObjKey(DynamicObject dynObj) {
        return dynObj.getPkValue();
    }
}

