/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exp.complexconvert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.exp.util.FieldAliasParseUtil;
import kd.hr.hrptmc.common.model.exp.RptRefComplexPropBo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public abstract class BaseComplexPropConvert {
    protected MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
    private DynamicObject[] queryFieldArr;
    private Object anObjPk;

    public abstract void transBdPropData(String var1, Map<String, String> var2, Map<String, Object> var3, RptRefComplexPropBo var4);

    protected String transBdPksToUks(String mainEntityNumber, Map<String, String> relEntityMap, String fieldAlias, String pkStr) {
        String bdEntityNumber = FieldAliasParseUtil.getBdPropEntityNumber(mainEntityNumber, relEntityMap, fieldAlias, this.entityTypeUtil);
        return this.transBdPksToUks(bdEntityNumber, pkStr);
    }

    protected String transBdPksToUks(String bdEntityNumber, String pkStr) {
        if (HRStringUtils.isEmpty((String)bdEntityNumber) || HRStringUtils.isEmpty((String)pkStr)) {
            return null;
        }
        Class propertyType = this.entityTypeUtil.getMainEntityType(bdEntityNumber).getPrimaryKey().getPropertyType();
        String ID_SPLIT = ",";
        List<Object> pkList = propertyType == String.class ? Arrays.stream(pkStr.split(ID_SPLIT)).collect(Collectors.toList()) : Arrays.stream(pkStr.split(ID_SPLIT)).map(Long::valueOf).collect(Collectors.toList());
        List<String> uniqueKeyList = this.getUniqueKeyList(bdEntityNumber, pkList);
        return String.join((CharSequence)ID_SPLIT, uniqueKeyList);
    }

    protected List<String> getUniqueKeyList(String entityNumber, List<Object> pkList) {
        ArrayList<String> uniqueKeyList = new ArrayList<String>(10);
        if (CollectionUtils.isNotEmpty(pkList)) {
            DynamicObject[] dynamicObjects;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            for (DynamicObject dynamicObject : dynamicObjects = serviceHelper.queryOriginalArray("id,number,name", new QFilter[]{new QFilter("id", "in", pkList)})) {
                String number = dynamicObject.getString("number");
                String name = dynamicObject.getString("name");
                String uniqueKey = number + "\u03b5" + name;
                uniqueKeyList.add(uniqueKey);
            }
        }
        return uniqueKeyList;
    }

    protected Map<Object, String> getUniqueKeyMap(String entityNumber, List<Object> pkList) {
        HashMap<Object, String> uniqueKeyMap = new HashMap<Object, String>(16);
        if (CollectionUtils.isNotEmpty(pkList)) {
            DynamicObject[] dynamicObjects;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            for (DynamicObject dynamicObject : dynamicObjects = serviceHelper.queryOriginalArray("id,number,name", new QFilter[]{new QFilter("id", "in", pkList)})) {
                String number = dynamicObject.getString("number");
                String name = dynamicObject.getString("name");
                String uniqueKey = number + "\u03b5" + name;
                uniqueKeyMap.put(dynamicObject.get("id"), uniqueKey);
            }
        }
        return uniqueKeyMap;
    }

    protected String queryFieldAlias(Long pk) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("fieldalias", (Object)pk);
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("fieldalias");
    }

    protected String getFieldAlias(Map<String, Object> data, RptRefComplexPropBo refComplexPropBo) {
        if (MapUtils.isEmpty(data)) {
            return null;
        }
        Object fieldAliasObj = data.get(refComplexPropBo.getFieldNameStoreField());
        if (fieldAliasObj == null) {
            return null;
        }
        String fieldAlias = refComplexPropBo.isStoreFieldIsPk() ? this.queryFieldAlias((Long)fieldAliasObj) : fieldAliasObj.toString();
        return fieldAlias;
    }

    public DynamicObject[] getQueryFieldArr() {
        return this.queryFieldArr;
    }

    public void setQueryFieldArr(DynamicObject[] queryFieldArr) {
        this.queryFieldArr = queryFieldArr;
    }

    public Object getAnObjPk() {
        return this.anObjPk;
    }

    public void setAnObjPk(Object anObjPk) {
        this.anObjPk = anObjPk;
    }
}

