/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exp.complexconvert;

import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.exp.complexconvert.BaseComplexPropConvert;
import kd.hr.hrptmc.common.model.exp.RptRefComplexPropBo;

public class ComplexConditionConvert
extends BaseComplexPropConvert {
    private static final Log LOGGER = LogFactory.getLog(ComplexConditionConvert.class);

    @Override
    public void transBdPropData(String mainEntityNumber, Map<String, String> relEntityMap, Map<String, Object> data, RptRefComplexPropBo refComplexPropBo) {
        String fieldValStoreField = refComplexPropBo.getFieldValStoreField();
        String conditionStr = (String)data.get(fieldValStoreField);
        if (HRStringUtils.isEmpty((String)conditionStr)) {
            return;
        }
        try {
            RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionStr, RuleConditionInfo.class);
            DynamicObject[] queryFieldArr = this.getQueryFieldArr();
            Object anObjPk = this.getAnObjPk();
            if (queryFieldArr == null && anObjPk != null) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
                queryFieldArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", anObjPk)});
            }
            if (queryFieldArr == null) {
                return;
            }
            for (ConditionInfo info : conditionInfo.getConditionList()) {
                String paramType = info.getParamType();
                String objectStr = info.getValue();
                if (!HRStringUtils.equals((String)paramType, (String)"dynamicObject") || HRStringUtils.isEmpty((String)objectStr)) continue;
                String fieldAlias = info.getParam();
                for (DynamicObject dynamicObject : queryFieldArr) {
                    QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
                    queryFieldCommonBo.setEntityNumber(dynamicObject.getString("entitynumber"));
                    queryFieldCommonBo.setFieldAlias(dynamicObject.getString("fieldalias"));
                    queryFieldCommonBo.setFieldPath(dynamicObject.getString("fieldpath"));
                    if (!queryFieldCommonBo.getHRFilterParam().equals(fieldAlias)) continue;
                    fieldAlias = queryFieldCommonBo.getFieldAlias();
                    break;
                }
                String uniqueKey = this.transBdPksToUks(mainEntityNumber, relEntityMap, fieldAlias, objectStr);
                info.setValue(uniqueKey);
            }
            data.put(fieldValStoreField, SerializationUtils.toJsonString((Object)conditionInfo));
        }
        catch (Exception e) {
            LOGGER.error("BaseComplexPropConvert convert error:", (Throwable)e);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u8f6c\u6362\u5931\u8d25:%s\u3002", (String)"ComplexConditionConvert_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), conditionStr));
        }
    }
}

