/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exp.complexconvert;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.exp.complexconvert.BaseComplexPropConvert;
import kd.hr.hrptmc.business.repdesign.enums.ParamTypeEnum;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleMapInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleRuleInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.model.exp.RptRefComplexPropBo;

public class ComplexConditionStyleConvert
extends BaseComplexPropConvert {
    private static final Log LOGGER = LogFactory.getLog(ComplexConditionStyleConvert.class);

    @Override
    public void transBdPropData(String mainEntityNumber, Map<String, String> relEntityMap, Map<String, Object> data, RptRefComplexPropBo refComplexPropBo) {
        String rowJson = (String)data.get("row");
        String columnJson = (String)data.get("column");
        try {
            List rows = Lists.newArrayListWithCapacity((int)10);
            List columns = Lists.newArrayListWithCapacity((int)10);
            if (HRStringUtils.isNotEmpty((String)rowJson)) {
                rows = SerializationUtils.fromJsonStringToList((String)rowJson, RowFieldInfo.class);
            }
            if (HRStringUtils.isNotEmpty((String)columnJson)) {
                columns = SerializationUtils.fromJsonStringToList((String)columnJson, FieldInfo.class);
            }
            for (RowFieldInfo row : rows) {
                if ("1".equals(row.getMergeType())) {
                    this.recursive(row._getChildFields(), this::parseReportFieldInfoForStyle);
                    continue;
                }
                this.parseReportFieldInfoForStyle(row.getGroupName());
            }
            for (FieldInfo col : columns) {
                this.parseReportFieldInfoForStyle(col);
            }
            data.put("row", SerializationUtils.toJsonString(rows));
            data.put("column", SerializationUtils.toJsonString(columns));
        }
        catch (Exception e) {
            LOGGER.error("BaseComplexPropConvert convert error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u683c\u5f0f\u8f6c\u6362\u5931\u8d25\u3002", (String)"ComplexConditionStyleConvert_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
    }

    private void parseReportFieldInfoForStyle(FieldInfo field) {
        List<ReportStyleMapInfo> styleMaps = field.getStyleMaps();
        if (styleMaps == null) {
            return;
        }
        String baseDataNum = field.getBaseDataNum();
        for (ReportStyleMapInfo styleMap : styleMaps) {
            Class propertyType;
            List<Object> pkList;
            List<String> uniqueKeyList;
            List objects;
            String value;
            ReportStyleRuleInfo ruleInfo = styleMap.getR();
            String pt = ruleInfo.getPt();
            if (!HRStringUtils.equals((String)pt, (String)ParamTypeEnum.BASEDATA.getType()) && !HRStringUtils.equals((String)pt, (String)ParamTypeEnum.ADMINORG.getType()) || HRStringUtils.isEmpty((String)(value = ruleInfo.getV())) || (objects = SerializationUtils.fromJsonStringToList((String)value, String.class)).isEmpty() || (uniqueKeyList = this.getUniqueKeyList(baseDataNum, pkList = (propertyType = this.entityTypeUtil.getMainEntityType(baseDataNum).getPrimaryKey().getPropertyType()) == String.class ? Collections.singletonList(objects) : objects.stream().map(Long::valueOf).collect(Collectors.toList()))).isEmpty()) continue;
            ruleInfo.setV(SerializationUtils.toJsonString(uniqueKeyList));
        }
    }

    private void recursive(List<FieldInfo> fields, Consumer<FieldInfo> consumer) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (FieldInfo children : fields) {
            if (!"0".equals(children.getType())) {
                consumer.accept(children);
            }
            if (!CollectionUtils.isNotEmpty(children.getFields())) continue;
            this.recursive(children.getFields(), consumer);
        }
    }
}

