/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exp.complexconvert;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hrptmc.business.exp.complexconvert.BaseComplexPropConvert;
import kd.hr.hrptmc.common.model.exp.RptRefComplexPropBo;
import org.apache.commons.collections.MapUtils;

public class ComplexJoinConditionConvert
extends BaseComplexPropConvert {
    private static final Log LOGGER = LogFactory.getLog(ComplexJoinConditionConvert.class);

    @Override
    public void transBdPropData(String mainEntityNumber, Map<String, String> relEntityMap, Map<String, Object> data, RptRefComplexPropBo refComplexPropBo) {
        String entryName = refComplexPropBo.getEntryName();
        Object entryListMapObj = data.get(entryName);
        if (!(entryListMapObj instanceof List)) {
            return;
        }
        List entryDataList = (List)entryListMapObj;
        String fieldValStoreField = refComplexPropBo.getFieldValStoreField();
        try {
            for (Map entryDataMap : entryDataList) {
                String fieldAlias;
                if (MapUtils.isEmpty((Map)entryDataMap)) continue;
                QFilter specialQFilter = refComplexPropBo.getSpecialQFilter();
                if (specialQFilter != null) {
                    String filterVal = (String)entryDataMap.get(specialQFilter.getProperty());
                    if (!specialQFilter.getValue().equals(filterVal)) continue;
                }
                if (!(fieldAlias = (String)entryDataMap.get(refComplexPropBo.getFieldNameStoreField())).endsWith(".id")) continue;
                String pkStr = (String)entryDataMap.get(fieldValStoreField);
                List pkCol = Arrays.stream(pkStr.split(",")).collect(Collectors.toList());
                pkStr = String.join((CharSequence)",", pkCol = pkCol.stream().map(pk -> {
                    if (pk.startsWith("'") && pk.endsWith("'")) {
                        return pk.substring(1, pk.length() - 1);
                    }
                    return pk;
                }).collect(Collectors.toList()));
                String uniqueKey = this.transBdPksToUks(mainEntityNumber, relEntityMap, fieldAlias, pkStr);
                if (uniqueKey == null) continue;
                entryDataMap.put(fieldValStoreField, uniqueKey);
            }
        }
        catch (Exception e) {
            LOGGER.error("BaseComplexPropConvert convert error:", (Throwable)e);
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u62a5\u8868\u8df3\u8f6c\u914d\u7f6e\u8f6c\u6362\u5931\u8d25:%s\u3002", (String)"ComplexEntryPropConvert_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), fieldValStoreField));
        }
    }
}

