/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exp.util;

import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class FieldAliasParseUtil {
    public static String getBdPropEntityNumber(String mainEntityNumber, Map<String, String> relEntityMap, String fieldAlias, MainEntityTypeUtil entityTypeUtil) {
        if (HRStringUtils.isEmpty((String)mainEntityNumber) || HRStringUtils.isEmpty((String)fieldAlias)) {
            return null;
        }
        String[] split = fieldAlias.split("\\.");
        String curEntityNumber = mainEntityNumber;
        if (relEntityMap != null && relEntityMap.containsKey(split[0])) {
            curEntityNumber = relEntityMap.get(split[0]);
            split = Arrays.copyOfRange(split, 1, split.length);
        }
        return FieldAliasParseUtil.getParentEntityNumber(curEntityNumber, split, entityTypeUtil, true);
    }

    private static String getParentEntityNumber(String curEntityNumber, String[] propSplit, MainEntityTypeUtil entityTypeUtil, boolean isHost) {
        if (propSplit == null || HRStringUtils.isEmpty((String)curEntityNumber)) {
            return null;
        }
        String firstProp = propSplit[0];
        MainEntityType entityType = entityTypeUtil.getMainEntityType(curEntityNumber);
        DynamicProperty property = entityType.getProperty(firstProp);
        if (property instanceof DynamicComplexProperty) {
            DynamicComplexProperty complexProperty = (DynamicComplexProperty)property;
            curEntityNumber = complexProperty.getComplexType().getName();
            if (propSplit.length > 1) {
                propSplit = Arrays.copyOfRange(propSplit, 1, propSplit.length);
                return FieldAliasParseUtil.getParentEntityNumber(curEntityNumber, propSplit, entityTypeUtil, false);
            }
        } else if (property instanceof ComboProp) {
            return null;
        }
        if (isHost) {
            return null;
        }
        return curEntityNumber;
    }
}

