/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exportconfig;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class HRReportMetaDataHelper {
    private static final Log logger = LogFactory.getLog(HRReportMetaDataHelper.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String DOWNLOAD_PATH = "KINGDEEDOWNLOAD";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPageSource(IFormView formView, String bizNumber) {
        if (bizNumber == null) {
            logger.info("the metadata number is null");
            return;
        }
        MetadataReader metadataReader = new MetadataReader();
        String bizId = metadataReader.loadIdByNumber(bizNumber, MetaCategory.Form);
        if (bizId == null) {
            logger.info("the metadata not exist:{}", (Object)bizNumber);
            return;
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)"2VKJ94YEM7AU", (boolean)false);
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        String userDownloadPath = USER_HOME + File.separator + DOWNLOAD_PATH + File.separator;
        String appNumberPath = userDownloadPath + bizAppNumber;
        String traceIdHash = this.getTraceIdHash();
        String traceIdPath = appNumberPath + File.separator + traceIdHash;
        String localPath = traceIdPath + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
        ArrayList fileList = new ArrayList();
        DevportalUtil.expFormMetadata((String)bizId, (String)localPath, (String)"EXPORT_PAGE");
        InputStream in = null;
        try {
            DevportalUtil.zipFiles((String)bizNumber, (String)localPath, fileList);
            String downloadFile = DevportalUtil.checkFilePath((String)FileUtils.cleanString((String)(localPath + File.separator)));
            Path downloadPath = Paths.get(DevportalUtil.checkFilePath((String)downloadFile), FilenameUtils.getName((String)this.getFileName(bizNumber)));
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(bizNumber + ".zip", in, 5000);
            formView.download(urls);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            formView.showErrorNotification(e.getMessage());
        }
        finally {
            try {
                String filePath;
                File traceIdFile;
                if (in != null) {
                    in.close();
                }
                if ((traceIdFile = new File(filePath = FileUtils.cleanString((String)(appNumberPath + File.separator).replace('.', '%').replace('/', '%')), FilenameUtils.getName((String)traceIdHash))).exists()) {
                    boolean appNumDelete;
                    AppUtils.deleteKd((File)traceIdFile);
                    String checkFilePath = FileUtils.cleanString((String)userDownloadPath.replace('.', '%').replace('/', '%'));
                    File appNumberFile = new File(checkFilePath, FilenameUtils.getName((String)bizAppNumber));
                    if (appNumberFile.listFiles().length == 0 && (appNumDelete = appNumberFile.delete())) {
                        logger.info(appNumberFile + "delete:" + appNumDelete);
                    }
                }
            }
            catch (IOException ioExp) {
                logger.error((Throwable)ioExp);
                AppUtils.addLog((String)"hr-report", (String)"exportPageSource", (String)ioExp.getMessage());
            }
        }
    }

    private String getFileName(String bizNumber) {
        return bizNumber + ".zip";
    }

    private String getTraceIdHash() {
        return Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
    }
}

