/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.exportconfig;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hr.hbp.common.util.HRDBUtil;

public class HRReportPreSQLHelper {
    private static final String STR_WRAP = "\r\n";

    public void generateHRReportPreSQLFile(AbstractListPlugin listPlugIn, List<Long> idList) {
        if (idList == null || idList.size() < 1) {
            return;
        }
        ArrayList<Map<String, StringWriter>> xmlFileList = new ArrayList<Map<String, StringWriter>>(16);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("/****** HR Management Report SQL ******/").append(STR_WRAP);
        List<Map<String, Object>> listSqlMap = this.generateReportManagementPreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        listSqlMap = this.generateWorkReportConfigPreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        listSqlMap = this.generateReportConfigPreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        listSqlMap = this.generateHRReportRefPreIndexPreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        String isv = ISVService.getISVInfo().getId();
        if ("kingdee".equals(isv)) {
            isv = "kd";
        }
        String sqlFileName = String.format("%s_%s_%s.sql", isv, "hrptmc_report_management_initsql_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(listPlugIn, ins, sqlFileName);
            this.exportXmlFile(listPlugIn, xmlFileList);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
        this.generateHRReportPreIndexBaseDataPreSQLFile(listPlugIn, idList);
    }

    private List<Map<String, Object>> generateWorkReportConfigPreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String splitIds = Joiner.on((String)",").join(idList);
        String whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        Map map = Maps.newHashMapWithExpectedSize((int)1);
        String deleteConditionSql = "DELETE FROM T_HRPTMC_WORKREPORT WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        String exportFields = "FID,FROW,FCOLUMN,FRPTMANAGEID,FINDEX,FKEY";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_WORKREPORT", exportFields, whereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    private List<Map<String, Object>> generateReportConfigPreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String splitIds = Joiner.on((String)",").join(idList);
        String exportFields = "FID,FTYPE,FTOTAL,FSUBTOTAL,FPAGE,FSHOWSEQ,FMERGECELL,FROWCOLTRANSPOSITION,FHEADERMERGE,FRPTMANAGEID,FFREE,FTOTALNAME,FSUBTOTAL,FSUBTOTALNAME,FDRILLINGDRL,FHEADSTYLE,FROWADVANCESORT,FCOLADVANCESORT,FWORKRPTID,FSHOWDATALABEL,FCATEGORYNAME,FCATEGORYUNIT,FVALUENAME,FVALUEUNIT,FLEGEND";
        String whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_REPORTCONFIG", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FTOTALNAME,FSUBTOTALNAME,FCATEGORYNAME,FCATEGORYUNIT,FVALUENAME,FVALUEUNIT";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_REPORTCONFIG WHERE FRPTMANAGEID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_REPORTCONFIG_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FREPORTMANAGEID IN (" + splitIds + ")";
        map = Maps.newHashMapWithExpectedSize((int)1);
        String deleteConditionSql = "DELETE FROM T_HRPTMC_PUBLISHMENU WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FMENUID,FMENUAPPID,FREPORTMANAGEID,FCREATORID,FCREATETIME,FMODIFYTIME,FMODIFIERID";
        whereCondition = "FREPORTMANAGEID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PUBLISHMENU", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FBASEDATAID";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_REPORTCONFIG WHERE FRPTMANAGEID IN (" + splitIds + "))";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_SUBTOTRFIELDREF", exportFields, whereCondition, null, null);
        listMap.add(map);
        this.generateReportFieldConfigPreSQL(listMap, splitIds);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ROWFIELD WHERE FRPTMANAGEID IN (" + splitIds + "))";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_DATAFORMAT WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FENTRYID,FSEQ,FDISPLAYMODE,FNULLRULE,FDECIMALDIGITS,FROUNDMETHOD";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_DATAFORMAT", exportFields, whereCondition, null, null);
        listMap.add(map);
        map = Maps.newHashMapWithExpectedSize((int)1);
        whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        deleteConditionSql = "DELETE FROM T_HRPTMC_FILTER WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FENABLE,FDATESCOPE,FHISDATE,FFILTERTYPE,FBASEDATAISMUL,FDATETYPE,FISMUST,FISSYSPRESET,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FNAME,FRPTMANAGEID,FSUBORG,FORGLEVEL,FHISSCOPE,FINDEX,FANOBJFIELDID,FGROUPDATE,FENDDATE,FBEGINDATE,FTEXTDEFAULTVALUE,FTEXTFILTERRANGE,FDATEFILTERTYPE,FDATEFILTERTEXT,FFILTERSTARTDATE,FFILTERENDDATE,FBDDEFAULTVALUE,FBDFILTERRANGE,FQUICKSCOPE,FSPLITDATEID,FGROUPFIELDID,FISGROUPFIELD,FOPT";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_FILTER", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_FILTER WHERE FRPTMANAGEID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_FILTER_L  WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FNAME";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_FILTER_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        this.generateSortFieldPreSQL(listMap, splitIds);
        this.generateReportRemarkPreSQL(listMap, splitIds);
        this.generateDisplaySchemeConfigPreSQL(listMap, splitIds);
        this.generateReportJumpRulePreSQL(listMap, splitIds);
        this.generateReportAlgorithmPreSQL(listMap, splitIds);
        this.generateDateSplitPreSQL(listMap, splitIds);
        exportFields = "FID,FREPORTID,FENABLECACHE,FCACHEBATCH,FSUMBATCHCOUNT,FDETAILBATCHCOUNT,FCACHETIMEOUT,FPAGEBYDIM,FQUERYSCHEME,FKSQLCOUNTBATCH,FKSQLSUMBATCH,FKSQLSUMTHRESHOLD,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FALGOXOPTIMIZEDIMCOUNT,FALGOXOPTIMIZEDATACOUNT,FKSQLDETAILOPTIMIZE,FENABLEENTITYJOINOPTIMIZE,FORIGINALFIELDSORT,FDEFSORTTYPE,FENABLESCHEME,FENABLEEXTRACT,FCYCLE,FSCHEDULETIME,FEXECUTEWITHSAVE,FJOBID,FNEWENTITYNUM,FDAY,FWEEK,FNEWTABLE,FSCHEDULESTATUS";
        whereCondition = "FREPORTID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTQUERYCONFIG", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FBASEDATAID";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_RPTQUERYCONFIG WHERE FREPORTID IN (" + splitIds + "))";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CONFIGSCHEDULE", exportFields, whereCondition, null, null);
        listMap.add(map);
        this.generateReportFieldConfigPreSQL(listMap, splitIds);
        return listMap;
    }

    private void generateDateSplitPreSQL(List<Map<String, Object>> listMap, String splitIds) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        String deleteConditionSql = "DELETE FROM T_HRPTMC_SPLITDATE WHERE " + whereCondition + ";";
        Map map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sql", deleteConditionSql);
        String exportFields = "FID,FNUMBER,FRPTMANAGEID,FANOBJFIELDID";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_SPLITDATE", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void generateReportAlgorithmPreSQL(List<Map<String, Object>> listMap, String splitIds) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String whereCondition = "FRPTCONFIGID IN (SELECT FID FROM T_HRPTMC_REPORTCONFIG WHERE FRPTMANAGEID IN (" + splitIds + "))";
        String deleteConditionSql = "DELETE FROM T_HRPTMC_ALGORITHMCOL WHERE " + whereCondition + ";";
        Map<String, String> map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sql", deleteConditionSql);
        listMap.add((Map<String, Object>)map);
        String exportFields = "FID,FSHOWLOCATION,FTOTAL,FTOTALNAME,FSUBTOTAL,FSUBTOTALNAME,FDIMFIELD,FRPTCONFIGID";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ALGORITHMCOL", exportFields, whereCondition, null, null);
        listMap.add((Map<String, Object>)map);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ALGORITHMCOL WHERE FRPTCONFIGID IN (SELECT FID FROM T_HRPTMC_REPORTCONFIG WHERE FRPTMANAGEID IN (" + splitIds + "))) AND FLOCALEID='zh_CN'";
        deleteConditionSql = "DELETE FROM T_HRPTMC_ALGORITHMCOL_L WHERE " + whereCondition + ";";
        map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FTOTALNAME,FSUBTOTALNAME";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ALGORITHMCOL_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ALGORITHMCOL WHERE FRPTCONFIGID IN (SELECT FID FROM T_HRPTMC_REPORTCONFIG WHERE FRPTMANAGEID IN (" + splitIds + ")))";
        deleteConditionSql = "DELETE FROM T_HRPTMC_COLALGORITHMTYPE WHERE " + whereCondition + ";";
        map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FSEQ,FID,FNUMBERALIAS,FALGORITHM";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_COLALGORITHMTYPE", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_REPORTCONFIG WHERE FRPTMANAGEID IN (" + splitIds + "))";
        deleteConditionSql = "DELETE FROM T_HRPTMC_ROWALGORITHM WHERE " + whereCondition + ";";
        map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FSEQ,FID,FNUMBERALIAS,FALGORITHM";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ROWALGORITHM", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void generateReportJumpRulePreSQL(List<Map<String, Object>> listMap, String splitIds) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String whereCondition = "FREPORTID IN (" + splitIds + ")";
        String deleteConditionSql = "DELETE FROM T_HRPTMC_RPTJUMP WHERE " + whereCondition + ";";
        Map<String, String> map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sql", deleteConditionSql);
        String exportFields = "FID,FREPORTID,FINDEX,FRULEGROUP,FJUMPREPORTID,FCARRYFILTER,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FWORKRPTID";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTJUMP", exportFields, whereCondition, null, null);
        listMap.add((Map<String, Object>)map);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_RPTJUMP WHERE FREPORTID IN (" + splitIds + "))";
        deleteConditionSql = "DELETE FROM T_HRPTMC_RPTJUMPRULE WHERE " + whereCondition + ";";
        map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sql", deleteConditionSql);
        exportFields = "FENTRYID,FID,FSEQ,FSOURCEFIELD,FTARGETFIELD,FTYPE";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTJUMPRULE", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void generateReportRemarkPreSQL(List<Map<String, Object>> listMap, String splitIds) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID,FSHOW,FRPTMANAGEID";
        String whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_REPORTMARK", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FRPTMARKID,FMARKCONTENT,FLOCALE";
        whereCondition = "FRPTMARKID IN (SELECT FID FROM T_HRPTMC_REPORTMARK WHERE FRPTMANAGEID IN (" + splitIds + "))";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTMARKCONTENT", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void generateSortFieldPreSQL(List<Map<String, Object>> listMap, String splitIds) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID,FRPTMANAGEID,FRPTFIELDID,FENTITYNUMBER,FENTITYFIELD,FFIELDTYPE,FVALUETYPE,FWORKRPTID";
        String whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CUSTOMSORT", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FENTRYID,FID,FSEQ,FLONG,FSTRING";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_CUSTOMSORT WHERE FRPTMANAGEID IN (" + splitIds + "))";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CUSTOMSORTETY", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FENTITYNUMBER,FENTITYFIELD,FFIELDTYPE,FVALUETYPE,FLOCALEID";
        whereCondition = "FID IN (SELECT FCOMMONSORTID FROM T_HRPTMC_RPTCOMREF WHERE FRPTMANAGEID IN (" + splitIds + ")) and FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_COMMONSORT", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void generateDisplaySchemeConfigPreSQL(List<Map<String, Object>> listMap, String splitIds) {
        String exportFields = "FID,FRPTMANAGEID,FWORKRPTID";
        String whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTDISPSCM", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FBIZINDEX,FRPTDISPSCMID,FCOLFIELDID,FENABLE";
        whereCondition = "FRPTDISPSCMID IN (SELECT FID FROM T_HRPTMC_RPTDISPSCM WHERE FRPTMANAGEID IN (" + splitIds + "))";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTDISPSCMCOL", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FBIZINDEX,FRPTDISPSCMID,FROWFIELDID,FENABLE";
        whereCondition = "FRPTDISPSCMID IN (SELECT FID FROM T_HRPTMC_RPTDISPSCM WHERE FRPTMANAGEID IN (" + splitIds + "))";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTDISPSCMROW", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FBIZINDEX,FRPTDISPSCMID,FROWFIELDID,FENABLE";
        whereCondition = "FRPTDISPSCMID IN (SELECT FID FROM T_HRPTMC_RPTDISPSCM WHERE FRPTMANAGEID IN (" + splitIds + "))";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTDISPSCMIDX", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_REPORTCONFIG WHERE FRPTMANAGEID IN (" + splitIds + "))";
        String deleteConditionSql = "DELETE FROM T_HRPTMC_RPTLASTSTYLE WHERE " + whereCondition + ";";
        map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FSEQ,FID,FTYPE,FLASTSTYLE,FTIME";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_RPTLASTSTYLE", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void generateReportFieldConfigPreSQL(List<Map<String, Object>> listMap, String splitIds) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID,FBIZINDEX,FDISPLAYNAME,FNUMBERALIAS,FRPTMANAGEID,FANOBJFIELDID,FCALCIDXFIELDID,FSHOWEMPTYCOL,FSORT,FWORKRPTID";
        String whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_COLFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FDISPLAYNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_COLFIELD WHERE FRPTMANAGEID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_COLFIELD_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FBIZINDEX,FDISPLAYNAME,FNUMBERALIAS,FTYPE,FALGORITHM,FDISPLAYMODE,FORGVERSIONDATE,FPARENTID,FRPTMANAGEID,FMERGETYPE,FANOBJFIELDID,FCALCIDXFIELDID,FPREIDXFIELDID,FSHOWEMPTYCOL,FSORT,FWORKRPTID";
        whereCondition = "FRPTMANAGEID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ROWFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FDISPLAYNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ROWFIELD WHERE FRPTMANAGEID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ROWFIELD_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FINDEX,FNUMBER,FNAME,FTYPE,FVALUETYPE,FCONTROLTYPE,FEXPR,FSOURCE,FORDER,FISSELECTED,FANOBJID,FREPORTID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FCALMETHOD,FVIEWEXPR,FHIDEFIELD";
        whereCondition = "FREPORTID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CALCULATEFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_CALCULATEFIELD WHERE FREPORTID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CALCULATEFIELD_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FENTRYID,FSEQ,FID,FREFTYPE,FREFFIELDALIAS,FREFCALFIELDID,FPREINDEXID,FAGGREGATION";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_CALCULATEFIELD WHERE FREPORTID IN (" + splitIds + "))";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CALREFFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private List<Map<String, Object>> generateReportManagementPreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String exportFields = "FID,FNAME,FNUMBER,FENABLE,FPUBLISHSTATUS,FCREATORID,FMODIFIERID,FDISABLERID,FMODIFYTIME,FCREATETIME,FDISABLEDATE,FDESCRIPTION,FISSYSPRESET,FCLOUDID,FANOBJID,FROW,FCOLUMN,FSTATUS,FDATAFILTER,FCREATEORGID";
        String splitIds = Joiner.on((String)",").join(idList);
        String whereCondition = "FID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_REPORTMANAGE", exportFields, whereCondition, null, null);
        listMap.add(map);
        String multiLanExportFields = "FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION";
        String paramWhereCondition = "FID IN (" + splitIds + ") AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_REPORTMANAGE_L", multiLanExportFields, paramWhereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    public void generateHRAnalysisObjPreSQLFile(AbstractListPlugin listPlugIn, List<Long> idList) {
        if (idList == null || idList.size() < 1) {
            return;
        }
        ArrayList<Map<String, StringWriter>> xmlFileList = new ArrayList<Map<String, StringWriter>>(16);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("/****** HR Analysis Object SQL ******/").append(STR_WRAP);
        List<Map<String, Object>> listSqlMap = this.generateHRAnalysisObjPreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        String isv = ISVService.getISVInfo().getId();
        if ("kingdee".equals(isv)) {
            isv = "kd";
        }
        String sqlFileName = String.format("%s_%s_%s.sql", isv, "hrptmc_analysisObj_initsql_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(listPlugIn, ins, sqlFileName);
            this.exportXmlFile(listPlugIn, xmlFileList);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private List<Map<String, Object>> generateHRAnalysisObjPreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String splitIds = Joiner.on((String)",").join(idList);
        String exportFields = "FID,FNUMBER,FNAME,FDESCRIPTION,FENABLE,FDATAFILTER,FSTORESTATUS,FISSYSPRESET,FSTOREENTITY,FQUERYSCHEME,FISV,FVERSION,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FISVIRTUALENTITY,FSIDEBAR,FPIVOTDIM,FPIVOTDIMVAL,FPIVOTINDEX,FOBJECTTYPE";
        String whereCondition = "FID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANALYSISOBJECT", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION";
        whereCondition = "FID IN (" + splitIds + ") AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANALYSISOBJECT_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FANOBJID,FINDEX,FENTITYNUMBER,FENTITYALIAS,FTYPE,FISV,FVERSION,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FLONGNUMBER";
        whereCondition = "FANOBJID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANOBJJOINENTITY", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FANOBJID,FENTITYID,FJOINTYPE,FJOINENTITYID,FISV,FVERSION,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME";
        whereCondition = "FANOBJID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANOBJENTJOINREL", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ANOBJENTJOINREL WHERE FANOBJID IN (" + splitIds + "))";
        map = Maps.newHashMapWithExpectedSize((int)1);
        String deleteConditionSql = "DELETE FROM T_HRPTMC_ANOBJJOINCOND WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FID,FSEQ,FLEFTPROP,FCOMPARETYPE,FRIGHTPROP,FRIGHTPROPTYPE,FRIGHTPROPVAL,FLOGICTYPE";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANOBJJOINCOND", exportFields, whereCondition, null, null);
        listMap.add(map);
        this.generateVirtulEntityPreSQL(listMap, splitIds);
        this.generateAnalysisFieldConfigPreSQL(listMap, splitIds, builder);
        exportFields = "FID,FINDEX,FTYPE,FANOBJID,FGROUPFIELD,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ANOBJSIDEBAR WHERE FANOBJID IN (" + splitIds + "))";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANOBJSIDEBAR", exportFields, whereCondition, null, null);
        listMap.add(map);
        this.generateAnalysisGroupFieldPreSQL(listMap, splitIds, builder);
        this.generateAnalysisPivotConfigPreSQL(listMap, splitIds, builder);
        exportFields = "FID,FINDEX,FANOBJID,FANOBJFIELDID,FPERMOBJID,FPERMFIELD,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PERMRULE", exportFields, whereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    private void generateAnalysisPivotConfigPreSQL(List<Map<String, Object>> listMap, String splitIds, PreInsDataScriptBuilder builder) {
        String exportFields = "FID,FPIVOTDIMVAL,FPIVOTINDEX,FPIVOTDIM,FPIVOTINDEXNUM,FANOBJID";
        String whereCondition = "FANOBJID IN (" + splitIds + ")";
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANOBJPIVOT", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void generateAnalysisGroupFieldPreSQL(List<Map<String, Object>> listMap, String splitIds, PreInsDataScriptBuilder builder) {
        String exportFields = "FID,FINDEX,FNUMBER,FNAME,FTYPE,FANOBJCALFIELD,FANOBJFIELD,FANOBJID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME";
        String whereCondition = "FANOBJID IN (" + splitIds + ")";
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANGROUPFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ANOBJQUERYFIELD WHERE FANOBJID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANGROUPFIELD_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FENTRYID,FSEQ,FITEMNAME,FITEMNUMBER,FITEMCONDITION,FISUNGROUPITEM";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ANGROUPFIELD WHERE FANOBJID IN (" + splitIds + "))";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_GROUPITEM", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FENTRYID,FLOCALEID,FITEMNAME";
        whereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRPTMC_GROUPITEM WHERE FID IN (SELECT FID FROM T_HRPTMC_ANGROUPFIELD WHERE FANOBJID IN (" + splitIds + "))) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_GROUPITEM_L", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void generateVirtulEntityPreSQL(List<Map<String, Object>> listMap, String splitIds) {
        String virEntWhereCondition = "FNUMBER IN (SELECT FENTITYNUMBER FROM T_HRPTMC_ANOBJJOINENTITY WHERE FANOBJID IN (" + splitIds + "))";
        Map<String, String> map = Maps.newHashMapWithExpectedSize((int)1);
        String deleteConditionSql = "DELETE FROM T_HRPTMC_VIRTUALENTITY WHERE " + virEntWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add((Map<String, Object>)map);
        String exportFields = "FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FSIMPLENAME,FDESCRIPTION,FINDEX,FISSYSPRESET,FDISABLERID,FDISABLEDATE,FBUSINESSFIELD,FCLASSPATH,FPATH,FCLOUDID";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VIRTUALENTITY", exportFields, virEntWhereCondition, null, null);
        listMap.add((Map<String, Object>)map);
        String senceZhWhereCondition = "FID IN (SELECT FID FROM T_HRPTMC_VIRTUALENTITY WHERE " + virEntWhereCondition + ") AND FLOCALEID='zh_CN'";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VIRTUALENTITY_L WHERE " + senceZhWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FLOCALEID,FPKID,FNAME,FSIMPLENAME,FDESCRIPTION";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VIRTUALENTITY_L", exportFields, senceZhWhereCondition, null, null);
        listMap.add(map);
        String senceWhereCondition = "FID IN (SELECT FID FROM T_HRPTMC_VIRTUALENTITY WHERE " + virEntWhereCondition + ")";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VIRTUALSCENE WHERE " + senceWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FSEQ,FSCENENAME,FISSUPPORT,FSENENUMBER,FID";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VIRTUALSCENE", exportFields, senceWhereCondition, null, null);
        listMap.add(map);
        senceZhWhereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRPTMC_VIRTUALSCENE WHERE " + senceWhereCondition + ") AND FLOCALEID='zh_CN'";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VIRTUALSCENE_L WHERE " + senceZhWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FLOCALEID,FPKID,FSCENENAME";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VIRTUALSCENE_L", exportFields, senceZhWhereCondition, null, null);
        listMap.add(map);
        String fieldWhereCondition = "FID IN (SELECT FID FROM T_HRPTMC_VIRTUALENTITY WHERE " + virEntWhereCondition + ")";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VIRTUALFIELD WHERE " + fieldWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FSEQ,FFIELDNAME,FFIELDNUMBER,FFIELDPATH,FISCOMMONFIELD,FCOMPLEXTYPE,FFIELDVALUETYPE,FCONTROLTYPE,FGROUP,FID";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VIRTUALFIELD", exportFields, fieldWhereCondition, null, null);
        listMap.add(map);
        senceZhWhereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRPTMC_VIRTUALFIELD WHERE " + senceWhereCondition + ") AND FLOCALEID='zh_CN'";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VIRTUALFIELD_L WHERE " + senceZhWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FLOCALEID,FPKID,FFIELDNAME";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VIRTUALFIELD_L", exportFields, senceZhWhereCondition, null, null);
        listMap.add(map);
        String fieldGroupWhereCondition = "FID IN (SELECT FGROUP FROM T_HRPTMC_VIRTUALFIELD WHERE " + fieldWhereCondition + ")";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VFIELDGROUP WHERE " + fieldGroupWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FSIMPLENAME,FDESCRIPTION,FINDEX,FISSYSPRESET,FDISABLERID,FDISABLEDATE";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VFIELDGROUP", exportFields, fieldGroupWhereCondition, null, null);
        listMap.add(map);
        String fieldGroupZhWhereCondition = fieldGroupWhereCondition + "AND FLOCALEID='zh_CN'";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VFIELDGROUP_L WHERE " + fieldGroupZhWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FLOCALEID,FPKID,FNAME,FSIMPLENAME,FDESCRIPTION";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VFIELDGROUP_L", exportFields, fieldGroupZhWhereCondition, null, null);
        listMap.add(map);
        String classWhereCondition = "FID IN (SELECT FCLASSPATH FROM T_HRPTMC_VIRTUALENTITY WHERE " + virEntWhereCondition + ")";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VIRTENTITYCLASS WHERE " + classWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FSIMPLENAME,FDESCRIPTION,FINDEX,FISSYSPRESET,FDISABLERID,FDISABLEDATE";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VIRTENTITYCLASS", exportFields, classWhereCondition, null, null);
        listMap.add(map);
        String classZhWhereCondition = classWhereCondition + "AND FLOCALEID='zh_CN'";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_VIRTENTITYCLASS_L WHERE " + classZhWhereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FLOCALEID,FPKID,FNAME,FSIMPLENAME,FDESCRIPTION";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_VIRTENTITYCLASS_L", exportFields, classZhWhereCondition, null, null);
        listMap.add(map);
    }

    private void generateAnalysisFieldConfigPreSQL(List<Map<String, Object>> listMap, String splitIds, PreInsDataScriptBuilder builder) {
        String exportFields = "FID,FANOBJID,FENTITYNUMBER,FFIELDNAME,FFIELDALIAS,FFIELDPATH,FVALUETYPE,FCOMPLEXTYPE,FCONTROLTYPE,FSTOREFIELD,FISV,FVERSION,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FISVIRTUALFIELD";
        String whereCondition = "FANOBJID IN (" + splitIds + ")";
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANOBJQUERYFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FFIELDNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_ANOBJQUERYFIELD WHERE FANOBJID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_ANOBJQUERYFIELD_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FINDEX,FNUMBER,FNAME,FTYPE,FVALUETYPE,FCONTROLTYPE,FEXPR,FSOURCE,FORDER,FISSELECTED,FANOBJID,FREPORTID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FCALMETHOD,FHIDEFIELD";
        whereCondition = "FANOBJID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CALCULATEFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_CALCULATEFIELD WHERE FANOBJID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CALCULATEFIELD_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FENTRYID,FSEQ,FID,FREFTYPE,FREFFIELDALIAS,FREFCALFIELDID,FPREINDEXID,FAGGREGATION";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_CALCULATEFIELD WHERE FANOBJID IN (" + splitIds + "))";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CALREFFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private List<Map<String, Object>> generateHRReportRefPreIndexPreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String splitIds = Joiner.on((String)",").join(idList);
        String whereCondition = "FREPORTID IN (" + splitIds + ")";
        Map<String, String> map = Maps.newHashMapWithExpectedSize((int)1);
        String deleteConditionSql = "DELETE FROM T_HRPTMC_DIMMAP WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        String exportFields = "FID,FREPORTID,FPREINDEXID,FPREINDEXNUMBER,FWORKRPTID";
        whereCondition = "FREPORTID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_DIMMAP", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_DIMMAP WHERE FREPORTID IN (" + splitIds + "))";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_DIMMAPENTRY WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FID,FSEQ,FDIMNUMBER,FDIM,FDIMTYPE,FDIMFROM,FDIMREALFROM,FPARAMRULE,FPREINDEXPARAM";
        whereCondition = "FID IN (SELECT FID FROM T_HRPTMC_DIMMAP WHERE FREPORTID IN (" + splitIds + "))";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_DIMMAPENTRY", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRPTMC_DIMMAPENTRY WHERE FID IN (SELECT FID FROM T_HRPTMC_DIMMAP WHERE FREPORTID IN (" + splitIds + ")))";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_DIMMAPENTRY_L WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FPKID,FENTRYID,FLOCALEID,FDIM";
        whereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRPTMC_DIMMAPENTRY WHERE FID IN (SELECT FID FROM T_HRPTMC_DIMMAP WHERE FREPORTID IN (" + splitIds + "))) AND FLOCALEID='zh_CN'";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_DIMMAPENTRY_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FREPORTID IN (" + splitIds + ")";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_REPORTPREINDEX WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FID,FREPORTID,FPREINDEXID";
        whereCondition = "FREPORTID IN (" + splitIds + ")";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_REPORTPREINDEX", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FENTRYID,FID,FSEQ,FCOLFROM,FNUMBER,FNAME,FCOLTYPE,FISREQUIRED";
        whereCondition = "FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX where FREPORTID IN (" + splitIds + "))";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PREINDEXCOL", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FENTRYID,FLOCALEID,FNAME";
        whereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRPTMC_PREINDEXCOL WHERE FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX WHERE FREPORTID IN (" + splitIds + "))) AND FLOCALEID='zh_CN'";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PREINDEXCOL_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    private void generateHRReportPreIndexBaseDataPreSQLFile(AbstractListPlugin listPlugIn, List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String splitIds = Joiner.on((String)",").join(idList);
        String exportFields = "FID,FNUMBER,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENABLE,FSTATUS,FDISABLERID,FDISABLEDATE,FINDEX,FISSYSPRESET,FMASTERID,FNAME,FSIMPLENAME,FDESCRIPTION,FGETWAY,FSERVICEID,FANOBJID,FTARGETFROM,FTARGET,FCALMETHOD";
        String whereCondition = "FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX WHERE FREPORTID IN (" + splitIds + "))";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PREINDEX", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FNAME,FSIMPLENAME,FDESCRIPTION";
        whereCondition = "FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX WHERE FREPORTID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PREINDEX_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        this.generateHRPreIndexParamAndColumnPreSQL(listMap, splitIds);
        exportFields = "FID,FNUMBER,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENABLE,FSTATUS,FDISABLERID,FDISABLEDATE,FINDEX,FISSYSPRESET,FMASTERID,FNAME,FSIMPLENAME,FDESCRIPTION,FAPPID,FCLASSFULLNAME,FMETHODNAME";
        whereCondition = "FID IN (SELECT FSERVICEID FROM T_HRPTMC_PREINDEX WHERE FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX WHERE FREPORTID IN (" + splitIds + ")))";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_BUSISERVICE", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FNAME,FSIMPLENAME,FDESCRIPTION";
        whereCondition = "FID IN (SELECT FSERVICEID FROM T_HRPTMC_PREINDEX WHERE FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX WHERE FREPORTID IN (" + splitIds + "))) AND FLOCALEID='zh_CN'";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_BUSISERVICE_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FENTRYID,FID,FSEQ,FNUMBER,FNAME,FTYPE,FISREQUIRED";
        whereCondition = "FID in (select FID from T_HRPTMC_BUSISERVICE where FID IN (SELECT FSERVICEID FROM T_HRPTMC_PREINDEX WHERE FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX WHERE FREPORTID IN (" + splitIds + "))))";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_BUSISRVPARAM", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FENTRYID,FLOCALEID,FNAME";
        whereCondition = "FENTRYID in (SELECT FENTRYID  FROM T_HRPTMC_BUSISRVPARAM WHERE FID IN (SELECT FID FROM T_HRPTMC_BUSISERVICE WHERE FID IN (SELECT FSERVICEID FROM T_HRPTMC_PREINDEX WHERE FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX WHERE FREPORTID IN (" + splitIds + "))))) AND FLOCALEID='zh_CN'";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_BUSISRVPARAM_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        this.outPutHRPreIndexSQLFile(listPlugIn, listMap);
    }

    private void generateHRPreIndexParamAndColumnPreSQL(List<Map<String, Object>> listMap, String splitIds) {
        String preIndexSql = "SELECT FID FROM T_HRPTMC_PREINDEX WHERE FID IN (SELECT FPREINDEXID FROM T_HRPTMC_REPORTPREINDEX WHERE FREPORTID IN (" + splitIds + "))";
        DataSet preIndexDataSet = HRDBUtil.queryDataSet((String)"HRReportPreSQLHelper.generateHRReportPreIndexBaseDataPreSQLFile", (DBRoute)DBRoute.of((String)"hmp"), (String)preIndexSql, null);
        ArrayList<String> preIndexList = new ArrayList<String>(10);
        while (preIndexDataSet.hasNext()) {
            Row row = preIndexDataSet.next();
            preIndexList.add(String.valueOf(row.getLong("FID")));
        }
        if (preIndexList.size() == 0) {
            return;
        }
        String preIndexIds = String.join((CharSequence)",", preIndexList);
        String whereCondition = "FID IN (" + preIndexIds + ")";
        Map<String, String> map = Maps.newHashMapWithExpectedSize((int)1);
        String deleteConditionSql = "DELETE FROM T_HRPTMC_PREINDEXPARAM WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add((Map<String, Object>)map);
        String exportFields = "FENTRYID,FID,FSEQ,FBUSISRVPARAMID,FNAME,FISREQUIRED";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PREINDEXPARAM", exportFields, whereCondition, null, null);
        listMap.add((Map<String, Object>)map);
        whereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRPTMC_PREINDEXPARAM WHERE FID IN (" + preIndexIds + ")) AND FLOCALEID='zh_CN'";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_PREINDEXPARAM_L WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FPKID,FENTRYID,FLOCALEID,FNAME";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PREINDEXPARAM_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FID IN (" + preIndexIds + ")";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_PREINDEXCOL WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FID,FSEQ,FCOLFROM,FNUMBER,FNAME,FCOLTYPE,FISREQUIRED";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PREINDEXCOL", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRPTMC_PREINDEXCOL WHERE FID IN (" + preIndexIds + ")) AND FLOCALEID='zh_CN'";
        map = Maps.newHashMapWithExpectedSize((int)1);
        deleteConditionSql = "DELETE FROM T_HRPTMC_PREINDEXCOL_L WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FPKID,FENTRYID,FLOCALEID,FNAME";
        builder = new PreInsDataScriptBuilder();
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_PREINDEXCOL_L", exportFields, whereCondition, null, null);
        listMap.add(map);
    }

    private void outPutHRPreIndexSQLFile(AbstractListPlugin listPlugIn, List<Map<String, Object>> listMap) {
        ArrayList<Map<String, StringWriter>> xmlFileList = new ArrayList<Map<String, StringWriter>>(16);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("/****** HR Report PreIndex BaseData SQL ******/").append(STR_WRAP);
        for (Map<String, Object> sqlMap : listMap) {
            sqlBuilder.append(sqlMap.get("sql")).append(STR_WRAP);
            if (sqlMap.get("xml") == null) continue;
            xmlFileList.add((Map)sqlMap.get("xml"));
        }
        String isv = ISVService.getISVInfo().getId();
        if ("kingdee".equals(isv)) {
            isv = "kd";
        }
        String sqlFileName = String.format("%s_%s_%s.sql", isv, "hrptmc_preIndexBaseData_initsql_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(listPlugIn, ins, sqlFileName);
            this.exportXmlFile(listPlugIn, xmlFileList);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private void exportXmlFile(AbstractListPlugin listPlugIn, List<Map<String, StringWriter>> xmlFileList) {
        for (Map<String, StringWriter> longTextDataFile : xmlFileList) {
            for (Map.Entry<String, StringWriter> entry : longTextDataFile.entrySet()) {
                StringWriter sw = entry.getValue();
                byte[] xmlByteArray = sw.toString().getBytes(StandardCharsets.UTF_8);
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlByteArray);
                    Throwable throwable = null;
                    try {
                        String fileName = this.getXmlFileName(entry);
                        this.exportFile(listPlugIn, inputStream, fileName);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inputStream).close();
                    }
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                }
            }
        }
    }

    private String getXmlFileName(Map.Entry<String, StringWriter> entry) {
        String curDate = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String xmlFileName = entry.getKey();
        xmlFileName = xmlFileName.substring(0, xmlFileName.lastIndexOf(46)) + "_" + curDate + ".xml";
        return xmlFileName;
    }

    private void exportFile(AbstractListPlugin listPlugIn, InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        listPlugIn.getView().openUrl(url);
    }
}

