/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.filesource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptmc.business.filesource.ReportFileSourceImportInfo;
import kd.hr.hrptmc.business.filesource.exception.RptFileSourceCreateAnObjException;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.util.ReportCommonUtils;

public class CreateAnObjService
implements AnalyseObjectConstants {
    private static final String numberPrefix = "file_source_";
    private final String name;
    private final String number;
    private final DynamicObject virtualEntity;
    private DynamicObject anObjDy;
    private final HRBaseServiceHelper anObjHelper = new HRBaseServiceHelper("hrptmc_analyseobject");

    public CreateAnObjService(ReportFileSourceImportInfo importInfo, String fileName) {
        this.number = this.generateNumber(importInfo.getDataStoreTableBo().getTableName());
        this.name = fileName;
        this.virtualEntity = importInfo.getCreateVirtualEntityService().getVirtualObjDy();
    }

    public void createAnObj() throws RptFileSourceCreateAnObjException {
        this.anObjDy = this.anObjHelper.loadDynamicObject(new QFilter[]{new QFilter("number", "=", (Object)this.number)});
        if (this.anObjDy != null) {
            this.deleteAnObj();
        }
        DynamicObject anObjDy = this.anObjHelper.generateEmptyDynamicObject();
        anObjDy.set("number", (Object)this.number);
        anObjDy.set("name", (Object)this.name);
        anObjDy.set("objecttype", (Object)"filesource");
        anObjDy.set("enable", (Object)"1");
        List<JoinEntityBo> joinEntities = this.createJoinEntities();
        List<QueryFieldBo> queryFields = this.createQueryFields();
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("joinEntities", SerializationUtils.toJsonString(joinEntities));
        operateOption.setVariableValue("queryFields", SerializationUtils.toJsonString(queryFields));
        operateOption.setVariableValue("entityRelations", "");
        OperationResult operationResult = opImpl.localInvokeOperation("save", new DynamicObject[]{anObjDy}, operateOption);
        if (!operationResult.isSuccess()) {
            throw new RptFileSourceCreateAnObjException("save error.");
        }
        this.anObjDy = anObjDy;
    }

    public boolean deleteAnObj() {
        if (this.anObjDy == null) {
            return true;
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        OperationResult operationResult = opImpl.localInvokeOperation("delete", new DynamicObject[]{this.anObjDy}, operateOption);
        return operationResult.isSuccess();
    }

    private List<JoinEntityBo> createJoinEntities() {
        ArrayList joinEntities = Lists.newArrayListWithCapacity((int)10);
        JoinEntityBo joinEntityBo = new JoinEntityBo();
        joinEntityBo.setLongNumber("0");
        String virtualEntityNumber = this.virtualEntity.getString("number");
        joinEntityBo.setEntityAlias(virtualEntityNumber);
        joinEntityBo.setEntityNumber(virtualEntityNumber);
        joinEntityBo.setVirtualEntity(true);
        joinEntityBo.setType("main");
        joinEntities.add(joinEntityBo);
        return joinEntities;
    }

    private List<QueryFieldBo> createQueryFields() {
        ArrayList queryFields = Lists.newArrayListWithCapacity((int)10);
        String virtualEntityNumber = this.virtualEntity.getString("number");
        DynamicObjectCollection virtualFields = this.virtualEntity.getDynamicObjectCollection("virtualfields");
        for (DynamicObject virtualField : virtualFields) {
            QueryFieldBo queryFieldBo = new QueryFieldBo();
            queryFieldBo.setFieldName(new LocaleString(virtualField.getString("fieldname")));
            queryFieldBo.setComplexType(virtualField.getString("complextype"));
            queryFieldBo.setControlType(virtualField.getString("controltype"));
            queryFieldBo.setValueType(virtualField.getString("fieldvaluetype"));
            queryFieldBo.setFieldAlias(virtualField.getString("fieldnumber"));
            queryFieldBo.setVirtualEntityField(true);
            queryFieldBo.setEntityNumber(virtualEntityNumber);
            queryFields.add(queryFieldBo);
        }
        return queryFields;
    }

    private String generateNumber(String tableName) {
        String anObjNum = ReportCommonUtils.validateNumberByISVIsKD() ? "kdhr_file_source_" + tableName : numberPrefix + tableName;
        return anObjNum;
    }

    public String getNumber() {
        return this.number;
    }

    public DynamicObject getAnObjDy() {
        return this.anObjDy;
    }
}

