/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.filesource;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreFieldBo;
import kd.hr.hrptmc.business.filesource.ReportFileSourceImportInfo;
import kd.hr.hrptmc.common.constant.anobj.VirtualEntityConstants;

public class CreateVirtualEntityService
implements VirtualEntityConstants {
    private static final String numberPrefix = "file_source_";
    private final String name;
    private final String number;
    private final ReportFileSourceImportInfo importInfo;
    private static final String HRMP_CLOUD_ID = "0PEIU203SX4Y";
    private static final String FILE_SOURCE_CLASS_NUMBER = "REPORT_FILE_SOURCE";
    private final HRBaseServiceHelper virtualEntityHelper = new HRBaseServiceHelper("hrptmc_virtualentity");
    private final HRBaseServiceHelper virtualClassHelper = new HRBaseServiceHelper("hrptmc_virtentityclass");
    private DynamicObject virtualObjDy;

    public CreateVirtualEntityService(ReportFileSourceImportInfo importInfo) {
        this.name = this.number = this.generateNumber(importInfo.getDataStoreTableBo().getTableName());
        this.importInfo = importInfo;
    }

    public void createVirtualEntity(String fileName) {
        if (this.virtualEntityHelper.isExists(new QFilter("number", "=", (Object)this.number))) {
            this.deleteVirtualEntity();
        }
        DynamicObject virObjDy = this.virtualEntityHelper.generateEmptyDynamicObject();
        virObjDy.set("name", (Object)fileName);
        virObjDy.set("number", (Object)this.number);
        virObjDy.set("cloud", (Object)HRMP_CLOUD_ID);
        DynamicObject classDy = this.virtualClassHelper.queryOne("id", new QFilter("number", "=", (Object)FILE_SOURCE_CLASS_NUMBER));
        virObjDy.set("classpath", (Object)classDy.getLong("id"));
        virObjDy.set("enable", (Object)"1");
        virObjDy.set("objecttype", (Object)"filesource");
        DynamicObjectCollection virtualFields = this.virtualEntityHelper.generateEmptyEntryCollection(virObjDy, "virtualfields");
        for (ReportDataStoreFieldBo fileSourceFieldBo : this.importInfo.getDataStoreTableBo().getStoreFields()) {
            DynamicObject fieldDy = this.virtualEntityHelper.generateEmptyEntryDynamicObject("virtualfields");
            fieldDy.set("fieldname", (Object)fileSourceFieldBo.getFieldDisplayName());
            fieldDy.set("fieldnumber", (Object)fileSourceFieldBo.getFieldName());
            fieldDy.set("fieldvaluetype", (Object)fileSourceFieldBo.getValueType());
            fieldDy.set("complextype", (Object)FieldComplexType.NORMAL.getValue());
            fieldDy.set("controltype", (Object)this.getFieldControlType(fileSourceFieldBo));
            fieldDy.set("iscommonfield", (Object)Boolean.FALSE);
            virtualFields.add((Object)fieldDy);
        }
        this.setSupportScene(virObjDy);
        this.virtualEntityHelper.saveOne(virObjDy);
        this.virtualObjDy = virObjDy;
    }

    private void setSupportScene(DynamicObject virObjDy) {
        DynamicObjectCollection sceneCol = this.virtualEntityHelper.generateEmptyEntryCollection(virObjDy, "virtualscene");
        DynamicObject totalRowDy = this.virtualEntityHelper.generateEmptyEntryDynamicObject("virtualscene");
        totalRowDy.set("senenumber", (Object)"totalRow");
        totalRowDy.set("issupport", (Object)Boolean.TRUE);
        sceneCol.add((Object)totalRowDy);
        DynamicObject fieldSortDy = this.virtualEntityHelper.generateEmptyEntryDynamicObject("virtualscene");
        fieldSortDy.set("senenumber", (Object)"fieldSort");
        fieldSortDy.set("issupport", (Object)Boolean.TRUE);
        sceneCol.add((Object)fieldSortDy);
        DynamicObject customSortDy = this.virtualEntityHelper.generateEmptyEntryDynamicObject("virtualscene");
        customSortDy.set("senenumber", (Object)"customSort");
        customSortDy.set("issupport", (Object)Boolean.TRUE);
        sceneCol.add((Object)customSortDy);
        DynamicObject orgTreeDy = this.virtualEntityHelper.generateEmptyEntryDynamicObject("virtualscene");
        orgTreeDy.set("senenumber", (Object)"orgTree");
        orgTreeDy.set("issupport", (Object)Boolean.FALSE);
        sceneCol.add((Object)orgTreeDy);
        DynamicObject hisDateQueryDy = this.virtualEntityHelper.generateEmptyEntryDynamicObject("virtualscene");
        hisDateQueryDy.set("senenumber", (Object)"hisDateQuery");
        hisDateQueryDy.set("issupport", (Object)Boolean.TRUE);
        sceneCol.add((Object)hisDateQueryDy);
    }

    private String getFieldControlType(ReportDataStoreFieldBo fileSourceFieldBo) {
        if (this.importInfo.getEnumFields().contains(fileSourceFieldBo.getFieldName())) {
            return FieldControlType.COMBO.getValue();
        }
        return fileSourceFieldBo.getDefaultControlType();
    }

    public void deleteVirtualEntity() {
        this.virtualEntityHelper.deleteByFilter(new QFilter[]{new QFilter("number", "=", (Object)this.number)});
    }

    private String generateNumber(String tableName) {
        return numberPrefix + tableName;
    }

    public String getNumber() {
        return this.number;
    }

    public DynamicObject getVirtualObjDy() {
        return this.virtualObjDy;
    }
}

