/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.filesource;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.service.complexobj.util.DataTypeConvertUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.virtulentity.IVirtualEntityService;
import kd.hr.hbp.business.virtulentity.VirtualConfigInfo;
import kd.hr.hbp.common.enums.query.KsqlJoinHint;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.virtulentity.SummaryQueryResultInfo;
import kd.hr.hbp.common.model.virtulentity.TotalRowValueInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.model.virtulentity.dimvalue.DimensionValueInfo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.common.DataSetTransUtil;
import kd.hr.hrptmc.business.datastore.physicaltable.model.AnObjFileSourceDataStoreTableBo;
import kd.hr.hrptmc.business.filesource.FileSourceTableMsgService;
import org.apache.commons.collections.CollectionUtils;

public class FileSourceVirtualService
implements IVirtualEntityService {
    private static final Log LOGGER = LogFactory.getLog(FileSourceVirtualService.class);
    private AnObjFileSourceDataStoreTableBo dataStoreTableBo = null;

    public VirtualConfigInfo getVirtualConfig() {
        VirtualConfigInfo virtualConfigInfo = new VirtualConfigInfo();
        virtualConfigInfo.setOrgTree(false);
        virtualConfigInfo.setCustomSort(true);
        virtualConfigInfo.setFieldSort(true);
        virtualConfigInfo.setTotalRow(true);
        virtualConfigInfo.setHisDateQuery(true);
        return virtualConfigInfo;
    }

    public DataSet getDetailReportData(VirtualEntityQueryParamInfo queryParamInfo) {
        List<QFilter> qFilters = this.getFilters(queryParamInfo);
        String orderBy = this.getOrderBy(queryParamInfo, false);
        String leftJoin = this.getCustomOrder(queryParamInfo);
        DataSet dataSet = this.queryDetailData(queryParamInfo, qFilters, leftJoin, orderBy);
        List<Field> fieldList = Arrays.stream(dataSet.getRowMeta().getFields()).collect(Collectors.toList());
        List<Map<String, Object>> dataSetMap = this.dataSetToListMapAndAddOrderField(fieldList, dataSet);
        dataSet = DataSetTransUtil.listToDataset(dataSetMap, fieldList);
        return dataSet;
    }

    public SummaryQueryResultInfo getSummaryReportData(VirtualEntityQueryParamInfo queryParamInfo) {
        List<QFilter> qFilters = this.getFilters(queryParamInfo);
        List<VirtualFieldInfo> groupFields = queryParamInfo.getSelectedFieldInfoList().stream().filter(VirtualFieldInfo::isGroupField).collect(Collectors.toList());
        List<String> groupFieldNumberSet = groupFields.stream().map(VirtualFieldInfo::getNumber).collect(Collectors.toList());
        String groupBy = this.getGroupBy(groupFields, groupFieldNumberSet, queryParamInfo);
        String orderBy = this.getOrderBy(queryParamInfo, HRStringUtils.isNotEmpty((String)groupBy));
        String leftJoin = this.getCustomOrder(queryParamInfo);
        String dimFields = String.join((CharSequence)",", groupFieldNumberSet);
        AnObjFileSourceDataStoreTableBo dataStoreTable = this.getDataStoreTable(queryParamInfo);
        DataSet dimDataSet = queryParamInfo.getLimit() > 0 ? this.queryData(dataStoreTable.getTableName(), qFilters, leftJoin, orderBy, groupBy, dimFields, queryParamInfo.getLimit(), queryParamInfo.getStart()) : this.queryData(dataStoreTable.getTableName(), qFilters, leftJoin, orderBy, groupBy, dimFields);
        List<Map<String, Object>> dimListMap = this.dataSetToListMap(dimDataSet);
        List<QFilter> dimQFilters = this.generateQFilterByDimValue(dimListMap, queryParamInfo);
        orderBy = this.getOrderBy(queryParamInfo, false);
        String selectedFields = queryParamInfo.getSelectedFieldInfoList().stream().map(VirtualFieldInfo::getNumber).collect(Collectors.joining(","));
        DataSet dataSet = this.queryData(dataStoreTable.getTableName(), dimQFilters, leftJoin, orderBy, null, selectedFields);
        List<Field> fieldList = Arrays.stream(dataSet.getRowMeta().getFields()).collect(Collectors.toList());
        List<Map<String, Object>> dataSetMap = this.dataSetToListMapAndAddOrderField(fieldList, dataSet);
        List<Map<String, Object>> result = this.filterByDimTuple(dataSetMap, dimListMap);
        DataSet dataset = DataSetTransUtil.listToDataset(result, fieldList);
        SummaryQueryResultInfo summaryQueryResultInfo = new SummaryQueryResultInfo();
        summaryQueryResultInfo.setDataSet(dataset);
        summaryQueryResultInfo.setAllData(true);
        return summaryQueryResultInfo;
    }

    public List<List<DimensionValueInfo>> getSummaryReportColumnDimensionData(VirtualEntityQueryParamInfo queryParamInfo) {
        ArrayList dimValues = Lists.newArrayListWithCapacity((int)10);
        List columnDimensionList = queryParamInfo.getColumnDimensionList();
        if (columnDimensionList == null || columnDimensionList.isEmpty()) {
            return dimValues;
        }
        AnObjFileSourceDataStoreTableBo dataStoreTable = this.getDataStoreTable(queryParamInfo);
        List<QFilter> qFilters = this.getFilters(queryParamInfo);
        String orderBy = this.getOrderBy(queryParamInfo, false);
        String leftJoin = this.getCustomOrder(queryParamInfo);
        String colFields = columnDimensionList.stream().map(VirtualFieldInfo::getNumber).collect(Collectors.joining(","));
        DataSet dimDataSet = this.queryData(dataStoreTable.getTableName(), qFilters, leftJoin, orderBy, null, colFields);
        String[] fieldNames = dimDataSet.getRowMeta().getFieldNames();
        for (Row row : dimDataSet) {
            ArrayList dimensionValueInfoList = Lists.newArrayListWithExpectedSize((int)fieldNames.length);
            for (String fieldName : fieldNames) {
                DimensionValueInfo info = new DimensionValueInfo();
                String value = row.getString(fieldName);
                info.setId(value);
                info.setName(value);
                dimensionValueInfoList.add(info);
            }
            dimValues.add(dimensionValueInfoList);
        }
        return dimValues;
    }

    public TotalRowValueInfo getTotalRow(VirtualEntityQueryParamInfo queryParamInfo) {
        DataSet detailData = this.getDetailReportData(queryParamInfo);
        return new TotalRowValueInfo(detailData, true);
    }

    public Long getTotalCount(VirtualEntityQueryParamInfo queryParamInfo) {
        List<String> groupFieldNumberSet;
        AnObjFileSourceDataStoreTableBo dataStoreTable = this.getDataStoreTable(queryParamInfo);
        String tableName = dataStoreTable.getTableName();
        DBRoute dbRoute = DBRoute.of((String)"hmp");
        List<QFilter> qFilters = this.getFilters(queryParamInfo);
        List<VirtualFieldInfo> groupFields = queryParamInfo.getSelectedFieldInfoList().stream().filter(VirtualFieldInfo::isGroupField).collect(Collectors.toList());
        String groupBy = this.getGroupBy(groupFields, groupFieldNumberSet = groupFields.stream().map(VirtualFieldInfo::getNumber).collect(Collectors.toList()), queryParamInfo);
        if (HRStringUtils.isNotEmpty((String)groupBy)) {
            String whereGroupByAndOrderBy = this.getWhereGroupByAndOrderBy(qFilters, groupBy, null, dbRoute);
            String querySql = String.format("select count(*) from %s %s", tableName, whereGroupByAndOrderBy);
            LOGGER.info("FileSourceVirtualService getTotalCount Sql: {}", (Object)querySql);
            return (Long)HRDBUtil.query((DBRoute)dbRoute, (String)querySql, (Object[])new Object[0], resultSet -> {
                long result = 0L;
                while (resultSet.next()) {
                    ++result;
                }
                return result;
            });
        }
        String whereGroupByAndOrderBy = this.getWhereGroupByAndOrderBy(qFilters, null, null, dbRoute);
        String querySql = String.format("select count(*) from %s %s", tableName, whereGroupByAndOrderBy);
        LOGGER.info("FileSourceVirtualService getTotalCount Sql: {}", (Object)querySql);
        return (Long)HRDBUtil.query((DBRoute)dbRoute, (String)querySql, (Object[])new Object[0], resultSet -> {
            long result = 0L;
            while (resultSet.next()) {
                result = resultSet.getLong(1);
            }
            return result;
        });
    }

    public List<OrderField> getOrderFields() {
        ArrayList orderFields = Lists.newArrayListWithExpectedSize((int)1);
        orderFields.add(new OrderField("rptdbsortidx", "rptdbsortidx", DataTypeEnum.INTEGER, "asc", true));
        return orderFields;
    }

    public DynamicObjectCollection getAllVirtualFieldCollection() {
        return super.getAllVirtualFieldCollection();
    }

    private DataSet queryDetailData(VirtualEntityQueryParamInfo queryParamInfo, List<QFilter> qFilters, String leftJoin, String orderBy) {
        AnObjFileSourceDataStoreTableBo dataStoreTable = this.getDataStoreTable(queryParamInfo);
        String selectedFields = queryParamInfo.getSelectedFieldInfoList().stream().map(VirtualFieldInfo::getNumber).collect(Collectors.joining(","));
        DataSet dimDataSet = queryParamInfo.getLimit() > 0 ? this.queryData(dataStoreTable.getTableName(), qFilters, leftJoin, orderBy, null, selectedFields, queryParamInfo.getLimit(), queryParamInfo.getStart()) : this.queryData(dataStoreTable.getTableName(), qFilters, leftJoin, orderBy, null, selectedFields);
        return dimDataSet;
    }

    private DataSet queryData(String tableName, List<QFilter> qFilters, String leftJoin, String orderBy, String groupBy, String selectedFields) {
        DBRoute dbRoute = DBRoute.of((String)"hmp");
        String whereGroupByAndOrderBy = this.getWhereGroupByAndOrderBy(qFilters, groupBy, orderBy, dbRoute);
        String querySql = String.format("select %s from %s %s %s", selectedFields, tableName, leftJoin, whereGroupByAndOrderBy);
        LOGGER.info("FileSourceVirtualService queryData Sql: {}", (Object)querySql);
        return HRDBUtil.queryDataSet((String)"FileSourceVirtualService_queryDetailData", (DBRoute)dbRoute, (String)querySql, (Object[])new Object[0]);
    }

    private DataSet queryData(String tableName, List<QFilter> qFilters, String leftJoin, String orderBy, String groupBy, String selectedFields, int limit, int start) {
        DBRoute dbRoute = DBRoute.of((String)"hmp");
        String whereGroupByAndOrderBy = this.getWhereGroupByAndOrderBy(qFilters, groupBy, orderBy, dbRoute);
        String querySql = String.format("select top %s,%s %s from %s %s %s", limit, start, selectedFields, tableName, leftJoin, whereGroupByAndOrderBy);
        LOGGER.info("FileSourceVirtualService queryData Sql: {}", (Object)querySql);
        return HRDBUtil.queryDataSet((String)"FileSourceVirtualService_queryDetailData", (DBRoute)dbRoute, (String)querySql, (Object[])new Object[0]);
    }

    private AnObjFileSourceDataStoreTableBo getDataStoreTable(VirtualEntityQueryParamInfo queryParamInfo) {
        if (this.dataStoreTableBo != null) {
            return this.dataStoreTableBo;
        }
        VirtualEntityInfo virtualEntityInfo = queryParamInfo.getVirtualEntityInfo();
        Long virtualObjectId = virtualEntityInfo.getId();
        this.dataStoreTableBo = FileSourceTableMsgService.getInstance().queryTableMsgBoByVirtualObj(virtualObjectId);
        return this.dataStoreTableBo;
    }

    private String getGroupBy(List<VirtualFieldInfo> groupFields, List<String> groupFieldNumberSet, VirtualEntityQueryParamInfo queryParamInfo) {
        String groupBy = "";
        if (!groupFields.isEmpty()) {
            List<String> orderByFieldNumSet = this.getOrderByFieldNumList(queryParamInfo);
            for (String orderByFieldNum : orderByFieldNumSet) {
                if (groupFieldNumberSet.contains(orderByFieldNum)) continue;
                groupFieldNumberSet.add(orderByFieldNum);
            }
            groupBy = "group by " + String.join((CharSequence)",", groupFieldNumberSet);
        }
        return groupBy;
    }

    private String getWhereGroupByAndOrderBy(List<QFilter> qFilters, String groupBy, String orderBy, DBRoute dbRoute) {
        StringBuilder whereSqlBuilder = new StringBuilder();
        HashMap tmpTableMap = Maps.newHashMapWithExpectedSize((int)16);
        for (QFilter filter : qFilters) {
            if (filter == null) continue;
            String sqlStr = QFilterUtilHR.toQFilterString((QFilter)filter, (boolean)true, (boolean)true, (Map)tmpTableMap, (DBRoute)dbRoute, (int)1000);
            if (whereSqlBuilder.length() > 0) {
                whereSqlBuilder.append(" and ");
            }
            whereSqlBuilder.append(sqlStr);
        }
        String result = "";
        if (whereSqlBuilder.length() > 0) {
            result = result + "where " + whereSqlBuilder;
        }
        if (HRStringUtils.isNotEmpty((String)groupBy)) {
            result = result + " " + groupBy;
        }
        if (HRStringUtils.isNotEmpty((String)orderBy)) {
            result = result + " " + orderBy;
        }
        return result;
    }

    private List<Map<String, Object>> dataSetToListMap(DataSet dimDataSet) {
        ArrayList dimListMap = Lists.newArrayListWithCapacity((int)10);
        String[] fieldNames = dimDataSet.getRowMeta().getFieldNames();
        for (Row row : dimDataSet) {
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            for (String fieldName : fieldNames) {
                dataMap.put(fieldName, row.get(fieldName));
            }
            dimListMap.add(dataMap);
        }
        return dimListMap;
    }

    private List<Map<String, Object>> dataSetToListMapAndAddOrderField(List<Field> fieldList, DataSet dimDataSet) {
        Field sortNumField = new Field("rptdbsortidx", (DataType)DataType.IntegerType);
        fieldList.add(sortNumField);
        ArrayList dimListMap = Lists.newArrayListWithCapacity((int)10);
        int index = 0;
        for (Row row : dimDataSet) {
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Field field : fieldList) {
                if (HRStringUtils.equals((String)field.getName(), (String)"rptdbsortidx")) {
                    dataMap.put(field.getName(), index);
                    continue;
                }
                dataMap.put(field.getName(), row.get(field.getName()));
            }
            dimListMap.add(dataMap);
            ++index;
        }
        return dimListMap;
    }

    private List<QFilter> getFilters(VirtualEntityQueryParamInfo queryParamInfo) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        List reportFilterList = queryParamInfo.getReportFilterList();
        if (reportFilterList != null && !reportFilterList.isEmpty()) {
            qFilterList.addAll(reportFilterList);
        }
        return qFilterList;
    }

    private List<String> getOrderByFieldNumList(VirtualEntityQueryParamInfo queryParamInfo) {
        ArrayList orderByFieldNumSet = Lists.newArrayListWithCapacity((int)10);
        LinkedHashMap sortFieldInfoList = queryParamInfo.getSortFieldsMap();
        for (Map.Entry entry : sortFieldInfoList.entrySet()) {
            orderByFieldNumSet.add(entry.getKey());
        }
        return orderByFieldNumSet;
    }

    private String getOrderBy(VirtualEntityQueryParamInfo queryParamInfo, boolean hasGroupBy) {
        StringBuilder orderBySb = new StringBuilder();
        LinkedHashMap sortFieldInfoList = queryParamInfo.getSortFieldsMap();
        int index = 0;
        for (Map.Entry entry : sortFieldInfoList.entrySet()) {
            if (HRStringUtils.equals((String)((String)entry.getValue()), (String)"custom")) {
                String customTbAlias = "custom_sort" + index;
                if (hasGroupBy) {
                    orderBySb.append("max(").append(customTbAlias).append(".").append("findex").append(")").append(',');
                } else {
                    orderBySb.append(customTbAlias).append(".").append("findex").append(',');
                }
                ++index;
                continue;
            }
            orderBySb.append((String)entry.getKey()).append(' ').append((String)entry.getValue()).append(',');
        }
        int indexPoint = orderBySb.lastIndexOf(",");
        if (indexPoint != -1) {
            orderBySb.deleteCharAt(indexPoint);
        }
        if (orderBySb.length() > 0) {
            return "order by " + orderBySb;
        }
        return "";
    }

    private String getCustomOrder(VirtualEntityQueryParamInfo queryParamInfo) {
        LinkedHashMap sortFieldInfoList = queryParamInfo.getSortFieldsMap();
        if (sortFieldInfoList.values().stream().noneMatch(value -> HRStringUtils.equals((String)value, (String)"custom"))) {
            return "";
        }
        AnObjFileSourceDataStoreTableBo dataStoreTable = this.getDataStoreTable(queryParamInfo);
        StringBuilder customOrder = new StringBuilder();
        int index = 0;
        for (Map.Entry entry : sortFieldInfoList.entrySet()) {
            String customTbAlias = "custom_sort" + index;
            if (!HRStringUtils.equals((String)((String)entry.getValue()), (String)"custom")) continue;
            customOrder.append(' ').append(KsqlJoinHint.LEFTJOIN.getJoin()).append(' ').append("t_hrptmc_fsenum").append(' ').append(customTbAlias).append(" ON ").append(customTbAlias).append('.').append("ftablename").append(" = ").append("'").append(dataStoreTable.getTableName()).append("'").append(" AND ").append(customTbAlias).append('.').append("ffieldname").append(" = ").append("'").append((String)entry.getKey()).append("'").append(" AND ").append(customTbAlias).append('.').append("fenum").append(" = ").append((String)entry.getKey()).append(' ');
            ++index;
        }
        return customOrder.toString();
    }

    private List<QFilter> generateQFilterByDimValue(List<Map<String, Object>> dimListMap, VirtualEntityQueryParamInfo queryParamInfo) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (CollectionUtils.isEmpty(dimListMap)) {
            qFilterList.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            return qFilterList;
        }
        Map<String, DataTypeEnum> fieldAliasMap = queryParamInfo.getSelectedFieldInfoList().stream().collect(Collectors.toMap(VirtualFieldInfo::getNumber, VirtualFieldInfo::getFieldValueType));
        HashMap<String, HashSet<Object>> dimDataMap = new HashMap<String, HashSet<Object>>(16);
        HashSet<String> nvlValFieldSet = new HashSet<String>(16);
        for (Map<String, Object> map : dimListMap) {
            for (String fieldAlias : fieldAliasMap.keySet()) {
                Object dataVal = map.get(fieldAlias);
                if (dataVal == null) {
                    nvlValFieldSet.add(fieldAlias);
                    continue;
                }
                HashSet<Object> dataList = (HashSet<Object>)dimDataMap.get(fieldAlias);
                if (dataList == null) {
                    dataList = new HashSet<Object>(16);
                }
                dataList.add(dataVal);
                if ("".equals(dataVal)) {
                    dataList.add(" ");
                }
                dimDataMap.put(fieldAlias, dataList);
            }
        }
        for (Map.Entry entry : dimDataMap.entrySet()) {
            String fieldAlias = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)value)) {
                qFilterList.add(QFilter.isNull((String)fieldAlias));
                nvlValFieldSet.remove(fieldAlias);
                continue;
            }
            DataTypeEnum valueType = fieldAliasMap.get(fieldAlias);
            HashSet<Object> dbVals = new HashSet<Object>(value.size());
            for (Object obj : value) {
                dbVals.add(DataTypeConvertUtil.toConvertDbStore((DataTypeEnum)valueType, obj));
            }
            QFilter qFilter = new QFilter(fieldAlias, "in", dbVals);
            if (nvlValFieldSet.contains(fieldAlias)) {
                qFilter.or(QFilter.isNull((String)fieldAlias));
            }
            qFilterList.add(qFilter);
        }
        return qFilterList;
    }

    private List<Map<String, Object>> filterByDimTuple(List<Map<String, Object>> listDB, List<Map<String, Object>> dimListMap) {
        Object dimVal;
        StringBuilder allDimStb;
        if (CollectionUtils.isEmpty(dimListMap)) {
            return listDB;
        }
        Set<String> dimFieldAliasSet = dimListMap.get(0).keySet();
        HashSet<String> allDimStbCache = new HashSet<String>(16);
        for (Map<String, Object> dimData : dimListMap) {
            allDimStb = new StringBuilder();
            for (String dimFieldName : dimFieldAliasSet) {
                dimVal = dimData.get(dimFieldName);
                allDimStb.append(dimFieldName).append(dimVal);
            }
            allDimStbCache.add(allDimStb.toString());
        }
        Iterator<Map<String, Object>> iterator = listDB.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            allDimStb = new StringBuilder();
            for (String dimFieldName : dimFieldAliasSet) {
                dimVal = next.get(dimFieldName);
                allDimStb.append(dimFieldName).append(dimVal);
            }
            if (allDimStbCache.contains(allDimStb.toString())) continue;
            iterator.remove();
        }
        return listDB;
    }
}

