/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRReportDynamicObjectUtils {
    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty((Collection)fromPros)) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty((Collection)toPros)) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase(Locale.ROOT));
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase(Locale.ROOT));
        }
        HRReportDynamicObjectUtils.handletoPros(fromObj, toObj, ignoreKeys, transKeyMap, toPros, fromPsSet, toPsSet);
    }

    private static void handletoPros(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap, DataEntityPropertyCollection toPros, HashSet<String> fromPsSet, HashSet<String> toPsSet) {
        Object value;
        HashMap<String, String> toObjNotExistTransKeyMap = null;
        if (transKeyMap != null) {
            toObjNotExistTransKeyMap = new HashMap<String, String>(transKeyMap);
        }
        for (IDataEntityProperty pro : toPros) {
            String toProName;
            String fromProName = toProName = pro.getName();
            if (transKeyMap != null && Objects.nonNull(transKeyMap.get(fromProName))) {
                toProName = transKeyMap.get(fromProName);
                if (toObjNotExistTransKeyMap != null) {
                    toObjNotExistTransKeyMap.remove(fromProName);
                }
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) && !toPsSet.contains(toProName)) continue;
            value = fromObj.get(fromProName);
            HRReportDynamicObjectUtils.putObj(toObj, ignoreKeys, transKeyMap, toProName, pro, value);
        }
        if (toObjNotExistTransKeyMap != null && !toObjNotExistTransKeyMap.isEmpty()) {
            for (Map.Entry transEntry : toObjNotExistTransKeyMap.entrySet()) {
                String fromProName = (String)transEntry.getKey();
                String toProName = (String)transEntry.getValue();
                if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
                value = fromObj.get(fromProName);
                HRReportDynamicObjectUtils.putObj(toObj, ignoreKeys, transKeyMap, toProName, null, value);
            }
        }
    }

    private static void putObj(DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap, String toProName, IDataEntityProperty pro, Object value) {
        if (value instanceof DynamicObjectCollection) {
            if (value instanceof LocaleDynamicObjectCollection) {
                return;
            }
            DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
            DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
            if (toEntity != null) {
                DynamicObjectType entityType = toEntity.getDynamicObjectType();
                HRReportDynamicObjectUtils.clearCopy(formEntity, toEntity, ignoreKeys, entityType, transKeyMap);
            }
            toObj.set(toProName, (Object)toEntity);
        } else if (!toProName.endsWith("_id")) {
            toObj.set(toProName, value);
        }
    }

    public static Object buildBaseData(IDataEntityProperty prop, Object value) {
        BasedataProp basedataProp;
        String baseEntityId;
        DynamicObject baseData;
        if (prop instanceof BasedataProp && (value instanceof Long || value instanceof Integer) && (baseData = BusinessDataServiceHelper.loadSingle((Object)value, (String)(baseEntityId = (basedataProp = (BasedataProp)prop).getBaseEntityId()))) != null) {
            value = baseData;
        }
        return value;
    }

    private static void clearCopy(DynamicObjectCollection formEntity, DynamicObjectCollection toEntity, Set<String> ignoreKeys, DynamicObjectType entityType, Map<String, String> transKeyMap) {
        toEntity.clear();
        for (DynamicObject baseEntry : formEntity) {
            DynamicObject newEntry = new DynamicObject(entityType);
            HRReportDynamicObjectUtils.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
            toEntity.add((Object)newEntry);
        }
    }

    public static Map convertDynamicObjectToMap(DynamicObject dy) throws KDBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (dy == null) {
            return map;
        }
        DataEntityPropertyCollection dePros = dy.getDataEntityType().getProperties();
        if (dePros == null || dePros.size() == 0) {
            return map;
        }
        for (IDataEntityProperty pro : dePros) {
            String proName = pro.getName();
            Object value = dy.get(proName);
            if (value instanceof DynamicObject) {
                Map f7Map = HRReportDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)value);
                map.put(proName, f7Map);
            }
            if (value instanceof DynamicObjectCollection) {
                ArrayList<Map> entryList = new ArrayList<Map>();
                DynamicObjectCollection dyEntrys = (DynamicObjectCollection)value;
                for (DynamicObject dyEntry : dyEntrys) {
                    Map entryMap = HRReportDynamicObjectUtils.convertDynamicObjectToMap(dyEntry);
                    entryList.add(entryMap);
                }
                map.put(proName, entryList);
                continue;
            }
            map.put(proName, value);
        }
        return map;
    }

    public static String getQueryFields(DynamicObject dy) {
        if (dy == null) {
            return "";
        }
        DataEntityPropertyCollection pros = dy.getDataEntityType().getProperties();
        if (pros == null || pros.size() == 0) {
            return "";
        }
        StringBuilder queryFieldsStr = new StringBuilder();
        for (IDataEntityProperty pro : pros) {
            String proStr = pro.getName().toLowerCase(Locale.ROOT);
            if (proStr.endsWith("_id") || proStr.endsWith("text")) continue;
            queryFieldsStr.append(proStr).append(',');
        }
        if (queryFieldsStr.length() > 0) {
            queryFieldsStr.delete(queryFieldsStr.length() - 1, queryFieldsStr.length());
        }
        return queryFieldsStr.toString();
    }

    public static boolean equals(DynamicObject obj1, DynamicObject obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.getLong("id") == obj2.getLong("id");
    }

    public static String getStringValue(DynamicObject dy, String field) {
        Object propObject = dy.getDataEntityType().getProperties().get((Object)field);
        String result = HRObjectUtils.convertObjectToString((Object)dy.get(field));
        if (propObject instanceof AdminDivisionProp && !HRStringUtils.isEmpty((String)result)) {
            String adminDivision = "";
            long adminDivisionId = Long.parseLong(result);
            QFilter idFilter = new QFilter("id", "=", (Object)adminDivisionId);
            DynamicObject admindivisionDynamic = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])idFilter.toArray());
            String admindivisionFullName = admindivisionDynamic != null ? admindivisionDynamic.getString("fullname") : result;
            String[] admindivisionArray = admindivisionFullName.split("_");
            StringBuilder adminDivisionBuilder = new StringBuilder();
            int length = admindivisionArray.length;
            for (int i = 0; i < length; ++i) {
                adminDivisionBuilder.append(admindivisionArray[i]);
                adminDivisionBuilder.append('/');
            }
            if (adminDivisionBuilder.length() > 0) {
                adminDivision = adminDivisionBuilder.substring(0, adminDivision.length() - 1);
            }
            return adminDivision;
        }
        if (propObject instanceof ComboProp) {
            List comboItems = ((ComboProp)propObject).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(result)) continue;
                result = comboItem.getName().getLocaleValue();
                break;
            }
        }
        return result;
    }

    public static boolean isPropertyExist(DynamicObject dynamicObject, String propertyName) {
        if (Objects.isNull(dynamicObject)) {
            return false;
        }
        DynamicProperty property = dynamicObject.getDynamicObjectType().getProperty(propertyName);
        return Objects.nonNull(property);
    }

    public static DynamicObjectType buildDyObjType(String entityName) {
        HRAssert.notBlank((String)entityName, (String)"entityName cannot be empty", (Object[])new Object[0]);
        return new DynamicObjectType(entityName);
    }

    public static DynamicObject createEmptyDyObj(String entityName) {
        return new DynamicObject(HRReportDynamicObjectUtils.buildDyObjType(entityName));
    }
}

