/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;
import kd.hr.hrptmc.common.util.GzipCompress;

public class HReportImportUtil {
    private static final Log LOGGER = LogFactory.getLog(HReportImportUtil.class);
    private static DynamicObjectCollection currentLanCol = null;

    public static void clearCache() {
        IAppCache appCache = AppCache.get((String)"HRPTMC");
        appCache.remove(HReportImportUtil.getImportCacheKeySuffix("HR_REPORT_IMP_BaseDataId"));
        appCache.remove(HReportImportUtil.getImportCacheKeySuffix("HR_REPORT_IMP_baseDataIdResult"));
    }

    public static String getImportCacheKeySuffix(String key) {
        return key + RequestContext.get().getGlobalSessionId() + RequestContext.get().getCurrUserId();
    }

    public static void updateNameData(DynamicObject dy, List<DynamicObject> nameCol, HRBaseServiceHelper helper) {
        String number = dy.getString("number");
        DynamicObject name = nameCol.stream().filter(nameDy -> HRStringUtils.equals((String)nameDy.getString("number"), (String)number)).findAny().orElseGet(() -> {
            DynamicObject newNameDy = helper.generateEmptyDynamicObject();
            newNameDy.set("number", (Object)number);
            nameCol.add(newNameDy);
            return newNameDy;
        });
        name.set("name", (Object)dy.getLocaleString("name"));
    }

    public static boolean validateNameRepeat(JSONArray nameMulti, List<ILocaleString> names) {
        for (Object multiObj : nameMulti) {
            JSONObject nameJson = (JSONObject)multiObj;
            String lan = nameJson.getString("lan");
            String value = nameJson.getString("value");
            for (ILocaleString name : names) {
                if (value == null || !HRStringUtils.equals((String)((String)name.getItem(lan)), (String)value)) continue;
                return false;
            }
        }
        return true;
    }

    public static LocaleString transMultiField(JSONArray multis) {
        LocaleString localeString = new LocaleString();
        multis.stream().map(multiObj -> (JSONObject)multiObj).forEach(multiJson -> {
            String lan = multiJson.getString("lan");
            String value = multiJson.getString("value");
            localeString.setItem(lan, (Object)value);
        });
        return localeString;
    }

    public static String getEnumFieldValue(String entityNum, String fieldNum, String displayVal) {
        IDataEntityProperty property = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)entityNum).getFields().get(fieldNum);
        if (property instanceof ComboProp && HRStringUtils.isNotEmpty((String)displayVal)) {
            List valueMapItemList = ((ComboProp)property).getComboItems();
            return HReportImportUtil.getEnumValueInLan(valueMapItemList, displayVal);
        }
        return displayVal;
    }

    public static String getEnumFieldValue(String entityNum, String entryNum, String fieldNum, String displayVal) {
        List valueMapItemList = ((ComboProp)((EntityType)EntityMetadataCache.getDataEntityType((String)entityNum).getAllEntities().get(entryNum)).getFields().get(fieldNum)).getComboItems();
        return HReportImportUtil.getEnumValueInLan(valueMapItemList, displayVal);
    }

    private static String getEnumValueInLan(List<ValueMapItem> valueMapItemList, String displayVal) {
        if (currentLanCol == null) {
            HReportImportUtil.setCurrentEnabledLan();
        }
        for (ValueMapItem item : valueMapItemList) {
            for (DynamicObject lan : currentLanCol) {
                String name = (String)item.getName().getItem(lan.getString("number"));
                if (!HRStringUtils.equals((String)name, (String)displayVal)) continue;
                return item.getValue();
            }
        }
        return displayVal;
    }

    public static void parsePropData(String fieldKey, Object fieldValue, DynamicObject dyObj, ImportLogger importLogger, Integer rowNum) {
        try {
            if (Objects.nonNull(fieldValue) && HRStringUtils.isNotEmpty((String)fieldValue.toString())) {
                dyObj.set(fieldKey, (Object)HRDateTimeUtils.parseDate((String)String.valueOf(fieldValue)));
            }
        }
        catch (ParseException e) {
            LOGGER.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef,", (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\u3002\u65e0\u6548\u503c\u4e3a\uff1a\u201c%s\u201d\u3002", (String)"HReportImportUtil_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), fieldValue);
            importLogger.log(rowNum, msg);
        }
    }

    public static void parseTimePropData(String fieldKey, Object fieldValue, DynamicObject dyObj, ImportLogger importLogger, Integer rowNum) {
        try {
            if (Objects.nonNull(fieldValue) && HRStringUtils.isNotEmpty((String)fieldValue.toString())) {
                dyObj.set(fieldKey, (Object)HRDateTimeUtils.parseDate((String)String.valueOf(fieldValue)));
            }
        }
        catch (ParseException e) {
            LOGGER.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef,", (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\u3002\u65e0\u6548\u503c\u4e3a\uff1a\u201c%s\u201d\u3002", (String)"HReportImportUtil_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), fieldValue);
            importLogger.log(rowNum, msg);
        }
    }

    public static void initDynamicObjValues(int rowNum, DynamicObject dynamicObject, IDataEntityProperty prop, ImportLogger importLogger, JSONObject rowData, boolean isEntry) {
        if (prop instanceof EntryProp) {
            try {
                JSONArray jSONArray = rowData.getJSONArray(prop.getName());
                if (jSONArray == null) {
                    return;
                }
                DynamicObjectCollection entryCollection = dynamicObject.getDynamicObjectCollection(prop.getName());
                int size = jSONArray.size();
                for (int i = 0; i < size; ++i) {
                    JSONObject rowSubData = jSONArray.getJSONObject(i);
                    DynamicObjectType entryType = entryCollection.getDynamicObjectType();
                    DynamicObject entryItem = entryCollection.addNew();
                    for (IDataEntityProperty p : entryType.getProperties()) {
                        if (!rowSubData.containsKey((Object)p.getName())) continue;
                        HReportImportUtil.initDynamicObjValues(rowNum, entryItem, p, importLogger, rowSubData, true);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5206\u5f55json\u89e3\u6790\u9519\u8bef,", (Throwable)e);
                String msg = String.format(ResManager.loadKDString((String)"JSON\u89e3\u6790\u9519\u8bef\uff0c\u65e0\u6548\u503c\u4e3a:%s\u3002", (String)"HReportImportUtil_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), rowData.get((Object)prop.getName()));
                importLogger.log(Integer.valueOf(rowNum), msg);
            }
        } else {
            Object rowDataVal = rowData.get((Object)prop.getName());
            if (rowDataVal instanceof String) {
                rowDataVal = GzipCompress.decompressFromString((String)((String)rowDataVal));
            }
            try {
                if (prop instanceof MuliLangTextProp) {
                    Object property = rowDataVal;
                    if (property instanceof JSONObject) {
                        Map multiProperty = (Map)property;
                        dynamicObject.set(prop.getName(), (Object)LocaleString.fromMap((Map)multiProperty));
                    } else if (property instanceof JSONArray) {
                        JSONArray multiProperty = (JSONArray)property;
                        LocaleString multiPropertyLocale = HReportImportUtil.transMultiField(multiProperty);
                        dynamicObject.set(prop.getName(), (Object)multiPropertyLocale);
                    }
                } else if (prop instanceof TextProp || prop instanceof LargeTextProp || prop instanceof VarcharProp || prop instanceof ComboProp || prop instanceof BooleanProp) {
                    dynamicObject.set(prop.getName(), rowDataVal);
                } else if (prop instanceof DecimalProp) {
                    Object fieldValue = rowDataVal;
                    if (Objects.nonNull(fieldValue) && HRStringUtils.isNotEmpty((String)fieldValue.toString())) {
                        dynamicObject.set(prop.getName(), (Object)new BigDecimal(String.valueOf(fieldValue)));
                    }
                } else if (prop instanceof DateProp) {
                    HReportImportUtil.parsePropData(prop.getName(), rowDataVal, dynamicObject, importLogger, rowNum);
                } else if (prop instanceof DateTimeProp) {
                    HReportImportUtil.parseTimePropData(prop.getName(), rowDataVal, dynamicObject, importLogger, rowNum);
                } else if (!(prop instanceof CreaterProp) && !(prop instanceof ModifierProp)) {
                    if (prop instanceof BasedataProp) {
                        if (HRStringUtils.equalsIgnoreCase((String)prop.getName(), (String)"permobj")) {
                            HRBaseServiceHelper helper = new HRBaseServiceHelper("hbp_entityobject");
                            QFilter idFilter = new QFilter("id", "=", rowDataVal);
                            if (!helper.isExists(idFilter)) {
                                String msg = String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u89e3\u6790\u9519\u8bef\u3002\u65e0\u6548\u503c\u4e3a\uff1a\u201c%s\u201d\u3002", (String)"HReportImportUtil_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), rowDataVal);
                                importLogger.log(Integer.valueOf(rowNum), msg);
                            } else {
                                dynamicObject.set(prop.getName(), rowDataVal);
                            }
                        } else {
                            HReportImportUtil.transferBaseDataProp(rowData, dynamicObject, prop);
                        }
                    } else if (prop instanceof MulBasedataProp) {
                        JSONArray jSONArray = rowData.getJSONArray(prop.getName());
                        if (jSONArray == null) {
                            return;
                        }
                        MulBasedataProp multiProp = (MulBasedataProp)prop;
                        DynamicObjectCollection multiCollection = dynamicObject.getDynamicObjectCollection((IDataEntityProperty)multiProp);
                        DynamicObjectType multiDyObjType = multiCollection.getDynamicObjectType();
                        int size = jSONArray.size();
                        for (int i = 0; i < size; ++i) {
                            JSONObject rowSubData = jSONArray.getJSONObject(i);
                            DynamicObject multiDy = new DynamicObject(multiDyObjType);
                            for (IDataEntityProperty p : multiDyObjType.getProperties()) {
                                if (rowSubData.containsKey((Object)p.getName()) && HRStringUtils.equalsIgnoreCase((String)p.getName(), (String)"fbasedataid")) {
                                    DynamicObject instance = (DynamicObject)multiProp.getComplexType().createInstance();
                                    instance.set("id", rowSubData.get((Object)p.getName()));
                                    multiDy.set("fbasedataid", (Object)instance);
                                    continue;
                                }
                                if (!rowSubData.containsKey((Object)p.getName())) continue;
                                multiDy.set(p.getName(), rowSubData.get((Object)p.getName()));
                            }
                            multiCollection.add((Object)multiDy);
                        }
                    } else {
                        dynamicObject.set(prop.getName(), rowDataVal);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5c5e\u6027\u89e3\u6790\u9519\u8bef,", (Throwable)e);
                String msg = String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u89e3\u6790\u9519\u8bef\u3002\u65e0\u6548\u503c\u4e3a\uff1a\u201c%s\u201d\u3002", (String)"HReportImportUtil_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), rowDataVal);
                importLogger.log(Integer.valueOf(rowNum), msg);
            }
        }
    }

    private static void transferBaseDataProp(JSONObject rowData, DynamicObject dynamicObject, IDataEntityProperty prop) {
        Object baseDataStr = rowData.get((Object)prop.getName());
        if (Objects.isNull(baseDataStr) || HRStringUtils.isEmpty((String)baseDataStr.toString())) {
            return;
        }
        String[] baseDataArr = baseDataStr.toString().split("\u03b5");
        if (baseDataArr.length < 2) {
            dynamicObject.set(prop.getName(), baseDataStr);
            return;
        }
        if (HRStringUtils.equalsIgnoreCase((String)prop.getName(), (String)"createorg")) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org");
            DynamicObject dyObj = helper.generateEmptyDynamicObject();
            dyObj.set("number", (Object)baseDataArr[0]);
            dyObj.set("name", (Object)baseDataArr[1]);
            dynamicObject.set(prop.getName(), (Object)dyObj);
            return;
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)baseDataArr[0]);
        QFilter nameFilter = new QFilter("name", "=", (Object)baseDataArr[1]);
        String baseDataEntityId = ((BasedataProp)prop).getBaseEntityId();
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((String)baseDataEntityId, (String)"id", (QFilter[])new QFilter[]{numberFilter, nameFilter});
        if (dyObj != null) {
            dynamicObject.set(prop.getName(), (Object)dyObj.getLong("id"));
            return;
        }
    }

    public static String buildProperties(String entityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        StringBuilder selectProperties = new StringBuilder();
        for (Map.Entry entityType : mainEntityType.getAllEntities().entrySet()) {
            String entityKey = (String)entityType.getKey();
            if (HRStringUtils.equalsIgnoreCase((String)entityNumber, (String)entityKey)) {
                selectProperties.append(((EntityType)entityType.getValue()).getProperties().stream().filter(o -> o.getName().indexOf("_id") < 0).map(IMetadata::getName).collect(Collectors.joining(",")));
                continue;
            }
            selectProperties.append(((EntityType)entityType.getValue()).getProperties().stream().filter(o -> o.getName().indexOf("_id") < 0).map(IMetadata::getName).collect(Collectors.joining("," + entityKey + ".")));
        }
        return selectProperties.toString();
    }

    public static void queryExistData(Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData) {
        allPreData.entrySet().stream().forEach(entry -> {
            List rptManageIdList;
            List anObjIdList;
            List analyseObjectList;
            List dynamicObjectList = (List)entry.getValue();
            List idList = dynamicObjectList.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "in", idList);
            if (HREXPImpEnum.getSheetByNumber((String)((String)entry.getKey())) != null) {
                List numberList = dynamicObjectList.stream().map(dyObj -> dyObj.getString("number")).collect(Collectors.toList());
                QFilter numberFilter = new QFilter("number", "in", numberList);
                idFilter.or(numberFilter);
                List nameList = dynamicObjectList.stream().map(dyObj -> dyObj.getString("name")).collect(Collectors.toList());
                QFilter nameFilter = new QFilter("name", "in", nameList);
                idFilter.or(nameFilter);
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_reportpreindex")) {
                List reportIdList = dynamicObjectList.stream().map(dyObj -> dyObj.getLong("report")).collect(Collectors.toList());
                List preIndexIdList = dynamicObjectList.stream().map(dyObj -> dyObj.getLong("preindex")).collect(Collectors.toList());
                idFilter = new QFilter("report", "in", reportIdList);
                idFilter.and(new QFilter("preindex", "in", preIndexIdList));
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_anobjqueryfield") && allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber()) != null) {
                analyseObjectList = (List)allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber());
                anObjIdList = analyseObjectList.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                idFilter.or(new QFilter("anobj", "in", anObjIdList));
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_anobjpivot") && allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber()) != null) {
                analyseObjectList = (List)allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber());
                anObjIdList = analyseObjectList.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                idFilter.or(new QFilter("anobj", "in", anObjIdList));
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_calculatefield") && allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber()) != null) {
                analyseObjectList = (List)allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber());
                anObjIdList = analyseObjectList.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                idFilter.or(new QFilter("anobj", "in", anObjIdList));
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_anobjgroupfield") && allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber()) != null) {
                analyseObjectList = (List)allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber());
                anObjIdList = analyseObjectList.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                idFilter.or(new QFilter("anobj", "in", anObjIdList));
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_anobjsidebar") && allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber()) != null) {
                analyseObjectList = (List)allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber());
                anObjIdList = analyseObjectList.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                idFilter.or(new QFilter("anobj", "in", anObjIdList));
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_customsort") && allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber()) != null) {
                analyseObjectList = (List)allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber());
                rptManageIdList = analyseObjectList.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                idFilter.or(new QFilter("rptmanage", "in", rptManageIdList));
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)"hrptmc_reportjump") && allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber()) != null) {
                analyseObjectList = (List)allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber());
                rptManageIdList = analyseObjectList.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                idFilter.or(new QFilter("report", "in", rptManageIdList));
            } else if (HRStringUtils.equalsIgnoreCase((String)((String)entry.getKey()), (String)HREXPImpEnum.WORKREPORT.getNumber()) && allPreData.get(HREXPImpEnum.WORKREPORT.getNumber()) != null) {
                try {
                    List list = (List)allPreData.get(HREXPImpEnum.WORKREPORT.getNumber());
                    rptManageIdList = list.stream().map(dyObj -> dyObj.getLong("rptmanage")).collect(Collectors.toList());
                    HRBaseServiceHelper helper = new HRBaseServiceHelper((String)entry.getKey());
                    DynamicObject[] dynamicObjectArray = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("rptmanage", "in", rptManageIdList)});
                    List keys = Arrays.stream(dynamicObjectArray).map(dyObj -> dyObj.getInt("key")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(keys)) {
                        Integer max = (Integer)Collections.max(keys);
                        List ids = Arrays.stream(dynamicObjectArray).map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                        for (DynamicObject dyObj2 : list) {
                            Long id = dyObj2.getLong("id");
                            if (ids.contains(id)) continue;
                            max = max + 1;
                            dyObj2.set("key", (Object)max);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                }
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper((String)entry.getKey());
            DynamicObject[] existData = helper.loadDynamicObjectArray(new QFilter[]{idFilter});
            allExistData.put((String)entry.getKey(), Arrays.asList(existData));
        });
        HReportImportUtil.buildCoverData(allPreData, allExistData);
    }

    private static void buildCoverData(Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData) {
        List rptManageIdList;
        List<DynamicObject> analyseObjectList;
        List anObjIdList;
        QFilter idFilter;
        HRBaseServiceHelper helper;
        DynamicObject[] existData;
        if (allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber()) != null && allPreData.get("hrptmc_anobjsidebar") == null && (existData = (helper = new HRBaseServiceHelper("hrptmc_anobjsidebar")).loadDynamicObjectArray(new QFilter[]{idFilter = new QFilter("anobj", "in", anObjIdList = (analyseObjectList = allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber())).stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList()))})) != null && existData.length > 0) {
            allExistData.put("hrptmc_anobjsidebar", Arrays.asList(existData));
        }
        if (allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber()) != null && allPreData.get("hrptmc_anobjpivot") == null && (existData = (helper = new HRBaseServiceHelper("hrptmc_anobjpivot")).loadDynamicObjectArray(new QFilter[]{idFilter = new QFilter("anobj", "in", anObjIdList = (analyseObjectList = allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber())).stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList()))})) != null && existData.length > 0) {
            allExistData.put("hrptmc_anobjpivot", Arrays.asList(existData));
        }
        if (allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber()) != null && allPreData.get("hrptmc_customsort") == null && (existData = (helper = new HRBaseServiceHelper("hrptmc_customsort")).loadDynamicObjectArray(new QFilter[]{idFilter = new QFilter("rptmanage", "in", rptManageIdList = (analyseObjectList = allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber())).stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList()))})) != null && existData.length > 0) {
            allExistData.put("hrptmc_customsort", Arrays.asList(existData));
        }
        if (allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber()) != null && allPreData.get("hrptmc_reportjump") == null && (existData = (helper = new HRBaseServiceHelper("hrptmc_reportjump")).loadDynamicObjectArray(new QFilter[]{idFilter = new QFilter("report", "in", rptManageIdList = (analyseObjectList = allPreData.get(HREXPImpEnum.REPORTMANAGE.getNumber())).stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList()))})) != null && existData.length > 0) {
            allExistData.put("hrptmc_customsort", Arrays.asList(existData));
        }
    }

    private static void setCurrentEnabledLan() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("inte_enabledlanguage");
        currentLanCol = helper.queryOriginalCollection("name, number", new QFilter[]{new QFilter("enabledlang", "=", (Object)"1")});
    }
}

