/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.imp.validator;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptmc.business.imp.validator.AbstractImportValidator;
import kd.hr.hrptmc.common.constant.expimp.HREXPImpEnum;

public class ReportManageImportValidator
extends AbstractImportValidator {
    @Override
    public boolean validateImpl(int rowHeadNum, ImportContext ctx, HREXPImpEnum impEnum, Map<String, List<DynamicObject>> allPreData, Map<String, List<DynamicObject>> allExistData, ImportLogger importLogger) {
        List<DynamicObject> dynamicObjects = allPreData.get(impEnum.getNumber());
        List<DynamicObject> importAnObjObjects = allPreData.get(HREXPImpEnum.ANALYSEOBJECT.getNumber());
        List<DynamicObject> importPreIndexObjects = allPreData.get(HREXPImpEnum.PREINDEX.getNumber());
        List<DynamicObject> importReportPreIndex = allPreData.get("hrptmc_reportpreindex");
        List<DynamicObject> preReportJumpList = allPreData.get("hrptmc_reportjump");
        List<Long> dynamicObjectIds = dynamicObjects.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = dynamicObjects.get(i);
            this.checkJumpReport(rowHeadNum, impEnum, importLogger, preReportJumpList, dynamicObjectIds, i, dynamicObject);
            if (importAnObjObjects != null && importAnObjObjects.stream().anyMatch(data -> data.getLong("id") == dynamicObject.getLong("anobjid"))) continue;
            importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u4f9d\u8d56\u7684\u5206\u6790\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"ReportManageImportValidator_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        return false;
    }

    private void checkJumpReport(int rowHeadNum, HREXPImpEnum impEnum, ImportLogger importLogger, List<DynamicObject> preReportJumpList, List<Long> dynamicObjectIds, int i, DynamicObject dynamicObject) {
        if (CollectionUtils.isEmpty(preReportJumpList)) {
            return;
        }
        List rptManageIdList = preReportJumpList.stream().map(dyObj -> {
            if (dynamicObject.getLong("id") == dyObj.getLong("report")) {
                return dyObj.getLong("jumpreport");
            }
            return null;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rptManageIdList)) {
            return;
        }
        rptManageIdList.removeAll(dynamicObjectIds);
        rptManageIdList.remove(null);
        if (CollectionUtils.isNotEmpty(rptManageIdList)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(impEnum.getNumber());
            QFilter idFilter = new QFilter("id", "in", rptManageIdList);
            int existData = helper.count(impEnum.getNumber(), new QFilter[]{idFilter});
            if (existData != rptManageIdList.size()) {
                importLogger.log(Integer.valueOf(rowHeadNum + i), ResManager.loadKDString((String)"\u8df3\u8f6c\u62a5\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"ReportManageImportValidator_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            }
        }
    }
}

