/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.preindex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.ReflectUtil;
import kd.hr.hrptmc.business.preindex.IPresetIndexCallHandler;
import kd.hr.hrptmc.business.preindex.PresetIndexServiceHelper;
import kd.hr.hrptmc.business.preindex.model.PresetIndexBusinessServiceParam;
import kd.hr.hrptmc.business.preindex.model.PresetIndexServiceParam;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.common.constant.preindex.PresetIndexConstants;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;

public class PresetIndexCallServiceHandler
implements IPresetIndexCallHandler,
PresetIndexConstants {
    private static final Log LOGGER = LogFactory.getLog(PresetIndexCallServiceHandler.class);
    private final PresetIndexServiceHelper serviceHelper = new PresetIndexServiceHelper();

    @Override
    public List<Object> call(PresetIndexServiceParam params) {
        List<ReportField> rowList = params.getRowList();
        List<ReportField> columnList = params.getColumnList();
        DimMapBo dimMap = params.getDimMap();
        List<QFilter> paramList = params.getParamList();
        LOGGER.info("PresetIndexServiceHelper-invokeCalculateService-paramList-before:{}", paramList);
        List<QFilter> joinOnQFilters = params.getJoinOnQFilters();
        if (paramList != null && !paramList.isEmpty()) {
            if (joinOnQFilters != null && !joinOnQFilters.isEmpty()) {
                QFilter qFilter = paramList.get(0);
                for (QFilter joinOnQFilter : joinOnQFilters) {
                    qFilter.and(joinOnQFilter);
                }
            }
            ArrayList qFiltersCopy = Lists.newArrayListWithCapacity((int)10);
            for (QFilter qFilter : paramList) {
                if (qFilter == null) continue;
                QFilter copy = qFilter.copy();
                qFiltersCopy.add(copy);
            }
            paramList = this.rebuildParamByDimMap(qFiltersCopy, dimMap);
        }
        LOGGER.info("PresetIndexServiceHelper-invokeCalculateService-paramList-after:{}", paramList);
        List<Object[]> valueList = params.getValueList();
        AdminOrgSummaryInfo adminOrgSummaryInfo = params.getAdminOrgSummaryInfo();
        String presetIndexNumber = params.getPresetIndexNumber();
        DynamicObject presetIndex = this.serviceHelper.getPresetIndexByNumber(presetIndexNumber);
        String classFullName = presetIndex.getString("service.classfullname");
        String methodName = presetIndex.getString("service.methodname");
        List rspTargetValues = null;
        try {
            Class<?> targetClassObj = Class.forName(classFullName);
            Object service = targetClassObj.newInstance();
            Method serviceMethod = targetClassObj.getMethod(methodName, PresetIndexBusinessServiceParam.class);
            PresetIndexBusinessServiceParam param = new PresetIndexBusinessServiceParam();
            param.setRowList(rowList.stream().map(ReportField::getFieldAlias).collect(Collectors.toList()));
            param.setColumnList(columnList.stream().map(ReportField::getFieldAlias).collect(Collectors.toList()));
            param.setParamList(paramList);
            param.setValueList(valueList);
            param.setDimMapBo(dimMap);
            param.setDimMap(this.getDimMapMsg(dimMap));
            param.setAdminOrgSummaryInfo(adminOrgSummaryInfo);
            param.setTraceId(params.getTraceId());
            Object[] methodParams = new Object[]{param};
            rspTargetValues = (List)ReflectUtil.invoke(service, (Method)serviceMethod, (Object[])methodParams);
        }
        catch (ClassNotFoundException exc) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u670d\u52a1\u7c7b\u201c%1$s\u201d\u672a\u627e\u5230\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"PresetIndexServiceHelper_01", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), classFullName, exc.getMessage()));
        }
        catch (IllegalAccessException | InstantiationException exc) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b9e\u4f8b\u5316\u670d\u52a1\u7c7b\uff1a%1$s\uff0c\u53d1\u751f\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"PresetIndexServiceHelper_02", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), classFullName, exc.getMessage()));
        }
        catch (NoSuchMethodException exc) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u83b7\u53d6\u670d\u52a1\u7c7b\uff1a%1$s \u7684%2$s\u65b9\u6cd5\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%3$s", (String)"PresetIndexServiceHelper_03", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), classFullName, methodName, exc.getMessage()));
        }
        return rspTargetValues;
    }

    private Map<String, Map<String, String>> getDimMapMsg(DimMapBo dimMapBo) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)dimMapBo.getDimMapEntryBos().size());
        for (DimMapEntryBo dimMapEntryBo : dimMapBo.getDimMapEntryBos()) {
            String dimNumber = dimMapEntryBo.getDimNumber();
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("dim", dimMapEntryBo.getDim().getLocaleValue());
            map.put("dimtype", dimMapEntryBo.getDimType());
            map.put("dimfrom", dimMapEntryBo.getDimFrom());
            map.put("dimrealfrom", dimMapEntryBo.getDimRealFrom());
            map.put("paramrule", dimMapEntryBo.getParamRule());
            map.put("preindexparam", dimMapEntryBo.getPreIndexParam());
            result.put(dimNumber, map);
        }
        return result;
    }
}

