/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.preindex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.common.constant.preindex.PresetIndexConstants;

public class PresetIndexServiceHelper
implements PresetIndexConstants {
    private static final Log LOGGER = LogFactory.getLog(PresetIndexServiceHelper.class);
    private final HRBaseServiceHelper reportPreIndexHelper = new HRBaseServiceHelper("hrptmc_reportpreindex");
    private final HRBaseServiceHelper dimMapHelper = new HRBaseServiceHelper("hrptmc_dimmap");
    private final HRBaseServiceHelper presetIndexHelper = new HRBaseServiceHelper("hrptmc_preindex");

    public List<IndexFieldInfo> getPreIndexByReportId(Long rptManageId) {
        DynamicObject[] reportPreIndexS = this.reportPreIndexHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("report", "=", (Object)rptManageId)});
        ArrayList<IndexFieldInfo> indexFieldInfos = new ArrayList<IndexFieldInfo>(reportPreIndexS.length);
        for (DynamicObject reportPreIndex : reportPreIndexS) {
            IndexFieldInfo indexFieldInfo = new IndexFieldInfo();
            indexFieldInfo.setFieldId(reportPreIndex.getString("preindex.id"));
            indexFieldInfo.setFieldName(new LocaleString(reportPreIndex.getString("preindex.name")));
            indexFieldInfo.setFieldAlias(reportPreIndex.getString("preindex.number"));
            indexFieldInfo.setFieldSrc("2");
            indexFieldInfo.setControlType(FieldControlType.DECIMAL.getValue());
            indexFieldInfo.setValueType(DataTypeEnum.BIGDECIMAL.getDataTypeKey());
            indexFieldInfos.add(indexFieldInfo);
        }
        return indexFieldInfos;
    }

    public Map<Long, List<String>> getPresetIndexMustInputParams(List<Long> presetIndexIds) {
        DynamicObject[] presetIndexCol = this.presetIndexHelper.query("id, getway, entryentity_param, entryentity_param.selparam, entryentity_param.isrequired, entryentity_col, entryentity_col.colnumber, entryentity_col.isrequired1", new QFilter[]{new QFilter("id", "in", presetIndexIds)});
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject presetIndexDy : presetIndexCol) {
            DynamicObjectCollection entry;
            String getWay = presetIndexDy.getString("getway");
            ArrayList mustInputParams = Lists.newArrayListWithCapacity((int)10);
            if (HRStringUtils.equals((String)getWay, (String)"10")) {
                entry = presetIndexDy.getDynamicObjectCollection("entryentity_param");
                for (DynamicObject entryDy : entry) {
                    if (!entryDy.getBoolean("isrequired")) continue;
                    mustInputParams.add(entryDy.getString("selparam.number"));
                }
            } else {
                entry = presetIndexDy.getDynamicObjectCollection("entryentity_col");
                for (DynamicObject entryDy : entry) {
                    if (!entryDy.getBoolean("isrequired1")) continue;
                    mustInputParams.add(entryDy.getString("colnumber"));
                }
            }
            result.put(presetIndexDy.getLong("id"), mustInputParams);
        }
        return result;
    }

    public List<DynamicObject> getDimMapByReportWorkId(Long workRptId) {
        DynamicObject[] dimMaps = this.dimMapHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
        ArrayList<DynamicObject> dimMapInfos = new ArrayList<DynamicObject>(dimMaps.length);
        Collections.addAll(dimMapInfos, dimMaps);
        return dimMapInfos;
    }

    public String getGetWayById(Object pkId) {
        DynamicObject presetIndex = this.getPresetIndexById(pkId);
        return presetIndex.getString("getway");
    }

    public String getCalMethodByNumber(String number) {
        DynamicObject presetIndex = this.getPresetIndexByNumber(number);
        return presetIndex.getString("calmethod");
    }

    public DynamicObject getPresetIndexByNumber(String number) {
        HRBaseServiceHelper presetIndexHelper = new HRBaseServiceHelper("hrptmc_preindex");
        QFilter[] numberFilter = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject[] dynamicObjects = presetIndexHelper.loadDynamicObjectArray(numberFilter);
        return dynamicObjects[0];
    }

    public DynamicObject getPresetIndexById(Object pkId) {
        HRBaseServiceHelper presetIndexHelper = new HRBaseServiceHelper("hrptmc_preindex");
        return presetIndexHelper.loadSingle(pkId);
    }

    public List<Object> queryServicePkList(List<Object> preIdxPkList) {
        HRBaseServiceHelper presetIndexHelper = new HRBaseServiceHelper("hrptmc_preindex");
        DynamicObject[] dynamicObjects = presetIndexHelper.queryOriginalArray("service", new QFilter[]{new QFilter("id", "in", preIdxPkList)});
        return Arrays.stream(dynamicObjects).map(dyo -> dyo.getLong("service")).distinct().collect(Collectors.toList());
    }

    public List<Object> queryAnObjPkList(List<Object> preIdxPkList) {
        HRBaseServiceHelper presetIndexHelper = new HRBaseServiceHelper("hrptmc_preindex");
        DynamicObject[] dynamicObjects = presetIndexHelper.queryOriginalArray("anobj", new QFilter[]{new QFilter("id", "in", preIdxPkList)});
        return Arrays.stream(dynamicObjects).map(dyo -> dyo.getLong("anobj")).distinct().collect(Collectors.toList());
    }
}

