/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.publish;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptmc.business.entity.AppMenuInfo;
import kd.hr.hrptmc.common.constant.publish.HRPublishConstants;

public class GenMetaDataHelper
implements HRPublishConstants {
    private static final Log log = LogFactory.getLog(GenMetaDataHelper.class);
    private static final String REGEX = "[a-z0-9_]+";
    private static final String HBSS_CLOUD = "hbss_cloud";
    private static final Pattern PATTERN = Pattern.compile("[a-z0-9_]+");

    public static Map<String, Object> createMetaAndSave(String pageNumber, String pageName, String modelType, String parentId, String bizUnitId, String bizAppId, String appId) {
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        HashMap<String, String> map = new HashMap<String, String>(16);
        LocaleString localeValue = new LocaleString("zh_CN", pageName);
        map.put("bizappid", bizAppId);
        map.put("name", (String)localeValue);
        map.put("modelType", modelType);
        map.put("id", pageNumber);
        map.put("bizunitid", bizUnitId);
        map.put("parentId", parentId);
        Map content = metaDataUtil.createBlankModel(map);
        Map entityMeta = (Map)content.get("entitymeta");
        Map formMeta = (Map)content.get("formmeta");
        String currentIsv = GenMetaDataHelper.getCurrentIsv();
        entityMeta.put("Isv", currentIsv);
        formMeta.put("Isv", currentIsv);
        content.put("isDeveloper", true);
        List items = (List)entityMeta.get("Items");
        Map dm = (Map)items.get(0);
        Map permissionDimension = (Map)dm.get("PermissionDimension");
        if (null != permissionDimension && !appId.equals("2VKJ94YEM7AU")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(appId);
            permissionDimension.put("PublishApps", SerializationUtils.toJsonString(arrayList));
        }
        Map saveResult = metaDataUtil.save(content);
        return GenMetaDataHelper.handlerResult(saveResult, content, bizAppId, bizUnitId, pageName);
    }

    private static Map<String, Object> handlerResult(Map<String, Object> saveResult, Map<String, Object> content, String bizAppId, String bizUnitId, String pageName) {
        HashMap<String, Object> message = new HashMap<String, Object>(16);
        if (saveResult.get("success") == null || ((Boolean)saveResult.get("success")).booleanValue() || saveResult.get("errors") == null) {
            String formId = (String)content.get("id");
            AppUtils.addLog((String)"bos_formmeta", (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"GenMetaDataHelper_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u7a7a\u767d\u8868\u5355", (String)"GenMetaDataHelper_1", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
            dObject.set("bizapp", (Object)bizAppId);
            dObject.set("bizunit", (Object)bizUnitId);
            dObject.set("form", (Object)formId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
            AppUtils.addLog((String)"bos_formmeta", (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"GenMetaDataHelper_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", (String)"GenMetaDataHelper_2", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            message.put("formid", formId);
            message.put("formname", pageName);
            message.put("success", Boolean.TRUE);
            message.put("message", ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"GenMetaDataHelper_3", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        } else {
            message.put("success", Boolean.FALSE);
            List errors = (List)saveResult.get("errors");
            StringBuilder sb = new StringBuilder();
            for (ErrorInfo error : errors) {
                sb.append(error.getError()).append("\r\n");
            }
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                message.put("message", ResManager.loadKDString((String)"\u521b\u5efa\u62a5\u8868\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GenMetaDataHelper_4", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            } else {
                message.put("message", sb.toString());
            }
        }
        return message;
    }

    public static Map<String, Object> createExtMetaAndSave(String extPageNumber, String extPageName, String modelType, String parentId, String bizUnitId, String bizAppId, String appId) throws KDBizException {
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("bizappid", bizAppId);
        map.put("bizunitid", bizUnitId);
        map.put("name", extPageName);
        map.put("id", extPageNumber);
        map.put("modelType", modelType);
        map.put("parentId", parentId);
        map.put("devType", "2");
        map.put("entityId", parentId);
        Map content = metaDataUtil.createBlankModel((Map)map);
        Map entityMeta = (Map)content.get("entitymeta");
        List items = (List)entityMeta.get("Items");
        Map dm = (Map)items.get(0);
        Map permissionDimension = (Map)dm.get("PermissionDimension");
        if (null != permissionDimension && !appId.equals("2VKJ94YEM7AU")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(appId);
            permissionDimension.put("PublishApps", SerializationUtils.toJsonString(arrayList));
        }
        Map saveResult = metaDataUtil.save(content);
        return GenMetaDataHelper.handlerResult(saveResult, content, bizAppId, bizUnitId, extPageName);
    }

    public static Map<String, Object> editMetadata(String metaNumber, String metaName, String appId) {
        Map<String, Object> result = new HashMap<String, Object>();
        Map lastestMetadata = MetadataDao.loadDesignerMetadata((String)GenMetaDataHelper.getMetaIdByNumber(metaNumber));
        if (lastestMetadata != null) {
            Map localeItems;
            Map entitymeta;
            Map formmeta;
            LocaleString name = new LocaleString(metaName);
            lastestMetadata.put("caption", metaName);
            Map entityTree = (Map)lastestMetadata.get("entitytree");
            if (entityTree != null) {
                entityTree.put("Name", metaName);
            }
            if ((formmeta = (Map)lastestMetadata.get("formmeta")) != null) {
                Map map;
                formmeta.put("Name", metaName);
                ArrayList items = (ArrayList)formmeta.get("Items");
                if (items != null && items.size() > 0 && (map = (Map)items.get(0)) != null && metaNumber.equals(map.get("Key"))) {
                    map.put("Name", metaName);
                }
            }
            if ((entitymeta = (Map)lastestMetadata.get("entitymeta")) != null) {
                entitymeta.put("Name", metaName);
                ArrayList items = (ArrayList)entitymeta.get("Items");
                if (items != null && items.size() > 0) {
                    Map map = (Map)items.get(0);
                    if (map != null && metaNumber.equals(map.get("Key"))) {
                        map.put("Name", metaName);
                    }
                    if (map != null && !appId.equals("2VKJ94YEM7AU")) {
                        Map permissionDimension = (Map)map.get("PermissionDimension");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(appId);
                        permissionDimension.put("PublishApps", SerializationUtils.toJsonString(arrayList));
                    }
                }
            }
            if ((localeItems = (Map)lastestMetadata.get("localeItems")) != null) {
                ArrayList entity;
                ArrayList form = (ArrayList)localeItems.get("form");
                if (form != null && form.size() > 3) {
                    Map formMetadataName = (Map)form.get(0);
                    formMetadataName.put("FormMetadata.Name", name);
                }
                if ((entity = (ArrayList)localeItems.get("entity")) != null && entity.size() > 3) {
                    Map entityMetadataName = (Map)entity.get(0);
                    entityMetadataName.put("EntityMetadata.Name", name);
                }
            }
            MetaDataUtil metaDataUtil = new MetaDataUtil();
            result = metaDataUtil.save(lastestMetadata);
        }
        return result;
    }

    public static String createAppMenuAndSave(AppMenuInfo appMenuInfo) {
        String bizAppId = appMenuInfo.getBizAppId();
        String permissionId = appMenuInfo.getPermissionId();
        String parentNodeId = appMenuInfo.getParentNodeId();
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        List appMenus = metadata.getAppMenus();
        Integer seq = appMenus.size();
        AppMenuElement appMenuElement = AppMetaServiceHelper.CreateBlankAppMenuElement();
        String menuId = String.valueOf(DBServiceHelper.genGlobalLongId());
        appMenuElement.setId(menuId);
        appMenuElement.setName(new LocaleString(appMenuInfo.getMenuName()));
        appMenuElement.setFormName(appMenuInfo.getFormName());
        appMenuElement.setFormId(appMenuInfo.getFormId());
        appMenuElement.setFormNumber(appMenuInfo.getFormNumber());
        String visible = UUID.randomUUID().toString().replace("-", "");
        String menuNumber = visible.substring(0, 10);
        appMenuElement.setNumber(menuNumber);
        appMenuElement.setDescription(new LocaleString(appMenuInfo.getDescription()));
        if (StringUtils.isBlank((CharSequence)parentNodeId)) {
            appMenuElement.setParentId(bizAppId);
        } else {
            appMenuElement.setParentId(parentNodeId);
        }
        appMenuElement.setSeq(seq.shortValue());
        appMenuElement.setVectorImage(appMenuInfo.getVectorValue());
        appMenuElement.setIconShortcut(appMenuInfo.getShortCutEntrance());
        appMenuElement.setOpenType(appMenuInfo.getOpenType());
        if (StringUtils.isNotBlank((CharSequence)permissionId)) {
            appMenuElement.setPermission(permissionId);
        } else {
            appMenuElement.setPermission(null);
        }
        appMenuElement.setVisible("true");
        appMenuElement.setParameterType(appMenuInfo.getParameterType());
        appMenuElement.setCaption(new LocaleString(appMenuInfo.getCaption()));
        appMenuElement.setParameter(appMenuInfo.getParameter());
        appMenus.add(appMenuElement);
        ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
        AppMetaServiceHelper.save((AppMetadata)metadata);
        ThreadCache.remove((Object)"AppMetaDao.querySubApp.ignoreExtApp");
        AppUtils.addLog((String)"bos_devportal_menu", (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"GenMetaDataHelper_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u83dc\u5355", (String)"GenMetaDataHelper_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        return menuId;
    }

    public static boolean editAppMenuAndSave(String bizAppId, String menuName, String formId, String formName, String menuId) {
        boolean isSuccess = false;
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        List appMenus = metadata.getAppMenus();
        for (AppMenuElement appMenu : appMenus) {
            if (!menuId.equals(appMenu.getId())) continue;
            appMenu.setName(new LocaleString(menuName));
            appMenu.setFormName(formName);
            appMenu.setFormId(formId);
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                appMenu.setFormNumber(MetadataDao.getNumberById((String)formId));
            }
            appMenu.setVisible("true");
            isSuccess = true;
            break;
        }
        if (isSuccess) {
            ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
            AppMetaServiceHelper.save((AppMetadata)metadata);
            ThreadCache.remove((Object)"AppMetaDao.querySubApp.ignoreExtApp");
            AppUtils.addLog((String)"bos_devportal_menu", (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"GenMetaDataHelper_0", (String)"hrmp-hrptmc-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u83dc\u5355", (String)"GenMetaDataHelper_5", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        return isSuccess;
    }

    public static StringBuilder validateNameAndNumber(String number, String name) {
        StringBuilder buffer = new StringBuilder();
        Matcher matcher = PATTERN.matcher(number);
        if (StringUtils.isBlank((CharSequence)number)) {
            buffer.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002\r\n", (String)"GenMetaDataHelper_6", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        } else if (number.endsWith("_devportal")) {
            buffer.append(ResManager.loadKDString((String)"\u4e3a\u4e86\u533a\u5206svn\u811a\u672c\u6587\u4ef6\u547d\u540d\uff0c\u7f16\u7801\u4e0d\u80fd\u4ee5\u201c_devportal\u201d\u7ed3\u5c3e\u3002", (String)"GenMetaDataHelper_7", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        } else if (!matcher.matches()) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002\r\n", (String)"GenMetaDataHelper_8", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        } else if (!number.startsWith("_") && !number.endsWith("_")) {
            if (number.length() > 25) {
                buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u3002", (String)"GenMetaDataHelper_9", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
            }
        } else {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002\r\n", (String)"GenMetaDataHelper_10", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        if (name == null || StringUtils.isBlank((CharSequence)name)) {
            buffer.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002\r\n", (String)"GenMetaDataHelper_11", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        }
        return buffer;
    }

    public static String getMetaIdByNumber(String metaNumber) {
        return MetadataDao.getIdByNumber((String)metaNumber, (MetaCategory)MetaCategory.Form);
    }

    public static String getCurrentIsv() {
        return ISVService.getISVInfo().getId();
    }

    public static Map<String, Object> deleteMenuById(String menuId, String bizAppId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
                AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
                if (!menuId.equalsIgnoreCase(menu.getId())) continue;
                metadata.getAppMenus().remove(menu);
                return AppMetaServiceHelper.save((AppMetadata)metadata);
            }
        }
        result.put("success", Boolean.TRUE);
        result.put("offline", Boolean.TRUE);
        result.put("message", ResManager.loadKDString((String)"\u83dc\u5355\u5df2\u4e0d\u5b58\u5728\u3002", (String)"GenMetaDataHelper_12", (String)"hrmp-hrptmc-business", (Object[])new Object[0]));
        log.error("\u83dc\u5355\u5df2\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5e94\u7528\u4e0b\u7684\u83dc\u5355\u5931\u8d25\uff0c\u53c2\u6570\u4e3amenuId\uff1a{}\uff0cbizAppId\uff1a{}", (Object)menuId, (Object)bizAppId);
        return result;
    }

    public static String createExtendApp(String bizCloudId, String bizAppId) {
        DynamicObject cloudIndustry;
        String inheritPath;
        String parentInheritPath;
        DynamicObject appObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp");
        DynamicObject extendAppObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_bizapp");
        if (appObj != null) {
            DataEntityPropertyCollection props = appObj.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : props) {
                String key = prop.getName();
                if ("isv".equals(key) || "id".equals(key) || prop instanceof DynamicLocaleProperty) continue;
                if (prop instanceof MuliLangTextProp) {
                    OrmLocaleValue localValue = (OrmLocaleValue)prop.getValue((Object)appObj);
                    String val = localValue.getLocaleValue();
                    extendAppObj.set(key, (Object)val);
                    continue;
                }
                Object val = prop.getValue((Object)appObj);
                extendAppObj.set(key, val);
            }
            parentInheritPath = appObj.getString("inheritpath");
            inheritPath = "";
            if (StringUtils.isNotBlank((CharSequence)parentInheritPath)) {
                if (parentInheritPath.startsWith(",")) {
                    parentInheritPath = parentInheritPath.substring(1, parentInheritPath.length());
                }
                inheritPath = parentInheritPath + "," + bizAppId;
            } else {
                inheritPath = bizAppId;
            }
        } else {
            return null;
        }
        extendAppObj.set("inheritpath", (Object)inheritPath);
        String number = AppReader.getAppNumberById((String)bizAppId);
        number = AppUtils.autoExtendedNumber((String)number);
        number = AppUtils.autoAppNumber((String)bizCloudId, (String)number, (String)"_ext");
        extendAppObj.set("number", (Object)number.toLowerCase());
        extendAppObj.set("type", (Object)"2");
        extendAppObj.set("parentid", (Object)bizAppId);
        parentInheritPath = bizAppId;
        if (appObj != null && StringUtils.isNotBlank((CharSequence)appObj.getString("masterid"))) {
            parentInheritPath = appObj.getString("masterid");
        }
        extendAppObj.set("masterid", (Object)parentInheritPath);
        if (StringUtils.isNotBlank((CharSequence)bizCloudId) && (cloudIndustry = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)"industry")) != null) {
            String cloudIndustryId = cloudIndustry.get("industry_id").toString();
            extendAppObj.set("industry", (Object)cloudIndustryId);
        }
        extendAppObj.set("isv", (Object)GenMetaDataHelper.getCurrentIsv());
        Object[] pks = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extendAppObj});
        if (pks != null && pks.length > 0) {
            return ((DynamicObject)pks[0]).getString("id");
        }
        return null;
    }

    public static List<String> queryHRCloudIds() {
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper(HBSS_CLOUD);
        DynamicObject[] clouds = cloudHelper.query("cloud,index", new QFilter[0], "index asc");
        return Arrays.stream(clouds).map(e -> e.getString("cloud.id")).collect(Collectors.toList());
    }

    public static DynamicObject[] queryHRClouds() {
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper(HBSS_CLOUD);
        return cloudHelper.query("cloud,cloud.name,cloud.number,index", null, "index asc");
    }
}

