/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.publish;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.ext.hr.report.field.SelectF7Ap;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.center.query.EsF7QueryService;
import kd.hr.hrptmc.business.center.utils.ReportCenterUtil;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.center.EsF7QueryParam;
import kd.hr.hrptmc.common.model.center.EsF7QueryResult;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;

public class ReportCenterPublishService {
    private static final Log LOGGER = LogFactory.getLog(ReportCenterPublishService.class);
    private static final Pattern numberPattern = Pattern.compile("^[\\d]*$");

    private static boolean isNumber(String numStr) {
        return numberPattern.matcher(numStr).matches();
    }

    public static List<Object> getIds(List<String> ids) {
        if (ids.size() > 0) {
            boolean isLong = ReportCenterPublishService.isNumber(ids.get(0));
            if (isLong) {
                return ids.stream().map(Long::parseLong).collect(Collectors.toList());
            }
            return new ArrayList<Object>(ids);
        }
        return new ArrayList<Object>(ids);
    }

    public static FieldAp getFieldApBySelectF7Ap(FilterBo filterBo) {
        SelectF7Ap selectF7Ap = new SelectF7Ap();
        selectF7Ap.setId(filterBo.getFieldAlias());
        selectF7Ap.setKey(filterBo.getFieldAlias());
        selectF7Ap.setName(filterBo.getFilterAlias());
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("22px");
        margin.setRight("30px");
        style.setMargin(margin);
        selectF7Ap.setStyle(style);
        map.put("mustInput", filterBo.getMustInput());
        map.put("fieldAlias", filterBo.getFieldAlias());
        map.put("bdFilterRange", filterBo.getBdFilterRange());
        map.put("bdDefaultValue", filterBo.getBdDefaultValue());
        map.put("filterAlias", filterBo.getFilterAlias().getLocaleValue());
        map.put("baseDataNum", filterBo.getBaseDataNum());
        map.put("baseDataEsIndexId", filterBo.getBaseDataEsIndexId());
        map.put("baseDataPermQFilter", filterBo.getBaseDataPermQFilter());
        map.put("timestamp", System.currentTimeMillis());
        if (filterBo.getBaseDataMul()) {
            map.put("mode", "multiple");
        } else {
            map.put("mode", "single");
        }
        ArrayList dataSource = new ArrayList();
        String bdDefaultValue = filterBo.getBdDefaultValue();
        List esF7QueryResultList = filterBo.getEsF7QueryResultList();
        if (!CollectionUtils.isEmpty((Collection)esF7QueryResultList)) {
            for (EsF7QueryResult esF7QueryResult : esF7QueryResultList) {
                HashMap<String, Object> objectObjectHashMap = new HashMap<String, Object>();
                objectObjectHashMap.put("id", esF7QueryResult.getId());
                objectObjectHashMap.put("number", esF7QueryResult.getNumber());
                objectObjectHashMap.put("name", esF7QueryResult.getName().getLocaleValue());
                objectObjectHashMap.put("selected", HRStringUtils.isNotEmpty((String)bdDefaultValue) && bdDefaultValue.contains(String.valueOf(esF7QueryResult.getId())));
                dataSource.add(objectObjectHashMap);
            }
        }
        map.put("dataSource", dataSource);
        selectF7Ap.setFireUpdEvt(true);
        selectF7Ap.setArgsJson(map);
        return selectF7Ap;
    }

    private static List<Long> getLongIds(String idStr) {
        String[] split = idStr.split(",");
        List<String> ids = Arrays.asList(split);
        if (ids.size() > 0) {
            return ids.stream().map(Long::parseLong).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    public static List<Map<String, Object>> getEsF7QueryResult(Map<String, Object> argMap) {
        String fieldAlias = (String)argMap.get("fieldAlias");
        String baseDataNum = (String)argMap.get("baseDataNum");
        String bdFilterRange = (String)argMap.get("bdFilterRange");
        String bdDefaultValue = (String)argMap.get("bdDefaultValue");
        String baseDataEsIndexId = (String)argMap.get("baseDataEsIndexId");
        String baseDataPermQFilter = (String)argMap.get("baseDataPermQFilter");
        String value = (String)argMap.get("value");
        String searchText = (String)argMap.get("searchText");
        QFilter qFilter = null;
        if (HRStringUtils.isNotEmpty((String)baseDataPermQFilter)) {
            qFilter = QFilter.fromSerializedString((String)baseDataPermQFilter);
        }
        EsF7QueryParam esF7QueryParam = new EsF7QueryParam(baseDataEsIndexId, searchText, baseDataNum, fieldAlias, qFilter, "0", bdDefaultValue, bdFilterRange, null);
        EsF7QueryService esF7QueryService = new EsF7QueryService();
        ArrayList<Map<String, Object>> dataSource = new ArrayList<Map<String, Object>>();
        List<EsF7QueryResult> esF7QueryResultList = esF7QueryService.queryF7Result(esF7QueryParam);
        if (!CollectionUtils.isEmpty(esF7QueryResultList)) {
            LOGGER.info("esF7QueryResultList:{}", (Object)esF7QueryResultList.size());
            for (EsF7QueryResult esF7QueryResult : esF7QueryResultList) {
                HashMap<String, Object> objectObjectHashMap = new HashMap<String, Object>();
                objectObjectHashMap.put("id", esF7QueryResult.getId());
                objectObjectHashMap.put("number", esF7QueryResult.getNumber());
                objectObjectHashMap.put("name", esF7QueryResult.getName().getLocaleValue());
                if (HRStringUtils.isNotEmpty((String)value) && value.contains(String.valueOf(esF7QueryResult.getId()))) {
                    objectObjectHashMap.put("selected", true);
                } else {
                    objectObjectHashMap.put("selected", false);
                }
                dataSource.add(objectObjectHashMap);
            }
        }
        return dataSource;
    }

    public static void setBaseDataEnum(FormShowParameter formShowParameter, List<FilterBo> filterBoList) {
        if (!ReportCenterUtil.isShareOrMySubscribeOpenReportPage(formShowParameter.getCustomParams())) {
            return;
        }
        String baseDataEsIndexId = (String)formShowParameter.getCustomParam(ReportCenterUtil.PARAM_BASE_DATA_ES_INDEX_ID);
        Object customParam = formShowParameter.getCustomParam(ReportCenterUtil.PARAM_BASE_DATA_PERM_QFTILER);
        QFilter qFilter = null;
        EsF7QueryService esF7QueryService = new EsF7QueryService();
        List collect = filterBoList.stream().filter(filterBo -> filterBo.getFilterType().equals(FilterType.BASE_DATA_ENUM.getValue())).collect(Collectors.toList());
        ArrayList esF7QueryParamList = Lists.newArrayListWithExpectedSize((int)collect.size());
        for (FilterBo filterBo2 : collect) {
            Map<String, QFilter> baseDataPermQFilter;
            if (customParam != null && !CollectionUtils.isEmpty(baseDataPermQFilter = ReportCenterUtil.getBaseDataF7PermQFilters((String)customParam))) {
                qFilter = baseDataPermQFilter.get(filterBo2.getFieldAlias());
            }
            EsF7QueryParam esF7QueryParam = new EsF7QueryParam(baseDataEsIndexId, null, filterBo2.getBaseDataNum(), filterBo2.getFieldAlias(), qFilter, "0", filterBo2.getBdDefaultValue(), filterBo2.getBdFilterRange(), null);
            esF7QueryParamList.add(esF7QueryParam);
        }
        List<Object> esF7QueryResults = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)esF7QueryParamList)) {
            esF7QueryResults = esF7QueryService.queryF7Result(esF7QueryParamList);
            LOGGER.info("esF7QueryResultList.size:{}", (Object)esF7QueryResults.size());
        }
        for (FilterBo filterBo3 : filterBoList) {
            if (!filterBo3.getFilterType().equals(FilterType.BASE_DATA_ENUM.getValue())) continue;
            List resultList = esF7QueryResults.stream().filter(esF7QueryResult -> esF7QueryResult.getBaseDataNum().equals(filterBo3.getBaseDataNum())).collect(Collectors.toList());
            LOGGER.info("resultList.size:{}", (Object)resultList.size());
            if (resultList.size() > 10000) {
                String[] split;
                String bdDefaultValue = filterBo3.getBdDefaultValue();
                String bdFilterRange = filterBo3.getBdFilterRange();
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)10);
                if (HRStringUtils.isNotEmpty((String)bdDefaultValue)) {
                    split = bdDefaultValue.split(",");
                    ids.addAll(Arrays.asList(split));
                }
                if (HRStringUtils.isNotEmpty((String)bdFilterRange)) {
                    split = bdFilterRange.split(",");
                    ids.addAll(Arrays.asList(split));
                }
                List existIds = resultList.stream().filter(esF7QueryResult -> ids.contains(String.valueOf(esF7QueryResult.getId()))).collect(Collectors.toList());
                List notExistIds = resultList.stream().filter(esF7QueryResult -> !ids.contains(String.valueOf(esF7QueryResult.getId()))).collect(Collectors.toList());
                if (existIds.size() > 10000) {
                    filterBo3.setEsF7QueryResultList(existIds);
                } else {
                    ArrayList list = new ArrayList(10000);
                    list.addAll(existIds);
                    list.addAll(notExistIds);
                    filterBo3.setEsF7QueryResultList(list.stream().limit(10000L).collect(Collectors.toList()));
                }
            } else {
                filterBo3.setEsF7QueryResultList(resultList);
            }
            filterBo3.setBaseDataEsIndexId(baseDataEsIndexId);
            if (qFilter == null) continue;
            filterBo3.setBaseDataPermQFilter(qFilter.toSerializedString());
        }
    }
}

