/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.CalculateContext;
import kd.hr.hrptmc.business.repcalculate.RepCalculateService;
import kd.hr.hrptmc.business.repcalculate.RepQueryCacheService;
import kd.hr.hrptmc.business.repcalculate.model.RepQueryConfigBo;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.utils.CacheUtils;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.common.constant.repdesign.RepQueryConfigConstants;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractReportQueryCacheService
implements RepQueryConfigConstants {
    private static final Log LOGGER = LogFactory.getLog(AbstractReportQueryCacheService.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"AbstractReportQueryCacheServiceThreadPool", (int)ZkConfig.getNumOfWorkThread());
    protected RepQueryConfigBo repQueryConfigBo;
    protected ReportCalculateInfo calculateInfo;
    protected IPageCache pageCache;
    protected static final String PAGE_CACHE_KEY = "ReportQueryCacheKey";
    protected static final String BATCH_NUMBERS_CACHE_KEY = "batchNumbers";
    protected static final String ASYNC_CACHE_KEY = "ReportAsyncQueryCacheKey";
    protected int batchCount;
    private final RepCalculateService repCalculateService;

    public AbstractReportQueryCacheService(RepQueryConfigBo repQueryConfigBo, ReportCalculateInfo calculateInfo, IPageCache pageCache) {
        this.calculateInfo = calculateInfo;
        this.repCalculateService = new RepCalculateService(calculateInfo);
        this.pageCache = pageCache;
        this.repQueryConfigBo = repQueryConfigBo;
        this.batchCount = HRStringUtils.equals((String)calculateInfo.getReportType(), (String)"0") ? repQueryConfigBo.getSumBatchCount() : repQueryConfigBo.getDetailBatchCount();
    }

    public RepCalculateService getRepCalculateService() {
        return this.repCalculateService;
    }

    protected DataSet calculateFromCache(int start, int limit) {
        List<ReportField> rowFieldList = this.calculateInfo.getRowFieldList();
        List<ReportField> columnFieldList = this.calculateInfo.getColumnFieldList();
        boolean isIncludeSubOrg = this.calculateInfo.getAdminOrgSummaryInfo() != null && this.calculateInfo.getAdminOrgSummaryInfo().getIncludeSubOrg();
        String cacheKeyPrefix = this.calculateInfo.getReportId() == null || this.calculateInfo.getReportId() == 0L ? CacheUtils.generateCacheKey(this.calculateInfo.getAnObjRelId(), this.calculateInfo.getOriginFilters(), rowFieldList, columnFieldList, isIncludeSubOrg) : CacheUtils.generateCacheKey(this.calculateInfo.getReportId(), this.calculateInfo.getOriginFilters(), rowFieldList, columnFieldList, isIncludeSubOrg);
        List<Integer> batchNumbers = this.getBatchNumbers(start, limit);
        this.pageCache.put(BATCH_NUMBERS_CACHE_KEY, SerializationUtils.toJsonString(batchNumbers));
        boolean allExist = true;
        List<String> cacheKeys = this.getCacheKeyFromPageCache();
        for (Integer batchNumber : batchNumbers) {
            String cacheKey = cacheKeyPrefix + "\u03b4" + batchNumber;
            if (cacheKeys.contains(cacheKey)) continue;
            allExist = false;
            break;
        }
        DataSet resultDataSet = null;
        if (allExist) {
            resultDataSet = this.getBatchDataSetFromCache(start, limit, cacheKeyPrefix, batchNumbers);
            if ((start + limit) % this.batchCount >= this.batchCount / 2) {
                int nextStart = start + 3 * limit;
                List<Integer> nextBatchNumbers = this.getBatchNumbers(nextStart, limit);
                ArrayList queryBatchNumbers = Lists.newArrayListWithExpectedSize((int)nextBatchNumbers.size());
                for (Integer nextBatchNumber : nextBatchNumbers) {
                    String cacheKey = cacheKeyPrefix + "\u03b4" + nextBatchNumber;
                    if (cacheKeys.contains(cacheKey)) continue;
                    queryBatchNumbers.add(nextBatchNumber);
                }
                if (!queryBatchNumbers.isEmpty()) {
                    this.asynchronousUpdateCache(nextStart, cacheKeyPrefix, nextBatchNumbers);
                }
            }
        } else if (limit < this.batchCount) {
            resultDataSet = this.repCalculateService.calculate(start, limit);
            this.asynchronousUpdateCache(start, cacheKeyPrefix, batchNumbers);
        } else {
            resultDataSet = this.getBatchDataSetFromCache(start, limit, cacheKeyPrefix, batchNumbers);
        }
        return resultDataSet;
    }

    private void asynchronousUpdateCache(int start, String cacheKeyPrefix, List<Integer> batchNumbers) {
        String mainThreadTraceId = TraceIdUtil.getCurrentTraceIdString();
        THREAD_POOL.execute(() -> {
            int currentStart = start;
            for (Integer batchNumber : batchNumbers) {
                int batchStart = currentStart;
                String cacheKey = cacheKeyPrefix + "\u03b4" + batchNumber;
                THREAD_POOL.execute(() -> {
                    if (this.addAsyncCacheKeyToPageCache(cacheKey)) {
                        try {
                            this.setUpdatePartitionCache();
                            LOGGER.info("start_asynchronousUpdateCache_mainTraceId={},traceId={},cacheKeyPrefix={},batchNumber={}", new Object[]{mainThreadTraceId, TraceIdUtil.getCurrentTraceIdString(), cacheKeyPrefix, batchNumber});
                            this.getDatasetFromCache(cacheKey, batchStart);
                            this.removeAsyncCacheKeyToPageCache(cacheKey);
                            LOGGER.info("end_asynchronousUpdateCache_mainTraceId={},traceId={},cacheKeyPrefix={},batchNumber={}", new Object[]{mainThreadTraceId, TraceIdUtil.getCurrentTraceIdString(), cacheKeyPrefix, batchNumber});
                        }
                        catch (Exception e) {
                            LOGGER.error("async_getDatasetFromCache_error_cacheKey_{}_error_{}", (Object)cacheKey, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                        }
                    }
                });
                currentStart += this.batchCount;
            }
        });
    }

    private void setUpdatePartitionCache() {
        ReportCalculateInfo calculateInfo = this.repCalculateService.getCalculateInfo();
        calculateInfo.setUpdateCachePartition(true);
    }

    private DataSet getBatchDataSetFromCache(int start, int limit, String cacheKeyPrefix, List<Integer> batchNumbers) {
        DataSet resultDataSet = null;
        int currentStart = start;
        int resultDataSetCount = 0;
        ArrayList resultFutures = Lists.newArrayListWithExpectedSize((int)batchNumbers.size());
        for (Integer batchNumber : batchNumbers) {
            int batchStart = currentStart;
            resultFutures.add(THREAD_POOL.submit(() -> {
                String cacheKey = cacheKeyPrefix + "\u03b4" + batchNumber;
                CachedDataSet cachedDataSet = null;
                if (this.addAsyncCacheKeyToPageCache(cacheKey)) {
                    cachedDataSet = this.getDatasetFromCache(cacheKey, batchStart);
                    this.removeAsyncCacheKeyToPageCache(cacheKey);
                } else {
                    boolean run = true;
                    while (run) {
                        if (this.addAsyncCacheKeyToPageCache(cacheKey)) {
                            cachedDataSet = this.getDatasetFromCache(cacheKey, batchStart);
                            this.removeAsyncCacheKeyToPageCache(cacheKey);
                            run = false;
                            continue;
                        }
                        Thread.sleep(1000L);
                    }
                }
                return cachedDataSet;
            }));
            currentStart += this.batchCount;
        }
        int lastCount = ((batchNumbers.get(0) == 0 ? 0 : batchNumbers.get(0)) - 1) * this.batchCount;
        for (int index = 0; index < resultFutures.size(); ++index) {
            Integer batchNumber = batchNumbers.get(index);
            String cacheKey = cacheKeyPrefix + "\u03b4" + batchNumber;
            try {
                Future dataSetFuture = (Future)resultFutures.get(index);
                CachedDataSet cachedDataSet = (CachedDataSet)dataSetFuture.get();
                if (cachedDataSet == null) continue;
                int cachedRowCount = cachedDataSet.getRowCount();
                LOGGER.info("ReportQueryCache#cacheCount: {}, cacheKey: {}", (Object)cachedRowCount, (Object)cacheKey);
                Algo algo = Algo.create((String)"kd.hr.hrptmc.business.repcalculate.AbstractReportQueryCacheService");
                DataSet datasetFromCache = cachedDataSet.toDataSet(algo, false);
                resultDataSet = resultDataSet == null ? datasetFromCache : resultDataSet.union(datasetFromCache);
                if ((resultDataSetCount += cachedRowCount) > limit) {
                    resultDataSet = resultDataSet.range(start - lastCount, limit);
                }
                if (cachedRowCount >= this.batchCount) continue;
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("getDataSetFromCacheError_cacheKey_{}_error_{}", (Object)cacheKey, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return resultDataSet;
    }

    public static void clearCache(IPageCache pageCache) {
        AbstractReportQueryCacheService.removeAllAsyncCacheKeyToPageCache(pageCache);
        String cacheKeyStr = pageCache.get(PAGE_CACHE_KEY);
        if (HRStringUtils.isNotEmpty((String)cacheKeyStr)) {
            List cacheKeyList = (List)SerializationUtils.fromJsonString((String)cacheKeyStr, List.class);
            cacheKeyList.forEach(Algo::removeCacheDataSet);
        }
        pageCache.remove(PAGE_CACHE_KEY);
    }

    protected void removeDatasetFromCache(String cacheKey) {
        Algo.removeCacheDataSet((String)cacheKey);
    }

    protected CachedDataSet putDatasetToCache(String cacheKey, DataSet dataSet) {
        try (DLock lock = DLock.create((String)ASYNC_CACHE_KEY);){
            lock.lock();
            List<String> allAsyncKeys = this.getAsyncCacheKeyFromPageCache();
            if (allAsyncKeys.contains(cacheKey)) {
                CacheHint hint = new CacheHint();
                hint.setCacheId(cacheKey);
                hint.setTimeout(this.repQueryConfigBo.getCacheTimeout());
                CachedDataSet cachedDataSet = dataSet.cache(hint);
                return cachedDataSet;
            }
            CachedDataSet cachedDataSet = null;
            return cachedDataSet;
        }
    }

    protected CachedDataSet getDatasetFromCache(String cacheKey, int start) {
        CachedDataSet cachedDataSet = null;
        try {
            cachedDataSet = Algo.getCacheDataSet((String)cacheKey);
        }
        catch (AlgoException exception) {
            LOGGER.info("ReportQueryCache#CacheMiss cacheKey: {}, message: {}", (Object)cacheKey, (Object)exception.getMessage());
        }
        if (cachedDataSet != null) {
            this.handleCacheKey(cacheKey);
        } else {
            int batchStart = start / this.batchCount * this.batchCount;
            LOGGER.info("ReportQueryCache#queryDataSet start: {}, limit: {}, cacheKey: {}", new Object[]{batchStart, this.batchCount, cacheKey});
            DataSet queryDataSet = this.repCalculateService.calculate(batchStart, this.batchCount);
            int count = 0;
            DataSet copy = queryDataSet.copy();
            for (Row row : copy) {
                ++count;
            }
            copy.close();
            LOGGER.info("ReportQueryCache#queryDataSet count: {}", (Object)count);
            cachedDataSet = this.putDatasetToCache(cacheKey, queryDataSet);
            if (cachedDataSet != null) {
                this.handleCacheKey(cacheKey);
            }
        }
        CalculateContext globalContext = this.repCalculateService.getGlobalContext();
        if (globalContext != null) {
            HRComplexObjContext complexObjContext = globalContext.getComplexObjContext();
            RepQueryCacheService.setEsPageCache(this.pageCache, complexObjContext.getObjSortValueMap(), complexObjContext.getAfterKeyMap());
        }
        return cachedDataSet;
    }

    private List<Integer> getBatchNumbers(int start, int limit) {
        ArrayList batchNumbers = Lists.newArrayListWithCapacity((int)10);
        int batchStart = start / this.batchCount + 1;
        int batchEnd = (start + limit - 1) / this.batchCount + 1;
        int n = batchEnd = batchEnd == 0 ? 1 : batchEnd;
        if (batchStart <= batchEnd) {
            for (int i = batchStart; i <= batchEnd; ++i) {
                batchNumbers.add(i);
            }
        }
        return batchNumbers;
    }

    private List<String> getCacheKeyFromPageCache() {
        List cacheKeys = Lists.newArrayListWithCapacity((int)10);
        String cacheKeyStr = this.pageCache.get(PAGE_CACHE_KEY);
        if (HRStringUtils.isNotEmpty((String)cacheKeyStr)) {
            cacheKeys = (List)SerializationUtils.fromJsonString((String)cacheKeyStr, List.class);
        }
        return cacheKeys;
    }

    private List<String> getAsyncCacheKeyFromPageCache() {
        List cacheKeys = Lists.newArrayListWithCapacity((int)10);
        String cacheKeyStr = new PageCache(this.pageCache.getPageId()).get(ASYNC_CACHE_KEY);
        if (HRStringUtils.isNotEmpty((String)cacheKeyStr)) {
            cacheKeys = (List)SerializationUtils.fromJsonString((String)cacheKeyStr, List.class);
        }
        return cacheKeys;
    }

    private void handleCacheKey(String cacheKey) {
        try (DLock lock = DLock.create((String)PAGE_CACHE_KEY);){
            String removeCacheKey;
            lock.lock();
            List<String> cacheKeys = this.getCacheKeyFromPageCache();
            if (cacheKeys.contains(cacheKey)) {
                return;
            }
            if (cacheKeys.size() >= this.repQueryConfigBo.getCacheBatch() && (removeCacheKey = this.removeFirstCacheKey(cacheKeys)) != null) {
                CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheKey);
                Algo algo = Algo.create((String)"kd.hr.hrptmc.business.repcalculate.AbstractReportQueryCacheService");
                DataSet datasetFromCache = cacheDataSet.toDataSet(algo, false);
                datasetFromCache.copy();
                this.removeDatasetFromCache(removeCacheKey);
            }
            cacheKeys.add(cacheKey);
            this.addCacheKeyToPageCache(cacheKeys);
        }
    }

    private String removeFirstCacheKey(List<String> cacheKeys) {
        int batchNum;
        int removeIndex;
        String batchNumberStr = this.pageCache.get(BATCH_NUMBERS_CACHE_KEY);
        if (HRStringUtils.isEmpty((String)batchNumberStr)) {
            return cacheKeys.get(0);
        }
        List batchNumbers = (List)SerializationUtils.fromJsonString((String)batchNumberStr, List.class);
        for (removeIndex = 0; removeIndex < cacheKeys.size() && batchNumbers.contains(batchNum = Integer.parseInt(cacheKeys.get(removeIndex).split("\u03b4")[1])); ++removeIndex) {
        }
        if (removeIndex < cacheKeys.size()) {
            return cacheKeys.remove(removeIndex);
        }
        return null;
    }

    private void addCacheKeyToPageCache(List<String> cacheKeys) {
        this.pageCache.put(PAGE_CACHE_KEY, SerializationUtils.toJsonString(cacheKeys));
        this.pageCache.saveChanges();
    }

    private boolean addAsyncCacheKeyToPageCache(String cacheKey) {
        boolean addSuccess = true;
        try (DLock lock = DLock.create((String)ASYNC_CACHE_KEY);){
            lock.lock();
            List<String> cacheKeys = this.getAsyncCacheKeyFromPageCache();
            if (!cacheKeys.contains(cacheKey)) {
                cacheKeys.add(cacheKey);
            } else {
                addSuccess = false;
            }
            this.pageCache.put(ASYNC_CACHE_KEY, SerializationUtils.toJsonString(cacheKeys));
            this.pageCache.saveChanges();
        }
        return addSuccess;
    }

    private void removeAsyncCacheKeyToPageCache(String cacheKey) {
        try (DLock lock = DLock.create((String)ASYNC_CACHE_KEY);){
            lock.lock();
            List<String> cacheKeys = this.getAsyncCacheKeyFromPageCache();
            cacheKeys.remove(cacheKey);
            this.pageCache.put(ASYNC_CACHE_KEY, SerializationUtils.toJsonString(cacheKeys));
            this.pageCache.saveChanges();
        }
    }

    private static void removeAllAsyncCacheKeyToPageCache(IPageCache pageCache) {
        try (DLock lock = DLock.create((String)ASYNC_CACHE_KEY);){
            lock.lock();
            pageCache.remove(ASYNC_CACHE_KEY);
            pageCache.saveChanges();
        }
    }
}

