/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class DataSetAliasHelper {
    private LinkedHashMap<String, String> aliasMap;
    private BiMap<String, String> inverse;
    private DataSet dataSet;

    public DataSetAliasHelper(DataSet dataSet, LinkedHashMap<String, String> aliasMap) {
        this.dataSet = dataSet;
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        List<String> allFieldList = Arrays.asList(fieldNames);
        this.aliasMap = new LinkedHashMap(aliasMap.size());
        for (Map.Entry<String, String> entry : aliasMap.entrySet()) {
            if (!allFieldList.contains(entry.getKey())) continue;
            this.aliasMap.put(entry.getKey(), entry.getValue());
        }
        HashBiMap hashBiMap = HashBiMap.create(this.aliasMap);
        this.inverse = hashBiMap.inverse();
    }

    public DataSet trans() {
        DataSet reduceDataSet = this.dataSet.reduceGroup((ReduceGroupFunction)new AliasReplaceFunction());
        String[] fieldNames = this.aliasMap.values().toArray(new String[0]);
        return reduceDataSet.select(fieldNames);
    }

    private class AliasReplaceFunction
    extends ReduceGroupFunction {
        private static final long serialVersionUID = 6325494249894469089L;

        private AliasReplaceFunction() {
        }

        public Iterator<Object[]> reduce(Iterator<Row> iterator) {
            RowMeta resultRowMeta = this.getResultRowMeta();
            ArrayList<Object[]> arrays = new ArrayList<Object[]>();
            while (iterator.hasNext()) {
                Row row = iterator.next();
                Object[] objects = new Object[resultRowMeta.getFieldCount()];
                for (int i = 0; i < resultRowMeta.getFieldNames().length; ++i) {
                    Field field = resultRowMeta.getField(i);
                    objects[i] = row.get((String)DataSetAliasHelper.this.inverse.get((Object)field.getName()));
                }
                arrays.add(objects);
            }
            return arrays.iterator();
        }

        public RowMeta getResultRowMeta() {
            RowMeta rowMeta = DataSetAliasHelper.this.dataSet.getRowMeta();
            Field[] rstFields = new Field[rowMeta.getFieldCount()];
            String[] fieldNames = rowMeta.getFieldNames();
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                DataType dataType = rowMeta.getField(fieldName).getDataType();
                rstFields[i] = new Field((String)DataSetAliasHelper.this.aliasMap.get(fieldName), dataType);
            }
            return new RowMeta(rstFields);
        }
    }
}

