/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.formula.excel.Expr;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.RptLRUCache;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.service.complexobj.util.ReportFunctionExecuteByCache;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hr.hrptmc.business.common.DataSetTransUtil;
import kd.hr.hrptmc.business.repcalculate.ReportCalculateHandler;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class NonAggregateIndexHandler
extends ReportCalculateHandler {
    private final Map<String, ReportField> reportFieldMap;
    private final RptLRUCache<String, Object> lruCache = new RptLRUCache(1000);
    private final ReportFunctionExecuteByCache reportFunctionExecuteByCache;
    private final HRComplexObjContext context;

    public NonAggregateIndexHandler(ReportCalculateInfo calculateInfo, HRComplexObjContext context) {
        super(calculateInfo);
        this.reportFieldMap = calculateInfo.getRowFieldList().stream().collect(Collectors.toMap(field -> HRStringUtils.isNotEmpty((String)field.getUniqueKey()) ? field.getUniqueKey() : field.getFieldAlias(), field -> field, (x, y) -> y));
        Map<String, TimeZoneInfo> timeZoneInfoMap = calculateInfo.getRowFieldList().stream().filter(field -> field instanceof EntityPropField && ((EntityPropField)field).getTimeZoneInfo() != null).collect(Collectors.toMap(ReportField::getFieldAlias, field -> ((EntityPropField)field).getTimeZoneInfo(), (k1, k2) -> k1));
        timeZoneInfoMap.putAll(calculateInfo.getColumnFieldList().stream().filter(field -> field instanceof EntityPropField && ((EntityPropField)field).getTimeZoneInfo() != null).collect(Collectors.toMap(ReportField::getFieldAlias, field -> ((EntityPropField)field).getTimeZoneInfo(), (k1, k2) -> k1)));
        this.reportFunctionExecuteByCache = new ReportFunctionExecuteByCache(context, timeZoneInfoMap);
        this.context = context;
    }

    @Override
    public DataSet doHandler(DataSet dataSet) {
        this.calculateInfo.getCostTimeHelper().nestedStart();
        List<NonAggregateIndexField> nonAggregateIndexFieldList = this.calculateInfo.getRowFieldListWithoutDp(true).stream().filter(reportField -> reportField instanceof NonAggregateIndexField).map(obj -> (NonAggregateIndexField)obj).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(nonAggregateIndexFieldList)) {
            boolean transToListCal = false;
            if (nonAggregateIndexFieldList.size() > 1) {
                List indexFieldList = nonAggregateIndexFieldList.stream().map(ReportField::getFieldAlias).collect(Collectors.toList());
                transToListCal = nonAggregateIndexFieldList.stream().anyMatch(nonAggregateIndexField -> nonAggregateIndexField.getDependentFieldSet().stream().anyMatch(indexFieldList::contains));
            }
            dataSet = transToListCal ? this.aggregateIndexByList(dataSet, nonAggregateIndexFieldList) : dataSet.map((MapFunction)new NonAggregateIndexMap(nonAggregateIndexFieldList, dataSet.getRowMeta(), this.reportFunctionExecuteByCache));
        }
        this.calculateInfo.getCostTimeHelper().logCost("NonAggregateIndexHandler_doHandler", "NonAggregateIndexHandler_doHandler");
        return this.doNext(dataSet);
    }

    private DataSet aggregateIndexByList(DataSet dataSet, List<NonAggregateIndexField> nonAggregateIndexFieldList) {
        ArrayList<Field> queryFieldList = new ArrayList<Field>(Arrays.asList(dataSet.getRowMeta().getFields()));
        List<Map<String, Object>> dataList = DataSetTransUtil.dataSetToList(dataSet);
        for (NonAggregateIndexField nonAggregateIndexField : nonAggregateIndexFieldList) {
            String formula = nonAggregateIndexField.getCalcFormulaInfo();
            String alias = nonAggregateIndexField.getFieldAlias();
            Expr expr = ReportFunctionExecuteService.getInstance().parseExpr(formula);
            Set<String> refFieldAliasSet = nonAggregateIndexField.getDependentFieldSet();
            for (Map<String, Object> dataMap : dataList) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                for (String key : refFieldAliasSet) {
                    ReportField field = this.reportFieldMap.get(key);
                    String dataKey = field instanceof AggregateIndexField ? key + "\u03b1" + ((AggregateIndexField)field).getCalcFunction() : (field instanceof EntityPrimitiveIndexField ? key + "\u03b1" + ((EntityPrimitiveIndexField)field).getCalcFunction() : key);
                    Object value = dataMap.get(dataKey);
                    paramMap.putIfAbsent(key, value);
                }
                Object val = this.reportFunctionExecuteByCache.getFormulaVal(this.lruCache, formula, expr, paramMap);
                val = QueryEntityUtil.convertDataValueType((DataTypeEnum)DataTypeEnum.of((String)nonAggregateIndexField.getFieldType()), (Object)val, null, (HRComplexObjContext)this.context);
                dataMap.put(alias, val);
            }
        }
        for (NonAggregateIndexField nonAggregateIndexField : nonAggregateIndexFieldList) {
            Field field = new Field(nonAggregateIndexField.getUniqueKey(), AlgoDataTypeTransUtil.getDataType((String)nonAggregateIndexField.getFieldType()));
            queryFieldList.add(field);
        }
        return DataSetTransUtil.listToDataset(dataList, queryFieldList);
    }

    private static class NonAggregateIndexMap
    extends MapFunction {
        private static final long serialVersionUID = -2482848028357790158L;
        private List<NonAggregateIndexField> nonAggregateIndexFieldList;
        private Map<String, Expr> exprCache = new HashMap<String, Expr>(16);
        private final RptLRUCache<String, Object> lruCache = new RptLRUCache(1000);
        private final ReportFunctionExecuteByCache reportFunctionExecuteByCache;
        private RowMeta resultRowMeta;
        private RowMeta sourceRowMeta;

        public NonAggregateIndexMap(List<NonAggregateIndexField> nonAggregateIndexFieldList, RowMeta sourceRowMeta, ReportFunctionExecuteByCache reportFunctionExecuteByCache) {
            this.nonAggregateIndexFieldList = nonAggregateIndexFieldList;
            this.sourceRowMeta = sourceRowMeta;
            this.resultRowMeta = this.getResultRowMeta();
            this.reportFunctionExecuteByCache = reportFunctionExecuteByCache;
        }

        public Object[] map(Row row) {
            Object[] newRow = new Object[this.resultRowMeta.getFieldCount()];
            Field[] sourceFields = this.sourceRowMeta.getFields();
            for (int i = 0; i < sourceFields.length; ++i) {
                newRow[i] = row.get(sourceFields[i].getAlias());
            }
            Set existsKey = Arrays.stream(sourceFields).map(Field::getAlias).collect(Collectors.toSet());
            for (int i = sourceFields.length; i < newRow.length; ++i) {
                NonAggregateIndexField nonAggregateIndexField = this.nonAggregateIndexFieldList.get(i - sourceFields.length);
                String calcFormula = nonAggregateIndexField.getCalcFormulaInfo();
                Expr expr = this.getExpr(calcFormula);
                Set<String> refFieldAliasSet = nonAggregateIndexField.getDependentFieldSet();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                for (String key : refFieldAliasSet) {
                    String avgKey = this.genGroupByCalFieldAlias(key, "avg");
                    String sumKey = this.genGroupByCalFieldAlias(key, "sum");
                    String countKey = this.genGroupByCalFieldAlias(key, "count");
                    String idxKey = null;
                    if (existsKey.contains(countKey)) {
                        idxKey = countKey;
                    } else if (existsKey.contains(avgKey)) {
                        idxKey = avgKey;
                    } else if (existsKey.contains(sumKey)) {
                        idxKey = sumKey;
                    } else if (existsKey.contains(key)) {
                        idxKey = key;
                    }
                    if (HRStringUtils.isEmpty((String)idxKey)) {
                        paramMap.putIfAbsent(key, null);
                        continue;
                    }
                    paramMap.putIfAbsent(key, row.get(idxKey));
                }
                newRow[i] = this.reportFunctionExecuteByCache.getFormulaVal(this.lruCache, calcFormula, expr, paramMap);
            }
            return newRow;
        }

        private String genGroupByCalFieldAlias(String fieldAlias, String calFunction) {
            return fieldAlias + "\u03b1" + calFunction;
        }

        private Expr getExpr(String formula) {
            Expr expr = this.exprCache.get(formula);
            if (expr == null) {
                expr = ReportFunctionExecuteService.getInstance().parseExpr(formula);
                this.exprCache.put(formula, expr);
            }
            return expr;
        }

        public final RowMeta getResultRowMeta() {
            Field[] sourceFields = this.sourceRowMeta.getFields();
            Field[] resultFields = Arrays.copyOf(sourceFields, sourceFields.length + this.nonAggregateIndexFieldList.size());
            for (int i = sourceFields.length; i < resultFields.length; ++i) {
                Field field;
                NonAggregateIndexField nonAggregateIndexField = this.nonAggregateIndexFieldList.get(i - sourceFields.length);
                String alias = nonAggregateIndexField.getUniqueKey();
                resultFields[i] = field = new Field(alias, AlgoDataTypeTransUtil.getDataType((String)nonAggregateIndexField.getFieldType()));
            }
            return new RowMeta(resultFields);
        }
    }
}

