/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.preindex.IPresetIndexCallHandler;
import kd.hr.hrptmc.business.preindex.PresetIndexCallAnObjHandler;
import kd.hr.hrptmc.business.preindex.PresetIndexCallHandlerFactory;
import kd.hr.hrptmc.business.preindex.PresetIndexCallServiceHandler;
import kd.hr.hrptmc.business.preindex.model.PresetIndexServiceParam;
import kd.hr.hrptmc.business.repcalculate.ReportCalculateHandler;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.AnalysisObjectPresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.BizServicePresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class PresetIndexHandler
extends ReportCalculateHandler {
    private static final Log LOGGER = LogFactory.getLog(PresetIndexHandler.class);
    private static final ThreadPool threadPool = ThreadPools.getOrCreateFixedThreadPool((String)"PresetIndexHandlerPool", (int)2);
    List<PresetIndexField> presetIndexFieldList = Lists.newArrayListWithExpectedSize((int)10);
    private final boolean isAlgoX;

    public PresetIndexHandler(ReportCalculateInfo calculateInfo, boolean isAlgoX) {
        super(calculateInfo);
        this.isAlgoX = isAlgoX;
    }

    @Override
    public DataSet doHandler(DataSet dataSet) {
        long startTime = System.currentTimeMillis();
        List<ReportField> indexFields = this.calculateInfo.getRowFieldListWithoutDp(true).stream().filter(field -> field instanceof PresetIndexField).collect(Collectors.toList());
        if (indexFields.isEmpty()) {
            return this.doNext(dataSet);
        }
        HashMap rowIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList selectedFields = Lists.newArrayListWithCapacity((int)10);
        Map<String, List<Object>> resultMap = this.handlePreIndex(dataSet, indexFields, selectedFields, rowIndexMap);
        dataSet = dataSet.map((MapFunction)new PresetIndexMap(this.presetIndexFieldList, resultMap, selectedFields, rowIndexMap, dataSet.getRowMeta(), this.isAlgoX));
        LOGGER.info("[repcalculate] PresetIndexHandler doHandler costTime:{}", (Object)(System.currentTimeMillis() - startTime));
        return this.doNext(dataSet);
    }

    private List<Object[]> buildDataList(DataSet dataSet, List<String> selectedFields, Map<String, Integer> rowIndexMap) {
        ArrayList dataList = Lists.newArrayListWithCapacity((int)10);
        List rowFields = this.calculateInfo.getRowFieldListWithoutDp(true).stream().filter(this::fieldIsDimension).collect(Collectors.toList());
        selectedFields.addAll(rowFields.stream().map(field -> {
            if (this.isAlgoX) {
                return AlgoXFieldInfo.replaceAlgoxAlias((String)field.getFieldAlias());
            }
            return field.getFieldAlias();
        }).collect(Collectors.toList()));
        selectedFields.addAll(this.calculateInfo.getColumnFieldList().stream().map(field -> {
            if (this.isAlgoX) {
                return AlgoXFieldInfo.replaceAlgoxAlias((String)field.getFieldAlias());
            }
            return field.getFieldAlias();
        }).collect(Collectors.toList()));
        int rowIndex = 0;
        DataSet copyDataset = dataSet.copy();
        for (Row row : copyDataset) {
            Object data;
            String fieldAlias;
            Object[] rowData = new Object[rowFields.size() + this.calculateInfo.getColumnFieldList().size()];
            int i = 0;
            for (ReportField field2 : rowFields) {
                fieldAlias = field2.getFieldAlias();
                if (this.isAlgoX) {
                    fieldAlias = AlgoXFieldInfo.replaceAlgoxAlias((String)fieldAlias);
                }
                rowData[i] = data = row.get(fieldAlias);
                ++i;
            }
            for (ReportField field2 : this.calculateInfo.getColumnFieldList()) {
                fieldAlias = field2.getFieldAlias();
                if (this.isAlgoX) {
                    fieldAlias = AlgoXFieldInfo.replaceAlgoxAlias((String)fieldAlias);
                }
                rowData[i] = data = row.get(fieldAlias);
                ++i;
            }
            dataList.add(rowData);
            String latitudeFieldValue = selectedFields.stream().map(arg_0 -> ((Row)row).getString(arg_0)).collect(Collectors.joining("_"));
            rowIndexMap.put(latitudeFieldValue, rowIndex++);
        }
        return dataList;
    }

    private PresetIndexServiceParam buildServiceParam(List<Object[]> dataList) {
        PresetIndexServiceParam serviceParam = new PresetIndexServiceParam();
        serviceParam.setRowList(this.calculateInfo.getRowFieldListWithoutDp(true).stream().filter(this::fieldIsDimension).map(HRObjectUtils::clone).collect(Collectors.toList()));
        serviceParam.setColumnList(this.calculateInfo.getColumnFieldList().stream().map(HRObjectUtils::clone).collect(Collectors.toList()));
        serviceParam.setValueList(dataList);
        if (this.calculateInfo.getAdminOrgSummaryInfo() != null) {
            serviceParam.setAdminOrgSummaryInfo((AdminOrgSummaryInfo)HRObjectUtils.clone((Object)this.calculateInfo.getAdminOrgSummaryInfo()));
        }
        serviceParam.setParamList(this.calculateInfo.getPresetIndexQFilters());
        serviceParam.setJoinOnQFilters(this.calculateInfo.getJoinQFilterList());
        serviceParam.setAnObjId(this.calculateInfo.getAnObjRelId());
        this.reverseMappingStoreFields(serviceParam);
        return serviceParam;
    }

    private void reverseMappingStoreFields(PresetIndexServiceParam serviceParam) {
        RptMetaFieldMap rptMetaFieldMap;
        String fieldAlias;
        if (this.calculateInfo.getStoreFieldMapList() == null || this.calculateInfo.getStoreFieldMapList().isEmpty()) {
            return;
        }
        List<RptMetaFieldMap> storeFieldMapList = this.calculateInfo.getStoreFieldMapList();
        Map fieldMap = storeFieldMapList.stream().collect(Collectors.toMap(RptMetaFieldMap::getMetaFieldNumber, Function.identity(), (k1, k2) -> k1));
        for (ReportField reportField : serviceParam.getRowList()) {
            fieldAlias = reportField.getFieldAlias();
            rptMetaFieldMap = (RptMetaFieldMap)fieldMap.get(fieldAlias);
            if (rptMetaFieldMap == null) continue;
            reportField.setFieldAlias(rptMetaFieldMap.getFieldAlias());
            ((LatitudeField)reportField).setPropName(rptMetaFieldMap.getFieldAlias());
            ((LatitudeField)reportField).setPropFullPath(rptMetaFieldMap.getFieldAlias());
        }
        for (ReportField reportField : serviceParam.getColumnList()) {
            fieldAlias = reportField.getFieldAlias();
            rptMetaFieldMap = (RptMetaFieldMap)fieldMap.get(fieldAlias);
            if (rptMetaFieldMap == null) continue;
            reportField.setFieldAlias(rptMetaFieldMap.getFieldAlias());
            ((LatitudeField)reportField).setPropName(rptMetaFieldMap.getFieldAlias());
            ((LatitudeField)reportField).setPropFullPath(rptMetaFieldMap.getFieldAlias());
        }
        AdminOrgSummaryInfo adminOrgSummaryInfo = serviceParam.getAdminOrgSummaryInfo();
        if (adminOrgSummaryInfo != null) {
            RptMetaFieldMap rptMetaFieldMap2 = (RptMetaFieldMap)fieldMap.get(adminOrgSummaryInfo.getAdminOrgSelectField());
            if (rptMetaFieldMap2 == null) {
                return;
            }
            String idField = adminOrgSummaryInfo.getAdminOrgFieldAlias().substring(0, adminOrgSummaryInfo.getAdminOrgFieldAlias().lastIndexOf(".")) + ".id";
            rptMetaFieldMap2 = (RptMetaFieldMap)fieldMap.get(idField);
            String idNum = rptMetaFieldMap2.getFieldAlias().substring(0, rptMetaFieldMap2.getFieldAlias().lastIndexOf("."));
            adminOrgSummaryInfo.setAdminOrgFieldFullPath(idNum + ".id");
            String newNum = idNum + adminOrgSummaryInfo.getAdminOrgFieldAlias().substring(adminOrgSummaryInfo.getAdminOrgFieldAlias().lastIndexOf("."));
            adminOrgSummaryInfo.setAdminOrgFieldAlias(newNum);
        }
    }

    private boolean fieldIsDimension(ReportField field) {
        return field instanceof LatitudeField || field instanceof AggregateIndexField && ((AggregateIndexField)field).isLatitudeField();
    }

    private Map<String, List<Object>> handlePreIndex(DataSet dataSet, List<ReportField> indexFields, List<String> selectedFields, Map<String, Integer> rowIndexMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)indexFields.size());
        List<Object[]> dataList = this.buildDataList(dataSet, selectedFields, rowIndexMap);
        String traceId = RequestContext.get().getTraceId();
        CountDownLatch countDownLatch = new CountDownLatch(indexFields.size());
        try {
            for (ReportField indexField : indexFields) {
                this.presetIndexFieldList.add((PresetIndexField)indexField);
                if (indexField instanceof BizServicePresetIndexField) {
                    threadPool.execute(() -> {
                        try {
                            PresetIndexServiceParam serviceParam = this.buildServiceParam(dataList);
                            serviceParam.setTraceId(traceId);
                            List<Object> result = this.callService((BizServicePresetIndexField)indexField, serviceParam);
                            String uniqueKey = indexField.getUniqueKey();
                            if (this.isAlgoX) {
                                uniqueKey = uniqueKey.replace("\u03b4", "_UNI_CODE_SPLIT_");
                            }
                            resultMap.put(uniqueKey, result);
                        }
                        catch (Exception ex) {
                            LOGGER.error("BizServicePresetIndexField_error", (Throwable)ex);
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    });
                    continue;
                }
                threadPool.execute(() -> {
                    try {
                        PresetIndexServiceParam serviceParam = this.buildServiceParam(dataList);
                        List<Object> result = this.callAnalyseObject((AnalysisObjectPresetIndexField)indexField, serviceParam);
                        String uniqueKey = indexField.getUniqueKey();
                        if (this.isAlgoX) {
                            uniqueKey = uniqueKey.replace("\u03b4", "_UNI_CODE_SPLIT_");
                        }
                        resultMap.put(uniqueKey, result);
                    }
                    catch (Exception ex) {
                        LOGGER.error("AnalysisObjectPresetIndexField_error", (Throwable)ex);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            countDownLatch.await();
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("500", "PresetIndex handle error."), new Object[0]);
        }
        return resultMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<Object> callService(BizServicePresetIndexField presetIndexField, PresetIndexServiceParam serviceParam) {
        serviceParam.setPresetIndexNumber(presetIndexField.getPresetIndexInfo());
        serviceParam.setDimMap(presetIndexField.getDimMap());
        IPresetIndexCallHandler rptMetadataHandler = PresetIndexCallHandlerFactory.getRptMetadataHandler(PresetIndexCallServiceHandler.class);
        return rptMetadataHandler.call(serviceParam);
    }

    private List<Object> callAnalyseObject(AnalysisObjectPresetIndexField presetIndexField, PresetIndexServiceParam serviceParam) {
        serviceParam.setPresetIndexNumber(presetIndexField.getPresetIndexInfo());
        serviceParam.setDimMap(presetIndexField.getDimMap());
        IPresetIndexCallHandler rptMetadataHandler = PresetIndexCallHandlerFactory.getRptMetadataHandler(PresetIndexCallAnObjHandler.class);
        return rptMetadataHandler.call(serviceParam);
    }

    private static class PresetIndexMap
    extends MapFunction {
        private static final long serialVersionUID = -3704395600411022109L;
        private final List<PresetIndexField> presetIndexFieldList;
        private final Map<String, List<Object>> resultMap;
        private final Map<String, Integer> rowIndexMap;
        private final List<String> selectFieldList;
        private final RowMeta sourceRowMeta;
        private final boolean isAlgoX;
        private RowMeta rowMeta = null;

        PresetIndexMap(List<PresetIndexField> presetIndexFieldList, Map<String, List<Object>> resultMap, List<String> selectFieldList, Map<String, Integer> rowIndexMap, RowMeta sourceRowMeta, boolean isAlgoX) {
            this.presetIndexFieldList = presetIndexFieldList;
            this.resultMap = resultMap;
            this.rowIndexMap = rowIndexMap;
            this.selectFieldList = selectFieldList;
            this.sourceRowMeta = sourceRowMeta;
            this.isAlgoX = isAlgoX;
        }

        public Object[] map(Row row) {
            Object[] newRow = new Object[this.getResultRowMeta().getFieldCount()];
            Field[] sourceFields = this.sourceRowMeta.getFields();
            for (int i = 0; i < sourceFields.length; ++i) {
                newRow[i] = row.get(sourceFields[i].getAlias());
            }
            String latitudeFieldValue = this.selectFieldList.stream().map(arg_0 -> ((Row)row).getString(arg_0)).collect(Collectors.joining("_"));
            for (int i = sourceFields.length; i < newRow.length; ++i) {
                List<Object> objects;
                PresetIndexField presetIndexField = this.presetIndexFieldList.get(i - sourceFields.length);
                String fieldAlias = presetIndexField.getUniqueKey();
                if (this.isAlgoX) {
                    fieldAlias = fieldAlias.replace("\u03b4", "_UNI_CODE_SPLIT_");
                }
                if ((objects = this.resultMap.get(fieldAlias)) == null || objects.isEmpty()) {
                    newRow[i] = null;
                    continue;
                }
                Integer rowIndex = this.rowIndexMap.get(latitudeFieldValue);
                Object indexValue = objects.get(rowIndex);
                if (!(indexValue instanceof BigDecimal) && indexValue != null) {
                    try {
                        indexValue = new BigDecimal(String.valueOf(indexValue));
                    }
                    catch (Exception e) {
                        indexValue = null;
                    }
                }
                newRow[i] = indexValue;
            }
            return newRow;
        }

        public RowMeta getResultRowMeta() {
            if (this.rowMeta != null) {
                return this.rowMeta;
            }
            Field[] sourceFields = this.sourceRowMeta.getFields();
            Field[] resultFields = Arrays.copyOf(sourceFields, sourceFields.length + this.presetIndexFieldList.size());
            for (int i = sourceFields.length; i < resultFields.length; ++i) {
                Field field;
                PresetIndexField presetIndexField = this.presetIndexFieldList.get(i - sourceFields.length);
                String alias = presetIndexField.getUniqueKey();
                if (this.isAlgoX) {
                    alias = alias.replace("\u03b4", "_UNI_CODE_SPLIT_");
                }
                resultFields[i] = field = new Field(alias, (DataType)DataType.BigDecimalType);
            }
            this.rowMeta = new RowMeta(resultFields);
            return this.rowMeta;
        }
    }
}

