/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;

public class AnObjPivotMapFunction
extends MapFunction {
    private static final long serialVersionUID = -3572525924592264932L;
    private final RowMeta originalRowMeta;
    private RowMeta newRowMeta;
    private final List<IndexFieldInfo> transIndexFieldInfoList;
    private final Map<String, String> newToOldFieldNameMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, List<FieldInfo>> pivotIndexMap;
    private final Map<String, List<IndexFieldInfo>> refPivotIndexMap;
    private final ReportCalculateInfo calculateInfo;

    public AnObjPivotMapFunction(List<IndexFieldInfo> transIndexFieldInfoList, Map<String, List<FieldInfo>> pivotIndexMap, Map<String, List<IndexFieldInfo>> refPivotIndexMap, RowMeta originalRowMeta, ReportCalculateInfo calculateInfo) {
        this.transIndexFieldInfoList = transIndexFieldInfoList;
        this.pivotIndexMap = pivotIndexMap;
        this.refPivotIndexMap = refPivotIndexMap;
        this.originalRowMeta = originalRowMeta;
        this.calculateInfo = calculateInfo;
    }

    public Object[] map(Row row) {
        Object[] objects = new Object[this.newRowMeta.getFieldCount()];
        for (int i = 0; i < this.newRowMeta.getFieldNames().length; ++i) {
            Field field = this.newRowMeta.getField(i);
            String oldFieldAlias = this.newToOldFieldNameMap.get(field.getAlias());
            objects[i] = HRStringUtils.isEmpty((String)oldFieldAlias) ? row.get(field.getAlias()) : row.get(oldFieldAlias);
        }
        return objects;
    }

    public RowMeta getResultRowMeta() {
        Field[] fields = this.originalRowMeta.getFields();
        Field[] newFields = new Field[fields.length];
        ArrayList repeatFields = Lists.newArrayListWithCapacity((int)16);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String alias = field.getAlias();
            Field newField = field;
            if (alias.contains("\u03b3") && alias.contains("\u03b2")) {
                int gamaIndex = alias.indexOf("\u03b3");
                String dimFieldAlias = alias.substring(0, gamaIndex);
                int betaIndex = alias.indexOf("\u03b2");
                String dimValName = alias.substring(gamaIndex + 1, betaIndex);
                String indexFieldAlias = alias.substring(betaIndex + 1);
                for (IndexFieldInfo indexFieldInfo : this.transIndexFieldInfoList) {
                    String name = this.calculateInfo.isTransferField() ? indexFieldInfo.getPivotDimVal() : indexFieldInfo.getPivotDimName();
                    if (!HRStringUtils.equals((String)indexFieldInfo.getPivotDimAlias(), (String)dimFieldAlias) || !HRStringUtils.equals((String)name, (String)dimValName) || !HRStringUtils.equals((String)indexFieldInfo.getPivotIndexAlias(), (String)indexFieldAlias)) continue;
                    List<FieldInfo> fieldInfos = this.pivotIndexMap.get(indexFieldInfo.getFieldAlias());
                    if (fieldInfos != null) {
                        boolean firstAdd = false;
                        for (FieldInfo fieldInfo : fieldInfos) {
                            this.newToOldFieldNameMap.put(fieldInfo.getNumberAlias(), field.getAlias());
                            if (firstAdd) {
                                repeatFields.add(new Field(fieldInfo.getNumberAlias(), field.getDataType()));
                                continue;
                            }
                            newField = new Field(fieldInfo.getNumberAlias(), field.getDataType());
                            firstAdd = true;
                        }
                    } else {
                        List<IndexFieldInfo> indexFieldInfos = this.refPivotIndexMap.get(indexFieldInfo.getFieldAlias());
                        if (indexFieldInfos == null) continue;
                        boolean firstAdd = false;
                        HashSet indexFieldAliasSet = Sets.newHashSetWithExpectedSize((int)16);
                        for (IndexFieldInfo fieldInfo : indexFieldInfos) {
                            if (indexFieldAliasSet.contains(fieldInfo.getFieldAlias())) continue;
                            this.newToOldFieldNameMap.put(fieldInfo.getFieldAlias(), field.getAlias());
                            if (firstAdd) {
                                repeatFields.add(new Field(fieldInfo.getFieldAlias(), field.getDataType()));
                            } else {
                                newField = new Field(fieldInfo.getFieldAlias(), field.getDataType());
                                firstAdd = true;
                            }
                            indexFieldAliasSet.add(fieldInfo.getFieldAlias());
                        }
                    }
                    break;
                }
            }
            newFields[i] = newField;
        }
        if (!repeatFields.isEmpty()) {
            Field[] result = new Field[newFields.length + repeatFields.size()];
            System.arraycopy(newFields, 0, result, 0, newFields.length);
            System.arraycopy(repeatFields.toArray(new Object[0]), 0, result, newFields.length, repeatFields.size());
            this.newRowMeta = new RowMeta(result);
        } else {
            this.newRowMeta = new RowMeta(newFields);
        }
        return this.newRowMeta;
    }
}

