/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hrptmc.business.repcalculate.algo.CalculateAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.DetailCalculateAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.DetailPivotCalculateAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.SummaryCalculateAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.SummaryPivotCalculateAlgo;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;

public class CalculateAlgoFactory {
    private static final Log LOGGER = LogFactory.getLog(CalculateAlgoFactory.class);

    public static CalculateAlgo getCalculate(HRComplexObjContext complexObjContext, ReportCalculateInfo calculateInfo) {
        if (calculateInfo.getReportType().equals("1")) {
            if (CollectionUtils.isNotEmpty(calculateInfo.getTransposeConfigInfoList())) {
                LOGGER.info("[repcalculate-ALGO]:detail report of rows to columns calculate by ALGO");
                return new DetailPivotCalculateAlgo(calculateInfo, complexObjContext);
            }
            LOGGER.info("[repcalculate-ALGO]:detail report calculate by ALGO");
            return new DetailCalculateAlgo(calculateInfo, complexObjContext);
        }
        if (CollectionUtils.isNotEmpty(calculateInfo.getTransposeConfigInfoList())) {
            LOGGER.info("[repcalculate-ALGO]:summary report of rows to columns calculate by ALGO");
            return new SummaryPivotCalculateAlgo(calculateInfo, complexObjContext);
        }
        LOGGER.info("[repcalculate-ALGO]:summary report calculate by ALGO");
        return new SummaryCalculateAlgo(calculateInfo, complexObjContext);
    }
}

