/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class CopyFieldMapFunction
extends MapFunction {
    private static final long serialVersionUID = -6816298621253907639L;
    private final List<ReportField> reportFieldList;
    private final HashMap<String, String> copyField = new HashMap();
    private final String[] allFieldName;
    private final RowMeta originalRowMeta;
    private BiMap<String, String> fieldBiMap;
    private RowMeta resultRowMeta;
    private String[] fieldNames;

    public CopyFieldMapFunction(List<ReportField> reportFieldList, String[] allFieldName, RowMeta originalRowMeta, BiMap<String, String> fieldBiMap) {
        this.reportFieldList = reportFieldList;
        this.allFieldName = allFieldName;
        this.originalRowMeta = originalRowMeta;
        this.fieldBiMap = fieldBiMap;
    }

    public CopyFieldMapFunction(List<ReportField> reportFieldList, String[] allFieldName, RowMeta originalRowMeta) {
        this.reportFieldList = reportFieldList;
        this.allFieldName = allFieldName;
        this.originalRowMeta = originalRowMeta;
    }

    public Object[] map(Row row) {
        BiMap inverse = null;
        if (this.fieldBiMap != null) {
            inverse = this.fieldBiMap.inverse();
        }
        Object[] objects = new Object[this.getResultRowMeta().getFieldCount()];
        for (int i = 0; i < this.getFieldNames().length; ++i) {
            Field field = this.getResultRowMeta().getField(i);
            String copyFromFieldName = this.copyField.get(field.getName());
            String fieldAlias = copyFromFieldName != null ? copyFromFieldName : field.getName();
            String rowFieldName = fieldAlias;
            if (inverse != null) {
                rowFieldName = (String)inverse.get((Object)fieldAlias);
            }
            objects[i] = row.get(rowFieldName);
        }
        return objects;
    }

    private String[] getFieldNames() {
        if (this.fieldNames != null) {
            return this.fieldNames;
        }
        this.fieldNames = this.getResultRowMeta().getFieldNames();
        return this.fieldNames;
    }

    public RowMeta getResultRowMeta() {
        if (this.resultRowMeta != null) {
            return this.resultRowMeta;
        }
        Field[] fields = this.originalRowMeta.getFields();
        Map fieldMap = Arrays.stream(fields).collect(Collectors.toMap(Field::getAlias, Function.identity(), (x, y) -> y));
        List<String> allFieldList = Arrays.asList(this.allFieldName);
        ArrayList<Field> rstFieldList = new ArrayList<Field>();
        for (Field field : fields) {
            if (!allFieldList.contains(field.getName())) continue;
            String alias = field.getName();
            if (this.fieldBiMap != null) {
                alias = (String)this.fieldBiMap.get((Object)field.getName());
            }
            field.setName(alias);
            field.setAlias(alias);
            rstFieldList.add(field);
        }
        for (ReportField reportField : this.reportFieldList) {
            String fieldName = reportField.getFieldAlias();
            String fieldNameCopy = reportField.getUniqueKey();
            Field field = (Field)fieldMap.get(fieldName);
            Field fieldCopy = (Field)fieldMap.get(fieldNameCopy);
            if (field == null || fieldCopy != null) continue;
            String sourceAlias = fieldName;
            String copyAlias = fieldNameCopy;
            if (this.fieldBiMap != null) {
                copyAlias = (String)this.fieldBiMap.get((Object)fieldNameCopy);
                sourceAlias = (String)this.fieldBiMap.get((Object)fieldName);
            }
            this.copyField.put(copyAlias, sourceAlias);
            fieldCopy = new Field(copyAlias, field.getDataType());
            rstFieldList.add(fieldCopy);
        }
        this.resultRowMeta = new RowMeta(rstFieldList.toArray(new Field[0]));
        return this.resultRowMeta;
    }
}

