/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.QuerySegment;
import kd.hr.hrptmc.business.repcalculate.algo.CalculateAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.ReportFieldDivideHelper;
import kd.hr.hrptmc.business.repcalculate.algo.RowColumnTransHelper;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;

public class PivotCalculateAlgo
extends CalculateAlgo {
    protected List<ReportField> latitudeExTransFieldList;
    protected ReportField[] indexExTransFields;
    private Set<String> transposeFieldAliasSet;

    public PivotCalculateAlgo(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        super(calculateInfo, complexObjContext);
        this.assignFieldExTrans();
    }

    @Override
    public DataSet calculate(int start, int limit) {
        DataSet dataSet = this.getData(start, limit);
        DataSet transpose = this.transpose(dataSet, start, limit);
        return this.renewFieldName(transpose);
    }

    @Override
    public long count(int start, int limit) {
        if (!this.calculateInfo.getTransposeConfigInfoList().isEmpty() && this.latitudeExTransFieldList.isEmpty()) {
            return 1L;
        }
        return super.count(start, limit);
    }

    protected DataSet groupbyDataSet(RowColumnTransHelper rowColumnTransHelper, DataSet dataSet) {
        long count = Arrays.stream(this.indexExTransFields).filter(field -> "rptdbsortidx".equals(field.getUniqueKey())).count();
        if (count == 0L && this.hasOrderIdx(dataSet) && this.calculateInfo.isHasOrderIdx()) {
            EntityPrimitiveIndexField orderNumIdxField = ReportFieldDivideHelper.genRowNumIndexField(this.calculateInfo);
            ArrayList<ReportField> list = new ArrayList<ReportField>(Arrays.asList(this.indexExTransFields));
            list.add(orderNumIdxField);
            this.indexExTransFields = list.toArray(new ReportField[0]);
        }
        return rowColumnTransHelper.groupbyDataSet(dataSet, this.latitudeExTransFieldList, this.indexExTransFields);
    }

    @ExcludeFromJacocoGeneratedReport
    private DataSet onlyGroupByAgg(DataSet dataSet, int start, int limit, Map<String, RowColumnTransHelper> transHelperMap, Map<String, DataSet> preprocessDataSetMap) {
        QuerySegment querySegment = this.getComplexObjContext().getQuerySegment();
        DataSet rstDataSet = null;
        DataSet copyDataSet = dataSet.copy();
        List<TransposeConfigInfo> transposeConfigInfoList = this.getCalculateInfo().getTransposeConfigInfoList();
        RowColumnTransHelper rowColumnTransHelper = new RowColumnTransHelper();
        rowColumnTransHelper.setAddCountField(this.isTotalCal());
        rowColumnTransHelper.setTotalCalculate(this.isTotalCal());
        rowColumnTransHelper.setFieldBiMap((BiMap<String, String>)this.fieldBiMap);
        rowColumnTransHelper.init(this.getCalculateInfo());
        if (querySegment == null) {
            DataSet transDataSet = copyDataSet.copy();
            rstDataSet = this.groupbyDataSet(rowColumnTransHelper, copyDataSet);
            this.convertPreprocess(transDataSet, transposeConfigInfoList, false, transHelperMap, preprocessDataSetMap);
        } else {
            rowColumnTransHelper.setAddCountField(true);
            boolean loop = true;
            while (loop) {
                if (rstDataSet == null) {
                    rstDataSet = this.groupbyDataSet(rowColumnTransHelper, copyDataSet);
                } else {
                    DataSet waitUnionDs = this.groupbyDataSet(rowColumnTransHelper, copyDataSet);
                    waitUnionDs = waitUnionDs.select(rstDataSet.getRowMeta().getFieldNames());
                    rstDataSet = rstDataSet.union(waitUnionDs);
                }
                this.convertPreprocess(copyDataSet, transposeConfigInfoList, true, transHelperMap, preprocessDataSetMap);
                if (querySegment.hasNext()) {
                    copyDataSet = this.getData(start, limit).copy();
                    if (!this.isAdminOrgIncludeSub()) continue;
                    AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
                    copyDataSet = this.addAdminOrgIncludeSub(copyDataSet, adminOrgSummaryInfo);
                    continue;
                }
                loop = false;
            }
            String[] latitudeArr = (String[])this.latitudeExTransFieldList.stream().map(ReportField::getUniqueKey).toArray(String[]::new);
            if ("0".equals(this.calculateInfo.getReportType())) {
                for (int i = 0; i < latitudeArr.length; ++i) {
                    String fieldName = latitudeArr[i];
                    latitudeArr[i] = (String)this.fieldBiMap.get((Object)fieldName);
                }
                rstDataSet = rowColumnTransHelper.groupAfterMerge(rstDataSet, latitudeArr, this.indexExTransFields).copy();
            } else {
                latitudeArr = (String[])this.latitudeExTransFieldList.stream().map(ReportField::getUniqueKey).toArray(String[]::new);
                rstDataSet = rowColumnTransHelper.detailReportRowReduce(rstDataSet, latitudeArr, this.indexExTransFields, true).copy();
            }
            this.groupAfterMerge(transposeConfigInfoList, transHelperMap, preprocessDataSetMap);
        }
        this.getComplexObjContext().clearAlterAbleField();
        return rstDataSet;
    }

    @ExcludeFromJacocoGeneratedReport
    private void groupAfterMerge(List<TransposeConfigInfo> transposeConfigInfoList, Map<String, RowColumnTransHelper> transHelperMap, Map<String, DataSet> preprocessDataSetMap) {
        Map configInfoMap = transposeConfigInfoList.stream().collect(Collectors.toMap(TransposeConfigInfo::getTransConfKeys, Function.identity()));
        preprocessDataSetMap.forEach((key, value) -> {
            value = "0".equals(this.calculateInfo.getReportType()) ? ((RowColumnTransHelper)transHelperMap.get(key)).groupAfterMerge((DataSet)value, (TransposeConfigInfo)configInfoMap.get(key)).copy() : ((RowColumnTransHelper)transHelperMap.get(key)).detailReportRowReduce(this.calculateInfo, (DataSet)value, (TransposeConfigInfo)configInfoMap.get(key)).copy();
            preprocessDataSetMap.put((String)key, (DataSet)value);
        });
    }

    private void convertPreprocess(DataSet copyDataSet, List<TransposeConfigInfo> transposeConfigInfoList, boolean branch, Map<String, RowColumnTransHelper> transHelperMap, Map<String, DataSet> preprocessDataSetMap) {
        for (TransposeConfigInfo transposeConfigInfo : transposeConfigInfoList) {
            DataSet preprocessDataSet;
            RowColumnTransHelper columnTransHelper = transHelperMap.get(transposeConfigInfo.getTransConfKeys());
            if (columnTransHelper == null) {
                columnTransHelper = new RowColumnTransHelper();
                if (branch) {
                    columnTransHelper.setAddCountField(true);
                } else {
                    columnTransHelper.setAddCountField(this.isTotalCal());
                }
                columnTransHelper.setTotalCalculate(this.isTotalCal());
                columnTransHelper.setFieldBiMap((BiMap<String, String>)this.fieldBiMap);
                columnTransHelper.init(this.getCalculateInfo());
                transHelperMap.put(transposeConfigInfo.getTransConfKeys(), columnTransHelper);
            }
            if ((preprocessDataSet = preprocessDataSetMap.get(transposeConfigInfo.getTransConfKeys())) == null) {
                preprocessDataSet = columnTransHelper.beforeConvertPreprocess(copyDataSet, transposeConfigInfo);
            } else {
                DataSet waitUnionDs = columnTransHelper.beforeConvertPreprocess(copyDataSet, transposeConfigInfo);
                waitUnionDs = waitUnionDs.select(preprocessDataSet.getRowMeta().getFieldNames());
                preprocessDataSet = preprocessDataSet.union(waitUnionDs);
            }
            preprocessDataSetMap.put(transposeConfigInfo.getTransConfKeys(), preprocessDataSet);
        }
    }

    protected DataSet transpose(DataSet dataSet, int start, int limit) {
        this.calculateInfo.getCostTimeHelper().nestedStart(false);
        List<TransposeConfigInfo> transposeConfigInfoList = this.getCalculateInfo().getTransposeConfigInfoList();
        HashMap<String, RowColumnTransHelper> transHelperMap = new HashMap<String, RowColumnTransHelper>(transposeConfigInfoList.size());
        HashMap<String, DataSet> preprocessDataSetMap = new HashMap<String, DataSet>(transposeConfigInfoList.size());
        DataSet resultDataSet = this.onlyGroupByAgg(dataSet, start, limit, transHelperMap, preprocessDataSetMap);
        LinkedHashSet<String> aliasMap = new LinkedHashSet<String>(16);
        this.recordFieldNames(resultDataSet, aliasMap);
        Set<Object> latitudeAliasSet = new HashSet(16);
        if (this.latitudeExTransFieldList != null) {
            latitudeAliasSet = this.latitudeExTransFieldList.stream().map(ReportField::getUniqueKey).collect(Collectors.toSet());
        }
        HashSet finalLatitudeAliasSet = latitudeAliasSet;
        boolean first = true;
        for (TransposeConfigInfo transposeConfigInfo : transposeConfigInfoList) {
            String[] joinFieldNames;
            JoinDataSet join;
            RowColumnTransHelper columnTransHelper = (RowColumnTransHelper)transHelperMap.get(transposeConfigInfo.getTransConfKeys());
            List<Map<String, Object>> columnListMap = this.queryLatitudeValList(transposeConfigInfo.getTransposeFieldList());
            DataSet preprocessDataSet = (DataSet)preprocessDataSetMap.get(transposeConfigInfo.getTransConfKeys());
            DataSet transposeDs = columnTransHelper.convert(preprocessDataSet, columnListMap, transposeConfigInfo);
            LinkedHashSet<String> dsAliasMap = new LinkedHashSet<String>(16);
            this.recordFieldNames(transposeDs, dsAliasMap);
            for (String alias : dsAliasMap) {
                if (finalLatitudeAliasSet.contains(alias) || this.transposeFieldAliasSet.contains(alias)) continue;
                aliasMap.add(alias);
            }
            if (this.latitudeExTransFieldList.isEmpty()) {
                transposeDs = transposeDs.addField("1", "onwrowid");
                if (first) {
                    resultDataSet = resultDataSet.addField("1", "onwrowid");
                    first = false;
                }
                join = resultDataSet.leftJoin(transposeDs).on("onwrowid", "onwrowid");
                aliasMap.add("onwrowid");
                joinFieldNames = aliasMap.toArray(new String[0]);
                resultDataSet = join.select(joinFieldNames).finish();
                continue;
            }
            join = resultDataSet.leftJoin(transposeDs);
            for (ReportField latitudeField : this.latitudeExTransFieldList) {
                String alias = (String)this.fieldBiMap.get((Object)latitudeField.getUniqueKey());
                join.on(alias, alias);
            }
            joinFieldNames = aliasMap.toArray(new String[0]);
            resultDataSet = join.select(joinFieldNames).finish();
        }
        this.calculateInfo.getCostTimeHelper().logCost("algo_transpose", "algo_transpose");
        return this.reOrder(resultDataSet);
    }

    private void recordFieldNames(DataSet dataSet, LinkedHashSet<String> aliasMap) {
        RowMeta rowMeta = dataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        if (fieldNames.length > 0) {
            Collections.addAll(aliasMap, fieldNames);
        }
    }

    private void assignFieldExTrans() {
        List<TransposeConfigInfo> transposeConfigInfoList = this.getCalculateInfo().getTransposeConfigInfoList();
        this.transposeFieldAliasSet = transposeConfigInfoList.stream().flatMap(tr -> tr.getTransposeFieldUniKeyList().stream()).collect(Collectors.toSet());
        this.latitudeExTransFieldList = ReportFieldDivideHelper.getRowLatitudeFields(this.getCalculateInfo(), this.transposeFieldAliasSet);
        Set<String> transposeIndexAliasSet = transposeConfigInfoList.stream().map(TransposeConfigInfo::getTransposeValueFieldList).flatMap(Collection::stream).map(ReportField::getUniqueKey).collect(Collectors.toSet());
        this.indexExTransFields = ReportFieldDivideHelper.getAllIndexFields(this.getCalculateInfo(), transposeIndexAliasSet);
    }
}

