/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.hr.hrptmc.business.repcalculate.algo.PivotReduceGroupAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.ReportFieldDivideHelper;
import kd.hr.hrptmc.business.repcalculate.algo.RptTransform;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import org.apache.commons.lang.ArrayUtils;

public class PivotHelper
extends RptTransform {
    private boolean containDependField;

    public boolean isContainDependField() {
        return this.containDependField;
    }

    public void setContainDependField(boolean containDependField) {
        this.containDependField = containDependField;
    }

    @Override
    public void init(ReportCalculateInfo calculateInfo) {
        this.calculateInfo = calculateInfo;
        this.getLatitudeFieldList(calculateInfo);
        this.getAllIndexFields(calculateInfo);
    }

    public DataSet convert(DataSet dataSet, List<Map<String, Object>> columnListMap) {
        String[] latitudeArr = null;
        if (ArrayUtils.isNotEmpty((Object[])this.rowLatitudeArr)) {
            latitudeArr = (String[])Arrays.stream(this.rowLatitudeArr).map(reportField -> (String)this.getFieldBiMap().get((Object)reportField.getUniqueKey())).toArray(String[]::new);
        }
        PivotReduceGroupAlgo pivotReduce = new PivotReduceGroupAlgo(columnListMap, this.rowLatitudeArr, this.columnLatitudeArr, this.rowIndexArr, this.isAddCountField(), this.getFieldBiMap(), this.calculateInfo.isTransferField());
        pivotReduce.setColumnSummaryInfo(this.calculateInfo.getColumnSummaryInfo());
        pivotReduce.setRowSummaryInfo(this.calculateInfo.getRowSummaryInfo());
        pivotReduce.setTotalCalculate(this.isTotalCalculate);
        if (this.calculateInfo.isHasOrderIdx()) {
            DataSet copy = dataSet.copy();
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(latitudeArr).min("rptdbsortidx");
            DataSet pivotDs = groupbyDataSet.reduceGroup((ReduceGroupFunctionWithCollector)pivotReduce);
            if (latitudeArr != null) {
                String[] fieldNames = pivotDs.getRowMeta().getFieldNames();
                DataSet rowNum = copy.groupBy(latitudeArr).min("rptdbsortidx").finish();
                JoinDataSet joinDataSet = pivotDs.leftJoin(rowNum);
                for (String latitude : latitudeArr) {
                    joinDataSet.on(latitude, latitude);
                }
                return joinDataSet.select(this.removeDuplicates(fieldNames), new String[]{"rptdbsortidx"}).finish();
            }
            pivotDs.addField("1", "rptdbsortidx");
            return pivotDs;
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(latitudeArr);
        return groupbyDataSet.reduceGroup((ReduceGroupFunctionWithCollector)pivotReduce);
    }

    private String[] removeDuplicates(String[] array) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(array));
        return set.toArray(new String[0]);
    }

    public DataSet groupAfterMerge(DataSet dataSet) {
        List<ReportField> latitudeFieldList = this.getLatitudeFieldList(this.calculateInfo);
        ReportField[] allIndexFields = this.getAllIndexFields(this.calculateInfo);
        String[] latitudeArr = (String[])latitudeFieldList.stream().map(ReportField::getUniqueKey).toArray(String[]::new);
        for (int i = 0; i < latitudeArr.length; ++i) {
            latitudeArr[i] = (String)this.getFieldBiMap().get((Object)latitudeArr[i]);
        }
        EntityPrimitiveIndexField orderNumIdxField = ReportFieldDivideHelper.genRowNumIndexField(this.calculateInfo);
        if (orderNumIdxField != null) {
            ArrayList<ReportField> list = new ArrayList<ReportField>(Arrays.asList(allIndexFields));
            list.add(orderNumIdxField);
            allIndexFields = list.toArray(new ReportField[0]);
        }
        return this.groupAfterMerge(dataSet, latitudeArr, allIndexFields);
    }

    public DataSet groupLatitudeCalPrimitive(DataSet dataSet) {
        List<ReportField> latitudeFieldList = this.getLatitudeFieldList(this.calculateInfo);
        ReportField[] allIndexFields = this.getAllIndexFields(this.calculateInfo);
        EntityPrimitiveIndexField orderNumIdxField = ReportFieldDivideHelper.genRowNumIndexField(this.calculateInfo);
        if (orderNumIdxField != null) {
            ArrayList<ReportField> list = new ArrayList<ReportField>(Arrays.asList(allIndexFields));
            list.add(orderNumIdxField);
            allIndexFields = list.toArray(new ReportField[0]);
        }
        return this.groupbyDataSet(dataSet, latitudeFieldList, allIndexFields);
    }

    private ReportField[] getAllIndexFields(ReportCalculateInfo calculateInfo) {
        if (this.rowIndexArr != null) {
            return this.rowIndexArr;
        }
        this.rowIndexArr = ReportFieldDivideHelper.getAllIndexFields(calculateInfo, this.isContainDependField());
        return this.rowIndexArr;
    }

    @Override
    protected List<ReportField> getAllLatitudeFields(ReportCalculateInfo calculateInfo, TransposeConfigInfo transposeConfigInfo) {
        List<ReportField> latitudeFieldList = ReportFieldDivideHelper.getRowLatitudeFields(calculateInfo);
        this.rowLatitudeArr = latitudeFieldList.toArray(new ReportField[0]);
        List<ReportField> columnLatitudeFields = ReportFieldDivideHelper.getColumnLatitudeFields(calculateInfo);
        this.columnLatitudeArr = columnLatitudeFields.toArray(new ReportField[0]);
        latitudeFieldList.addAll(columnLatitudeFields);
        return latitudeFieldList;
    }
}

