/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import org.apache.commons.collections.CollectionUtils;

public class ReportFieldDivideHelper {
    public static List<ReportField> getRowLatitudeFields(ReportCalculateInfo calculateInfo) {
        return ReportFieldDivideHelper.getRowLatitudeFields(calculateInfo, null);
    }

    public static List<ReportField> getRowLatitudeFields(ReportCalculateInfo calculateInfo, Set<String> excludeFieldUKSet) {
        return ReportFieldDivideHelper.getLatitudeFields(calculateInfo.getRowFieldListWithoutDp(false), excludeFieldUKSet);
    }

    public static List<ReportField> getColumnLatitudeFields(ReportCalculateInfo calculateInfo) {
        return ReportFieldDivideHelper.getColumnLatitudeFields(calculateInfo, null);
    }

    public static List<ReportField> getColumnLatitudeFields(ReportCalculateInfo calculateInfo, Set<String> excludeFieldUKSet) {
        return ReportFieldDivideHelper.getLatitudeFields(calculateInfo.getColumnFieldList(), excludeFieldUKSet);
    }

    public static List<HRComplexObjFieldInfo> getComplexObjLatitudeFieldList(List<ReportField> fieldList, Set<String> excludeFieldUKSet) {
        List<Object> complexObjFieldInfoList;
        if (CollectionUtils.isEmpty(fieldList)) {
            complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(0);
        } else {
            List<LatitudeField> latitudeFieldList = ReportFieldDivideHelper.getLatitudeFieldList(fieldList, excludeFieldUKSet);
            complexObjFieldInfoList = latitudeFieldList.stream().map(ReportFieldDivideHelper::entityField2ComplexField).collect(Collectors.toList());
            List<AggregateIndexField> aggregateLatitudeFieldList = ReportFieldDivideHelper.getAggLatitudeFieldList(fieldList, excludeFieldUKSet);
            complexObjFieldInfoList.addAll(aggregateLatitudeFieldList.stream().map(ReportFieldDivideHelper::aggregateField2ComplexField).collect(Collectors.toList()));
        }
        return complexObjFieldInfoList;
    }

    public static List<ReportField> getLatitudeFields(List<ReportField> fieldList, Set<String> excludeFieldUKSet) {
        ArrayList<ReportField> latitudeFieldList;
        if (CollectionUtils.isEmpty(fieldList)) {
            latitudeFieldList = new ArrayList<ReportField>(0);
        } else {
            latitudeFieldList = new ArrayList(10);
            latitudeFieldList.addAll(ReportFieldDivideHelper.getLatitudeFieldList(fieldList, excludeFieldUKSet));
            List<AggregateIndexField> aggregateLatitudeFieldList = ReportFieldDivideHelper.getAggLatitudeFieldList(fieldList, excludeFieldUKSet);
            latitudeFieldList.addAll(aggregateLatitudeFieldList);
        }
        return latitudeFieldList;
    }

    private static List<AggregateIndexField> getAggLatitudeFieldList(List<ReportField> fieldList, Set<String> excludeFieldUKSet) {
        return fieldList.stream().filter(obj -> obj instanceof AggregateIndexField).filter(obj -> CollectionUtils.isEmpty((Collection)excludeFieldUKSet) || !excludeFieldUKSet.contains(obj.getUniqueKey())).filter(rpt -> !rpt.isDependField()).map(obj -> (AggregateIndexField)obj).filter(AggregateIndexField::isLatitudeField).sorted(Comparator.comparingInt(ReportField::getFieldSeq)).collect(Collectors.toList());
    }

    private static List<LatitudeField> getLatitudeFieldList(List<ReportField> fieldList, Set<String> excludeFieldUKSet) {
        return fieldList.stream().filter(obj -> obj instanceof LatitudeField).filter(obj -> CollectionUtils.isEmpty((Collection)excludeFieldUKSet) || !excludeFieldUKSet.contains(obj.getUniqueKey())).filter(rpt -> !rpt.isDependField()).sorted(Comparator.comparingInt(ReportField::getFieldSeq)).map(obj -> (LatitudeField)obj).collect(Collectors.toList());
    }

    public static ReportField[] getAllIndexFields(TransposeConfigInfo transposeConfigInfo) {
        ArrayList<ReportField> reportFieldList = new ArrayList<ReportField>();
        reportFieldList.addAll(Arrays.asList(ReportFieldDivideHelper.getPrimitiveIndexFields(transposeConfigInfo.getTransposeValueFieldList(), null)));
        reportFieldList.addAll(Arrays.asList(ReportFieldDivideHelper.getAggregateIndexFields(transposeConfigInfo.getTransposeValueFieldList(), null)));
        reportFieldList.addAll(Arrays.asList(ReportFieldDivideHelper.getPresetIndexFields(transposeConfigInfo.getTransposeValueFieldList(), null)));
        return reportFieldList.toArray(new ReportField[0]);
    }

    public static ReportField[] getAllIndexFields(ReportCalculateInfo calculateInfo, boolean containDependField) {
        return ReportFieldDivideHelper.getAllIndexFields(calculateInfo, null, false, containDependField);
    }

    public static ReportField[] getAllIndexFields(ReportCalculateInfo calculateInfo, Set<String> excludeFieldUKSet) {
        return ReportFieldDivideHelper.getAllIndexFields(calculateInfo, excludeFieldUKSet, true, false);
    }

    public static ReportField[] getAllIndexFields(ReportCalculateInfo calculateInfo, Set<String> excludeFieldUKSet, boolean addRowNum, boolean containDependField) {
        EntityPrimitiveIndexField indexField;
        ArrayList<ReportField> reportFieldList = new ArrayList<ReportField>();
        reportFieldList.addAll(Arrays.asList(ReportFieldDivideHelper.getPrimitiveIndexFields(calculateInfo.getRowFieldList(), excludeFieldUKSet)));
        reportFieldList.addAll(Arrays.asList(ReportFieldDivideHelper.getAggregateIndexFields(calculateInfo.getRowFieldList(), excludeFieldUKSet)));
        reportFieldList.addAll(Arrays.asList(ReportFieldDivideHelper.getPresetIndexFields(calculateInfo.getRowFieldList(), excludeFieldUKSet)));
        if (addRowNum && (indexField = ReportFieldDivideHelper.genRowNumIndexField(calculateInfo)) != null) {
            reportFieldList.add(indexField);
        }
        return reportFieldList.toArray(new ReportField[0]);
    }

    public static EntityPrimitiveIndexField genRowNumIndexField(ReportCalculateInfo calculateInfo) {
        if (!calculateInfo.isHasOrderIdx()) {
            return null;
        }
        EntityPrimitiveIndexField rowNum = new EntityPrimitiveIndexField();
        rowNum.setUniqueKey("rptdbsortidx");
        rowNum.setFieldAlias("rptdbsortidx");
        rowNum.setCalcFunction("rownummax");
        return rowNum;
    }

    private static EntityPrimitiveIndexField[] getPrimitiveIndexFields(List<ReportField> rowIndexFields, Set<String> excludeFieldUKSet) {
        return (EntityPrimitiveIndexField[])rowIndexFields.stream().filter(obj -> obj instanceof EntityPrimitiveIndexField).filter(obj -> CollectionUtils.isEmpty((Collection)excludeFieldUKSet) || !excludeFieldUKSet.contains(obj.getUniqueKey())).map(obj -> (EntityPrimitiveIndexField)obj).toArray(EntityPrimitiveIndexField[]::new);
    }

    private static AggregateIndexField[] getAggregateIndexFields(List<ReportField> rowIndexFields, Set<String> excludeFieldUKSet) {
        return (AggregateIndexField[])rowIndexFields.stream().filter(obj -> obj instanceof AggregateIndexField).map(obj -> (AggregateIndexField)obj).filter(obj -> CollectionUtils.isEmpty((Collection)excludeFieldUKSet) || !excludeFieldUKSet.contains(obj.getUniqueKey())).filter(AggregateIndexField::isIndexField).toArray(AggregateIndexField[]::new);
    }

    private static PresetIndexField[] getPresetIndexFields(List<ReportField> rowIndexFields, Set<String> excludeFieldUKSet) {
        return (PresetIndexField[])rowIndexFields.stream().filter(obj -> obj instanceof PresetIndexField).filter(obj -> CollectionUtils.isEmpty((Collection)excludeFieldUKSet) || !excludeFieldUKSet.contains(obj.getUniqueKey())).toArray(PresetIndexField[]::new);
    }

    private static HRComplexObjFieldInfo entityField2ComplexField(LatitudeField field) {
        HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(field.getPropFullPath(), "1", field.getFieldAlias());
        fieldInfo.setDataType(DataTypeEnum.of((String)field.getFieldType()));
        return fieldInfo;
    }

    private static HRComplexObjFieldInfo aggregateField2ComplexField(AggregateIndexField aggregateIndexField) {
        HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(aggregateIndexField.getCalcFormulaInfo(), "3", aggregateIndexField.getFieldAlias());
        fieldInfo.setDataType(DataTypeEnum.of((String)aggregateIndexField.getFieldType()));
        fieldInfo.setRefFieldAliasSet(aggregateIndexField.getDependentFieldSet());
        return fieldInfo;
    }

    public static List<HRComplexObjFieldInfo> getComplexObjLatitudeFieldListWithDp(List<ReportField> fieldList, Set<String> excludeFieldUKSet) {
        List<Object> complexObjFieldInfoList;
        if (CollectionUtils.isEmpty(fieldList)) {
            complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(0);
        } else {
            List<LatitudeField> latitudeFieldList = ReportFieldDivideHelper.getLatitudeFieldListWithDp(fieldList, excludeFieldUKSet);
            complexObjFieldInfoList = latitudeFieldList.stream().map(ReportFieldDivideHelper::entityField2ComplexField).collect(Collectors.toList());
            List<AggregateIndexField> aggregateLatitudeFieldList = ReportFieldDivideHelper.getAggLatitudeFieldList(fieldList, excludeFieldUKSet);
            complexObjFieldInfoList.addAll(aggregateLatitudeFieldList.stream().map(ReportFieldDivideHelper::aggregateField2ComplexField).collect(Collectors.toList()));
        }
        return complexObjFieldInfoList;
    }

    private static List<LatitudeField> getLatitudeFieldListWithDp(List<ReportField> fieldList, Set<String> excludeFieldUKSet) {
        return fieldList.stream().filter(obj -> obj instanceof LatitudeField).filter(obj -> CollectionUtils.isEmpty((Collection)excludeFieldUKSet) || !excludeFieldUKSet.contains(obj.getUniqueKey())).sorted(Comparator.comparingInt(ReportField::getFieldSeq)).map(obj -> (LatitudeField)obj).collect(Collectors.toList());
    }
}

