/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algo;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrptmc.business.repcalculate.algo.DetailIndexReplaceFunction;
import kd.hr.hrptmc.business.repcalculate.algo.PivotReduceGroupAlgo;
import kd.hr.hrptmc.business.repcalculate.algo.ReportFieldDivideHelper;
import kd.hr.hrptmc.business.repcalculate.algo.RptTransform;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import org.apache.commons.lang.ArrayUtils;

public class RowColumnTransHelper
extends RptTransform {
    private static final Log LOGGER = LogFactory.getLog(RowColumnTransHelper.class);
    private Set<String> transposeFieldSet;

    @Override
    public void init(ReportCalculateInfo calculateInfo) {
        this.calculateInfo = calculateInfo;
        Set allTransFieldUniqueKeySet = calculateInfo.getTransposeConfigInfoList().stream().flatMap(tr -> tr.getTransposeFieldUniKeyList().stream()).collect(Collectors.toSet());
        this.transposeFieldSet = new HashSet<String>(16);
        this.transposeFieldSet.addAll(allTransFieldUniqueKeySet);
    }

    public DataSet beforeConvertPreprocess(DataSet dataSet, TransposeConfigInfo transposeConfigInfo) {
        DataSet finishDataSet = "0".equals(this.calculateInfo.getReportType()) ? this.groupLatitudeCalPrimitive(this.calculateInfo, dataSet, transposeConfigInfo) : this.detailReportRowReduce(this.calculateInfo, dataSet, transposeConfigInfo);
        return finishDataSet;
    }

    public DataSet groupAfterMerge(DataSet dataSet, TransposeConfigInfo transposeConfigInfo) {
        List<ReportField> latitudeFieldList = this.getLatitudeFieldList(this.calculateInfo, transposeConfigInfo);
        ReportField[] allIndexFields = this.getAllIndexFields(transposeConfigInfo);
        String[] latitudeArr = (String[])latitudeFieldList.stream().map(ReportField::getUniqueKey).toArray(String[]::new);
        for (int i = 0; i < latitudeArr.length; ++i) {
            String fieldName = latitudeArr[i];
            latitudeArr[i] = (String)this.getFieldBiMap().get((Object)fieldName);
        }
        return this.groupAfterMerge(dataSet, latitudeArr, allIndexFields);
    }

    public DataSet convert(DataSet dataSet, List<Map<String, Object>> columnListMap, TransposeConfigInfo transposeConfigInfo) {
        String[] latitudeArr = null;
        if (ArrayUtils.isNotEmpty((Object[])this.rowLatitudeArr)) {
            latitudeArr = (String[])Arrays.stream(this.rowLatitudeArr).map(ReportField::getUniqueKey).map(key -> (String)this.getFieldBiMap().get(key)).toArray(String[]::new);
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(latitudeArr);
        PivotReduceGroupAlgo pivotReduceGroupAlgo = new PivotReduceGroupAlgo(columnListMap, this.rowLatitudeArr, this.columnLatitudeArr, this.rowIndexArr, transposeConfigInfo.getTransConfKeys(), this.isAddCountField(), this.getFieldBiMap(), this.calculateInfo.isTransferField());
        pivotReduceGroupAlgo.setTotalCalculate(this.isTotalCalculate);
        pivotReduceGroupAlgo.setRowSummaryInfo(this.calculateInfo.getRowSummaryInfo());
        return groupbyDataSet.reduceGroup((ReduceGroupFunctionWithCollector)pivotReduceGroupAlgo);
    }

    private void recordTransposeField(TransposeConfigInfo transposeConfigInfo) {
        this.transposeFieldSet.addAll(transposeConfigInfo.getTransposeFieldUniKeyList());
        this.transposeFieldSet.addAll(transposeConfigInfo.getTransposeValueFieldList().stream().map(ReportField::getUniqueKey).collect(Collectors.toSet()));
    }

    private DataSet groupLatitudeCalPrimitive(ReportCalculateInfo calculateInfo, DataSet dataSet, TransposeConfigInfo transposeConfigInfo) {
        this.recordTransposeField(transposeConfigInfo);
        List<ReportField> allLatitudeFields = this.getLatitudeFieldList(calculateInfo, transposeConfigInfo);
        ReportField[] allIndexFields = this.getAllIndexFields(transposeConfigInfo);
        return this.groupbyDataSet(dataSet, allLatitudeFields, allIndexFields);
    }

    public DataSet detailReportRowReduce(ReportCalculateInfo calculateInfo, DataSet dataSet, TransposeConfigInfo transposeConfigInfo) {
        this.recordTransposeField(transposeConfigInfo);
        List<ReportField> allLatitudeFields = this.getLatitudeFieldList(calculateInfo, transposeConfigInfo);
        ReportField[] allIndexFields = this.getAllIndexFields(transposeConfigInfo);
        String[] latitudeArr = (String[])allLatitudeFields.stream().map(ReportField::getFieldAlias).toArray(String[]::new);
        return this.detailReportRowReduce(dataSet, latitudeArr, allIndexFields, true);
    }

    public DataSet detailReportRowReduce(DataSet dataSet, String[] latitudeArr, ReportField[] indexFields, boolean unsUniqueKey) {
        for (int i = 0; i < latitudeArr.length; ++i) {
            String fieldName = latitudeArr[i];
            latitudeArr[i] = (String)this.getFieldBiMap().get((Object)fieldName);
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(latitudeArr);
        LOGGER.info("[repcalculate-ALGO]: detail report group by: {}", (Object)Arrays.toString(latitudeArr));
        DetailIndexReplaceFunction detailTansFun = new DetailIndexReplaceFunction(dataSet, indexFields, this.getFieldBiMap(), unsUniqueKey);
        detailTansFun.setAddSumAndCount(this.isTotalCalculate);
        return groupbyDataSet.reduceGroup((ReduceGroupFunction)detailTansFun);
    }

    private ReportField[] getAllIndexFields(TransposeConfigInfo transposeConfigInfo) {
        if (this.rowIndexArr != null) {
            return this.rowIndexArr;
        }
        this.rowIndexArr = ReportFieldDivideHelper.getAllIndexFields(transposeConfigInfo);
        return this.rowIndexArr;
    }

    @Override
    protected List<ReportField> getAllLatitudeFields(ReportCalculateInfo calculateInfo, TransposeConfigInfo transposeConfigInfo) {
        List<ReportField> latitudeFieldList = ReportFieldDivideHelper.getRowLatitudeFields(calculateInfo, this.transposeFieldSet);
        this.rowLatitudeArr = latitudeFieldList.toArray(new ReportField[0]);
        List<ReportField> transposeFieldList = transposeConfigInfo.getTransposeFieldList();
        this.columnLatitudeArr = transposeFieldList.toArray(new ReportField[0]);
        latitudeFieldList.addAll(transposeFieldList);
        return latitudeFieldList;
    }
}

