/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.business.service.complexobj.ReportQueryPlanByAlgoX;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.output.AlgoxOutputHelper;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.CalculateStrategy;
import kd.hr.hrptmc.business.repcalculate.PresetIndexHandler;
import kd.hr.hrptmc.business.repcalculate.ReportCalculateHandler;
import kd.hr.hrptmc.business.repcalculate.algo.ReplaceFieldMapFunction;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXOrderAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.AlgoXAliasToAlgoXAliasExtendMapFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.NonAggIndexMapFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.RemoveCustomOrderFieldMapFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.TotalCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.algo.AfterCalculateToUniqueKeyAlgoMapFunction;
import kd.hr.hrptmc.business.repcalculate.algox.parser.CalculateAlgoxParser;
import kd.hr.hrptmc.business.repcalculate.algox.query.QueryServiceFactory;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgFlatMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.func.AdminOrgLongNumberMapFunction;
import kd.hr.hrptmc.business.repcalculate.org.handler.AdminOrgHandler;
import kd.hr.hrptmc.business.repcalculate.org.handler.AdminOrgLatitudeReduceHandler;
import kd.hr.hrptmc.business.repcalculate.utils.CacheUtils;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class CalculateAlgoX
extends CalculateStrategy {
    private static final Log LOGGER = LogFactory.getLog(CalculateAlgoX.class);
    protected static final String SESSION_JOB_NAME = "GROUP_BY";
    protected IReportQueryPlan reportQueryPlan;
    protected CalculateAlgoxParser calculateAlgoxParser;
    protected AlgoxOutputHelper algoxOutputHelper;
    protected IPageCache pageCache;

    public CalculateAlgoX(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        super(calculateInfo, complexObjContext);
        this.init(calculateInfo, complexObjContext);
    }

    private void init(ReportCalculateInfo calculateInfo, HRComplexObjContext complexObjContext) {
        IReportQueryPlan reportQueryPlan = this.getReportQueryPlan();
        this.algoxOutputHelper = this.createAlgoXOutputHelper(reportQueryPlan, complexObjContext);
        this.reportQueryPlan = reportQueryPlan;
        this.calculateAlgoxParser = new CalculateAlgoxParser(reportQueryPlan, calculateInfo, complexObjContext);
        if (HRStringUtils.isNotEmpty((String)calculateInfo.getPageId())) {
            this.pageCache = new PageCache(calculateInfo.getPageId());
        }
    }

    @Override
    public long count(int start, int limit) {
        long count = 0L;
        if (this.isAdminOrgIncludeSub()) {
            DataSetX dataSetX = this.getQueryDataSetX(start, limit);
            dataSetX = this.calculateX(dataSetX, true);
            DataSet dataSet = this.getAfterCalculateDataSet(dataSetX, true);
            AdminOrgLatitudeReduceHandler adminOrgLatitudeReduceHandler = new AdminOrgLatitudeReduceHandler(this.calculateInfo);
            dataSet = adminOrgLatitudeReduceHandler.doHandler(dataSet);
            dataSet = dataSet.addField("1", "REPORT_COUNT_FIELD");
            count = dataSet.count("REPORT_COUNT_FIELD", false);
        } else {
            count = this.reportQueryPlan.queryDataCount(start, limit);
        }
        return count;
    }

    @Override
    public DataSet calculate(int start, int limit) {
        return this.queryOriginalDataSet(start, limit);
    }

    @Override
    public DataSet totalCalculate(int start, int limit) {
        List nonAggregateIndexFieldList;
        DataSetX dataSetX = this.queryOriginalDataSetX(start, limit);
        dataSetX = this.calculateX(dataSetX, true);
        if (this.isAdminOrgIncludeSub() && !this.notOnlyGroupByOrg()) {
            String adminOrgIdAlias = this.calculateInfo.getAdminOrgSummaryInfo().getAdminOrgSelectField();
            String adminOrgIdAlgoXAlias = AlgoXFieldInfo.replaceAlgoxAlias((String)adminOrgIdAlias);
            dataSetX = dataSetX.groupBy(new String[]{AlgoXField.buildAlgoXAliasExtend(adminOrgIdAlgoXAlias, adminOrgIdAlgoXAlias)}).reduceGroup((GroupReduceFunction)new TotalCalculateReduceGroupFunction(this.calculateInfo, this.calculateAlgoxParser.getRowFieldParser(), dataSetX.getRowMeta()));
        }
        if (!(nonAggregateIndexFieldList = this.calculateInfo.getRowFieldListWithoutDp(true).stream().filter(reportField -> reportField instanceof NonAggregateIndexField).map(obj -> (NonAggregateIndexField)obj).collect(Collectors.toList())).isEmpty()) {
            dataSetX = dataSetX.map((kd.bos.algox.MapFunction)new NonAggIndexMapFunction(this.calculateInfo, dataSetX.getRowMeta(), this.getComplexObjContext()));
        }
        dataSetX = dataSetX.addFields(new Field[]{new Field("REPORT_COUNT_FIELD", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ONE});
        dataSetX = dataSetX.reduceGroup((GroupReduceFunction)new TotalCalculateReduceGroupFunction(this.calculateInfo, this.calculateAlgoxParser.getRowFieldParser(), dataSetX.getRowMeta()));
        return this.getAfterCalculateDataSet(dataSetX, true);
    }

    protected DataSetX calculateX(DataSetX dataSetX, boolean isTotalCalculate) {
        return dataSetX;
    }

    protected DataSet queryOriginalDataSet(int start, int limit) {
        this.calculateInfo.getCostTimeHelper().nestedStart(false);
        DataSet dataSet = this.getQueryDataSet(start, limit);
        this.calculateInfo.getCostTimeHelper().logCost("algoX_getData", true, "algoX_getData");
        ReportCalculateHandler.Builder builder = new ReportCalculateHandler.Builder();
        builder.addHandler(new AdminOrgHandler(this.calculateInfo, true)).addHandler(new PresetIndexHandler(this.calculateInfo, true));
        dataSet = builder.build().doHandler(dataSet);
        this.calculateInfo.getCostTimeHelper().logCost("algoX_do_PresetIndexHandler", "algoX_do_PresetIndexHandler");
        return dataSet;
    }

    protected DataSetX queryOriginalDataSetX(int start, int limit) {
        DataSetX dataSetX;
        this.calculateInfo.getCostTimeHelper().nestedStart(false);
        if (this.calculateInfo.getRowFieldList().stream().anyMatch(field -> field instanceof PresetIndexField)) {
            DataSet dataSet = this.getQueryDataSet(start, limit);
            ReportCalculateHandler.Builder builder = new ReportCalculateHandler.Builder();
            builder.addHandler(new AdminOrgHandler(this.calculateInfo, true)).addHandler(new PresetIndexHandler(this.calculateInfo, true));
            dataSet = builder.build().doHandler(dataSet);
            dataSetX = this.algoxOutputHelper.getSession().fromInput((Input)new DataSetInput(dataSet));
            dataSetX = dataSetX.map((kd.bos.algox.MapFunction)new AlgoXAliasToAlgoXAliasExtendMapFunction(dataSetX.getRowMeta(), this.calculateAlgoxParser.getRowFieldParser(), this.calculateAlgoxParser.getColFieldParser()));
        } else {
            dataSetX = this.getQueryDataSetX(start, limit);
        }
        this.calculateInfo.getCostTimeHelper().logCost("algoX_do_queryOriginalDataSetX", "algoX_do_queryOriginalDataSetX");
        return dataSetX;
    }

    protected DataSet getAfterCalculateDataSet(DataSetX dataSetX, boolean mappingField) {
        this.calculateInfo.getCostTimeHelper().nestedStart(false);
        LOGGER.info("[repCalculate-algoX] getAfterCalculateDataSet algoXJobKey:{} mappingField:{} ", (Object)this.getComplexObjContext().getAlgoxJobKey(), (Object)mappingField);
        Set<String> customOrderFieldNames = this.calculateAlgoxParser.getRowFieldParser().getRowOrderFieldList().stream().filter(AlgoXOrderAlgoXField::isOutputRemove).map(AlgoXField::getAlgoXAliasExtend).collect(Collectors.toSet());
        if (!customOrderFieldNames.isEmpty()) {
            dataSetX = dataSetX.map((kd.bos.algox.MapFunction)new RemoveCustomOrderFieldMapFunction(dataSetX.getRowMeta(), customOrderFieldNames));
        }
        DataSet dataSet = this.algoxOutputHelper.dataSetOutput(dataSetX);
        if (mappingField) {
            dataSet = dataSet.map((MapFunction)new AfterCalculateToUniqueKeyAlgoMapFunction(dataSet.getRowMeta(), this.calculateAlgoxParser.getRowFieldParser(), this.calculateAlgoxParser.getParseTypeSet()));
        }
        this.calculateInfo.getCostTimeHelper().logCost("algoX_do_getAfterCalculateDataSet", "algoX_do_getAfterCalculateDataSet");
        return dataSet;
    }

    protected final AlgoxOutputHelper createAlgoXOutputHelper(IReportQueryPlan reportQueryPlan, HRComplexObjContext complexObjContext) {
        if (reportQueryPlan instanceof ReportQueryPlanByAlgoX) {
            return ((ReportQueryPlanByAlgoX)reportQueryPlan).getAlgoXQueryService().getAlgoXOutputHelper();
        }
        String jobName = complexObjContext.getAlgoxJobKey() == null ? SESSION_JOB_NAME : String.join((CharSequence)"_", SESSION_JOB_NAME, complexObjContext.getAlgoxJobKey());
        return new AlgoxOutputHelper(jobName);
    }

    private DataSet getQueryDataSet(int start, int limit) {
        DataSet dataSet;
        this.beforeQuery();
        if (this.reportQueryPlan instanceof ReportQueryPlanByAlgoX) {
            dataSet = ((ReportQueryPlanByAlgoX)this.reportQueryPlan).queryDataSet(start, limit, false);
        } else {
            dataSet = this.reportQueryPlan.queryDataSet(start, limit);
            dataSet = this.addAlgoAliasToAlgoXAlias(dataSet);
        }
        this.afterQuery();
        return dataSet;
    }

    private DataSetX getQueryDataSetX(int start, int limit) {
        DataSetX dataSetX;
        this.beforeQuery();
        if (this.reportQueryPlan instanceof ReportQueryPlanByAlgoX) {
            dataSetX = ((ReportQueryPlanByAlgoX)this.reportQueryPlan).query4DataSetX(start, limit);
        } else {
            DataSet dataSet = this.reportQueryPlan.queryDataSet(start, limit);
            dataSet = this.addAlgoAliasToAlgoXAlias(dataSet);
            dataSetX = this.algoxOutputHelper.getSession().fromInput((Input)new DataSetInput(dataSet));
        }
        this.afterQuery();
        dataSetX = dataSetX.map((kd.bos.algox.MapFunction)new AlgoXAliasToAlgoXAliasExtendMapFunction(dataSetX.getRowMeta(), this.calculateAlgoxParser.getRowFieldParser(), this.calculateAlgoxParser.getColFieldParser()));
        return dataSetX;
    }

    protected DataSetX addOrderBy(DataSetX dataSetX) {
        AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
        if (adminOrgSummaryInfo == null || !adminOrgSummaryInfo.getTreeShow()) {
            Object[] orderArray = this.calculateAlgoxParser.getLatitudeFieldAlgoXAliasExtendOrder(dataSetX);
            LOGGER.info("AlgoX OrderBy :{}", (Object)Arrays.toString(orderArray));
            if (orderArray != null && orderArray.length > 0) {
                dataSetX = dataSetX.orderBy((String[])orderArray);
            }
        }
        return dataSetX;
    }

    protected DataSet addAlgoAliasToAlgoXAlias(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        HashMap inverse = Maps.newHashMapWithExpectedSize((int)16);
        for (Field field : fields) {
            inverse.put(field.getAlias(), AlgoXFieldInfo.replaceAlgoxAlias((String)field.getAlias()));
        }
        return dataSet.map((MapFunction)new ReplaceFieldMapFunction(inverse, rowMeta));
    }

    protected boolean isAdminOrgIncludeSub() {
        AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
        return adminOrgSummaryInfo != null && !adminOrgSummaryInfo.getTreeShow() && adminOrgSummaryInfo.getIncludeSubOrg();
    }

    protected boolean notOnlyGroupByOrg() {
        AdminOrgSummaryInfo adminOrgSummaryInfo = this.calculateInfo.getAdminOrgSummaryInfo();
        return !this.isAdminOrgIncludeSub() || !adminOrgSummaryInfo.isOnlyGroupOrg();
    }

    protected DataSetX addAdminOrgIncludeSub(DataSetX dataSetX, AdminOrgSummaryInfo adminOrgSummaryInfo) {
        int fieldIndex = dataSetX.getRowMeta().getFieldIndex("ROW_FIELD_ADMIN_ORG_LONG_NUMBER", false);
        DataSetX newResultDataSetX = dataSetX;
        RowMeta newRowMeta = dataSetX.getRowMeta();
        if (fieldIndex < 0) {
            newResultDataSetX = dataSetX.map((kd.bos.algox.MapFunction)new AdminOrgLongNumberMapFunction(adminOrgSummaryInfo, dataSetX.getRowMeta()));
            newRowMeta = newResultDataSetX.getRowMeta();
        }
        if (!adminOrgSummaryInfo.getHasDoneFlatMap()) {
            newResultDataSetX = newResultDataSetX.flatMap((FlatMapFunction)new AdminOrgFlatMapFunction(adminOrgSummaryInfo, newRowMeta, this.calculateInfo.getStoreFieldMapList()));
        }
        return newResultDataSetX;
    }

    protected void beforeQuery() {
    }

    protected void afterQuery() {
    }

    protected DataSetX printDataSetX(DataSetX dataSetX, String tag) {
        DataSet dataSetAll = this.algoxOutputHelper.dataSetOutput(dataSetX);
        DataSet copy = dataSetAll.copy();
        this.printDataSet(copy, tag);
        return this.algoxOutputHelper.getSession().fromInput((Input)new DataSetInput(dataSetAll));
    }

    private void printDataSet(DataSet dataSet, String tag) {
        int index = 0;
        int count = 0;
        LOGGER.info("print_out_{},head:{}", (Object)tag, (Object)Arrays.toString(dataSet.getRowMeta().getFieldNames()));
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            LOGGER.info("print_out_{},detail:{}", (Object)tag, (Object)next.toString());
            ++index;
        }
        LOGGER.info("print_out_{},count:{}", (Object)tag, (Object)index);
        LOGGER.info("print_out_{},count:{}", (Object)tag, (Object)count);
    }

    public CalculateAlgoxParser getCalculateAlgoxParser() {
        return this.calculateAlgoxParser;
    }

    protected String getPartitionCacheKey(ReportCalculateInfo reportCalculateInfo, boolean isIncludeSubOrg) {
        Long id = reportCalculateInfo.getReportId() == null || reportCalculateInfo.getReportId() == 0L ? reportCalculateInfo.getAnObjRelId() : reportCalculateInfo.getReportId();
        return CacheUtils.generateCacheKey(id, reportCalculateInfo.getOriginFilters(), reportCalculateInfo.getRowFieldList(), reportCalculateInfo.getColumnFieldList(), isIncludeSubOrg);
    }

    protected IReportQueryPlan getReportQueryPlan() {
        return QueryServiceFactory.getReportQueryPlanByALgoX(this.calculateInfo, this.getComplexObjContext());
    }
}

