/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hrptmc.business.repcalculate.algox.func.AlgoxCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.AlgoXCalculateHelper;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;

public abstract class AlgoxTransposeCalculateReduceGroupFunction
extends AlgoxCalculateReduceGroupFunction {
    private static final long serialVersionUID = 4767270273059564125L;
    protected final RowFieldParser rowFieldParser;

    public AlgoxTransposeCalculateReduceGroupFunction(RowFieldParser rowFieldParser, AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO) {
        this.rowFieldParser = rowFieldParser;
        this.algoxCalculateReduceGroupDTO = algoxCalculateReduceGroupDTO;
        this.algoxCalculateHelper = new AlgoXCalculateHelper();
        this.algoxCalculateHelper.setNewRowMetaFields(this.getResultRowMeta().getFields());
    }

    public void setTransposeFieldResultRowX(RowX resultRowX, RowX rowX) {
        List<TransposeConfigInfo> transposeConfigInfoList = this.algoxCalculateReduceGroupDTO.getTransposeConfigInfoList();
        List<List<Map<String, Object>>> transposeDataList = this.algoxCalculateReduceGroupDTO.getTransposeDataList();
        for (int i = 0; i < transposeConfigInfoList.size(); ++i) {
            TransposeConfigInfo transposeConfigInfo = transposeConfigInfoList.get(i);
            List<Map<String, Object>> dataMapList = transposeDataList.get(i);
            this.parseTransposeFieldResultRowX(resultRowX, rowX, dataMapList, transposeConfigInfo);
        }
    }

    protected void parseTransposeFieldResultRowX(RowX resultRowX, RowX rowX, List<Map<String, Object>> dataMapList, TransposeConfigInfo transposeConfigInfo) {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        List<ReportField> transposeFieldList = transposeConfigInfo.getTransposeFieldList();
        List<ReportField> transposeValueFieldList = transposeConfigInfo.getTransposeValueFieldList();
        for (Map<String, Object> data : dataMapList) {
            boolean allLatitudeEqs = true;
            for (ReportField transposeLatitudeField : transposeFieldList) {
                String transposeFieldAlgoXAlias = this.rowFieldParser.getAlgoXAliasExtend(transposeLatitudeField);
                Object transposeLatitudeFieldValue = this.algoxCalculateHelper.getRowX(sourceRowMeta, rowX, transposeFieldAlgoXAlias);
                Object val = data.get(transposeLatitudeField.getUniqueKey());
                if (val == null || "".equals(val) || "null".equals(val)) {
                    val = " ";
                }
                if (transposeLatitudeFieldValue == null || "".equals(transposeLatitudeFieldValue) || "null".equals(transposeLatitudeFieldValue)) {
                    transposeLatitudeFieldValue = " ";
                }
                if (allLatitudeEqs = HRObjectUtils.equals((Object)val, (Object)transposeLatitudeFieldValue)) continue;
                break;
            }
            if (!allLatitudeEqs) continue;
            String transposeFieldPrefixStr = AlgoxTransposeCalculateReduceGroupFunction.getTransLatitudeHead(transposeFieldList, data, this.rowFieldParser).toString();
            this.setTransposeFieldResultRowX(resultRowX, rowX, transposeValueFieldList, transposeFieldPrefixStr);
            break;
        }
    }

    public static StringBuilder getTransLatitudeHead(List<ReportField> latitudeList, Map<String, Object> data, RowFieldParser rowFieldParser) {
        StringBuilder transUnkPrefix = new StringBuilder();
        StringBuilder transLatitudeVal = new StringBuilder();
        for (int i = 0; i < latitudeList.size(); ++i) {
            ReportField reportField = latitudeList.get(i);
            Object val = data.get(reportField.getUniqueKey());
            if (val == null || "".equals(val) || "null".equals(val)) {
                val = " ";
            }
            String transposeFieldAlgoXAlias = rowFieldParser.getAlgoXAliasExtend(reportField);
            transUnkPrefix.append(transposeFieldAlgoXAlias);
            transLatitudeVal.append(val);
            if (i >= latitudeList.size() - 1) continue;
            transUnkPrefix.append("\u03bb");
            transLatitudeVal.append("\u03b5");
        }
        transUnkPrefix.append('\u03b3').append((CharSequence)transLatitudeVal);
        return transUnkPrefix;
    }

    protected abstract void setTransposeFieldResultRowX(RowX var1, RowX var2, List<ReportField> var3, String var4);
}

