/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXEntityPrimitiveIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.AlgoxTransposeCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.RowMetaBuilder;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class DetailTransposeCalculateReduceGroupFunction
extends AlgoxTransposeCalculateReduceGroupFunction {
    private static final long serialVersionUID = -903967119886581914L;

    public DetailTransposeCalculateReduceGroupFunction(RowFieldParser rowFieldParser, AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO) {
        super(rowFieldParser, algoxCalculateReduceGroupDTO);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX resultRowX = new RowX(this.algoxCalculateHelper.getNewRowMetaFields().length);
        for (RowX rowX : iterable) {
            this.setLatitudeResultRowX(resultRowX, rowX);
            this.setEntityPrimitiveIndexResultRowX(resultRowX, rowX);
            this.setAggregateIndexResultRowX(resultRowX, rowX);
            this.setTransposeFieldResultRowX(resultRowX, rowX);
            this.setOrderResultRowX(resultRowX, rowX);
        }
        collector.collect(resultRowX);
    }

    public RowMeta getResultRowMeta() {
        boolean totalCalculate = this.algoxCalculateReduceGroupDTO.isTotalCalculate();
        RowSummaryInfo rowSummaryInfo = this.algoxCalculateReduceGroupDTO.getRowSummaryInfo();
        return new RowMetaBuilder("1", totalCalculate, rowSummaryInfo, this.algoxCalculateHelper, this.algoxCalculateReduceGroupDTO).createRowFieldBuilder(rowFieldBuilder -> rowFieldBuilder.addLatitudeField(this.algoxCalculateReduceGroupDTO.getRowLatitudeList()).addEntityPrimitiveIndexField(this.algoxCalculateReduceGroupDTO.getEntityPrimitiveIndexFieldList()).addRowOrderLatitudeField(this.algoxCalculateReduceGroupDTO.getRowOrderFieldList()).addAggregateIndexField(this.algoxCalculateReduceGroupDTO.getAggregateIndexFieldList())).createTransposeFieldBuilder(this.rowFieldParser, this.algoxCalculateReduceGroupDTO.getTransposeConfigInfoList(), this.algoxCalculateReduceGroupDTO.getTransposeDataList(), (transposeDataList, fieldName, transposeFieldBuilder) -> transposeFieldBuilder.addEntityPrimitiveIndexField((List<ReportField>)transposeDataList, (String)fieldName).addAggregateIndexField((List<ReportField>)transposeDataList, (String)fieldName).addPresetIndexField((List<ReportField>)transposeDataList, (String)fieldName)).buildRowMeta();
    }

    protected void setEntityPrimitiveIndexResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXEntityPrimitiveIndexAlgoXField algoxEntityPrimitiveIndexAlgoxField : this.algoxCalculateReduceGroupDTO.getEntityPrimitiveIndexFieldList()) {
            String algoXAliasExtend = algoxEntityPrimitiveIndexAlgoxField.getAlgoXAliasExtend();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                String calcFunction = this.getRowSummaryIndexFunction("sum", algoxEntityPrimitiveIndexAlgoxField.getUniqueKey());
                this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoXAliasExtend);
                continue;
            }
            this.algoxCalculateHelper.setResultRowX(this.sourceRowMeta, resultRowX, rowX, algoXAliasExtend);
        }
    }

    protected void setAggregateIndexResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXAggregateIndexAlgoXField algoxAggregateIndexAlgoxField : this.algoxCalculateReduceGroupDTO.getAggregateIndexFieldList()) {
            String algoXAliasExtend = algoxAggregateIndexAlgoxField.getAlgoXAliasExtend();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                String calcFunction = this.getRowSummaryIndexFunction("sum", algoxAggregateIndexAlgoxField.getUniqueKey());
                this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoXAliasExtend);
                continue;
            }
            this.algoxCalculateHelper.setResultRowX(this.sourceRowMeta, resultRowX, rowX, algoXAliasExtend);
        }
    }

    @Override
    protected void setTransposeFieldResultRowX(RowX resultRowX, RowX rowX, List<ReportField> transposeValueFieldList, String transposeFieldPrefixStr) {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        for (ReportField reportField : transposeValueFieldList) {
            StringBuilder fieldBuilder = new StringBuilder(transposeFieldPrefixStr);
            String algoXAliasExtend = "";
            if (reportField instanceof EntityPrimitiveIndexField) {
                EntityPrimitiveIndexField entityPrimitiveIndexField = (EntityPrimitiveIndexField)reportField;
                algoXAliasExtend = this.rowFieldParser.getAlgoXAliasExtend(entityPrimitiveIndexField);
            }
            if (reportField instanceof AggregateIndexField) {
                AggregateIndexField aggregateIndexField = (AggregateIndexField)reportField;
                algoXAliasExtend = this.rowFieldParser.getAlgoXAliasExtend(aggregateIndexField);
            }
            if (!HRStringUtils.isNotEmpty((String)algoXAliasExtend)) continue;
            String fieldName = fieldBuilder.append('\u03b2').append(algoXAliasExtend).toString();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                String calFunction = RowSummaryInfo.getTotalCalFunction(reportField.getUniqueKey(), "sum", this.algoxCalculateReduceGroupDTO.getRowSummaryInfo());
                this.setCalculateResultRowX(calFunction, resultRowX, rowX, algoXAliasExtend, fieldName);
                continue;
            }
            this.algoxCalculateHelper.setCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName);
        }
    }

    @Override
    protected void setCalculateResultRowX(String calcFunction, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        if (HRStringUtils.isNotEmpty((String)calcFunction)) {
            RowMeta sourceRowMeta = this.getSourceRowMeta();
            if ("sum".equals(calcFunction)) {
                this.algoxCalculateHelper.setDetailTransposeSumCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName);
            }
            if ("avg".equals(calcFunction)) {
                this.algoxCalculateHelper.setDetailTransposeAvgCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName);
            }
            if ("count".equals(calcFunction)) {
                this.algoxCalculateHelper.setCountCalculateResult(resultRowX, fieldName);
            }
        }
    }
}

