/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXPresetIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.AlgoXCalculateHelper;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.RowMetaBuilder;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;

public class TotalCalculateReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -7697352627276779808L;
    private final RowMeta rowMeta;
    private final AlgoXCalculateHelper algoxCalculateHelper;
    private final Map<String, AlgoXPresetIndexAlgoXField> presetIndexFieldMap;
    private final Set<String> nonAggIndexAliasExtends;
    private final RowSummaryInfo rowSummaryInfo;
    private final RowFieldParser rowFieldParser;
    private final String reportType;
    private final RowMeta newRowMeta;
    private final boolean isTranspose;

    public TotalCalculateReduceGroupFunction(ReportCalculateInfo reportCalculateInfo, RowFieldParser rowFieldParser, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.rowFieldParser = rowFieldParser;
        this.rowSummaryInfo = reportCalculateInfo.getRowSummaryInfo();
        this.reportType = reportCalculateInfo.getReportType();
        this.newRowMeta = this.getResultRowMeta();
        this.algoxCalculateHelper = new AlgoXCalculateHelper();
        this.algoxCalculateHelper.setNewRowMetaFields(this.newRowMeta.getFields());
        this.presetIndexFieldMap = rowFieldParser.getPresetIndexFieldList().stream().collect(Collectors.toMap(AlgoXField::getAlgoXAliasExtend, Function.identity()));
        this.isTranspose = reportCalculateInfo.getTransposeConfigInfoList() != null && !reportCalculateInfo.getTransposeConfigInfoList().isEmpty();
        this.nonAggIndexAliasExtends = reportCalculateInfo.getRowFieldListWithoutDp(true).stream().filter(reportField -> reportField instanceof NonAggregateIndexField).map(obj -> (NonAggregateIndexField)obj).map(index -> AlgoXCalculateAlgoXField.buildAlgoXAliasExtend(AlgoXFieldInfo.replaceAlgoxAlias((String)index.getFieldAlias()), index.getUniqueKey())).collect(Collectors.toSet());
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX resultRowX = new RowX(this.newRowMeta.getFieldCount());
        for (RowX rowX : iterable) {
            Field[] fields = this.rowMeta.getFields();
            int countIndex = this.algoxCalculateHelper.getValIndex("REPORT_COUNT_FIELD");
            if (countIndex > 0) {
                this.setTotalCountResultRowX(resultRowX, rowX);
            }
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String dataTypeName = field.getDataType().getName();
                if ("REPORT_COUNT_FIELD".equals(field.getAlias()) || !RowMetaBuilder.TOTALCALCULATE_SET.contains(dataTypeName)) continue;
                this.setTotalCalculateResultRowX(resultRowX, rowX, i, field.getAlias());
            }
        }
        collector.collect(resultRowX);
    }

    private void setTotalCalculateResultRowX(RowX resultRowX, RowX rowX, int index, String algoXAliasExtend) {
        if ("0".equals(this.reportType) || this.isTranspose) {
            if (algoXAliasExtend.contains("\u03b1")) {
                String[] tempArr = algoXAliasExtend.split("\u03b1");
                String fieldName = tempArr[0];
                String calculateSuffix = tempArr[1];
                if ("sum".equals(calculateSuffix) || "count".equals(calculateSuffix)) {
                    this.algoxCalculateHelper.setTotalSumCalculateResultRowX(resultRowX, rowX, index);
                } else if ("avg".equals(calculateSuffix)) {
                    if (this.presetIndexFieldMap.containsKey(fieldName)) {
                        AlgoXPresetIndexAlgoXField presetIndexAlgoXField = this.presetIndexFieldMap.get(fieldName);
                        Map<String, String> indexFunctionMap = this.rowSummaryInfo.getIndexFunctionMap();
                        if (indexFunctionMap != null) {
                            String function = indexFunctionMap.get(presetIndexAlgoXField.getUniqueKey());
                            if ("sum".equals(function)) {
                                this.algoxCalculateHelper.setTotalSumCalculateResultRowX(resultRowX, rowX, index);
                            } else if ("avg".equals(function)) {
                                this.algoxCalculateHelper.setNonAggIndexTotalAvgCalculateResultRowX(resultRowX, rowX, index, fieldName);
                            }
                        }
                    } else if (this.nonAggIndexAliasExtends.contains(fieldName)) {
                        this.algoxCalculateHelper.setNonAggIndexTotalAvgCalculateResultRowX(resultRowX, rowX, index, fieldName);
                    } else {
                        this.algoxCalculateHelper.setTotalAvgCalculateResultRowX(resultRowX, rowX, index, fieldName);
                    }
                }
            }
        } else {
            Object val = rowX.get(index);
            String uniqueKey = this.rowFieldParser.getUniqueKeyByAlgoXAliasExtend(algoXAliasExtend);
            String function = RowSummaryInfo.getTotalCalFunction(uniqueKey, "sum", this.rowSummaryInfo);
            BigDecimal calculateVal = new BigDecimal(String.valueOf(val == null ? Integer.valueOf(0) : val));
            int newIndex = this.algoxCalculateHelper.getValIndex(algoXAliasExtend);
            if ("avg".equals(function)) {
                String fieldKey = algoXAliasExtend + '\u03b1' + "avgsum";
                BigDecimal sumVal = this.algoxCalculateHelper.setSumAddCalculateResultRowX(resultRowX, calculateVal, fieldKey);
                String countFieldKey = algoXAliasExtend + '\u03b1' + "avgcount";
                BigDecimal countVal = this.algoxCalculateHelper.setSumAddCalculateResultRowX(resultRowX, BigDecimal.ONE, countFieldKey);
                BigDecimal avgVal = countVal.intValue() == 0 ? BigDecimal.ZERO : sumVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
                resultRowX.set(newIndex, (Object)avgVal);
            } else {
                BigDecimal nowVal = resultRowX.getBigDecimal(newIndex);
                if (nowVal == null) {
                    nowVal = BigDecimal.ZERO;
                }
                nowVal = nowVal.add(calculateVal);
                resultRowX.set(newIndex, (Object)nowVal);
            }
        }
    }

    private void setTotalCountResultRowX(RowX resultRowX, RowX rowX) {
        int newCountIndex = this.algoxCalculateHelper.getValIndex("REPORT_COUNT_FIELD");
        int oldCountIndex = this.algoxCalculateHelper.getOldFieldIndex(this.rowMeta, "REPORT_COUNT_FIELD");
        BigDecimal nowVal = resultRowX.getBigDecimal(newCountIndex);
        BigDecimal oldVal = rowX.getBigDecimal(oldCountIndex);
        if (nowVal == null) {
            nowVal = BigDecimal.ZERO;
        }
        if (oldVal == null) {
            oldVal = BigDecimal.ONE;
        }
        nowVal = nowVal.add(oldVal);
        resultRowX.set(newCountIndex, (Object)nowVal);
    }

    public final RowMeta getResultRowMeta() {
        return RowMetaBuilder.buildAlgoXTotalResultRowMeta(this.rowMeta, this.reportType, this.rowSummaryInfo, this.rowFieldParser);
    }
}

