/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func;

import java.util.Arrays;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXEntityPrimitiveIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXPresetIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.func.AlgoxTransposeCalculateReduceGroupFunction;
import kd.hr.hrptmc.business.repcalculate.algox.func.dto.AlgoxCalculateReduceGroupDTO;
import kd.hr.hrptmc.business.repcalculate.algox.func.util.RowMetaBuilder;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class TransposeCalculateReduceGroupFunction
extends AlgoxTransposeCalculateReduceGroupFunction {
    private static final long serialVersionUID = -9039671198806581914L;

    public TransposeCalculateReduceGroupFunction(RowFieldParser rowFieldParser, AlgoxCalculateReduceGroupDTO algoxCalculateReduceGroupDTO) {
        super(rowFieldParser, algoxCalculateReduceGroupDTO);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX resultRowX = new RowX(this.algoxCalculateHelper.getNewRowMetaFields().length);
        for (RowX rowX : iterable) {
            this.setLatitudeResultRowX(resultRowX, rowX);
            this.setEntityPrimitiveIndexResultRowX(resultRowX, rowX);
            this.setAggregateIndexResultRowX(resultRowX, rowX);
            this.setPresetIndexResultRowX(resultRowX, rowX);
            this.setTransposeFieldResultRowX(resultRowX, rowX);
            this.setOrderResultRowX(resultRowX, rowX);
        }
        collector.collect(resultRowX);
    }

    public RowMeta getResultRowMeta() {
        boolean totalCalculate = this.algoxCalculateReduceGroupDTO.isTotalCalculate();
        RowSummaryInfo rowSummaryInfo = this.algoxCalculateReduceGroupDTO.getRowSummaryInfo();
        return new RowMetaBuilder("0", totalCalculate, rowSummaryInfo, this.algoxCalculateHelper, this.algoxCalculateReduceGroupDTO).createRowFieldBuilder(rowFieldBuilder -> rowFieldBuilder.addLatitudeField(this.algoxCalculateReduceGroupDTO.getRowLatitudeList()).addEntityPrimitiveIndexField(this.algoxCalculateReduceGroupDTO.getEntityPrimitiveIndexFieldList()).addAggregateIndexField(this.algoxCalculateReduceGroupDTO.getAggregateIndexFieldList()).addRowOrderLatitudeField(this.algoxCalculateReduceGroupDTO.getRowOrderFieldList()).addPresetIndexField(this.algoxCalculateReduceGroupDTO.getPresetIndexFieldList())).createTransposeFieldBuilder(this.rowFieldParser, this.algoxCalculateReduceGroupDTO.getTransposeConfigInfoList(), this.algoxCalculateReduceGroupDTO.getTransposeDataList(), (transposeDataList, fieldName, transposeFieldBuilder) -> transposeFieldBuilder.addEntityPrimitiveIndexField((List<ReportField>)transposeDataList, (String)fieldName).addAggregateIndexField((List<ReportField>)transposeDataList, (String)fieldName).addPresetIndexField((List<ReportField>)transposeDataList, (String)fieldName)).buildRowMeta();
    }

    protected void setEntityPrimitiveIndexResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXEntityPrimitiveIndexAlgoXField algoxEntityPrimitiveIndexAlgoxField : this.algoxCalculateReduceGroupDTO.getEntityPrimitiveIndexFieldList()) {
            String calcFunction = algoxEntityPrimitiveIndexAlgoxField.getEntityPrimitiveIndexField().getCalcFunction();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                calcFunction = this.getRowSummaryIndexFunction(calcFunction, algoxEntityPrimitiveIndexAlgoxField.getUniqueKey());
            }
            this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoxEntityPrimitiveIndexAlgoxField.getAlgoXAliasExtend());
        }
    }

    protected void setAggregateIndexResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXAggregateIndexAlgoXField algoxAggregateIndexAlgoxField : this.algoxCalculateReduceGroupDTO.getAggregateIndexFieldList()) {
            String calcFunction = algoxAggregateIndexAlgoxField.getAggregateIndexField().getCalcFunction();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                calcFunction = this.getRowSummaryIndexFunction(calcFunction, algoxAggregateIndexAlgoxField.getUniqueKey());
            }
            this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoxAggregateIndexAlgoxField.getAlgoXAliasExtend());
        }
    }

    protected void setPresetIndexResultRowX(RowX resultRowX, RowX rowX) {
        for (AlgoXPresetIndexAlgoXField algoxPresetIndexAlgoxField : this.algoxCalculateReduceGroupDTO.getPresetIndexFieldList()) {
            if (!Arrays.stream(this.sourceRowMeta.getFields()).anyMatch(field -> HRStringUtils.equals((String)algoxPresetIndexAlgoxField.getAlgoXAliasExtend(), (String)field.getAlias()))) continue;
            String algoXAliasExtend = algoxPresetIndexAlgoxField.getAlgoXAliasExtend();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                String calcFunction = algoxPresetIndexAlgoxField.getPresetIndexField().getCalcFunction();
                calcFunction = this.getRowSummaryIndexFunction(calcFunction, algoxPresetIndexAlgoxField.getUniqueKey());
                this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoxPresetIndexAlgoxField.getAlgoXAliasExtend());
                continue;
            }
            this.algoxCalculateHelper.setAvgCalculateResultRowXForPreIndex(this.getSourceRowMeta(), resultRowX, rowX, algoXAliasExtend, algoXAliasExtend);
        }
    }

    @Override
    protected void setTransposeFieldResultRowX(RowX resultRowX, RowX rowX, List<ReportField> transposeValueFieldList, String transposeFieldPrefixStr) {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        for (ReportField reportField : transposeValueFieldList) {
            String fieldName;
            String calcFunction;
            String algoXAliasExtend;
            StringBuilder fieldBuilder = new StringBuilder(transposeFieldPrefixStr);
            if (reportField instanceof EntityPrimitiveIndexField) {
                EntityPrimitiveIndexField entityPrimitiveIndexField = (EntityPrimitiveIndexField)reportField;
                algoXAliasExtend = this.rowFieldParser.getAlgoXAliasExtend(entityPrimitiveIndexField);
                calcFunction = entityPrimitiveIndexField.getCalcFunction();
                if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                    calcFunction = this.getRowSummaryIndexFunction(calcFunction, reportField.getUniqueKey());
                }
                fieldName = fieldBuilder.append('\u03b2').append(algoXAliasExtend).toString();
                this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoXAliasExtend, fieldName);
                continue;
            }
            if (reportField instanceof AggregateIndexField) {
                AggregateIndexField aggregateIndexField = (AggregateIndexField)reportField;
                algoXAliasExtend = this.rowFieldParser.getAlgoXAliasExtend(aggregateIndexField);
                calcFunction = aggregateIndexField.getCalcFunction();
                if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                    calcFunction = this.getRowSummaryIndexFunction(calcFunction, reportField.getUniqueKey());
                }
                fieldName = fieldBuilder.append('\u03b2').append(algoXAliasExtend).toString();
                this.setCalculateResultRowX(calcFunction, resultRowX, rowX, algoXAliasExtend, fieldName);
                continue;
            }
            if (!(reportField instanceof PresetIndexField)) continue;
            PresetIndexField presetIndexField = (PresetIndexField)reportField;
            algoXAliasExtend = this.rowFieldParser.getAlgoXAliasExtend(presetIndexField);
            String fieldName2 = fieldBuilder.append('\u03b2').append(algoXAliasExtend).toString();
            if (this.algoxCalculateReduceGroupDTO.isTotalCalculate()) {
                String calcFunction2 = presetIndexField.getCalcFunction();
                calcFunction2 = this.getRowSummaryIndexFunction(calcFunction2, presetIndexField.getUniqueKey());
                this.setCalculateResultRowX(calcFunction2, resultRowX, rowX, algoXAliasExtend, fieldName2);
                continue;
            }
            this.algoxCalculateHelper.setAvgCalculateResultRowXForPreIndex(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName2);
        }
    }
}

