/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func.algo;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.RowFieldParser;

public class AlgoXAliasToUniqueKeyAlgoMapFunction
extends MapFunction {
    private static final long serialVersionUID = 5818491646587609431L;
    private final RowMeta oldRowMeta;
    private final RowFieldParser rowFieldParser;
    private final RowMeta newRowMeta;
    private final Map<String, Integer> newFieldAliasToIndexMap;
    private final Map<String, Set<Integer>> oldAliasToNewIndexSetMap;

    public AlgoXAliasToUniqueKeyAlgoMapFunction(RowMeta oldRowMeta, RowFieldParser rowFieldParser) {
        this.oldRowMeta = oldRowMeta;
        this.rowFieldParser = rowFieldParser;
        this.newRowMeta = this.buildResultRowMeta();
        this.newFieldAliasToIndexMap = this.getFieldIndexMap();
        this.oldAliasToNewIndexSetMap = this.getAlgoXFieldIndexMap();
    }

    public Object[] map(Row row) {
        Field[] fields;
        Object[] objects = new Object[this.newRowMeta.getFieldCount()];
        for (Field field : fields = this.oldRowMeta.getFields()) {
            String algoXAlias = field.getAlias();
            Set<Integer> indexList = this.oldAliasToNewIndexSetMap.get(algoXAlias);
            if (indexList == null) continue;
            for (Integer index : indexList) {
                objects[index.intValue()] = row.get(field.getName());
            }
        }
        return objects;
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }

    private RowMeta buildResultRowMeta() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field[] fields = this.oldRowMeta.getFields();
        HashSet fieldNameSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Field field : fields) {
            String algoXAlias = field.getAlias();
            Set<String> uniqueKeyList = this.rowFieldParser.getUniqueKeyByAlgoXAlias(algoXAlias);
            for (String uniqueKey : uniqueKeyList) {
                if (!fieldNameSet.add(uniqueKey)) continue;
                fieldList.add(new Field(uniqueKey, field.getDataType()));
            }
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    private Map<String, Set<Integer>> getAlgoXFieldIndexMap() {
        Field[] oldRowMetaFields = this.oldRowMeta.getFields();
        HashMap aliasToIndexListMap = Maps.newHashMapWithExpectedSize((int)this.oldRowMeta.getFieldCount());
        for (Field oldRowMetaField : oldRowMetaFields) {
            Set<String> uniqueKeyList = this.rowFieldParser.getUniqueKeyByAlgoXAlias(oldRowMetaField.getAlias());
            for (String uniqueKey : uniqueKeyList) {
                Integer index = this.newFieldAliasToIndexMap.get(uniqueKey);
                if (index == null) continue;
                aliasToIndexListMap.putIfAbsent(oldRowMetaField.getAlias(), Sets.newHashSetWithExpectedSize((int)uniqueKeyList.size()));
                aliasToIndexListMap.computeIfPresent(oldRowMetaField.getAlias(), (alias, indexSet) -> {
                    indexSet.add(index);
                    return indexSet;
                });
            }
        }
        return aliasToIndexListMap;
    }

    private Map<String, Integer> getFieldIndexMap() {
        HashMap fieldIndexMap = Maps.newHashMapWithExpectedSize((int)this.newRowMeta.getFieldCount());
        for (int index = 0; index < this.newRowMeta.getFieldCount(); ++index) {
            Field field = this.newRowMeta.getField(index);
            fieldIndexMap.put(field.getAlias(), index);
        }
        return fieldIndexMap;
    }
}

