/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.func.util;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.utils.ObjectComparable;

public class AlgoXCalculateHelper
implements Serializable {
    private static final long serialVersionUID = 6820695238733662240L;
    private Field[] newRowMetaFields;
    private Map<String, Integer> newFieldAliasToIndexMap;
    private Map<String, Integer> oldFieldAliasToIndexMap;

    public AlgoXCalculateHelper setNewRowMetaFields(Field[] newRowMetaFields) {
        this.newRowMetaFields = newRowMetaFields;
        this.newFieldAliasToIndexMap = Maps.newHashMapWithExpectedSize((int)newRowMetaFields.length);
        for (int index = 0; index < newRowMetaFields.length; ++index) {
            this.newFieldAliasToIndexMap.put(newRowMetaFields[index].getAlias(), index);
        }
        return this;
    }

    public Field[] getNewRowMetaFields() {
        return this.newRowMetaFields;
    }

    public void addCalculateField(List<Field> fieldList, Set<String> hasAddFieldSet, String calcFunction, String fieldName) {
        String fieldKey;
        if (HRStringUtils.isNotEmpty((String)calcFunction) && hasAddFieldSet.add(fieldKey = fieldName + '\u03b1' + calcFunction)) {
            if ("sum".equals(calcFunction)) {
                this.addCalculateField(fieldList, fieldName, "sum");
                this.addCalculateField(fieldList, fieldName, "avgsum");
                this.addCalculateField(fieldList, fieldName, "avgcount");
            }
            if ("avg".equals(calcFunction)) {
                this.addCalculateField(fieldList, fieldName, "avgsum");
                this.addCalculateField(fieldList, fieldName, "avgcount");
                this.addCalculateField(fieldList, fieldName, "avg");
            }
            if ("count".equals(calcFunction)) {
                this.addCalculateField(fieldList, fieldName, "count");
            }
            if ("deCount".equals(calcFunction)) {
                this.addCalculateField(fieldList, fieldName, "deCount");
                String countFieldKeyDist = fieldName + '\u03b1' + "deCount" + "\u03c9";
                fieldList.add(new Field(countFieldKeyDist, (DataType)DataType.StringType));
            }
            hasAddFieldSet.add(fieldKey);
        }
    }

    private void addCalculateField(List<Field> fieldList, String fieldName, String suffix) {
        fieldList.add(new Field(fieldName + '\u03b1' + suffix, (DataType)DataType.BigDecimalType));
    }

    public Object getRowX(RowMeta sourceRowMeta, RowX rowX, String algoXAliasExtend) {
        int index = this.getOldFieldIndex(sourceRowMeta, algoXAliasExtend);
        Object value = rowX.get(index);
        if (value instanceof Integer) {
            value = new BigDecimal(String.valueOf(value));
        }
        return value;
    }

    public void setResultRowX(RowMeta sourceRowMeta, RowX resultRowX, RowX rowX, String algoxAliasExtend) {
        Object val = this.getRowX(sourceRowMeta, rowX, algoxAliasExtend);
        int valIndex = this.getValIndex(algoxAliasExtend);
        resultRowX.set(valIndex, val);
    }

    public void setCalculateResultRowX(RowMeta sourceRowMeta, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        int calculateIndex = this.getOldFieldIndex(sourceRowMeta, algoXAliasExtend);
        BigDecimal calculateVal = rowX.getBigDecimal(calculateIndex);
        int valIndex = this.getValIndex(fieldName);
        Object nowValue = resultRowX.get(valIndex);
        if (calculateVal != null) {
            Object value = calculateVal;
            if (nowValue != null) {
                String order = "asc";
                Object headMostObject = ObjectComparable.getHeadMostObject(calculateVal, nowValue, order);
                value = headMostObject == null ? value : headMostObject;
            }
            resultRowX.set(valIndex, value);
        } else {
            resultRowX.set(valIndex, (Object)BigDecimal.ZERO);
        }
    }

    public void setSumCalculateResultRowX(RowMeta sourceRowMeta, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        int calculateIndex = this.getOldFieldIndex(sourceRowMeta, algoXAliasExtend);
        BigDecimal calculateVal = rowX.getBigDecimal(calculateIndex);
        String avgSumFieldKey = fieldName + '\u03b1' + "avgsum";
        int avgSumIndex = this.getValIndex(avgSumFieldKey);
        BigDecimal avgSumNowVal = resultRowX.getBigDecimal(avgSumIndex);
        if (avgSumNowVal == null) {
            avgSumNowVal = BigDecimal.ZERO;
        }
        avgSumNowVal = avgSumNowVal.add(calculateVal == null ? BigDecimal.ZERO : calculateVal);
        resultRowX.set(avgSumIndex, (Object)avgSumNowVal);
        String countFieldKey = fieldName + '\u03b1' + "avgcount";
        int countIndex = this.getValIndex(countFieldKey);
        BigDecimal countVal = resultRowX.getBigDecimal(countIndex);
        if (countVal == null) {
            countVal = BigDecimal.ZERO;
        }
        countVal = countVal.add(BigDecimal.ONE);
        resultRowX.set(countIndex, (Object)countVal);
        String fieldKey = fieldName + '\u03b1' + "sum";
        int valIndex = this.getValIndex(fieldKey);
        BigDecimal nowVal = resultRowX.getBigDecimal(valIndex);
        if (nowVal == null) {
            nowVal = BigDecimal.ZERO;
        }
        nowVal = nowVal.add(calculateVal == null ? BigDecimal.ZERO : calculateVal);
        resultRowX.set(valIndex, (Object)nowVal);
    }

    public void setAvgCalculateResultRowX(RowMeta sourceRowMeta, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        int calculateIndex = this.getOldFieldIndex(sourceRowMeta, algoXAliasExtend);
        this.setAvgCalculateResult(resultRowX, rowX, fieldName, calculateIndex);
    }

    public void setAvgCalculateResultRowXForPreIndex(RowMeta sourceRowMeta, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        int calculateIndex = this.getOldFieldIndex(sourceRowMeta, algoXAliasExtend);
        BigDecimal calculateVal = rowX.getBigDecimal(calculateIndex);
        String fieldKey = fieldName + '\u03b1' + "avgsum";
        int avgSumIndex = this.getValIndex(fieldKey);
        resultRowX.set(avgSumIndex, (Object)(calculateVal == null ? BigDecimal.ZERO : calculateVal));
        String countFieldKey = fieldName + '\u03b1' + "avgcount";
        int countIndex = this.getValIndex(countFieldKey);
        resultRowX.set(countIndex, (Object)BigDecimal.ONE);
        String avgFieldKey = fieldName + '\u03b1' + "avg";
        int avgIndex = this.getValIndex(avgFieldKey);
        if (avgIndex > -1) {
            resultRowX.set(avgIndex, (Object)(calculateVal == null ? BigDecimal.ZERO : calculateVal));
        }
    }

    public void setCountCalculateResult(RowX resultRowX, String fieldName) {
        String countFieldKey = fieldName + '\u03b1' + "count";
        int countIndex = this.getValIndex(countFieldKey);
        BigDecimal countVal = resultRowX.getBigDecimal(countIndex);
        if (countVal == null) {
            countVal = BigDecimal.ZERO;
        }
        countVal = countVal.add(BigDecimal.ONE);
        resultRowX.set(countIndex, (Object)countVal);
    }

    private void setAvgCalculateResult(RowX resultRowX, RowX rowX, String fieldName, int calculateIndex) {
        BigDecimal calculateVal = rowX.getBigDecimal(calculateIndex);
        String fieldKey = fieldName + '\u03b1' + "avgsum";
        int avgSumIndex = this.getValIndex(fieldKey);
        BigDecimal nowVal = resultRowX.getBigDecimal(avgSumIndex);
        if (nowVal == null) {
            nowVal = BigDecimal.ZERO;
        }
        nowVal = nowVal.add(calculateVal == null ? BigDecimal.ZERO : calculateVal);
        resultRowX.set(avgSumIndex, (Object)nowVal);
        String countFieldKey = fieldName + '\u03b1' + "avgcount";
        int countIndex = this.getValIndex(countFieldKey);
        BigDecimal countVal = resultRowX.getBigDecimal(countIndex);
        if (countVal == null) {
            countVal = BigDecimal.ZERO;
        }
        countVal = countVal.add(BigDecimal.ONE);
        resultRowX.set(countIndex, (Object)countVal);
        String avgFieldKey = fieldName + '\u03b1' + "avg";
        int avgIndex = this.getValIndex(avgFieldKey);
        if (avgIndex > -1) {
            BigDecimal avgVal = countVal.intValue() == 0 ? BigDecimal.ZERO : nowVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
            resultRowX.set(avgIndex, (Object)avgVal);
        }
    }

    public BigDecimal setTotalSumCalculateResultRowX(RowX resultRowX, RowX rowX, int index) {
        BigDecimal calculateVal = rowX.getBigDecimal(index);
        BigDecimal nowVal = resultRowX.getBigDecimal(index);
        if (nowVal == null) {
            nowVal = BigDecimal.ZERO;
        }
        nowVal = nowVal.add(calculateVal == null ? BigDecimal.ZERO : calculateVal);
        resultRowX.set(index, (Object)nowVal);
        return nowVal;
    }

    public BigDecimal setSumAddCalculateResultRowX(RowX resultRowX, BigDecimal sumAddValue, String fieldKey) {
        int avgSumIndex = this.getValIndex(fieldKey);
        BigDecimal resultValue = resultRowX.getBigDecimal(avgSumIndex);
        if (resultValue == null) {
            resultValue = BigDecimal.ZERO;
        }
        if (sumAddValue == null) {
            sumAddValue = BigDecimal.ZERO;
        }
        resultValue = resultValue.add(sumAddValue);
        resultRowX.set(avgSumIndex, (Object)resultValue);
        return resultValue;
    }

    public void setTotalAvgCalculateResultRowX(RowX resultRowX, RowX rowX, int index, String fieldName) {
        String fieldKey = fieldName + '\u03b1' + "avgsum";
        int avgSumIndex = this.getValIndex(fieldKey);
        BigDecimal sumVal = this.setTotalSumCalculateResultRowX(resultRowX, rowX, avgSumIndex);
        String countFieldKey = fieldName + '\u03b1' + "avgcount";
        int countIndex = this.getValIndex(countFieldKey);
        BigDecimal countVal = this.setTotalSumCalculateResultRowX(resultRowX, rowX, countIndex);
        BigDecimal avgVal = countVal.intValue() == 0 ? BigDecimal.ZERO : sumVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
        resultRowX.set(index, (Object)avgVal);
    }

    public void setNonAggIndexTotalAvgCalculateResultRowX(RowX resultRowX, RowX rowX, int index, String fieldName) {
        String fieldKey = fieldName + '\u03b1' + "avgsum";
        int avgSumIndex = this.getValIndex(fieldKey);
        BigDecimal sumVal = this.setTotalSumCalculateResultRowX(resultRowX, rowX, avgSumIndex);
        int countIndex = this.getValIndex("REPORT_COUNT_FIELD");
        BigDecimal countVal = resultRowX.getBigDecimal(countIndex);
        BigDecimal avgVal = countVal.intValue() == 0 ? BigDecimal.ZERO : sumVal.divide(countVal, 10, RoundingMode.HALF_DOWN);
        resultRowX.set(index, (Object)avgVal);
    }

    public int getValIndex(String fieldKey) {
        Integer index = this.newFieldAliasToIndexMap.get(fieldKey);
        if (index != null) {
            return index;
        }
        return -1;
    }

    public void setDetailTransposeSumCalculateResultRowX(RowMeta sourceRowMeta, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        this.setDetailTransposeCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName);
        String fieldKey = fieldName + '\u03b1' + "sum";
        this.setCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldKey);
    }

    public void setDetailTransposeAvgCalculateResultRowX(RowMeta sourceRowMeta, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        this.setDetailTransposeCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldName);
        String fieldKey = fieldName + '\u03b1' + "avg";
        this.setCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, fieldKey);
    }

    private void setDetailTransposeCalculateResultRowX(RowMeta sourceRowMeta, RowX resultRowX, RowX rowX, String algoXAliasExtend, String fieldName) {
        String avgSumFieldKey = fieldName + '\u03b1' + "avgsum";
        this.setCalculateResultRowX(sourceRowMeta, resultRowX, rowX, algoXAliasExtend, avgSumFieldKey);
        String countFieldKey = fieldName + '\u03b1' + "avgcount";
        int countIndex = this.getValIndex(countFieldKey);
        BigDecimal countVal = resultRowX.getBigDecimal(countIndex);
        if (countVal == null) {
            countVal = BigDecimal.ONE;
            resultRowX.set(countIndex, (Object)countVal);
        }
    }

    public int getOldFieldIndex(RowMeta oldRowMeta, String algoXAliasExtend) {
        Integer index;
        if (this.oldFieldAliasToIndexMap == null) {
            Field[] oldRowMetaFields = oldRowMeta.getFields();
            this.oldFieldAliasToIndexMap = Maps.newHashMapWithExpectedSize((int)oldRowMetaFields.length);
            for (int index2 = 0; index2 < oldRowMetaFields.length; ++index2) {
                this.oldFieldAliasToIndexMap.put(oldRowMetaFields[index2].getAlias(), index2);
            }
        }
        if ((index = this.oldFieldAliasToIndexMap.get(algoXAliasExtend)) == null) {
            index = -1;
        }
        return index;
    }
}

