/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.parser.specific;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXLatitudeAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.parser.AlgoXFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.utils.ParseUtils;
import kd.hr.hrptmc.business.repcalculate.algox.query.QueryServiceFactory;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.utils.ColumnAllValueHelper;
import kd.hr.hrptmc.business.repcalculate.utils.ReportFieldUtils;
import kd.hr.hrptmc.business.repcalculate.utils.SortFieldUtil;
import kd.hr.hrptmc.business.repcalculate.utils.sort.DimComparator;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;

public class ColFieldParser
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(ColFieldParser.class);
    private static final long serialVersionUID = -2372659187206227417L;
    protected AlgoXFieldParser algoXFieldParser;
    private final List<ReportField> columnFieldList;
    private final HRComplexObjContext complexObjContext;
    private final Map<String, AlgoXLatitudeAlgoXField> latitudeFieldMap = new LinkedHashMap<String, AlgoXLatitudeAlgoXField>(16);
    private final Map<String, AlgoXAggregateIndexAlgoXField> aggregateIndexFieldMap = new LinkedHashMap<String, AlgoXAggregateIndexAlgoXField>();
    private final Map<String, Map<String, AlgoXField>> allAliasFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private final boolean parseFlag;

    public ColFieldParser(ReportCalculateInfo calculateInfo, AlgoXFieldParser algoXFieldParser) {
        this.columnFieldList = calculateInfo.getColumnFieldList();
        this.algoXFieldParser = algoXFieldParser;
        this.complexObjContext = algoXFieldParser.getContext();
        this.parseFlag = this.init();
    }

    private boolean init() {
        if (CollectionUtils.isEmpty(this.columnFieldList)) {
            return false;
        }
        for (ReportField reportField : this.columnFieldList) {
            if (reportField instanceof LatitudeField) {
                LatitudeField latitudeField = (LatitudeField)reportField;
                this.putLatitudeField(latitudeField);
            }
            if (!(reportField instanceof AggregateIndexField)) continue;
            AggregateIndexField aggregateIndexField = (AggregateIndexField)reportField;
            this.putAggregateIndexField(aggregateIndexField);
        }
        return true;
    }

    private void putLatitudeField(LatitudeField latitudeField) {
        String fieldAlias = latitudeField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXLatitudeAlgoXField algoXLatitudeField = new AlgoXLatitudeAlgoXField(latitudeField, algoxFieldInfo);
        this.latitudeFieldMap.put(algoXLatitudeField.getAlgoXAliasExtend(), algoXLatitudeField);
        ParseUtils.addToAllAliasFieldMap(algoXLatitudeField, this.allAliasFieldMap);
    }

    private void putAggregateIndexField(AggregateIndexField aggregateIndexField) {
        String fieldAlias = aggregateIndexField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXAggregateIndexAlgoXField algoxAggregateIndexAlgoxField = new AlgoXAggregateIndexAlgoXField(aggregateIndexField, algoxFieldInfo);
        this.aggregateIndexFieldMap.put(algoxAggregateIndexAlgoxField.getAlgoXAliasExtend(), algoxAggregateIndexAlgoxField);
        ParseUtils.addToAllAliasFieldMap(algoxAggregateIndexAlgoxField, this.allAliasFieldMap);
    }

    public List<AlgoXCalculateAlgoXField> getLatitudeFieldList() {
        return ParseUtils.getLatitudeFieldList(this.columnFieldList, this.latitudeFieldMap, this.aggregateIndexFieldMap);
    }

    public List<Map<String, Object>> createColumnData(ReportCalculateInfo calculateInfo) {
        HRComplexObjContext context = new HRComplexObjContext();
        context.setQueryMode("2");
        List<ReportField> copyColumnFields = SortFieldUtil.resetDepSortField(this.columnFieldList);
        ArrayList<HRComplexObjFieldInfo> complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(copyColumnFields.size());
        for (ReportField reportField : copyColumnFields) {
            HRComplexObjFieldInfo complexObjFieldInfo = reportField instanceof EntityPropField ? ReportFieldUtils.entityField2ComplexField((EntityPropField)reportField) : ReportFieldUtils.aggregateIndexField2ComplexField((AggregateIndexField)reportField);
            complexObjFieldInfoList.add(complexObjFieldInfo);
        }
        List<ReportField> sortFields = ParseUtils.getSortFields(this.columnFieldList);
        context.setComplexObjFieldInfoList(complexObjFieldInfoList);
        context.setGroupFieldList(complexObjFieldInfoList);
        context.setTransferField(false);
        context.setDistinct(true);
        context.setReturnEnumOriginalValue(true);
        context.setEntityNumber(this.complexObjContext.getEntityNumber());
        context.setEntityTable(this.complexObjContext.getEntityTable());
        context.setJoinRelationList(this.complexObjContext.getJoinRelationList());
        context.setVirtualEntity(this.complexObjContext.getVirtualEntity());
        context.setVirtualEntityQueryParamInfo(ParseUtils.getVirtualEntityQueryParamInfoWithColList(this.complexObjContext, context, copyColumnFields));
        context.setVirtualEntityQueryService(this.complexObjContext.getVirtualEntityQueryService());
        context.setQfilterList(this.complexObjContext.getQfilterList());
        context.setOrder(false);
        context.setReturnDependOrderValue(true);
        SortFieldUtil.initSortField(context, copyColumnFields, calculateInfo.getReportId());
        context.setAlgoxJobKey(String.format("%s_column", this.complexObjContext.getAlgoxJobKey()));
        LOGGER.info("ColFieldParser_query_context_{}" + context);
        IReportQueryPlan reportQueryPlan = QueryServiceFactory.getReportQueryPlanByALgoX(calculateInfo, context);
        List dimensionData = reportQueryPlan.queryDimensionData();
        ColumnAllValueHelper columnValueHelper = new ColumnAllValueHelper(this.complexObjContext, this.columnFieldList);
        List<Map<String, DimensionData>> allDimValue = columnValueHelper.getAllDimensionData(dimensionData);
        if (!sortFields.isEmpty()) {
            allDimValue.sort(new DimComparator(sortFields));
        }
        return ColumnAllValueHelper.convertToObjMapList(allDimValue);
    }

    public List<String> getAlgoXAliasExtend(String algoXAlias) {
        ArrayList<String> algoXAliasExtendList = new ArrayList<String>();
        Map<String, AlgoXField> algoXFieldMap = this.allAliasFieldMap.get(algoXAlias);
        if (algoXFieldMap != null) {
            algoXAliasExtendList.addAll(algoXFieldMap.keySet());
        }
        return algoXAliasExtendList;
    }

    public boolean isParseFlag() {
        return this.parseFlag;
    }
}

