/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.algox.parser.specific;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algox.DataSetX;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXAggregateIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXCalculateAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXEntityPrimitiveIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXLatitudeAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXNonAggIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXOrderAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.field.AlgoXPresetIndexAlgoXField;
import kd.hr.hrptmc.business.repcalculate.algox.parser.AlgoXFieldParser;
import kd.hr.hrptmc.business.repcalculate.algox.parser.specific.utils.ParseUtils;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class RowFieldParser
implements Serializable {
    private static final long serialVersionUID = 183197466249346977L;
    private final List<ReportField> rowFieldList;
    protected AlgoXFieldParser algoXFieldParser;
    private final Map<String, AlgoXLatitudeAlgoXField> latitudeFieldMap = new LinkedHashMap<String, AlgoXLatitudeAlgoXField>();
    private final Map<String, AlgoXEntityPrimitiveIndexAlgoXField> entityPrimitiveIndexFieldMap = new LinkedHashMap<String, AlgoXEntityPrimitiveIndexAlgoXField>();
    private final Map<String, AlgoXAggregateIndexAlgoXField> aggregateIndexFieldMap = new LinkedHashMap<String, AlgoXAggregateIndexAlgoXField>();
    private final Map<String, AlgoXPresetIndexAlgoXField> presetIndexFieldMap = new LinkedHashMap<String, AlgoXPresetIndexAlgoXField>();
    private final Map<String, AlgoXNonAggIndexAlgoXField> nonAggIndexFieldMap = new LinkedHashMap<String, AlgoXNonAggIndexAlgoXField>();
    private final List<AlgoXOrderAlgoXField> rowOrderFieldList = Lists.newArrayListWithExpectedSize((int)10);
    private Map<String, OrderField> queryOrderFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, Map<String, AlgoXField>> allAliasFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private boolean parseFlag;

    public RowFieldParser(IReportQueryPlan reportQueryPlan, ReportCalculateInfo calculateInfo, AlgoXFieldParser algoXFieldParser) {
        this.initQueryOrder(reportQueryPlan);
        this.rowFieldList = calculateInfo.getRowFieldList();
        this.algoXFieldParser = algoXFieldParser;
        this.parseFlag = this.init(calculateInfo);
    }

    private boolean init(ReportCalculateInfo calculateInfo) {
        boolean parseFlag = false;
        if (!kd.bos.orm.util.CollectionUtils.isEmpty(this.rowFieldList)) {
            for (ReportField reportField : this.rowFieldList) {
                if (reportField instanceof LatitudeField) {
                    LatitudeField latitudeField = (LatitudeField)reportField;
                    this.putLatitudeField(latitudeField, calculateInfo);
                }
                if (reportField instanceof EntityPrimitiveIndexField) {
                    EntityPrimitiveIndexField entityPrimitiveIndexField = (EntityPrimitiveIndexField)reportField;
                    this.putEntityPrimitiveIndexField(entityPrimitiveIndexField);
                }
                if (reportField instanceof AggregateIndexField) {
                    AggregateIndexField aggregateIndexField = (AggregateIndexField)reportField;
                    this.putAggregateIndexField(aggregateIndexField);
                }
                if (reportField instanceof PresetIndexField) {
                    this.putPresetIndexField((PresetIndexField)reportField);
                }
                if (!(reportField instanceof NonAggregateIndexField)) continue;
                this.putNonAggIndexField((NonAggregateIndexField)reportField);
            }
            if (this.rowOrderFieldList.stream().anyMatch(field -> field.getOrderSeq() != null)) {
                this.rowOrderFieldList.removeIf(field -> field.getOrderSeq() == null);
                this.rowOrderFieldList.sort(Comparator.comparingInt(AlgoXOrderAlgoXField::getOrderSeq));
            }
            parseFlag = true;
        }
        return parseFlag;
    }

    private void initQueryOrder(IReportQueryPlan reportQueryPlan) {
        List orderFields = reportQueryPlan.getOrderFields();
        if (orderFields != null) {
            this.queryOrderFieldMap = orderFields.stream().collect(Collectors.toMap(OrderField::getAlias, orderField -> orderField, (x, y) -> x));
        }
    }

    private void putLatitudeField(LatitudeField latitudeField, ReportCalculateInfo calculateInfo) {
        String fieldAlias = latitudeField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXLatitudeAlgoXField algoXLatitudeField = new AlgoXLatitudeAlgoXField(latitudeField, algoxFieldInfo);
        this.latitudeFieldMap.put(algoXLatitudeField.getAlgoXAliasExtend(), algoXLatitudeField);
        ParseUtils.addToAllAliasFieldMap(algoXLatitudeField, this.allAliasFieldMap);
        String sortOrder = latitudeField.getSortord();
        AdminOrgSummaryInfo adminOrgSummaryInfo = calculateInfo.getAdminOrgSummaryInfo();
        if (adminOrgSummaryInfo != null && adminOrgSummaryInfo.getTreeShow()) {
            return;
        }
        if (!SortEnum.NONE.getValue().equals(sortOrder)) {
            OrderField orderField = this.queryOrderFieldMap.get(fieldAlias);
            if (orderField != null) {
                AlgoXOrderAlgoXField orderAlgoXField = new AlgoXOrderAlgoXField(orderField, (ReportField)latitudeField, SortEnum.CUSTOM.getValue().equals(sortOrder));
                orderAlgoXField.setDependSortField(latitudeField.isDependField());
                this.rowOrderFieldList.add(orderAlgoXField);
            } else if ("0".equals(calculateInfo.getReportType()) || CollectionUtils.isNotEmpty(calculateInfo.getTransposeConfigInfoList())) {
                orderField = new OrderField(fieldAlias, fieldAlias, DataTypeEnum.of((String)latitudeField.getFieldType()), SortEnum.ASC.getValue(), false);
                AlgoXOrderAlgoXField orderAlgoXField = new AlgoXOrderAlgoXField(orderField, (ReportField)latitudeField, false);
                this.rowOrderFieldList.add(orderAlgoXField);
            }
        }
    }

    private void putEntityPrimitiveIndexField(EntityPrimitiveIndexField entityPrimitiveIndexField) {
        String fieldAlias = entityPrimitiveIndexField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXEntityPrimitiveIndexAlgoXField algoXEntityPrimitiveIndexField = new AlgoXEntityPrimitiveIndexAlgoXField(entityPrimitiveIndexField, algoxFieldInfo);
        this.entityPrimitiveIndexFieldMap.put(algoXEntityPrimitiveIndexField.getAlgoXAliasExtend(), algoXEntityPrimitiveIndexField);
        ParseUtils.addToAllAliasFieldMap(algoXEntityPrimitiveIndexField, this.allAliasFieldMap);
    }

    private void putAggregateIndexField(AggregateIndexField aggregateIndexField) {
        String fieldAlias = aggregateIndexField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXAggregateIndexAlgoXField algoxAggregateIndexAlgoxField = new AlgoXAggregateIndexAlgoXField(aggregateIndexField, algoxFieldInfo);
        this.aggregateIndexFieldMap.put(algoxAggregateIndexAlgoxField.getAlgoXAliasExtend(), algoxAggregateIndexAlgoxField);
        ParseUtils.addToAllAliasFieldMap(algoxAggregateIndexAlgoxField, this.allAliasFieldMap);
    }

    private void putPresetIndexField(PresetIndexField presetIndexField) {
        String fieldAlias = presetIndexField.getFieldAlias();
        AlgoXFieldInfo algoxFieldInfo = this.algoXFieldParser.getAlgoXFieldInfo(fieldAlias);
        AlgoXPresetIndexAlgoXField algoxPresetIndexAlgoxField = new AlgoXPresetIndexAlgoXField(presetIndexField, algoxFieldInfo);
        this.presetIndexFieldMap.put(algoxPresetIndexAlgoxField.getAlgoXAliasExtend(), algoxPresetIndexAlgoxField);
        ParseUtils.addToAllAliasFieldMap(algoxPresetIndexAlgoxField, this.allAliasFieldMap);
    }

    private void putNonAggIndexField(NonAggregateIndexField nonAggregateIndexField) {
        AlgoXNonAggIndexAlgoXField algoXNonAggIndexAlgoXField = new AlgoXNonAggIndexAlgoXField(nonAggregateIndexField);
        this.nonAggIndexFieldMap.put(algoXNonAggIndexAlgoXField.getAlgoXAliasExtend(), algoXNonAggIndexAlgoXField);
    }

    public List<AlgoXCalculateAlgoXField> getLatitudeFieldList() {
        return ParseUtils.getLatitudeFieldList(this.rowFieldList, this.latitudeFieldMap, this.aggregateIndexFieldMap);
    }

    public List<AlgoXEntityPrimitiveIndexAlgoXField> getEntityPrimitiveIndexFieldList() {
        return this.entityPrimitiveIndexFieldMap.values().stream().filter(algoXEntityPrimitiveIndexAlgoXField -> !algoXEntityPrimitiveIndexAlgoXField.getEntityPrimitiveIndexField().isDependField()).collect(Collectors.toList());
    }

    public List<AlgoXAggregateIndexAlgoXField> getAggregateIndexFieldList() {
        return this.aggregateIndexFieldMap.values().stream().filter(algoXAggregateIndexAlgoXField -> algoXAggregateIndexAlgoXField.getAggregateIndexField().isIndexField()).filter(algoXAggregateIndexAlgoXField -> !algoXAggregateIndexAlgoXField.getAggregateIndexField().isDependField()).collect(Collectors.toList());
    }

    public List<AlgoXPresetIndexAlgoXField> getPresetIndexFieldList() {
        return this.presetIndexFieldMap.values().stream().filter(algoXPresetIndexAlgoXField -> !algoXPresetIndexAlgoXField.getPresetIndexField().isDependField()).collect(Collectors.toList());
    }

    public List<AlgoXEntityPrimitiveIndexAlgoXField> getEntityPrimitiveIndexFieldListWithDp() {
        return new ArrayList<AlgoXEntityPrimitiveIndexAlgoXField>(this.entityPrimitiveIndexFieldMap.values());
    }

    public List<AlgoXAggregateIndexAlgoXField> getAggregateIndexFieldListWithDp() {
        return this.aggregateIndexFieldMap.values().stream().filter(algoXAggregateIndexAlgoXField -> algoXAggregateIndexAlgoXField.getAggregateIndexField().isIndexField()).collect(Collectors.toList());
    }

    public List<AlgoXPresetIndexAlgoXField> getPresetIndexFieldListWithDp() {
        return new ArrayList<AlgoXPresetIndexAlgoXField>(this.presetIndexFieldMap.values());
    }

    public String getUniqueKeyByAlgoXAliasExtend(String algoXAliasExtend) {
        AlgoXLatitudeAlgoXField latitudeAlgoXField = this.latitudeFieldMap.get(algoXAliasExtend);
        if (latitudeAlgoXField != null) {
            return latitudeAlgoXField.getLatitudeField().getUniqueKey();
        }
        AlgoXEntityPrimitiveIndexAlgoXField algoXEntityPrimitiveIndexAlgoxField = this.entityPrimitiveIndexFieldMap.get(algoXAliasExtend);
        if (algoXEntityPrimitiveIndexAlgoxField != null) {
            return algoXEntityPrimitiveIndexAlgoxField.getEntityPrimitiveIndexField().getUniqueKey();
        }
        AlgoXAggregateIndexAlgoXField algoXAggregateIndexAlgoxField = this.aggregateIndexFieldMap.get(algoXAliasExtend);
        if (algoXAggregateIndexAlgoxField != null) {
            return algoXAggregateIndexAlgoxField.getAggregateIndexField().getUniqueKey();
        }
        AlgoXPresetIndexAlgoXField algoXPresetIndexAlgoxField = this.presetIndexFieldMap.get(algoXAliasExtend);
        if (algoXPresetIndexAlgoxField != null) {
            return algoXPresetIndexAlgoxField.getPresetIndexField().getUniqueKey();
        }
        AlgoXNonAggIndexAlgoXField algoXNonAggIndexAlgoXField = this.nonAggIndexFieldMap.get(algoXAliasExtend);
        if (algoXNonAggIndexAlgoXField != null) {
            return algoXNonAggIndexAlgoXField.getNonAggregateIndexField().getUniqueKey();
        }
        return null;
    }

    public boolean checkIfDependField(String algoXAliasExtend) {
        AlgoXLatitudeAlgoXField latitudeAlgoXField = this.latitudeFieldMap.get(algoXAliasExtend);
        if (latitudeAlgoXField != null) {
            return latitudeAlgoXField.getLatitudeField().isDependField();
        }
        return false;
    }

    public String getAlgoXAliasExtend(ReportField reportField) {
        Map<String, AlgoXField> algoXExtendToFieldMap = this.allAliasFieldMap.get(AlgoXFieldInfo.replaceAlgoxAlias((String)reportField.getFieldAlias()));
        if (algoXExtendToFieldMap != null) {
            for (Map.Entry<String, AlgoXField> algoXFieldEntry : algoXExtendToFieldMap.entrySet()) {
                AlgoXField algoXField = algoXFieldEntry.getValue();
                if (!algoXField.getUniqueKey().equals(reportField.getUniqueKey())) continue;
                return algoXField.getAlgoXAliasExtend();
            }
        }
        return null;
    }

    public Set<String> getUniqueKeyByAlgoXAlias(String algoXAlias) {
        AlgoXPresetIndexAlgoXField algoXPresetIndexAlgoXField;
        HashSet algoXAliasExtendList = Sets.newHashSetWithExpectedSize((int)16);
        Map<String, AlgoXField> algoXExtendToFieldMap = this.allAliasFieldMap.get(algoXAlias);
        if (algoXExtendToFieldMap != null) {
            for (Map.Entry<String, AlgoXField> algoXFieldEntry : algoXExtendToFieldMap.entrySet()) {
                AlgoXField algoXField = algoXFieldEntry.getValue();
                algoXAliasExtendList.add(algoXField.getUniqueKey());
            }
        }
        if ((algoXPresetIndexAlgoXField = this.presetIndexFieldMap.get(algoXAlias)) != null) {
            algoXAliasExtendList.add(algoXPresetIndexAlgoXField.getUniqueKey());
        }
        return algoXAliasExtendList;
    }

    public Set<String> getAlgoXAliasExtend(String algoXAlias) {
        HashSet algoXAliasExtendList = Sets.newHashSetWithExpectedSize((int)16);
        Map<String, AlgoXField> algoXExtendToFieldMap = this.allAliasFieldMap.get(algoXAlias);
        if (algoXExtendToFieldMap != null) {
            for (Map.Entry entry : algoXExtendToFieldMap.entrySet()) {
                AlgoXField algoXField = (AlgoXField)entry.getValue();
                algoXAliasExtendList.add(algoXField.getAlgoXAliasExtend());
            }
        }
        for (AlgoXPresetIndexAlgoXField algoXPresetIndexAlgoXField : this.presetIndexFieldMap.values()) {
            if (!algoXPresetIndexAlgoXField.getAlgoXAlias().equals(algoXAlias) && !algoXPresetIndexAlgoXField.getAlgoXAliasExtend().equals(algoXAlias)) continue;
            algoXAliasExtendList.add(algoXPresetIndexAlgoXField.getAlgoXAliasExtend());
        }
        for (AlgoXOrderAlgoXField algoXOrderAlgoXField : this.rowOrderFieldList) {
            if (!algoXOrderAlgoXField.getAlgoXAlias().equals(algoXAlias) && !algoXOrderAlgoXField.getAlgoXAliasExtend().equals(algoXAlias)) continue;
            algoXAliasExtendList.add(algoXOrderAlgoXField.getAlgoXAliasExtend());
        }
        return algoXAliasExtendList;
    }

    public List<AlgoXOrderAlgoXField> getRowOrderFieldList() {
        return this.rowOrderFieldList;
    }

    public String[] getRowOrderAliasExtendArray(DataSetX dataSetX) {
        HRComplexObjContext context = this.algoXFieldParser.getContext();
        HashSet fieldSet = Sets.newHashSetWithExpectedSize((int)this.allAliasFieldMap.size());
        List<AlgoXCalculateAlgoXField> latitudeFieldList = null;
        if ("2".equals(context.getQueryMode())) {
            latitudeFieldList = this.getLatitudeFieldList();
        }
        ArrayList orderList = Lists.newArrayListWithExpectedSize((int)this.rowOrderFieldList.size());
        for (AlgoXOrderAlgoXField orderAlgoXField : this.rowOrderFieldList) {
            String algoXAliasExtend = orderAlgoXField.getAlgoXAliasExtend();
            int fieldIndex = dataSetX.getRowMeta().getFieldIndex(algoXAliasExtend, false);
            if (fieldIndex == -1 || !fieldSet.add(algoXAliasExtend)) continue;
            orderList.add(algoXAliasExtend + " " + orderAlgoXField.getOrder());
        }
        if (latitudeFieldList != null && !latitudeFieldList.isEmpty()) {
            for (AlgoXCalculateAlgoXField algoXField : latitudeFieldList) {
                int fieldIndex;
                if (!fieldSet.add(algoXField.getAlgoXAliasExtend()) || (fieldIndex = dataSetX.getRowMeta().getFieldIndex(algoXField.getAlgoXAliasExtend(), false)) == -1) continue;
                orderList.add(algoXField.getAlgoXAliasExtend() + " " + SortFieldInfo.SORTORD_ASC);
            }
        }
        return orderList.toArray(new String[0]);
    }

    public boolean isParseFlag() {
        return this.parseFlag;
    }

    public Map<String, OrderField> getQueryOrderFieldMap() {
        return this.queryOrderFieldMap;
    }
}

