/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.chart.adapter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.exception.ReportQueryBizException;
import kd.hr.hrptmc.business.repdesign.info.DrillingInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyCellInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.chart.RptChartResult;
import kd.hr.hrptmc.common.util.HRReportParamUtils;

public abstract class AbstractRptChartQueryAdapter {
    private static final Log log = LogFactory.getLog(AbstractRptChartQueryAdapter.class);
    protected int queryThreshold = HRReportParamUtils.getChartQueryThreshold();
    protected static long dimensionMaxDataCount = 2000L;

    public long getDimensionMaxDataCount() {
        return dimensionMaxDataCount;
    }

    public abstract void assembleReportField(ReportQueryParamInfo var1);

    public void adaptChartData(ReportQueryParamInfo reportQueryParamInfo, ReportInfo reportInfo) {
        if (this.isExceedThreshold(reportInfo)) {
            throw new ReportQueryBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8fd0\u7b97\u7ed3\u679c\u6570\u636e\u8d85\u8fc7%s\uff0c\u56fe\u8868\u65e0\u6cd5\u6b63\u5e38\u663e\u793a\u3002", (String)"AbstractRptChartQueryAdapter_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), this.queryThreshold));
        }
        try {
            this.doAdaptChartData(reportQueryParamInfo, reportInfo);
            this.handleJumpAndDrilling(reportQueryParamInfo.getReportManageConfigInfo(), reportInfo);
            this.clearOriginReportResult(reportInfo);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56fe\u8868\u67e5\u8be2\u5931\u8d25\u3002", (String)"AbstractRptChartQueryAdapter_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), this.queryThreshold));
        }
    }

    protected abstract void doAdaptChartData(ReportQueryParamInfo var1, ReportInfo var2);

    protected boolean isExceedThreshold(ReportInfo reportInfo) {
        if (reportInfo.getBody().size() > this.queryThreshold) {
            return true;
        }
        if (reportInfo.getBody().size() > 0) {
            int colSize = reportInfo.getBody().get(0).getR().size();
            return reportInfo.getBody().size() * colSize > this.queryThreshold;
        }
        return false;
    }

    protected void handleJumpAndDrilling(ReportManageConfigInfo rptManageConfigInfo, ReportInfo reportInfo) {
        RptChartResult chartResult = reportInfo.getChartResult();
        if (chartResult == null) {
            return;
        }
        List<String> rowFields = this.getAllRowField(rptManageConfigInfo.getRows());
        DrillingInfo drillingInfo = rptManageConfigInfo.getReportConfig().getDrillingInfo();
        if (null != drillingInfo && !CollectionUtils.isEmpty(drillingInfo.getReplaceMap())) {
            chartResult.setDrilling(this.containDrillingField(rptManageConfigInfo, new ArrayList<String>(drillingInfo.getReplaceMap().values())));
        } else {
            chartResult.setDrilling(this.containDrillingField(rptManageConfigInfo, rowFields));
        }
        if (HRStringUtils.isEmpty((String)chartResult.getDrillingField())) {
            chartResult.setJump(!CollectionUtils.isEmpty(rptManageConfigInfo.getReportConfig().getReportJumpConfigList()));
        }
    }

    private void clearOriginReportResult(ReportInfo reportInfo) {
        reportInfo.getBody().clear();
        reportInfo.setHead(null);
    }

    private boolean containDrillingField(ReportManageConfigInfo reportManageConfigInfo, List<String> fields) {
        return this.getDrillingField(reportManageConfigInfo).stream().anyMatch(fields::contains);
    }

    private List<String> getDrillingField(ReportManageConfigInfo reportManageConfigInfo) {
        ArrayList<String> drillingField = new ArrayList<String>(10);
        Map<String, String> drillingDrl = reportManageConfigInfo.getDrillingDrl();
        if (null != drillingDrl && !drillingDrl.isEmpty()) {
            for (String value : drillingDrl.values()) {
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                drillingField.addAll(Arrays.asList(value.split(",")));
                drillingField.remove(drillingField.size() - 1);
            }
        }
        return drillingField;
    }

    private List<String> getAllRowField(List<RowFieldInfo> rowFieldInfoList) {
        return rowFieldInfoList.stream().map(row -> row.getGroupName().getNumber()).collect(Collectors.toList());
    }

    protected List<String> getRowDims(ReportHeadInfo head, ReportManageConfigInfo reportManageConfigInfo, RptChartResult chartResult) {
        List<FieldInfo> legend = reportManageConfigInfo.getReportConfig().getLegend();
        if (legend != null && !legend.isEmpty()) {
            return head.getHf().stream().filter(headHf -> !headHf.getHasChildren()).map(info -> {
                if (!StringUtils.isEmpty((CharSequence)info.getDrillingKey())) {
                    chartResult.setDrillingField(this.getNumberAlias(info.getCodeAlias()));
                    return info.getDrillingKey();
                }
                return info.getCodeAlias();
            }).collect(Collectors.toList());
        }
        List dimList = reportManageConfigInfo.getCurWorkRpt().getRows().stream().filter(rowField -> HRStringUtils.equals((String)rowField.getGroupName().getType(), (String)"1")).map(rowField -> rowField.getGroupName().getNumberAlias()).collect(Collectors.toList());
        return head.getHf().stream().map(info -> {
            if (!StringUtils.isEmpty((CharSequence)info.getDrillingKey())) {
                chartResult.setDrillingField(this.getNumberAlias(info.getCodeAlias()));
                return info.getDrillingKey();
            }
            return info.getCodeAlias();
        }).filter(dimList::contains).collect(Collectors.toList());
    }

    protected String getNumberAlias(String codeAlias) {
        int index = codeAlias.indexOf("\u03b6");
        if (index != -1) {
            codeAlias = codeAlias.substring(0, index);
        }
        return codeAlias;
    }

    protected List<Object> collectTypes(List<ReportBodyRowInfo> body, List<String> rowDims, RptChartResult chartResult) {
        ArrayList typeList = Lists.newArrayListWithCapacity((int)10);
        typeList.add("type");
        ArrayList dimValues = Lists.newArrayListWithCapacity((int)10);
        for (ReportBodyRowInfo reportBodyRowInfo : body) {
            List<ReportBodyCellInfo> cellInfoList = reportBodyRowInfo.getR();
            StringBuilder typeSb = new StringBuilder();
            HashSet drillingFieldSet = Sets.newHashSetWithExpectedSize((int)cellInfoList.size());
            HashMap dimValueMap = Maps.newHashMapWithExpectedSize((int)rowDims.size());
            for (String rowDim : rowDims) {
                for (ReportBodyCellInfo cellInfo : cellInfoList) {
                    if (HRStringUtils.equals((String)cellInfo.getK(), (String)rowDim)) {
                        typeSb.append(cellInfo.getV()).append("-");
                        dimValueMap.put(rowDim, cellInfo.getV());
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)chartResult.getDrillingField()) || !cellInfo.getK().contains(chartResult.getDrillingField()) || !drillingFieldSet.add(chartResult.getDrillingField())) continue;
                    typeSb.append(cellInfo.getV()).append("-");
                    dimValueMap.put(chartResult.getDrillingField(), cellInfo.getV());
                }
            }
            dimValues.add(dimValueMap);
            if (typeSb.length() > 0) {
                typeList.add(typeSb.substring(0, typeSb.length() - 1));
                continue;
            }
            typeList.add(typeSb.toString());
        }
        chartResult.setDimValues(dimValues);
        return typeList;
    }
}

