/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.chart.adapter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.chart.adapter.AbstractRptChartQueryAdapter;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyCellInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.chart.RptPieChartResult;

public class RptPieChartQueryAdapter
extends AbstractRptChartQueryAdapter {
    @Override
    public void assembleReportField(ReportQueryParamInfo reportQueryParamInfo) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        reportQueryParamInfo.setLimit(this.queryThreshold + 1);
        reportQueryParamInfo.setStart(0);
        List rowIndexes = reportManageConfigInfo.getColumns().stream().map(RowFieldInfo::new).collect(Collectors.toList());
        reportManageConfigInfo.getRows().addAll(rowIndexes);
        reportManageConfigInfo.getColumns().clear();
        reportManageConfigInfo.getReportConfig().setType("0");
    }

    @Override
    protected void doAdaptChartData(ReportQueryParamInfo reportQueryParamInfo, ReportInfo reportInfo) {
        ReportManageConfigInfo rptManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        ReportHeadInfo head = reportInfo.getHead();
        List<ReportBodyRowInfo> body = reportInfo.getBody();
        FieldInfo firstIndex = this.getFirstIndex(rptManageConfigInfo);
        this.sortBody(body, firstIndex);
        Map<String, String> headMap = reportInfo.getHead().getHf().stream().collect(Collectors.toMap(ReportHeadRowInfo::getCodeAlias, ReportHeadRowInfo::getName));
        RptPieChartResult chartResult = new RptPieChartResult();
        List<String> rowDims = this.getRowDims(head, rptManageConfigInfo, chartResult);
        this.collectTypes(body, rowDims, chartResult);
        List<String> indexes = this.getIndexes(reportQueryParamInfo.getReportManageConfigInfo());
        String legend = HRStringUtils.isNotEmpty((String)chartResult.getDrillingField()) ? chartResult.getDrillingField() : rptManageConfigInfo.getRows().get(0).getGroupName().getNumberAlias();
        ArrayList indexDataList = Lists.newArrayListWithCapacity((int)16);
        ArrayList dataList = Lists.newArrayListWithCapacity((int)16);
        if (!body.isEmpty()) {
            ReportBodyRowInfo firstReportBodyRowInfo = body.get(0);
            int dimIndex = 0;
            int[] indexIndexList = new int[indexes.size()];
            block0: for (int i = 0; i < firstReportBodyRowInfo.getR().size(); ++i) {
                ReportBodyCellInfo cellInfo = firstReportBodyRowInfo.getR().get(i);
                if (HRStringUtils.equals((String)legend, (String)cellInfo.getK()) || HRStringUtils.equals((String)legend, (String)this.getNumberAlias(cellInfo.getK()))) {
                    dimIndex = i;
                    continue;
                }
                for (int j = 0; j < indexes.size(); ++j) {
                    if (!HRStringUtils.equals((String)indexes.get(j), (String)cellInfo.getK())) continue;
                    indexIndexList[j] = i;
                    continue block0;
                }
            }
            for (ReportBodyRowInfo reportBodyRowInfo : body) {
                RptPieChartResult.IndexData indexData = new RptPieChartResult.IndexData();
                ArrayList indexList = Lists.newArrayListWithCapacity((int)16);
                RptPieChartResult.Data pieData = new RptPieChartResult.Data();
                List<ReportBodyCellInfo> rowInfo = reportBodyRowInfo.getR();
                ReportBodyCellInfo dimCell = rowInfo.get(dimIndex);
                indexData.setName((String)dimCell.getV());
                pieData.setName((String)dimCell.getV());
                int[] nArray = indexIndexList;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer index = nArray[i];
                    ReportBodyCellInfo indexCellInfo = rowInfo.get(index);
                    if (HRStringUtils.equals((String)firstIndex.getNumberAlias(), (String)indexCellInfo.getK())) {
                        pieData.setValue(indexCellInfo.getV());
                    }
                    indexList.add(new RptPieChartResult.Data(headMap.get(indexCellInfo.getK()), indexCellInfo.getV()));
                }
                dataList.add(pieData);
                indexData.setData(indexList);
                indexDataList.add(indexData);
            }
        }
        chartResult.setLegend(dataList.stream().map(RptPieChartResult.Data::getName).collect(Collectors.toList()));
        chartResult.setData(dataList);
        chartResult.setIndexData(indexDataList);
        reportInfo.setChartResult(chartResult);
    }

    private FieldInfo getFirstIndex(ReportManageConfigInfo rptManageConfigInfo) {
        for (RowFieldInfo rowFieldInfo : rptManageConfigInfo.getRows()) {
            if (!"2".equals(rowFieldInfo.getGroupName().getType())) continue;
            return rowFieldInfo.getGroupName();
        }
        return new FieldInfo();
    }

    private List<String> getIndexes(ReportManageConfigInfo rptManageConfigInfo) {
        ArrayList indexes = Lists.newArrayListWithCapacity((int)rptManageConfigInfo.getRows().size());
        for (RowFieldInfo rowFieldInfo : rptManageConfigInfo.getRows()) {
            if (!"2".equals(rowFieldInfo.getGroupName().getType())) continue;
            indexes.add(rowFieldInfo.getGroupName().getNumberAlias());
        }
        return indexes;
    }

    private void sortBody(List<ReportBodyRowInfo> body, FieldInfo firstIndex) {
        if (SortEnum.ASC.getValue().equals(firstIndex.getSort())) {
            body.sort((o1, o2) -> (int)Math.ceil(this.getIndexValue((ReportBodyRowInfo)o1, firstIndex) - this.getIndexValue((ReportBodyRowInfo)o2, firstIndex)));
        } else if (SortEnum.DESC.getValue().equals(firstIndex.getSort())) {
            body.sort((o1, o2) -> (int)Math.ceil(this.getIndexValue((ReportBodyRowInfo)o2, firstIndex) - this.getIndexValue((ReportBodyRowInfo)o1, firstIndex)));
        }
    }

    private double getIndexValue(ReportBodyRowInfo row, FieldInfo firstIndex) {
        return Double.parseDouble(((String)row.getR().stream().filter(info -> HRStringUtils.equals((String)info.getK(), (String)firstIndex.getNumberAlias())).findAny().orElseGet(ReportBodyCellInfo::new).getV()).replace("%", ""));
    }
}

