/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.ReportRow;
import kd.hr.hrptmc.business.repcalculate.org.helper.AdminOrgCalHelper;
import kd.hr.hrptmc.business.repcalculate.org.model.AdminOrg;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import org.apache.commons.lang3.SerializationUtils;

public class CalResult
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(CalResult.class);
    private static final long serialVersionUID = 2084605694902047445L;
    private Long orgId;
    private Long parentOrgId;
    private String longOrgId;
    private Row rowData;
    private List<CalResult> childResultList;

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getParentOrgId() {
        return this.parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getLongOrgId() {
        return this.longOrgId;
    }

    public void setLongOrgId(String longOrgId) {
        this.longOrgId = longOrgId;
    }

    public Row getRowData() {
        return this.rowData;
    }

    public void setRowData(Row rowData) {
        this.rowData = rowData;
    }

    public List<CalResult> getChildResultList() {
        return this.childResultList;
    }

    public void setChildResultList(List<CalResult> childResultList) {
        this.childResultList = childResultList;
    }

    public void addChildResult(CalResult childResult) {
        if (this.childResultList == null) {
            this.childResultList = Lists.newArrayListWithExpectedSize((int)10);
        }
        this.childResultList.add(childResult);
    }

    public static List<CalResult> buildResult(AdminOrgSummaryInfo adminOrgSummaryInfo, String pageId, DataSet dataSet) {
        if (adminOrgSummaryInfo != null && adminOrgSummaryInfo.getTreeShow()) {
            return CalResult.buildTreeResult(adminOrgSummaryInfo, pageId, dataSet);
        }
        return CalResult.buildCommonResult(dataSet);
    }

    private static List<CalResult> buildCommonResult(DataSet dataSet) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)10);
        int queryCount = 0;
        RowMeta rowMeta = dataSet.getRowMeta();
        for (Row row : dataSet) {
            CalResult calResult = new CalResult();
            if (row instanceof AbstractRow) {
                calResult.setRowData((Row)new ReportRow(rowMeta, ((AbstractRow)row).values()));
            } else {
                Object[] values = new Object[rowMeta.getFieldCount()];
                for (int index = 0; index < rowMeta.getFieldCount(); ++index) {
                    values[index] = row.get(index);
                }
                calResult.setRowData((Row)new ReportRow(rowMeta, values));
            }
            results.add(calResult);
            ++queryCount;
        }
        LOGGER.info("buildCommonResult_query_count_is_{}", (Object)queryCount);
        return results;
    }

    private static List<CalResult> buildTreeResult(AdminOrgSummaryInfo adminOrgSummaryInfo, String pageId, DataSet dataSet) {
        Integer returnLevel;
        Map<Long, AdminOrg> adminOrgMap = adminOrgSummaryInfo.getAdminOrgIdMap();
        ArrayList results = Lists.newArrayListWithExpectedSize((int)1);
        if (adminOrgMap == null) {
            return results;
        }
        AdminOrg rootOrg = adminOrgMap.get(adminOrgSummaryInfo._getRootOrgId());
        RowMeta rowMeta = dataSet.getRowMeta();
        if (rootOrg == null) {
            return results;
        }
        int orgIdIndex = rowMeta.getFieldIndex(adminOrgSummaryInfo.getAdminOrgSelectField());
        int[] orgNumberAliasIndexArray = IntStream.range(0, rowMeta.getFieldCount()).filter(index -> HRStringUtils.isNotEmpty((String)rowMeta.getField(index).getAlias()) && rowMeta.getField(index).getAlias().startsWith(adminOrgSummaryInfo.getAdminOrgFieldPrefix() + "." + "number")).toArray();
        int[] orgNameAliasIndexArray = IntStream.range(0, rowMeta.getFieldCount()).filter(index -> HRStringUtils.isNotEmpty((String)rowMeta.getField(index).getAlias()) && rowMeta.getField(index).getAlias().startsWith(adminOrgSummaryInfo.getAdminOrgFieldPrefix() + "." + "name")).toArray();
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet copy = dataSet.copy();
        int queryCount = 0;
        for (Row row : copy) {
            Long orgId = row.getLong(orgIdIndex);
            rowMap.put(orgId, row);
            ++queryCount;
        }
        LOGGER.info("buildTreeResult_query_count_is_{}", (Object)queryCount);
        CalResult rootResult = CalResult.getTreeResult(null, rootOrg, rowMeta, orgNumberAliasIndexArray, orgNameAliasIndexArray, adminOrgSummaryInfo, rowMap);
        if (HRStringUtils.isNotEmpty((String)pageId) && adminOrgSummaryInfo.getInsertCache()) {
            AdminOrgCalHelper.putCalResultIntoCache(pageId, rowMeta, Lists.newArrayList((Object[])new CalResult[]{(CalResult)SerializationUtils.clone((Serializable)rootResult)}));
        }
        Integer tempReturnLevel = (returnLevel = CalResult.getReturnLevel(adminOrgSummaryInfo)) == null ? null : (returnLevel < 2 ? Integer.valueOf(2) : returnLevel);
        CalResult.cutLevelData(rootResult, tempReturnLevel, CalResult.getBottomIsNull(adminOrgSummaryInfo, returnLevel));
        results.add(rootResult);
        return results;
    }

    private static CalResult getTreeResult(CalResult parentResult, AdminOrg currentOrg, RowMeta rowMeta, int[] orgNumberAliasIndexArray, int[] orgNameAliasIndexArray, AdminOrgSummaryInfo adminOrgSummaryInfo, Map<Long, Row> rowMap) {
        String longOrgId;
        Set<Long> authorityOrgIds = adminOrgSummaryInfo.getAuthorityOrgIds();
        boolean hasAllOrgPerm = authorityOrgIds == null;
        CalResult currentResult = new CalResult();
        long orgId = currentOrg.getOrgId();
        Row row = rowMap.get(orgId);
        currentResult.setOrgId(orgId);
        currentResult.setParentOrgId(currentOrg.getParentOrgId());
        boolean deadLoop = false;
        if (parentResult != null) {
            if (parentResult.getLongOrgId().contains(orgId + "!")) {
                LOGGER.error("CalResult_dead_loop_parentLongId={},currentId={}", (Object)parentResult.getLongOrgId(), (Object)orgId);
                deadLoop = true;
            }
            longOrgId = parentResult.getLongOrgId() + currentResult.getOrgId() + "!";
        } else {
            longOrgId = currentResult.getOrgId() + "!";
        }
        currentResult.setLongOrgId(longOrgId);
        if (row == null) {
            ReportRow emptyRow = new ReportRow(rowMeta);
            for (int orgAliasIndex : orgNumberAliasIndexArray) {
                emptyRow.set(orgAliasIndex, currentOrg.getShowValue("number"));
            }
            for (int orgAliasIndex : orgNameAliasIndexArray) {
                emptyRow.set(orgAliasIndex, currentOrg.getShowValue("name"));
            }
            currentResult.setRowData((Row)emptyRow);
        } else {
            ReportRow resultRow = new ReportRow(rowMeta, row);
            Field[] fields = rowMeta.getFields();
            if (!hasAllOrgPerm && !authorityOrgIds.contains(orgId)) {
                for (int index = 0; index < fields.length; ++index) {
                    String aliasName = fields[index].getName();
                    if (!aliasName.contains("\u03b1")) continue;
                    resultRow.set(index, null);
                }
            }
            currentResult.setRowData((Row)resultRow);
        }
        if (deadLoop) {
            return currentResult;
        }
        List<AdminOrg> childOrgList = currentOrg.getChildOrgList();
        if (childOrgList != null && !childOrgList.isEmpty()) {
            ArrayList childResults = Lists.newArrayListWithExpectedSize((int)childOrgList.size());
            for (AdminOrg childOrg : childOrgList) {
                childResults.add(CalResult.getTreeResult(currentResult, childOrg, rowMeta, orgNumberAliasIndexArray, orgNameAliasIndexArray, adminOrgSummaryInfo, rowMap));
            }
            currentResult.setChildResultList(childResults);
        }
        return currentResult;
    }

    public static void cutLevelData(CalResult calResult, Integer returnLevel, boolean bottomLevelSetNull) {
        if (returnLevel == null || calResult == null) {
            return;
        }
        List<CalResult> childResultList = calResult.getChildResultList();
        if (returnLevel == 1 && bottomLevelSetNull) {
            if (childResultList != null && !childResultList.isEmpty()) {
                ArrayList childData = Lists.newArrayList();
                childData.add(null);
                calResult.setChildResultList(childData);
            }
            return;
        }
        if (returnLevel <= 1) {
            calResult.setChildResultList(null);
            return;
        }
        Integer n = returnLevel;
        Integer n2 = returnLevel = Integer.valueOf(returnLevel - 1);
        if (childResultList != null && !childResultList.isEmpty()) {
            for (CalResult child : childResultList) {
                CalResult.cutLevelData(child, returnLevel, bottomLevelSetNull);
            }
        }
    }

    public static long getTreeShowTotalValue(List<CalResult> calResults) {
        long total = 0L;
        if (calResults != null) {
            total += (long)calResults.size();
            for (CalResult calResult : calResults) {
                total += CalResult.getChildResultTotalValue(calResult);
            }
        }
        return total;
    }

    public static long getChildResultTotalValue(CalResult calResult) {
        List<CalResult> childResultList;
        long childTotal = 0L;
        if (calResult != null && (childResultList = calResult.getChildResultList()) != null) {
            childTotal += (long)childResultList.size();
            for (CalResult childResult : childResultList) {
                childTotal += CalResult.getChildResultTotalValue(childResult);
            }
        }
        return childTotal;
    }

    public static Integer getReturnLevel(AdminOrgSummaryInfo adminOrgSummaryInfo) {
        if (adminOrgSummaryInfo == null) {
            return null;
        }
        Integer currentLevel = adminOrgSummaryInfo.getCurrentLevel();
        Integer summaryLevel = adminOrgSummaryInfo.getSummaryLevel();
        if (adminOrgSummaryInfo.getShowAllSummaryLevel()) {
            return summaryLevel;
        }
        if (summaryLevel == null) {
            return 2;
        }
        if (currentLevel == null) {
            currentLevel = 0;
        }
        return Math.min(summaryLevel - currentLevel, 2);
    }

    public static boolean getBottomIsNull(AdminOrgSummaryInfo adminOrgSummaryInfo, Integer returnLevel) {
        if (adminOrgSummaryInfo == null) {
            return true;
        }
        Integer currentLevel = adminOrgSummaryInfo.getCurrentLevel();
        Integer summaryLevel = adminOrgSummaryInfo.getSummaryLevel();
        if (summaryLevel == null) {
            return true;
        }
        if (adminOrgSummaryInfo.getShowAllSummaryLevel()) {
            return false;
        }
        if (currentLevel == null) {
            currentLevel = 0;
        }
        if (returnLevel == null) {
            returnLevel = 0;
        }
        return currentLevel + returnLevel <= summaryLevel && summaryLevel != 1;
    }
}

