/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.ColumnNode;
import kd.hr.hrptmc.business.repcalculate.model.ColumnSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.utils.ReportFieldMethodInvokeUtil;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import org.apache.commons.collections.CollectionUtils;

public class ColumnDataTree {
    private ColumnNode root = null;
    private RowSummaryInfo rowSummaryInfo;
    private boolean isTotalCalculate;

    public ColumnNode getRoot() {
        return this.root;
    }

    public void addChild(ColumnNode parent, ColumnNode child) {
        parent.getChildren().add(child);
    }

    public void addChildToFirst(ColumnNode parent, ColumnNode child) {
        parent.getChildren().add(0, child);
    }

    public List<String> dfsTraversal(ColumnNode node, String prex) {
        return this.dfsTraversal(node, prex, "leaf");
    }

    public List<String> dfsTraversal(ColumnNode node, String prex, String endCondition) {
        ArrayList<String> result = new ArrayList<String>();
        if (node == null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        if (prex != null) {
            sb.append(prex);
        }
        if (!node.getData().equals("root")) {
            if (node.getPrex() != null) {
                sb.append(node.getPrex());
            }
            sb.append(node.getData());
        }
        if ("leaf".equals(endCondition) && node.isLeaf()) {
            result.add(sb.toString());
            return result;
        }
        if ("total".equals(endCondition) && node.isTotalField()) {
            result.add(sb.toString());
            return result;
        }
        prex = sb.toString();
        for (ColumnNode child : node.getChildren()) {
            result.addAll(this.dfsTraversal(child, prex, endCondition));
        }
        return result;
    }

    public void addSubTotalNode(List<Map<String, Object>> columnListMap, ReportField[] columnLatitudeArr, ColumnSummaryInfo columnSummaryInfo) {
        if (columnSummaryInfo == null) {
            return;
        }
        List<String> subTotalLatitudes = columnSummaryInfo.getSubTotalLatitudes();
        if (columnSummaryInfo.isShowSubTotalCol() && CollectionUtils.isNotEmpty(subTotalLatitudes)) {
            for (Map<String, Object> data : columnListMap) {
                LinkedHashMap<String, Object> parentDataMap = new LinkedHashMap<String, Object>(16);
                for (int i = 0; i < columnLatitudeArr.length - 1; ++i) {
                    ReportField reportField = columnLatitudeArr[i];
                    String uniqueKey = reportField.getUniqueKey();
                    Object dataVal = this.getDataVal(data, reportField);
                    parentDataMap.put(uniqueKey, dataVal);
                    if (!subTotalLatitudes.contains(uniqueKey)) continue;
                    ColumnNode parentNode = this.findNodeByParent(this.root, parentDataMap);
                    String subTotalNodeVal = columnSummaryInfo.getSubTotalColName().toString();
                    if (parentNode.getChildren().stream().anyMatch(node -> subTotalNodeVal.equals(node.getData()))) continue;
                    ColumnNode subTotalNode = new ColumnNode(subTotalNodeVal, subTotalNodeVal);
                    subTotalNode.setPrex("\u03b7");
                    subTotalNode.setTotalField(true);
                    if ("left".equals(columnSummaryInfo.getShowLocation())) {
                        this.addChildToFirst(parentNode, subTotalNode);
                        continue;
                    }
                    this.addChild(parentNode, subTotalNode);
                }
            }
        }
    }

    public void addTotalNode(ColumnNode node, ColumnSummaryInfo columnSummaryInfo) {
        if (columnSummaryInfo != null && columnSummaryInfo.isShowTotalCol()) {
            ColumnNode totalColNode = new ColumnNode(columnSummaryInfo.getTotalColName().toString(), columnSummaryInfo.getTotalColName().toString());
            totalColNode.setPrex("\u03b8");
            totalColNode.setSubTotalField(true);
            if ("left".equals(columnSummaryInfo.getShowLocation())) {
                this.addChildToFirst(node, totalColNode);
            } else {
                this.addChild(node, totalColNode);
            }
        }
    }

    public void addIndexLeaf(ColumnNode node, ReportField[] rowIndexArr, ColumnSummaryInfo columnSummaryInfo) {
        if (node.isLeaf()) {
            node.setSameEnd(true);
            Map<String, String> indexCalcFunctionMap = null;
            if (columnSummaryInfo != null) {
                indexCalcFunctionMap = columnSummaryInfo.getSubTotalIndexCalcFunctionMap();
            }
            for (ReportField indexField : rowIndexArr) {
                ColumnNode idxColumn = new ColumnNode(indexField.getUniqueKey(), indexField.getUniqueKey());
                idxColumn.setPrex("\u03b2");
                String calcFunction = ReportFieldMethodInvokeUtil.invokeMethod(indexField, "getCalcFunction", String.class);
                if ((node.isTotalField() || node.isSubTotalField()) && indexCalcFunctionMap != null) {
                    calcFunction = indexField instanceof PresetIndexField ? "avg" : indexCalcFunctionMap.get(indexField.getUniqueKey());
                }
                if (!HRStringUtils.isEmpty((String)(calcFunction = this.getRowSummaryIndexFunction(indexField.getUniqueKey(), calcFunction))) && !"rownummax".equals(calcFunction)) {
                    ColumnNode cal = new ColumnNode(calcFunction, calcFunction);
                    cal.setPrex("\u03b1");
                    ColumnNode count = new ColumnNode("avgsum", "avgsum");
                    count.setPrex("\u03b1");
                    ColumnNode sum = new ColumnNode("avgcount", "avgcount");
                    sum.setPrex("\u03b1");
                    this.addChild(idxColumn, cal);
                    this.addChild(idxColumn, count);
                    this.addChild(idxColumn, sum);
                }
                this.addChild(node, idxColumn);
            }
        } else {
            for (ColumnNode child : node.getChildren()) {
                this.addIndexLeaf(child, rowIndexArr, columnSummaryInfo);
            }
        }
    }

    public void convertToTree(List<Map<String, Object>> columnListMap, ReportField[] columnLatitudeArr, String specialPrex) {
        this.root = new ColumnNode(null, "root");
        for (Map<String, Object> data : columnListMap) {
            ReportField parentLatitude = null;
            LinkedHashMap<String, Object> parentDataMap = new LinkedHashMap<String, Object>(16);
            for (ReportField latitudeField : columnLatitudeArr) {
                String uniqueKey = latitudeField.getUniqueKey();
                Object val = this.getDataVal(data, latitudeField);
                ColumnNode parentNode = this.root;
                if (parentLatitude != null) {
                    Object parentData = this.getDataVal(data, parentLatitude);
                    parentDataMap.put(parentLatitude.getUniqueKey(), parentData);
                    parentNode = this.findNodeByParent(this.root, parentDataMap);
                }
                if (!parentNode.getChildren().stream().anyMatch(node -> val.equals(node.getData()))) {
                    ColumnNode childNode = new ColumnNode(uniqueKey, val);
                    if (parentLatitude != null) {
                        childNode.setPrex("\u03b5");
                    } else if (HRStringUtils.isNotEmpty((String)specialPrex)) {
                        childNode.setPrex(specialPrex);
                    }
                    this.addChild(parentNode, childNode);
                }
                parentLatitude = latitudeField;
            }
        }
    }

    private ColumnNode findNodeByParent(ColumnNode node, Map<String, Object> parentDataMap) {
        ColumnNode searchNode = node;
        for (Map.Entry<String, Object> entry : parentDataMap.entrySet()) {
            ColumnNode childRen = this.findChildRen(searchNode, entry.getKey(), entry.getValue());
            if (childRen == null) continue;
            searchNode = childRen;
        }
        return searchNode;
    }

    private ColumnNode findChildRen(ColumnNode node, String key, Object data) {
        List<ColumnNode> children = node.getChildren();
        Optional<ColumnNode> matchNode = children.stream().filter(n -> key.equals(n.getKey()) && data.equals(n.getData())).findAny();
        return matchNode.orElse(null);
    }

    private Object getDataVal(Map<String, Object> data, ReportField latitudeField) {
        Object val = data.get(latitudeField.getUniqueKey());
        if (val == null) {
            val = data.get(latitudeField.getFieldAlias());
        }
        if (val == null || val.toString().equals("")) {
            val = " ";
        }
        return val;
    }

    public void setRowSummaryInfo(RowSummaryInfo rowSummaryInfo) {
        this.rowSummaryInfo = rowSummaryInfo;
    }

    public void setTotalCalculate(boolean totalCalculate) {
        this.isTotalCalculate = totalCalculate;
    }

    private String getRowSummaryIndexFunction(String indexUniqueKey, String originalFunction) {
        String summaryFunction;
        Map<String, String> indexFunctionMap;
        String indexFunction = originalFunction;
        if (this.isTotalCalculate && this.rowSummaryInfo != null && (indexFunctionMap = this.rowSummaryInfo.getIndexFunctionMap()) != null && HRStringUtils.isNotEmpty((String)(summaryFunction = indexFunctionMap.get(indexUniqueKey)))) {
            indexFunction = summaryFunction;
        }
        return indexFunction;
    }
}

