/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.cache;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.mvc.cache.PageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.CalResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public interface AdminOrgCacheInterface {
    public static final String ROW_META_FIELD_NAMES_CACHE_KEY = "rowMeta_fieldNames";
    public static final String ROW_META_DATA_TYPES_CACHE_KEY = "rowMeta_DataTypes";

    public ReportResult getCacheCalResult(String var1, AdminOrgSummaryInfo var2);

    public void putCalResultIntoCache(String var1, RowMeta var2, List<CalResult> var3);

    public boolean cleanCalResultCache(String var1);

    public boolean isCacheServiceHeath();

    default public RowMeta buildRowMeta(String pageId) {
        PageCache pageCache = new PageCache(pageId);
        String rowMetaFieldNames = pageCache.get(ROW_META_FIELD_NAMES_CACHE_KEY);
        String rowMetaDataTypes = pageCache.get(ROW_META_DATA_TYPES_CACHE_KEY);
        if (HRStringUtils.isEmpty((String)rowMetaDataTypes) || HRStringUtils.isEmpty((String)rowMetaFieldNames)) {
            return null;
        }
        String[] fieldNames = (String[])SerializationUtils.fromJsonString((String)rowMetaFieldNames, String[].class);
        int[] dataTypeIntArray = (int[])SerializationUtils.fromJsonString((String)rowMetaDataTypes, int[].class);
        DataType[] dataTypes = (DataType[])Arrays.stream(dataTypeIntArray).boxed().map(DataType::fromSqlType).toArray(DataType[]::new);
        return new RowMeta(fieldNames, dataTypes);
    }

    default public void putRowMetaIntoCache(String pageId, RowMeta rowMeta) {
        PageCache pageCache = new PageCache(pageId);
        pageCache.put(ROW_META_FIELD_NAMES_CACHE_KEY, SerializationUtils.toJsonString((Object)rowMeta.getFieldNames()));
        pageCache.put(ROW_META_DATA_TYPES_CACHE_KEY, SerializationUtils.toJsonString(Arrays.stream(rowMeta.getDataTypes()).map(DataType::toSqlType).collect(Collectors.toList())));
    }

    public boolean clearCalResultCache(String var1);
}

