/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.repcalculate.org.cache.disc;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.algo.RowMeta;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.DiskTempFileCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repcalculate.model.CalResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repcalculate.org.cache.AdminOrgCacheInterface;
import kd.hr.hrptmc.business.repcalculate.org.cache.disc.Tag;
import kd.hr.hrptmc.business.repcalculate.org.cache.disc.TempDiskObj;
import kd.hr.hrptmc.business.repcalculate.org.cache.es.ReportEsStorageService;
import kd.hr.hrptmc.business.repcalculate.org.constants.ReportOrgConstants;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AdminOrgDiskCache
implements AdminOrgCacheInterface,
ReportOrgConstants {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgDiskCache.class);
    private final TempFileCache tempFileService = new DiskTempFileCache();
    private static final int TIME_OUT = 86400;
    private static final String CONFIG_KEY = "tempfile.disk";
    private static final String CAL_RESULT_URL_SET_CACHE_KEY = "calResultUrlSetCacheKey";
    private static final String CAL_RESULT_ID_CACHE_KEY_PREFIX = "calResultId:";
    private static final String CONFIG_FIELD_ID = "id";
    private static final String CONFIG_DISK_CACHE_PATH = "diskcache.path";
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"AdminOrgDiskCacheThreadPool", (int)ZkConfig.getNumOfWorkThread());

    @Override
    public ReportResult getCacheCalResult(String pageId, AdminOrgSummaryInfo adminOrgSummaryInfo) {
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            long parentOrgId = adminOrgSummaryInfo._getRootOrgId();
            if (parentOrgId == 0L) {
                parentOrgId = OrgUnitServiceHelper.getRootOrgId();
            }
            long finalParentOrgId = parentOrgId;
            PageCache pageCache = new PageCache(pageId);
            RowMeta rowMeta = this.buildRowMeta(pageId);
            if (rowMeta == null) {
                return null;
            }
            String urlSetStr = pageCache.get(CAL_RESULT_URL_SET_CACHE_KEY);
            if (HRStringUtils.isEmpty((String)urlSetStr)) {
                return null;
            }
            List fileUrlKeys = JSONArray.parseArray((String)urlSetStr, String.class);
            ArrayList futures = Lists.newArrayListWithExpectedSize((int)fileUrlKeys.size());
            Tag tag = new Tag(false);
            for (Object fileUrlKey : fileUrlKeys) {
                Future future = THREAD_POOL.submit(() -> this.lambda$getCacheCalResult$0(tag, pageCache, (String)fileUrlKey, finalParentOrgId));
                futures.add(future);
            }
            String fileUrl = null;
            for (Future future : futures) {
                try {
                    String url = (String)future.get(3L, TimeUnit.SECONDS);
                    if (!HRStringUtils.isNotEmpty((String)url)) continue;
                    fileUrl = url;
                    break;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    LOGGER.error("get_fileUrl_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            TempDiskObj tempDiscObj = (TempDiskObj)SerializationUtils.deserialize((InputStream)this.tempFileService.getInputStream(fileUrl));
            Map<String, CalResult> calResultMap = tempDiscObj.calResultMap;
            Integer returnLevel = CalResult.getReturnLevel(adminOrgSummaryInfo);
            CalResult calResult = calResultMap.get(String.valueOf(finalParentOrgId));
            if (calResult != null) {
                List<CalResult> childResultList = calResult.getChildResultList();
                if (childResultList != null) {
                    for (CalResult child : childResultList) {
                        CalResult.cutLevelData(child, returnLevel, returnLevel != null && returnLevel <= 1);
                    }
                }
                return new ReportResult(rowMeta, Lists.newArrayList((Object[])new CalResult[]{calResult}));
            }
        }
        return null;
    }

    @Override
    public void putCalResultIntoCache(String pageId, RowMeta rowMeta, List<CalResult> calResults) {
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            PageCache pageCache = new PageCache(pageId);
            this.cleanCalResultCache(pageId);
            this.putRowMetaIntoCache(pageId, rowMeta);
            HashMap calResultMap = Maps.newHashMapWithExpectedSize((int)16);
            this.buildResultMap(calResultMap, calResults);
            List<TempDiskObj> diskTempList = this.splitMapData(calResultMap);
            ArrayList fileRedisKeys = Lists.newArrayListWithExpectedSize((int)diskTempList.size());
            for (TempDiskObj tempDiskObj : diskTempList) {
                Map fileConfig = this.tempFileService.save("calResultsFile", SerializationUtils.serialize((Serializable)tempDiskObj), 86400);
                String urlRedisKey = CAL_RESULT_ID_CACHE_KEY_PREFIX + (String)fileConfig.get(CONFIG_FIELD_ID);
                fileRedisKeys.add(urlRedisKey);
                pageCache.put(urlRedisKey, JSONArray.toJSONString(tempDiskObj.calResultMap.keySet()));
            }
            pageCache.put(CAL_RESULT_URL_SET_CACHE_KEY, JSONArray.toJSONString((Object)fileRedisKeys));
        }
    }

    @Override
    public boolean cleanCalResultCache(String pageId) {
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            PageCache pageCache = new PageCache(pageId);
            String urlSetStr = pageCache.get(CAL_RESULT_URL_SET_CACHE_KEY);
            pageCache.remove(CAL_RESULT_URL_SET_CACHE_KEY);
            if (HRStringUtils.isNotEmpty((String)urlSetStr)) {
                List fileUrlKeys = JSONArray.parseArray((String)urlSetStr, String.class);
                THREAD_POOL.execute(() -> {
                    pageCache.batchRemove(fileUrlKeys);
                    for (String fileUrlKey : fileUrlKeys) {
                        this.tempFileService.remove(this.makeUrl(fileUrlKey.replaceFirst(CAL_RESULT_ID_CACHE_KEY_PREFIX, "")));
                    }
                });
            }
        }
        return false;
    }

    @Override
    public boolean isCacheServiceHeath() {
        String diskCacheUrl = System.getProperty(CONFIG_DISK_CACHE_PATH);
        return HRStringUtils.isNotEmpty((String)diskCacheUrl);
    }

    private void buildResultMap(Map<String, CalResult> calResultMap, List<CalResult> calResults) {
        if (calResults != null) {
            for (CalResult calResult : calResults) {
                if (calResult == null) continue;
                calResultMap.put(String.valueOf(calResult.getOrgId()), calResult);
                this.buildResultMap(calResultMap, calResult.getChildResultList());
            }
        }
    }

    private List<TempDiskObj> splitMapData(Map<String, CalResult> calResultMap) {
        ArrayList diskObjs = Lists.newArrayListWithExpectedSize((int)10);
        HashMap tempResultMap = Maps.newHashMapWithExpectedSize((int)1000);
        int index = 0;
        for (Map.Entry<String, CalResult> calResultEntry : calResultMap.entrySet()) {
            if (index == 1000) {
                diskObjs.add(new TempDiskObj(tempResultMap));
                tempResultMap.clear();
                index = 0;
            }
            tempResultMap.put(calResultEntry.getKey(), calResultEntry.getValue());
            ++index;
        }
        return diskObjs;
    }

    private String makeUrl(String id) {
        return String.format("tempfile/download.do?configKey=%s&id=%s", CONFIG_KEY, id);
    }

    @Override
    public boolean clearCalResultCache(String index) {
        if (HRStringUtils.isNotEmpty((String)index)) {
            return ReportEsStorageService.removeIndices(index);
        }
        return true;
    }

    private /* synthetic */ String lambda$getCacheCalResult$0(Tag tag, PageCache pageCache, String fileUrlKey, long finalParentOrgId) throws Exception {
        if (tag.isFind) {
            return null;
        }
        String orgIdArrayStr = pageCache.get(fileUrlKey);
        if (HRStringUtils.isNotEmpty((String)orgIdArrayStr)) {
            List orgIds = JSONArray.parseArray((String)orgIdArrayStr, String.class);
            for (String orgId : orgIds) {
                if (!String.valueOf(finalParentOrgId).equals(orgId)) continue;
                tag.isFind = true;
                return this.makeUrl(fileUrlKey.replaceFirst(CAL_RESULT_ID_CACHE_KEY_PREFIX, ""));
            }
        }
        return null;
    }
}

